;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    60,132
        TITLE   COMMNLVB.ASM -- Buffer Write Routines for Common Format

;/*****************************************************************************
;*
;* SOURCE FILE NAME = COMMNLVB.ASM
;*
;* DESCRIPTIVE NAME = BUFFERUPDATE write routines
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS    WriteCellStrC, WriteCharStrC, WriteCharStrAttrC,
;*              WriteNCharC, WriteNAttrC, WriteNCellC
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  UpdateRegenC    (in COMMNPVB.ASM)
;*                      CheckDBCS       (in XGAWRITE.ASM)
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*   09/25/89  J-KK0925           KKJ, Moved "temp" to top.
;*   10/03/89  J-KK1003           KKJ, INSTALLATION
;*   10/16/89  j-ys1016               fix for P0083 sct$12cc. In entry, SI/DI points 2nd attribute.
;*                                But implementaion treated as if they start at 1st byte of cell.
;*             j-ys1024,1026,1027 for MS-Xvio support.
;*   10/31/89  J-KK1031           KKJ, At Exception Handling, Don't change Attr0.
;*   11/29/89  J-KK1129           KKJ, Limit Check for NCELL and NCHAR with DBCS.
;*   11/30/89  J-KK1130           KKJ, CLD is assumed in CFill.
;*   03/13/90  J-KKB17            KKJ,     Fix - Must not clear attribute at WrtChar.
;*   07/10/90  @KK0710            KKJ,     Fix - Must not clear attribute at WrtChar/Fill20h.
;*                                     PRT JS00303 (IC01263)
;*   06/16/93  J-TS0616           TSO, DBCS Exception handling of VioWrtNAttr
;*   07/07/93  J-TS0707           TSO, DBCS J-TS0616 doesn't take care of buffer end
;****************************************************************************/

temp    equ     0h                      ; Font Select in LVB Buffer J-KK0925

        .286c                           ; 286 protect mode instructions

        .xlist
        INCLUDE struc.inc               ; Structure macro
        INCLUDE vdhequ.inc              ; Buffer update equates
        INCLUDE vdhstruc.inc            ; Buffer update data structures
        .list

        IFNDEF  INSTALLATION            ; Installation J-KK1003
            EXTRN   CheckDBCS:NEAR
            EXTRN   UpdateRegenC:NEAR
            EXTRN   UpdateAttrC:NEAR

;;   For CA
            EXTRN   UpdateCARegenC:NEAR ;                               j-ys1106
            EXTRN   UpdateCAAttrc:NEAR  ;                               j-ys1106

        ENDIF

R2CSEG  SEGMENT WORD    PUBLIC 'CODE'
        ASSUME  CS:R2CSEG,DS:NOTHING,ES:NOTHING

        IFDEF   INSTALLATION            ; Installation J-KK1003
Dummy       proc    near
WriteCStrC  label   byte
WriteNCellC label   byte
WriteNCharC label   byte
WriteNAttrC label   byte
COMMON_UpLeft label byte
COMMON_DnRight label byte
COMMON_CFill label  byte
COMMON_CFillR label byte
COMMON_LVBrecttoPVB label byte          ;j-ys1026
COMMON_CArecttoPVB label byte           ;j-ys111
            public  WriteCStrC
            public  WriteNCellC
            public  WriteNCharC
            public  WriteNAttrC
            public  COMMON_UpLeft
            public  COMMON_DnRight
            public  COMMON_CFill
            public  COMMON_CFillR
            public  COMMON_LVBrecttoPVB ;j-ys1026
            public  COMMON_CArecttoPVB  ;j-ys111
            ret
Dummy       endp
        ELSE

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteCStrC                                      *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write cells/chars/charsA   *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteCStrC  proc
            public  WriteCStrC

            mov     bx, [bp].Sub_index  ; Get Function Index
            .if     < bx e WCELL >      ;Cell ?             ;j-ys718
                shr     cx,1            ;j-ys718
                mov     [bp].Sub_length,cx ;j-ys719
            .endif                      ;j-ys718
;;*** Update LVB
            Call    HeadBoundc          ; 
            xor     dx,dx               ;clear the char counter
            .while  ncxz  near          ; 
                xor     ax,ax
                .if     < bx e WCELL >  ;Cell ?
                    lodsb               ;get a next cell
                    add     si,3        ;skip attr0,1,2
                    mov     ah,[si-1]   ;get character set bits (attr2)
                .elseif < bx e WCHAR >  ;Char ?
                    lodsb               ;get a next char
                .else                   ;CharAttribute
                    lodsb               ;get a next char
                    mov     ah,byte ptr [bp].Sub_attribute ;get attribute
                .endif                  ; 
                dec     cx              ;adjust the loop counter (CX)
                inc     dx              ;increment the char counter (DX)

                call    CheckDBCS       ; 
                .if     c               ;if char have DBCS lead byte
                    .if     < dx gt 1 > ; Hankaku Char Counter must be GT 1.
                        push    ax      ; save ax
                        dec     dx      ; Adjust
                        push    si      ; 
                        dec     si      ; Adjust
                        cmp     bx,WCELL ; 
                        .if     e       ; 
                            sub     si,3 ;adjust si for attr
                        .endif          ; 
                        call    Writec  ; Write the leading Hankaku String
                        pop     si      ; 
                        pop     ax      ; 
                    .endif

                    xor     dx,dx       ;clear the char counter (DX)
                    .if     ncxz        ;   & cx > 0
                        mov     ah,al   ;ah is DBCS lead
                        lodsb
                        cmp     bx,WCELL
                        .if     e       ; 
                            add     si,3 ;adust si for attr
                        .endif          ; 
                        dec     cx      ;adjust the loop counter (CX)

                        xchg    al,ah   ; 
                        call    PutDBCSc ;write dbcs into LVB
                    .else               ; Terminate with DBCS leading byte
                                        ; Ignored the last byte
                        dec     [bp].Sub_length
                    .endif              ; 
                .endif                  ; End of DBCS Case
            .endwhile                   ; 

            call    Writec              ;Write Hankaku Char to LVB
            call    TailBoundc

;;*** Update PVB
            .if     < bit [bp].Sub_Option nand CA_Request > ;          ;j-ys111
                call    UpdateRegenC    ; For Not CA
            .else                       ;                              ;j-ys1024
                call    UpdateCARegenC  ; For CA                       ;j-ys1024
            .endif                      ;                              ;j-ys1024

            ret
WriteCStrC  endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNCellC                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N cells              *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;*              (SI points start SI+2 in entry )                        *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNCellC proc
            public  WriteNCellC

;;*** Update LVB
            pushf                       ; 
            Call    HeadBoundc          ; 
            popf                        ; 
            .if     c                   ;*** DBCS Cell
                mov     dx,ds:[si+2]    ;Get 2nd Cell           ;j-ys718
                .repeat                 ; 
                    stosw               ;Store 1st Cell
                    movsw               ;store 1st attr1/2
                    mov     byte ptr es:[di-1], dbcsA1+temp ; Set DBCS 1st
                    xchg    ax,dx       ; 
                    stosw               ;Store 2nd Cell
                    add     si,2
                    movsw               ;store 2nd attr1/2
                    mov     byte ptr es:[di-1], dbcsA2+dbcsA1+temp ; Set DBCS 2nd
                    xchg    ax,dx       ; 
                    sub     si,6
                .loop                   ; 
            .else                       ;*** SBCS Cell
                .repeat                 ; 
                    stosw               ;Fill buffer with Cells
                    movsw
                    mov     byte ptr es:[di-1], temp ; Clear DBCS Attr
                    sub     si,2
                .loop                   ; 
            .endif                      ; 
            call    TailBoundc          ; 

;;*** Update PVB
            .if     < bit [bp].Sub_Option nand CA_Request > ;          ;j-ys111
                call    UpdateRegenC    ; For Not CA
            .else                       ;                              ;j-ys1024
                call    UpdateCARegenC  ; For CA                       ;j-ys1024
            .endif                      ;                              ;j-ys1024


            ret
WriteNCellC endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNCharC                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N chars              *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNCharC proc
            public  WriteNCharC

;;*** Update LVB
            pushf
            Call    HeadBoundc          ; 
            popf
            .if     c                   ;*** DBCS handling
                mov     ah,ds:[si]      ; Get 2nd Character
                .repeat                 ; 
                    stosb               ;Set the lead byte
                    mov     byte ptr es:[di+2], temp+dbcsA1 ; DBCS 1st Attr
                    add     di,3        ; 
                    mov     byte ptr es:[di],ah ;Store the second byte
                    mov     byte ptr es:[di+3], temp+dbcsA2+dbcsA1 ; DBCS 1st Attr
                    add     di,4        ; 
                .loop
            .else                       ;*** SBCS handling
                .repeat                 ; 
                    stosb               ;Store character
                    mov     byte ptr es:[di+2], temp ; Clear DBCS Attr
                    add     di,3        ;Skip attribute
                .loop                   ; 
            .endif                      ; 
            call    TailBoundc

;;*** Update PVB
            .if     < bit [bp].Sub_Option nand CA_Request > ;          ;j-ys111
                call    UpdateRegenC    ; For Not CA
            .else                       ;                              ;j-ys1024
                call    UpdateCARegenC  ; For CA                       ;j-ys1024
            .endif                      ;                              ;j-ys1024

            ret
WriteNCharC endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNAttrC                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N attribute          *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNAttrC proc
            public  WriteNAttrC

        mov     ah, es:[di+3]           ; First char is DBCS 2nd ?      ;J-TS0616
        and     ah, dbcsA1+dbcsA2                                       ;J-TS0616
        .if     <ah eq dbcsA1+dbcsA2>                                   ;J-TS0616
            inc     [bp].Sub_length                                     ;J-TS0616
            sub     [bp].Sub_offset, 4                                  ;J-TS0616
            sub     [bp].PVBOff, 2                                      ;J-TS0616
        .endif                                                          ;J-TS0616

            mov     ax,word ptr ds:[si-1]
;;*** Update LVB
            .repeat
                inc     di              ;Skip char byte
                stosw                   ;set attribute
                add     di,1            ;skip sysytem byte and char     ;j-ys718
            .loop

        mov     ah, es:[di-1]           ; Last char is DBCS 1st ?       ;J-TS0707
        and     ah, dbcsA1+dbcsA2                                       ;J-TS0616
        .if     <ah eq dbcsA1>                                          ;J-TS0707
            inc     [bp].Sub_length                                     ;J-TS0616
        .endif                                                          ;J-TS0616

;;*** Update PVB
            .if     < bit [bp].Sub_Option nand CA_Request > ;          ;j-ys111
                call    UpdateAttrC     ; For Not CA
            .else                       ;                              ;j-ys1024
                call    UpdateCAAttrc   ; For CA                       ;j-ys1024
            .endif                      ;                              ;j-ys1024


            ret
WriteNAttrC endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME: XXXXX                                               *
;*                                                                      *
;* DESCRIPTIVE NAME:    DBCS Exeption Handling Routine                  *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
;; OverWriting Handling
;; DS:SI - User Buffer
;; ES:DI - LVB
HeadBoundc  PROC    NEAR                ;OverWriting of Head DBCS Widow
            .if  < di ge 4 >            ;check start of screen or not ?
                .if < bit <byte ptr es:[di+3]> and dbcsA2 > ;DBCS 2nd ?
                    mov     byte ptr es:[di-4],20h ;set space
                    mov     byte ptr es:[di-1], EXTRA_ATTRHigh ;set attr2@KK0710
                    inc     [bp].Sub_length ;adjust repeat count
                    sub     [bp].Sub_offset,4 ;adjust offset            J-KK1031
                    sub     [bp].PVBOFF,2 ;adjust offset               ;j-ys1023
                .endif                  ; 
            .endif
            ret                         ; 
HeadBoundc  ENDP                        ; 

TailBoundc  PROC    NEAR                ;Overwriting of Tail DBCS Widow
            cmp     di, [bp].Sub_Buffsize ;check end of screen or not ?
            .if     b
                test    byte ptr ES:[DI+3],dbcsA2 ; Target Tail+1 is DBCS 2nd ?
                .if     nz              ; 
                    mov     byte ptr es:[di],20h ;set space
                    mov     byte ptr es:[di+3], EXTRA_ATTRHigh ;set attr2@KK0710
                    add     di,4
                    inc     [bp].Sub_length ;adjust repeat count
                .endif                  ; 
            .endif
            ret                         ; 
TailBoundc  ENDP                        ; 

PutDBCSc    PROC
;  al:lead   dbcs
;  ah:second dbcs
            .if < bx e WCELL >          ;Cell ?
                stosb                   ;store dbcs lead byte
                push    ax
                mov     ax,word ptr ds:[si-7] ;get 1st cell attribute
                stosw                   ;store dbcs lead byte attr0/1
                mov     byte ptr es:[di], temp+dbcsA1 ; set dbcs 1st flag
                inc     di
                pop     ax
                xchg    al,ah           ; 
                stosb                   ;store dbcs second byte
                mov     ax,word ptr ds:[si-3] ;get 2nd cell attribute
                stosw                   ;store dbcs second byte attribute
                mov     byte ptr es:[di], temp+dbcsA1+dbcsA2 ; set dbcs 2nd flag
                inc     di
            .elseif < bx e WCHAR >      ;Char ?
                stosb                   ;store dbcs lead byte
                mov     byte ptr es:[di+2], EXTRA_ATTR1/256 ;set dbcs1st flag @KK0710
                add     di,3
                xchg    al,ah
                stosb                   ;store dbcs second byte
                mov     byte ptr es:[di+2], EXTRA_ATTR2/256 ;set dbcs2nd flag @KK0710
                add     di,3
            .else                       ;Char Attribute
                stosb                   ;set 1st char
                push    ax              ;store dbcs first byte
                mov     ax,word ptr [bp].Sub_attribute
                stosw
                mov     byte ptr es:[di], dbcsA1+temp ; set dbcs 1st flag
                inc     di
                pop     ax

                xchg    al,ah           ;store dbcs second byte
                stosb
                mov     ax,word ptr [bp].Sub_attribute
                stosw
                mov     byte ptr es:[di], dbcsA2+dbcsA1+temp ; set dbcs 2nd flag
                inc     di
            .endif
            ret
PutDBCSc    ENDP

Writec      PROC                        ;Hankaku write routine
            Public  Writec
            push    cx
            sub     si,dx               ;adjust si
            mov     cx,dx
            .if     ncxz
                .if     < bx e WCELL >  ;Cell ?
                    sub     si,dx       ;adjust si more!
                    sub     si,dx       ;adjust si more!        ;j-ys718
                    sub     si,dx       ;adjust si more!        ;j-ys718
                    .repeat
                        movsw
                        movsw
                        mov     byte ptr es:[di-1], temp ;j-ys801
                    .loop
                .elseif < bx e WCHAR >  ;Char ?
                    .repeat
                        mov     byte ptr es:[di+3], temp ; clear dbcs flag
                        movsb
                        add     di,3    ;Skip Attr
                    .loop
                .else                   ;CharAttribute
                    mov     ax,word ptr [bp].Sub_attribute
                    .repeat
                        mov     byte ptr es:[di+3], temp ; clear dbcs flag
                        movsb
                        stosw
                        inc     di
                    .loop
                .endif
            .endif
            pop     cx
            ret
Writec      ENDP

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     COMMON_UpLeft                                   *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Up/Left             *
;*                      Move a one line.                                *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGASCROL.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  CLD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
COMMON_UpLeft proc
            public  COMMON_UpLeft
            .if     < si ge 4 >  and    ; 
            test    byte ptr ds:[si+3],dbcsA2 ; Source Head is DBCS 2nd ?
            .if     nz                  ; 
                mov     byte ptr ds:[si], 20h ; Fill Blank to Second
                mov     byte ptr ds:[si-4], 20h ; Fill Blank to First
                mov     byte ptr ds:[si+3], EXTRA_ATTRHigh ;reset flag @KK0710
                mov     byte ptr ds:[si-1], EXTRA_ATTRHigh ;reset flag @KK0710
            .endif                      ; 

            .if     < di ge 4 >  and    ; 
            test    byte ptr es:[di+3],dbcsA2 ; Target Head is DBCS 2nd ?
            .if     nz                  ; Overwrite DBCS 1st
                mov     byte ptr es:[di-4],20h ;set space
                mov     byte ptr es:[di-1], EXTRA_ATTRHigh ;reset flag @KK0710
            .endif                      ; 

            rep     movsw               ; Move Cells

;;                                      ; SI/DI-Pointed to Last+2 Cell
            .if     < si lt [bp].Sub_Buffsize > and
            test    byte ptr ds:[si+3],dbcsA2 ; Source Tail is DBCS 1st ?
            .if     nz                  ; Overwrite DBCS 2nd
                mov     byte ptr ds:[si], 20h ; Fill Blank to Second
                mov     byte ptr ds:[si-4], 20h ; Fill Blank to First
                mov     byte ptr ds:[si+3], EXTRA_ATTRHigh ;reset flag @KK0710
                mov     byte ptr ds:[si-1], EXTRA_ATTRHigh ;reset flag @KK0710
                mov     byte ptr es:[di-4],20h ;Change Copied Byte to Space
                mov     byte ptr es:[di-1], EXTRA_ATTRHigh ;reset flag @KK0710
            .endif

            .if     < di lt [bp].Sub_Buffsize > and
            test    byte ptr es:[di+3],dbcsA2 ; Target Tail is DBCS 1st ?
            .if     nz                  ; Overwrite DBCS 2nd
                mov     byte ptr es:[di],20h ;set space
                mov     byte ptr es:[di+3], EXTRA_ATTRHigh ;reset flag @KK0710
            .endif                      ; 


            ret
COMMON_UpLeft endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     COMMON_DnRight                                  *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Down/Right          *
;*                      Move a one line.                                *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGASCROL.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  STD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
COMMON_DnRight proc
            public  COMMON_DnRight
            push    ax

            mov     ax, [bp].Sub_Buffsize ; 
            sub     ax, 4               ; 
            push    ax                  ; Save Last Size
            .if     < si lt ax > and    ; 
            mov     al, ds:[si+1]       ; Source Head is DBCS 1st ?           ;j-ys1016
            and     al, dbcsA1+dbcsA2   ; 
            .if     < al e dbcsA1 >     ; 
                mov     byte ptr ds:[si-2], 20h ; Fill Blank to First       ;j-ys1016
                mov     byte ptr ds:[si+2], 20h ; Fill Blank to Second      ;j-ys1016
                mov     byte ptr ds:[si+1], EXTRA_ATTRHigh ;reset flag  @KK0710
                mov     byte ptr ds:[si+5], EXTRA_ATTRHigh ;reset flag  @KK0710
            .endif
            pop     ax                  ; Restore Last Size

            .if     < di lt ax > and    ; 
            mov     al, es:[di+1]       ; Target Head is DBCS 1st ?           ;j-ys1016
            and     al, dbcsA1+dbcsA2   ; 
            .if     < al e dbcsA1 >     ; Overwrite DBCS 2nd
                mov     byte ptr es:[di+2],20h ;set space                   ;j-ys1016
                mov     byte ptr es:[di+5], EXTRA_ATTRHigh ;reset flag  @KK0710
            .endif                      ; 

            rep     movsw               ; Move Cells
;;                                      ; SI/DI-Pointed to Last Cell-1
            .if     < si ge 2 > and     ;                            ;j-ys1016
            mov     al, ds:[si+1]       ; Source Tail is DBCS 2nd ?        ;j-ys1016
            and     al, dbcsA1+dbcsA2   ; 
            .if     < al e dbcsA1 >     ; 
                mov     byte ptr ds:[si-2], 20h ; Fill Blank to First       ;j-ys1016
                mov     byte ptr ds:[si+2], 20h ; Fill Blank to Second      ;j-ys1016
                mov     byte ptr ds:[si+1], EXTRA_ATTRHigh ;reset flag  @KK0710
                mov     byte ptr ds:[si+5], EXTRA_ATTRHigh ;reset flag  @KK0710
                mov     byte ptr es:[di+2],20h ; Change Copied byte to Space;j-ys1016
                mov     byte ptr es:[di+5], EXTRA_ATTRHigh ;reset flag  @KK0710
            .endif

            .if     < di ge 0 > and     ; 
            mov     al, es:[di+1]       ; Target Tail is DBCS 2nd ?           ;j-ys1016
            and     al, dbcsA1+dbcsA2   ; 
            .if     < al e dbcsA1 >     ; Overwrite DBCS 1st
                mov     byte ptr es:[di-2],20h ;set space                   ;j-ys1016
                mov     byte ptr es:[di+1], EXTRA_ATTRHigh ;reset flag  @KK0710
            .endif                      ; 

            pop     ax

            ret
COMMON_DnRight endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     COMMON_CFill                                    *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Fill Cell           *
;*                      Fill one line with Cell into LVB.               *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  Tartget LVB Address             (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  CLD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
COMMON_CFill proc
            public  COMMON_CFill

            shr     cx,1                ;j-ys727

            .if     < di ge 4 > and     ; 
            test    byte ptr es:[di+3],dbcsA2 ; Target Head is DBCS 2nd ?
            .if     nz                  ; Overwrite DBCS 1st
                mov     byte ptr es:[di-4],20h ;set space
                mov     byte ptr es:[di-1], EXTRA_ATTRHigh ;reset flag  @KK0710
            .endif                      ; 

            push    dx                  ;j-ys718
            mov     ax,[bp].FillCellLow
            mov     dx,[bp].FillCellHigh ;j-ys718
            .repeat                     ;j-ys718

                stosw                   ; Fill char and attr0
                xchg    ax,dx           ;j-ys718
                stosw                   ; Fill attr1 and attr2  ;j-ys718
                xchg    ax,dx           ;j-ys718
            .loop                       ;j-ys718
            pop     dx                  ;j-ys718

            .if     < di lt [bp].Sub_Buffsize > and ; 
            test    byte ptr es:[di+3],dbcsA2 ; Target Tail is DBCS 1st ?
            .if     nz                  ; Overwrite DBCS 2nd
                mov     byte ptr es:[di],20h ;set space
                mov     byte ptr es:[di+3], EXTRA_ATTRHigh ;reset flag @KK0710
            .endif                      ; 

            ret
COMMON_CFill endp
        ENDIF

R2CSEG  ENDS
        END
