;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = CGA2EPO.INC
;*
;* DESCRIPTIVE NAME = Table of CGA to Epoch mono mapping
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  This file contains some of the definitions needed for
;*              CGA to Epoch Mono mapping Table
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR    CHANGE DESCRIPTION
;*   --------  ----------  -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*   06/14/89  j-ys614                  Newly created in order yo map US mono attrbute into Epoch.
;*   11/29/89  J-KK1129            KKJ, Reverse bit in Epoch Color Mode for ANSI request.
;*                                      Reverse request from ANSI is "0x70", BG color bits On.
;*   01/17/89  J-KK0117            KKJ, No longer Use Table: cga2monotbl for Epoch Mono Mode
;*
;*****************************************************************************/

_DATA   SEGMENT WORD PUBLIC 'DATA'

        public  cga2monotbl
cga2monotbl label byte


        public  cga2epoch
cga2epoch   label byte
        db      0c8h,048h,088h,008h,0c0h,040h,080h, 00h      ;00h-07h   ;foreground
        db      0c8h,048h,088h,008h,0c0h,040h,080h, 00h      ;08h-0fh
        db      04ch,04ch,04ch,04ch,04ch,04ch,04ch,04ch      ;10h-17h   ;reverse blue
        db      04ch,04ch,04ch,04ch,04ch,04ch,04ch,04ch      ;18h-1fh
        db      08ch,08ch,08ch,08ch,08ch,08ch,08ch,08ch      ;20h-27h   ;reverse green
        db      08ch,08ch,08ch,08ch,08ch,08ch,08ch,08ch      ;28h-2fh
        db      00ch,00ch,00ch,00ch,00ch,00ch,00ch,00ch      ;30h-37h   ;reverse cyan
        db      00ch,00ch,00ch,00ch,00ch,00ch,00ch,00ch      ;38h-3fh
        db      0c4h,0c4h,0c4h,0c4h,0c4h,0c4h,0c4h,0c4h      ;40h-47h   ;reverse red
        db      0c4h,0c4h,0c4h,0c4h,0c4h,0c4h,0c4h,0c4h      ;48h-4fh
        db      044h,044h,044h,044h,044h,044h,044h,044h      ;50h-57h   ;reverse magenta
        db      044h,044h,044h,044h,044h,044h,044h,044h      ;58h-5fh
        db      084h,084h,084h,084h,084h,084h,084h,084h      ;60h-67h   ;reverse yellow
        db      084h,084h,084h,084h,084h,084h,084h,084h      ;68h-6fh
        db      004h,04ch,08ch,00ch,0c4h,044h,084h, 04h      ;70h-77h   ;reverse
        db      004h,004h,004h,004h,004h,004h,004h,004h      ;78h-7fh
        db      004h,004h,004h,004h,004h,004h,004h,004h      ;80h-87h   ;reverse white
        db      004h,004h,004h,004h,004h,004h,004h,004h      ;88h-8fh
        db      04ch,04ch,04ch,04ch,04ch,04ch,04ch,04ch      ;90h-97h   ;reverse blue
        db      04ch,04ch,04ch,04ch,04ch,04ch,04ch,04ch      ;98h-9fh
        db      08ch,08ch,08ch,08ch,08ch,08ch,08ch,08ch      ;a0h-a7h   ;reverse green
        db      08ch,08ch,08ch,08ch,08ch,08ch,08ch,08ch      ;a8h-afh
        db      00ch,00ch,00ch,00ch,00ch,00ch,00ch,00ch      ;b0h-b7h   ;reverse cyan
        db      00ch,00ch,00ch,00ch,00ch,00ch,00ch,00ch      ;b8h-bfh
        db      0c4h,0c4h,0c4h,0c4h,0c4h,0c4h,0c4h,0c4h      ;c0h-c7h   ;reverse red
        db      0c4h,0c4h,0c4h,0c4h,0c4h,0c4h,0c4h,0c4h      ;c8h-cfh
        db      044h,044h,044h,044h,044h,044h,044h,044h      ;d0h-d7h   ;reverse magenta
        db      044h,044h,044h,044h,044h,044h,044h,044h      ;d8h-dfh
        db      084h,084h,084h,084h,084h,084h,084h,084h      ;e0h-e7h   ;reverse yellow
        db      084h,084h,084h,084h,084h,084h,084h,084h      ;e8h-efh
        db      004h,004h,004h,004h,004h,004h,004h,004h      ;f0h-f7h   ;reverse white
        db      004h,004h,004h,004h,004h,004h,004h,004h      ;f8h-ffh

_DATA   ENDS
