;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    60,132
        TITLE   ATLS_LVB.ASM -- Buffer Write Routines for ATLAS U.S. Format

;/*****************************************************************************
;*
;* SOURCE FILE NAME = ATLS_LVB.ASM
;*
;* DESCRIPTIVE NAME = BUFFERUPDATE write routines
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS    WriteCellStrB, WriteCharStrB, WriteCharStrAttrB,
;*              WriteNCharB, WriteNAttrB, WriteNCellB
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  UpdateRegenB    (in COMMNPVB.ASM)
;*                      CheckDBCS       (in XGAWRITE.ASM)
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*   10/24/89  j-ys1024           for MS-Xvio support.
;*   11/29/89  J-KK1129           KKJ, Limit Check for NCELL and NCHAR with DBCS.
;*   11/30/89  J-KK1130           KKJ, CLD is assumed in CFill.
;*   06/16/93  J-TS0616           TSO, DBCS Exception handling of VioWrtNAttr
;*   07/07/93  J-TS0707           TSO, DBCS J-TS0616 doesn't take care of buffer end
;****************************************************************************/

        .286c                           ; 286 protect mode instructions

        .xlist
        INCLUDE struc.inc               ; Structure macro
        INCLUDE vdhequ.inc              ; Buffer update equates
        INCLUDE vdhstruc.inc            ; Buffer update data structures
        .list

        EXTRN   CheckDBCS:NEAR
        EXTRN   UpdateRegenB:NEAR
        EXTRN   UpdateAttrB:NEAR

        EXTRN   UpdateCARegenB:NEAR     ; For MS-XVIO                   j-ys1106
        EXTRN   UpdateCAAttrB:NEAR      ;                               j-ys1106

R2CSEG  SEGMENT WORD    PUBLIC 'CODE'
        ASSUME  CS:R2CSEG,DS:NOTHING,ES:NOTHING


;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteCStrB                                      *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write cells/chars/charsA   *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteCStrB proc
        public  WriteCStrB

        mov     bx, [bp].Sub_index      ; Get Function Index
;;*** Update LVB
        Call    HeadBoundB              ; 
        xor     dx,dx                   ;clear the char counter
        .while  ncxz  near              ; 
            xor     ax,ax
            .if     < bx e WCELL >      ;Cell ?
                lodsw                   ;get a next cell
            .elseif < bx e WCHAR >      ;Char ?
                lodsb                   ;get a next char
            .else                       ;CharAttribute
                lodsb                   ;get a next char
                mov     ah,byte ptr [bp].Sub_attribute ;get attribute
            .endif                      ; 
            dec     cx                  ;adjust the loop counter (CX)
            inc     dx                  ;increment the char counter (DX)

            call    CheckDBCS           ; 
            .if     c                   ;if char have DBCS lead byte
                .if     < dx gt 1 >     ; Hankaku Char Counter must be GT 1.
                    push    ax          ; save ax
                    dec     dx          ; Adjust
                    push    si          ; 
                    dec     si          ; Adjust
                    cmp     bx,WCELL    ; 
                    .if     e           ; 
                        dec     si      ; adjust si for attr
                    .endif              ; 
                    call    WriteB      ; Write the leading Hankaku String
                    pop     si          ; 
                    pop     ax          ; 
                .endif

                xor     dx,dx           ;clear the char counter (DX)
                .if     ncxz            ;   & cx > 0
                    mov     ah,al       ;ah is DBCS lead
                    lodsb
                    cmp     bx,WCELL
                    .if     e           ; 
                        inc     si      ;adust si for attr
                    .endif              ; 
                    dec     cx          ;adjust the loop counter (CX)

                    xchg    al,ah       ; 
                    call    PutDBCSB    ;write dbcs into LVB
                .else                   ; Terminate with DBCS leading byte
                                        ; Ignored the last byte
                    dec     [bp].Sub_length
                .endif                  ; 
            .endif                      ; End of DBCS Case
        .endwhile                       ; 

        call    WriteB                  ;Write Hankaku Char to LVB
        call    TailBoundB

;;*** Update PVB
        .if     < bit [bp].Sub_Option nand CA_Request > ;              ;j-ys111
            call    UpdateRegenB        ; 
        .else                           ;                              ;j-ys1024
            call    UpdateCARegenB      ;                              ;j-ys111
        .endif                          ;                              ;j-ys111

        ret
WriteCStrB endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNCharB                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N chars              *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNCharB proc
        public  WriteNCharB

;;*** Update LVB
        pushf
        Call    HeadBoundB              ; 
        popf
        .if     c                       ;*** DBCS handling
            mov     ah,ds:[si]          ; Get 2nd Character
            .repeat                     ; 
                stosb                   ;Set the lead byte
                mov     word ptr es:[di+TOEXT-1], EXTRA_ATTR1 ; DBCS 1st Attr
                inc     di              ; 
                mov     byte ptr es:[di],ah ;Store the second byte
                inc     di              ; 
                mov     word ptr es:[di+TOEXT-1], EXTRA_ATTR2 ; DBCS 2nd Attr
                inc     di              ; 
            .loop
        .else                           ;*** SBCS handling
            .repeat                     ; 
                stosb                   ;Store character
                mov     word ptr es:[di+TOEXT-1], EXTRA_ATTR ; Clear DBCS Attr
                inc     di              ;Skip attribute
            .loop                       ; 
        .endif                          ; 
        call    TailBoundB

;;*** Update PVB
        .if     < bit [bp].Sub_Option nand CA_Request > ;              ;j-ys111
            call    UpdateRegenB        ; 
        .else                           ;                              ;j-ys1024
            call    UpdateCARegenB      ;                              ;j-ys111
        .endif                          ;                              ;j-ys111

        ret
WriteNCharB endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNAttrB                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N attribute          *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;* AL     --->  Attribute Byte                  (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNAttrB proc
        public  WriteNAttrB

        mov     ah, es:[di+TOEXT+1]     ; First char is DBCS 2nd ?      ;J-TS0616
        and     ah, dbcsA1+dbcsA2                                       ;J-TS0616
        .if     <ah eq dbcsA1+dbcsA2>                                   ;J-TS0616
            inc     [bp].Sub_length                                     ;J-TS0616
            sub     [bp].Sub_offset, 2                                  ;J-TS0616
            sub     [bp].PVBOff, 2                                      ;J-TS0616
        .endif                                                          ;J-TS0616

;;*** Update LVB
        .repeat
            inc     di                  ;Skip char byte
            stosb                       ;set attribute
        .loop

        mov     ah, es:[di+TOEXT-1]     ; Last char is DBCS 1st ?       ;J-TS0707
        and     ah, dbcsA1+dbcsA2                                       ;J-TS0616
        .if     <ah eq dbcsA1>                                          ;J-TS0707
            inc     [bp].Sub_length                                     ;J-TS0616
        .endif                                                          ;J-TS0616

;;*** Update PVB
        .if     < bit [bp].Sub_Option nand CA_Request > ;              ;j-ys111
            call    UpdateAttrB         ; 
        .else                           ;                              ;j-ys1024
            call    UpdateCAAttrB       ;                              ;j-ys111
        .endif                          ;                              ;j-ys111

        ret
WriteNAttrB endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNCellB                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N cells              *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNCellB proc
        public  WriteNCellB

;;*** Update LVB
        pushf                           ; 
        Call    HeadBoundB              ; 
        popf                            ; 
        .if     c                       ;*** DBCS Cell
            mov     dx,ds:[si]          ;Get 2nd Cell
            .repeat                     ; 
                stosw                   ;Store 1st Cell
                mov     word ptr es:[di+TOEXT-2], EXTRA_ATTR1 ; Set DBCS 1st
                xchg    ax,dx           ; 
                stosw                   ;Store 2nd Cell
                mov     word ptr es:[di+TOEXT-2], EXTRA_ATTR2 ; Set DBCS 2nd
                xchg    ax,dx           ; 
            .loop                       ; 
        .else                           ;*** SBCS Cell
            .repeat                     ; 
                stosw                   ;Fill buffer with Cells
                mov     word ptr es:[di+TOEXT-2], EXTRA_ATTR ; Clear DBCS Attr
            .loop                       ; 
        .endif                          ; 
        call    TailBoundB              ; 

;;*** Update PVB
        .if     < bit [bp].Sub_Option nand CA_Request > ;              ;j-ys111
            call    UpdateRegenB        ; 
        .else                           ;                              ;j-ys1024
            call    UpdateCARegenB      ;                              ;j-ys111
        .endif                          ;                              ;j-ys111

        ret
WriteNCellB endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME: XXXXX                                               *
;*                                                                      *
;* DESCRIPTIVE NAME:    DBCS Exeption Handling Routine                  *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
;; OverWriting Handling
;; DS:SI - User Buffer
;; ES:DI - LVB
HeadBoundB PROC NEAR                    ;OverWriting of Head DBCS Widow
        cmp     di,2                    ;check start of screen or not ?
        .if     ge
            test    byte ptr es:[di+TOEXT+1],dbcsA2 ;DBCS 2nd ?
            .if     nz                  ; 
                mov     byte ptr es:[di-2],20h ;set space
                mov     word ptr es:[di+TOEXT-2], EXTRA_ATTR ;reset flag
                inc     [bp].Sub_length ;adjust repeat count
                sub     [bp].Sub_offset,2 ;adjust offset
                sub     [bp].PVBOFF,2   ;adjust offset     ;j-ys1024
            .endif                      ; 
        .endif
        ret                             ; 
HeadBoundB ENDP                         ; 

TailBoundB PROC NEAR                    ;Overwriting of Tail DBCS Widow
        cmp     di, [bp].Sub_Buffsize   ;check end of screen or not ?
        .if     b
            test    byte ptr ES:[DI+TOEXT+1],dbcsA2 ; Target Tail+1 is DBCS 2nd ?
            .if     nz                  ; 
                mov     byte ptr es:[di],20h ;set space
                inc     di              ; 
                mov     word ptr es:[di+TOEXT-1], EXTRA_ATTR ;reset attr
                inc     di              ; 
                inc     [bp].Sub_length ;adjust repeat count
            .endif                      ; 
        .endif
        ret                             ; 
TailBoundB ENDP                         ; 

PutDBCSB PROC
;  al:lead   dbcs
;  ah:second dbcs
        cmp     bx,WCELL                ; 
        .if     e                       ;Cell ?
            stosb                       ;store dbcs lead byte
            mov     al,ds:[si-3]        ;get 1st cell attribute
            stosb                       ;store dbcs lead byte attribute
            mov     word ptr es:[di+TOEXT-2], EXTRA_ATTR1 ; set dbcs 1st flag
            xchg    al,ah               ; 
            stosb                       ;store dbcs second byte
            mov     al,ds:[si-1]        ; 
            stosb                       ;store dbcs second byte attribute
            mov     word ptr es:[di+TOEXT-2], EXTRA_ATTR2 ; set dbcs 2nd flag
        .elseif < bx e WCHAR >          ;Char ?
            stosb                       ;store dbcs lead byte
            mov     word ptr es:[di+TOEXT-1], EXTRA_ATTR1 ; set dbcs 1st flag
            inc     di
            xchg    al,ah
            stosb                       ;store dbcs second byte
            mov     word ptr es:[di+TOEXT-1], EXTRA_ATTR2 ; set dbcs 2nd flag
            inc     di
        .else                           ;Char Attribute
            push    ax                  ;store dbcs first byte
            mov     ah,byte ptr [bp].Sub_attribute
            mov     word ptr es:[di+TOEXT], EXTRA_ATTR1 ; set dbcs 1st flag
            stosw
            pop     ax

            xchg    al,ah               ;store dbcs second byte
            mov     ah,byte ptr [bp].Sub_attribute
            mov     word ptr es:[di+TOEXT], EXTRA_ATTR2 ; set dbcs 2nd flag
            stosw
        .endif
        ret
PutDBCSB ENDP

WriteB  PROC                            ;Hankaku write routine
        Public  WriteB
        push    cx
        sub     si,dx                   ;adjust si
        mov     cx,dx
        .if     ncxz
            .if     < bx e WCELL >      ;Cell ?
                sub     si,dx           ;adjust si more!
                .repeat
                    mov     word ptr es:[di+TOEXT], EXTRA_ATTR ; clear dbcs flag
                    movsw
                .loop
            .elseif < bx e WCHAR >      ;Char ?
                .repeat
                    mov     word ptr es:[di+TOEXT], EXTRA_ATTR ; clear dbcs flag
                    movsb
                    inc     di          ;Skip Attr
                .loop
            .else                       ;CharAttribute
                mov     al,byte ptr [bp].Sub_attribute
                .repeat
                    mov     word ptr es:[di+TOEXT], EXTRA_ATTR ; clear dbcs flag
                    movsb
                    stosb
                .loop
            .endif
        .endif
        pop     cx
        ret
WriteB  ENDP

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     ATLAS_UpLeft                                    *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Up/Left             *
;*                      Move a one line.                                *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGASCROL.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  CLD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
ATLAS_UpLeft proc
        public  ATLAS_UpLeft

        .if     < si ge 2 >  and        ; 
        test    byte ptr ds:[si+TOEXT+1],dbcsA2 ; Source Head is DBCS 2nd ?
        .if     nz                      ; 
            mov     byte ptr ds:[si], 20h ; Fill Blank to Second
            mov     byte ptr ds:[si-2], 20h ; Fill Blank to First
            mov     word ptr ds:[si+TOEXT], EXTRA_ATTR ;reset flag
            mov     word ptr ds:[si+TOEXT-2], EXTRA_ATTR ;reset flag
        .endif                          ; 

        .if     < di ge 2 >  and        ; 
        test    byte ptr es:[di+TOEXT+1],dbcsA2 ; Target Head is DBCS 2nd ?
        .if     nz                      ; Overwrite DBCS 1st
            mov     byte ptr es:[di-2],20h ;set space
            mov     word ptr es:[di+TOEXT-2], EXTRA_ATTR ;reset flag
        .endif                          ; 

        push    si
        push    di
        push    cx
        rep     movsw                   ; Move Cells
        pop     cx
        pop     di
        pop     si
        add     si, TOEXT
        add     di, TOEXT
        rep     movsw                   ; Move Extra Attr1/2
        sub     si, TOEXT
        sub     di, TOEXT

;;                                      ; SI/DI-Pointed to Last+2 Cell
        .if     < si lt [bp].Sub_Buffsize > and
        test    byte ptr ds:[si+TOEXT+1],dbcsA2 ; Source Tail is DBCS 1st ?
        .if     nz                      ; Overwrite DBCS 2nd
            mov     byte ptr ds:[si], 20h ; Fill Blank to Second
            mov     byte ptr ds:[si-2], 20h ; Fill Blank to First
            mov     word ptr ds:[si+TOEXT], EXTRA_ATTR ;reset flag
            mov     word ptr ds:[si+TOEXT-2], EXTRA_ATTR ;reset flag
            mov     byte ptr es:[di-2],20h ;Change Copied Byte to Space
            mov     word ptr es:[di+TOEXT-2], EXTRA_ATTR ;reset flag
        .endif

        .if     < di lt [bp].Sub_Buffsize > and
        test    byte ptr es:[di+TOEXT+1],dbcsA2 ; Target Tail is DBCS 1st ?
        .if     nz                      ; Overwrite DBCS 2nd
            mov     byte ptr es:[di],20h ;set space
            mov     word ptr es:[di+TOEXT], EXTRA_ATTR ;reset flag
        .endif                          ; 

        ret
ATLAS_UpLeft endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     ATLAS_DnRight                                   *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Down/Right          *
;*                      Move a one line.                                *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGASCROL.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  STD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
ATLAS_DnRight proc
        public  ATLAS_DnRight
        push    ax

        mov     ax, [bp].Sub_Buffsize   ; 
        sub     ax, 2                   ; 
        push    ax                      ; Save Last Size
        .if     < si lt ax > and        ; 
        mov     al, ds:[si+TOEXT+1]     ; Source Head is DBCS 1st ?
        and     al, dbcsA1+dbcsA2       ; 
        .if     < al e dbcsA1 >         ; 
            mov     byte ptr ds:[si], 20h ; Fill Blank to First
            mov     byte ptr ds:[si+2], 20h ; Fill Blank to Second
            mov     word ptr ds:[si+TOEXT], EXTRA_ATTR ;reset flag
            mov     word ptr ds:[si+TOEXT+2], EXTRA_ATTR ;reset flag
        .endif
        pop     ax                      ; Restore Last Size

        .if     < di lt ax > and        ; 
        mov     al, es:[di+TOEXT+1]     ; Target Head is DBCS 1st ?
        and     al, dbcsA1+dbcsA2       ; 
        .if     < al e dbcsA1 >         ; Overwrite DBCS 2nd
            mov     byte ptr es:[di+2],20h ;set space
            mov     word ptr es:[di+TOEXT+2], EXTRA_ATTR ;reset flag
        .endif                          ; 

        push    si
        push    di
        push    cx
        rep     movsw                   ; Move Cells
        pop     cx
        pop     di
        pop     si
        add     si, TOEXT
        add     di, TOEXT
        rep     movsw                   ; Move Extra Attr1/2
        sub     si, TOEXT
        sub     di, TOEXT
;;                                      ; SI/DI-Pointed to Last Cell-1
        .if     < si ge 0 > and         ; 
        mov     al, ds:[si+TOEXT+1]     ; Source Tail is DBCS 2nd ?
        and     al, dbcsA1+dbcsA2       ; 
        .if     < al e dbcsA1 >         ; 
            mov     byte ptr ds:[si], 20h ; Fill Blank to First
            mov     byte ptr ds:[si+2], 20h ; Fill Blank to Second
            mov     word ptr ds:[si+TOEXT], EXTRA_ATTR ;reset flag
            mov     word ptr ds:[si+TOEXT+2], EXTRA_ATTR ;reset flag
            mov     byte ptr es:[di+2],20h ; Change Copied byte to Space
            mov     word ptr es:[di+TOEXT+2], EXTRA_ATTR ;reset flag
        .endif

        .if     < di ge 0 > and         ; 
        mov     al, es:[di+TOEXT+1]     ; Target Tail is DBCS 2nd ?
        and     al, dbcsA1+dbcsA2       ; 
        .if     < al e dbcsA1 >         ; Overwrite DBCS 1st
            mov     byte ptr es:[di],20h ;set space
            mov     word ptr es:[di+TOEXT], EXTRA_ATTR ;reset flag
        .endif                          ; 

        pop     ax
        ret
ATLAS_DnRight endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     ATLAS_CFill                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Fill Cell           *
;*                      Fill one line with Cell into LVB.               *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  Tartget LVB Address             (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  CLD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
ATLAS_CFill proc
        public  ATLAS_CFill

        .if     < di ge 2 > and         ; 
        test    byte ptr es:[di+TOEXT+1],dbcsA2 ; Target Head is DBCS 2nd ?
        .if     nz                      ; Overwrite DBCS 1st
            mov     byte ptr es:[di-2],20h ;set space
            mov     word ptr es:[di+TOEXT-2], EXTRA_ATTR ;reset flag
        .endif                          ; 

        mov     ax,[bp].FillCellLow
        push    di
        push    cx
        rep     stosw                   ; Fill line with cell
        pop     cx
        pop     di
        add     di, TOEXT
        mov     ax, EXTRA_ATTR
        rep     stosw                   ; Fill Extra Attr1/2
        sub     di, TOEXT

        .if     < di lt [bp].Sub_Buffsize > and ; 
        test    byte ptr es:[di+TOEXT+1],dbcsA2 ; Target Tail is DBCS 1st ?
        .if     nz                      ; Overwrite DBCS 2nd
            mov     byte ptr es:[di],20h ;set space
            mov     word ptr es:[di+TOEXT], EXTRA_ATTR ;reset flag
        .endif                          ; 

        ret
ATLAS_CFill endp

R2CSEG  ENDS
        END
