;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    60,132
        TITLE   ATLSFONT.ASM -- Font Call Routine and Make Regen Code

;/*****************************************************************************
;*
;* SOURCE FILE NAME = ATLSFONT.ASM
;*
;* DESCRIPTIVE NAME = Regen Font Related Routine for ATLAS
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*   10/02/89  J-KK1002           KKJ, Add Fontcall and ASPA Support.
;*   10/05/89  J-KK1005           KKJ, Add Sub_Option.
;*   10/31/89  J-KK1031           KKJ, All Changed.
;*   12/13/89  J-KK1213           KKJ,     for User Font. Requested by Funaki san.
;****************************************************************************/

        .286p                           ; 286 protect mode instructions

        .xlist
        INCLUDE struc.inc               ; Structure macro
        INCLUDE vdhequ.inc              ; Buffer update equates
        INCLUDE vdhstruc.inc            ; Buffer update data structures
        .list

        IFDEF   FONT_SUPPORT            ; 
        ENDIF

R2CSEG  SEGMENT WORD    PUBLIC 'CODE'
        ASSUME  CS:R2CSEG,DS:NOTHING,ES:NOTHING

;***********************************************************************
;*   Entry    : ATLAS_INTTOREGEN
;*
;*   Function : Internal code to ATLAS Regen Code Conversion
;*
;*   Input    : AX = internal code  AH - 1st, AL - 2nd
;*   Output   : AX = ATLAS Regen Code (if CY=0)
;*            : CF = 0 if in ROM
;*                   1 if not in ROM
;*
;*
;* Japan Valid Internal Code
;*  1st byte    8140-854Fh  JIS Non-Kanji
;*               |          Not in ROM
;*              87D9-9FFCh  JIS 1
;*
;*              E040-EAA2h  JIS 2
;*               |          Not in ROM
;*              FA40-FC4Bh  IBM Extension
;*               |          Not in ROM
;*              FCFFh
;*
;*  2nd byte    40-7Eh
;*              80-FCh
;***********************************************************************
ATLAS_INTTOREGEN PROC NEAR
        public  ATLAS_INTTOREGEN

        mov     [bp].Sub_FONTD,ax       ;                              J-KK1213
        test    byte ptr [bp].Sub_Option, ALWAYS_FNTCALL ;             J-KK1005
        .if     < nz >                  ; Always Call Font ?           J-KK1005

TO_FONT:
            IFDEF   FONT_SUPPORT        ; 

                push    bx
                mov     [bp].Sub_FONT,1 ; 
                lea     bx, [bp].Sub_FONT ; 
                push    ss              ;selector
                push    bx              ;offset
                push    1               ;increment use count
                mov     ax,[bp].Sub_FONTD
                pop     bx

            ENDIF                       ; 

        .else                           ;                              J-KK1002
            CMP     AX,854FH
            JBE     TS_HOK2             ;JIS non-KANJI
            CMP     AX,87D9H
            JB      NOT_ROM
            CMP     AX,9FFCH            ;JIS 1
            JBE     TS_HOK2
            CMP     AX,0EAA2H
            JBE     TS_HOK1             ;JIS  2
            CMP     AX,0FA40H
            JB      NOT_ROM
            CMP     AX,0FC4BH
            JBE     TS_HOK1             ;IBM extention
            JMP     NOT_ROM

TS_HOK1:
            SUB     AH,0E0H-0A0H
TS_HOK2:
            SUB     AH,81H

;; Check 2nd byte
            CMP     AL,040H             ;40H-7EH,80H-FCH
            JB      TS_ERROR
            CMP     AL,07EH
            JBE     TS_LOK2
            CMP     AL,080H
            JB      TS_ERROR
            CMP     AL,0FCH
            JBE     TS_LOK1
NOT_ROM:
TS_ERROR:
            JMP     TO_FONT             ; This Internal Code is not in ROM.
                                        ; Call FNTCALLS
TS_LOK1:
            DEC     AL
TS_LOK2:
            SUB     AL,40H

            push    cx
            MOV     CX,AX
            MOV     AL,CH
            MOV     AH,444-256
            MUL     AH
            XOR     CH,CH
            ADD     AX,CX
            ADD     AX,100H             ;BEGEN FROM 100H
            pop     cx
            .if     < ax ge 10972 >     ;IBM Extension ?
                add     ax,21796
            .endif
TS_EXIT:
        .endif                          

        RET
ATLAS_INTTOREGEN ENDP

R2CSEG  ENDS
        END
