;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    60,132
        TITLE   ATLS3LVB.ASM -- Buffer Write Routines for ATLAS 3 bytes Format

;/*****************************************************************************
;*
;* SOURCE FILE NAME = ATLS3LVB.ASM
;*
;* DESCRIPTIVE NAME:    BUFFERUPDATE write routines
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS    WriteCellStrA, WriteCharStrA, WriteCharStrAttrA,
;*              WriteNCharA, WriteNAttrA, WriteNCellA
;*
;* NOTES:       None
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  UpdateRegenA    (in COMMNPVB.ASM)
;*                      CheckDBCS       (in XGAWRITE.ASM)
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*   09/11/89  j-ys911                 fix for P0013 sct$12cc. In entry, SI/DI points 2nd attribute.
;*                                But  implementaion treated as if they start at 1st byte of cell.
;*   09/25/89  J-KK0925           KKJ, ROM Font -> RAM Font
;*   10/03/89  J-KK1003           KKJ, INSTALLATION
;*   10/31/89  J-KK1031           KKJ,     Fix for Exception Handling
;*   11/01/89  J-KK1101           KKJ, Change Extra Hankaku Handling
;*   11/17/89  J-KK1117           KKJ, P0162 12CC - Not Set DBCS 2nd bit at CharStrAttr.
;*   11/29/89  J-KK1129           KKJ, Limit Check for NCELL and NCHAR with DBCS.
;*   11/30/89  J-KK1130           KKJ, CLD is assumed in CFill.
;*   06/16/93  J-TS0616           TSO, DBCS Exception handling of VioWrtNAttr
;*   07/07/93  J-TS0707           TSO, DBCS J-TS0616 doesn't take care of buffer end
;****************************************************************************/

;;J-KK0925 temp    equ     0h
temp    equ     EXTRA_ATTRHigh          ;;ROM Font -> RAM Font J-KK0925

        .286c                           ; 286 protect mode instructions

        .xlist
        INCLUDE struc.inc               ; Structure macro
        INCLUDE vdhequ.inc              ; Buffer update equates
        INCLUDE vdhstruc.inc            ; Buffer update data structures
        .list

        IFNDEF  INSTALLATION            ; Installation J-KK1003
            EXTRN   CheckDBCS:NEAR
            EXTRN   UpdateRegenA:NEAR
            EXTRN   UpdateAttrA:NEAR
        ENDIF

R2CSEG  SEGMENT WORD    PUBLIC 'CODE'
        ASSUME  CS:R2CSEG,DS:NOTHING,ES:NOTHING

        IFDEF   INSTALLATION            ; Installation J-KK1003
Dummy       proc    near
WriteCStrA  label   byte
WriteNCellA label   byte
WriteNCharA label   byte
WriteNAttrA label   byte
ATLAS3UpLeft label  byte
ATLAS3DnRight label byte
ATLAS3CFill label   byte
ATLAS3CFillR label  byte
            public  WriteCStrA
            public  WriteNCellA
            public  WriteNCharA
            public  WriteNAttrA
            public  ATLAS3UpLeft
            public  ATLAS3DnRight
            public  ATLAS3CFill
            public  ATLAS3CFillR
            ret
Dummy       endp
        ELSE

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteCStrA                                      *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write cells/chars/charsA   *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteCStrA  proc
            public  WriteCStrA
            mov     bx, [bp].Sub_index  ; Get Function Index
            .if     < bx e WCELL >      ;Cell ?             ;j-ys718
                shr     cx,1            ;                   ;j-ys718
                mov     [bp].Sub_length,cx ;                ;j-ys719
            .endif                      ;                   ;j-ys718
;;*** Update LVB
            Call    HeadBounda          ; 
            xor     dx,dx               ;clear the char counter
            .while  ncxz  near          ; 
                xor     ax,ax
                .if     < bx e WCELL >  ;Cell ?
                    lodsb               ;get a next cell
                    add     si,3        ;skip attr0,1,2
                    mov     ah,[si-1]   ;get character set bits (attr2)
                .elseif < bx e WCHAR >  ;Char ?
                    lodsb               ;get a next char
                .else                   ;CharAttribute
                    lodsb               ;get a next char
                    mov     ah,byte ptr [bp].Sub_attribute2 ;get attr2 ;J-KK1101
                .endif                  ; 
                dec     cx              ;adjust the loop counter (CX)
                inc     dx              ;increment the char counter (DX)

                .if     <ah e TypeF>    ;extention hankaku  ?     ;j-ys728
                    clc                 ;reset DBCS check flag    ;j-ys728
                .else                   ;                         ;j-ys728
                    call    CheckDBCS   ; 
                .endif                  ;                         ;j-ys728
                .if     c               ;if char have DBCS lead byte
                    .if     < dx gt 1 > ; Hankaku Char Counter must be GT 1.
                        push    ax      ; save ax
                        dec     dx      ; Adjust
                        push    si      ; 
                        dec     si      ; Adjust
                        cmp     bx,WCELL ; 
                        .if     e       ; 
                            sub     si,3 ;adjust si for attr
                        .endif          ; 
                        call    Writea  ; Write the leading Hankaku String
                        pop     si      ; 
                        pop     ax      ; 
                    .endif

                    xor     dx,dx       ;clear the char counter (DX)
                    .if     ncxz        ;   & cx > 0
                        mov     ah,al   ;ah is DBCS lead
                        lodsb
                        cmp     bx,WCELL
                        .if     e       ; 
                            add     si,3 ;adust si for attr
                        .endif          ; 
                        dec     cx      ;adjust the loop counter (CX)

                        xchg    al,ah   ; 
                        call    PutDBCSa ;write dbcs into LVB
                    .else               ; Terminate with DBCS leading byte
                                        ; Ignored the last byte
                        dec     [bp].Sub_length
                    .endif              ; 
                .endif                  ; End of DBCS Case
            .endwhile                   ; 

            call    Writea              ;Write Hankaku Char to LVB
            call    TailBounda

;;*** Update PVB
            call    UpdateRegenA

            ret
WriteCStrA  endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNCellA                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N cells              *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNCellA proc
            public  WriteNCellA
;;*** Update LVB

            pushf                       ; 
            Call    HeadBounda          ; 
            popf                        ; 
            .if     c                   ;*** DBCS Cell
                mov     dx,ds:[si+2]    ;Get 2nd Cell           ;j-ys718
                .repeat                 ; 
                    stosw               ;Store 1st Cell
                    movsw               ;store 1st attr1/2
                    and     byte ptr es:[di-1], not (dbcsA1+dbcsA2) ; Clear J-KK1031
                    or      byte ptr es:[di-1], dbcsA1 ; Set DBCS 1st   J-KK1031
                    xchg    ax,dx       ; 
                    stosw               ;Store 2nd Cell
                    add     si,2
                    movsw               ;store 2nd attr1/2
                    and     byte ptr es:[di-1], not (dbcsA1+dbcsA2) ; Clear J-KK1031
                    or      byte ptr es:[di-1], dbcsA2+dbcsA1 ; Set DBCS 2nd J-KK031
                    xchg    ax,dx       ; 
                    sub     si,6        ;<===
                .loop                   ; 
            .else                       ;*** SBCS Cell
                mov     dx,ds:[si]      ;get second attr             ;j-ys731
                and     dh,not (dbcsA1+dbcsA2) ; To Hankaku          ;J-KK1101
                .repeat                 ;                            ;j-ys728
                    stosw               ;Fill buffer with Cells      ;j-ys728
                    mov     es:[di],dx  ;                            ;j-ys728
                    add     di,2        ;                            ;j-ys728
                .loop                   ;                            ;j-ys728
            .endif                      ; 
            call    TailBounda          ; 

;;*** Update PVB
            call    UpdateRegenA

            ret
WriteNCellA endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNCharA                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N chars              *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNCharA proc
            public  WriteNCharA

;;*** Update LVB
;;J-KK1129            call    CheckDBCS           ;
;;J-KK1129            .if     c
;;J-KK1129                mov     dx, cx
;;J-KK1129                shl     dx, 1           ; Adjust word offset length
;;J-KK1129                mov     [bp].Sub_length, dx ;   for DBCS chars
;;J-KK1129                stc
;;J-KK1129            .endif
            pushf
            Call    HeadBounda          ; 
            popf
            .if     c                   ;*** DBCS handling
                mov     ah,ds:[si]      ; Get 2nd Character
                .repeat                 ; 
                    stosb               ;Set the lead byte
;;J-KK1031      mov     byte ptr es:[di+2], temp+dbcsA1 ; DBCS 1st Attr
                    and     byte ptr es:[di+2], not (dbcsA1+dbcsA2) ; Clear J-KK1031
                    or      byte ptr es:[di+2], dbcsA1  ; DBCS 1st Attr   J-KK1031
                    add     di,3        ; 
                    mov     byte ptr es:[di],ah ;Store the second byte
;;J-KK1031      mov     byte ptr es:[di+3], temp+dbcsA2+dbcsA1 ; DBCS 1st Attr
                    and     byte ptr es:[di+3], not (dbcsA1+dbcsA2) ; Clear J-KK1031
                    or      byte ptr es:[di+3], dbcsA2+dbcsA1  ; DBCS 2nd J-KK1031
                    add     di,4        ; 
                .loop
            .else                       ;*** SBCS handling
                .repeat                 ; 
                    stosb               ;Store character
;;J-KK1031      mov     byte ptr es:[di+2], temp       ; Clear DBCS Attr
                    and     byte ptr es:[di+2], not (dbcsA1+dbcsA2) ; Clear J-KK1031
                    add     di,3        ;Skip attribute
                .loop                   ; 
            .endif                      ; 
            call    TailBounda

;;*** Update PVB
            call    UpdateRegenA

            ret
WriteNCharA endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNAttrA                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N attribute          *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNAttrA proc
            public  WriteNAttrA

        mov     ah, es:[di+3]           ; First char is DBCS 2nd ?      ;J-TS0616
        and     ah, dbcsA1+dbcsA2                                       ;J-TS0616
        .if     <ah eq dbcsA1+dbcsA2>                                   ;J-TS0616
            inc     [bp].Sub_length                                     ;J-TS0616
            sub     [bp].Sub_offset, 4                                  ;J-TS0616
            sub     [bp].PVBOff, 2                                      ;J-TS0616
        .endif                                                          ;J-TS0616

            mov     ax,word ptr ds:[si-1] ; Get Attr0/1
            push    bx                  ;                               J-KK1101
            mov     bl,ds:[si+1]        ; Get Attr2                    ;J-KK1101
            and     bl, not (dbcsA1+dbcsA2) ;                          ;J-KK1101

;;*** Update LVB
            .repeat
                inc     di              ;Skip char byte
                stosw                   ;set attribute
                mov     bh, byte ptr es:[di] ; Store Attr2              J-KK1101
                and     bh, dbcsA1+dbcsA2 ; Get DBCS bits of Original   J-KK1101
                or      bh, bl          ; Marge                         J-KK1101
                mov     es:[di], bh     ; Store Attr2                   J-KK1101
                inc     di              ;skip sysytem byte and char     ;j-ys718
            .loop
            pop     bx                  ;                               J-KK1101

        mov     ah, es:[di-1]           ; Last char is DBCS 1st ?       ;J-TS0707
        and     ah, dbcsA1+dbcsA2                                       ;J-TS0616
        .if     <ah eq dbcsA1>                                          ;J-TS0707
            inc     [bp].Sub_length                                     ;J-TS0616
        .endif                                                          ;J-TS0616

;;*** Update PVB
            call    UpdateAttrA

            ret
WriteNAttrA endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME: XXXXX                                               *
;*                                                                      *
;* DESCRIPTIVE NAME:    DBCS Exeption Handling Routine                  *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
;; OverWriting Handling
;; DS:SI - User Buffer
;; ES:DI - LVB
HeadBounda  PROC    NEAR                ;OverWriting of Head DBCS Widow
            cmp     di,4                ;check start of screen or not ?
            .if     ge
                test    byte ptr es:[di+3],dbcsA2 ;DBCS 2nd ?
                .if     nz              ; 
                    mov     byte ptr es:[di-4],20h ;set space
                    and     byte ptr es:[di-1], not (dbcsA1+dbcsA2) ; Clear J-KK1031
                    inc     [bp].Sub_length ;adjust repeat count
                    sub     [bp].Sub_offset,4 ;adjust offset            J-KK1031
                    sub     [bp].PVBOFF,2     ;adjust offset            ;J-TS00

                .endif                  ; 
            .endif
            ret                         ; 
HeadBounda  ENDP                        ; 

TailBounda  PROC    NEAR                ;Overwriting of Tail DBCS Widow
            cmp     di, [bp].Sub_Buffsize ;check end of screen or not ?
            .if     b
                test    byte ptr ES:[DI+3],dbcsA2 ; Target Tail+1 is DBCS 2nd ?
                .if     nz              ; 
                    mov     byte ptr es:[di],20h ;set space
                    and     byte ptr es:[di+3], not (dbcsA1+dbcsA2) ; Clear J-KK1031
                    add     di,4
                    inc     [bp].Sub_length ;adjust repeat count
                .endif                  ; 
            .endif
            ret                         ; 
TailBounda  ENDP                        ; 

PutDBCSa    PROC
;  al:lead   dbcs
;  ah:second dbcs
            .if     < bx e WCELL >      ;Cell ?
                stosb                   ;store dbcs lead byte
                push    ax
                mov     ax,word ptr ds:[si-7] ;get 1st cell attribute
                stosw                   ;store dbcs lead byte attr0/1
                and     byte ptr es:[di], not (dbcsA1+dbcsA2) ; Clear   J-KK1031
                or      byte ptr es:[di], dbcsA1 ; set dbcs 1st flag    J-KK1031
                inc     di
                pop     ax
                xchg    al,ah           ; 
                stosb                   ;store dbcs second byte
                mov     ax,word ptr ds:[si-3] ;get 2nd cell attribute
                stosw                   ;store dbcs second byte attribute
                and     byte ptr es:[di], not (dbcsA1+dbcsA2) ; Clear   J-KK1031
                or      byte ptr es:[di], dbcsA1+dbcsA2 ; dbcs 2nd flag J-KK1031
                inc     di
            .elseif < bx e WCHAR >      ;Char ?
                stosb                   ;store dbcs lead byte
                and     byte ptr es:[di+2], not (dbcsA1+dbcsA2) ; Clear   J-KK1031
                or      byte ptr es:[di+2], dbcsA1 ; dbcs 1st flag       J-KK1031
                add     di,3
                xchg    al,ah
                stosb                   ;store dbcs second byte
                and     byte ptr es:[di+2], not (dbcsA1+dbcsA2) ; Clear   J-KK1031
                or      byte ptr es:[di+2], dbcsA1+dbcsA2 ;dbcs 2nd flag J-KK1031
                add     di,3
            .else                       ;Char Attribute

                stosb                   ;set 1st char
                push    ax              ;store dbcs first byte
                mov     ax,word ptr [bp].Sub_attribute ; Set Attr0/1
                stosw

                mov     al, byte ptr [bp].Sub_attribute2 ; Set Attr2    J-KK1101
                or      al, dbcsA1      ; set dbcs 1st flag                  J-KK1101
                stosb                   ;                                               J-KK1101

                pop     ax

                xchg    al,ah           ;store dbcs second byte
                stosb
                mov     ax,word ptr [bp].Sub_attribute
                stosw
                mov     al, byte ptr [bp].Sub_attribute2 ; Set Attr2    J-KK1101
                or      al, dbcsA1+dbcsA2 ; set dbcs 2nd flag           J-KK1117
                stosb                   ;                                               J-KK1101
            .endif
            ret
PutDBCSa    ENDP

Writea      PROC                        ;Hankaku write routine
            Public  Writea
            push    cx
            sub     si,dx               ;adjust si
            mov     cx,dx
            .if     ncxz
                .if     < bx e WCELL >  ;Cell ?
                    sub     si,dx       ;adjust si more!
                    sub     si,dx       ;adjust si more!        ;j-ys718
                    sub     si,dx       ;adjust si more!        ;j-ys718
                    .repeat
                        movsw
                        movsw
                    .loop
                .elseif < bx e WCHAR >  ;Char ?
                    .repeat
                        and     byte ptr es:[di+3], not (dbcsA1+dbcsA2) ;Clear J-KK1031
                        movsb
                        add     di,3    ;Skip Attr
                    .loop
                .else                   ;CharAttribute
                    mov     ax,word ptr [bp].Sub_attribute
                    push    bx          ;                                       J-KK1101
                    mov     bl, byte ptr [bp].Sub_attribute2 ; Get Attr2J-KK1101
                    and     bl, not (dbcsA1+dbcsA2) ; Clear DBCS bits   J-KK1101
                    .repeat
                        movsb
                        stosw
                        mov     byte ptr es:[di], bl ; Store Attr2      J-KK1101
                        inc     di
                    .loop
                    pop     bx          ;                                       J-KK1101
                .endif
            .endif
            pop     cx
            ret
Writea      ENDP


;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     ATLAS3UpLeft                                    *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Up/Left             *
;*                      Move a one line.                                *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGASCROL.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  CLD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
ATLAS3UpLeft proc
            public  ATLAS3UpLeft
            .if     < si ge 4 >  and    ; 
            test    byte ptr ds:[si+3],dbcsA2 ; Source Head is DBCS 2nd ?
            .if     nz                  ; 
                mov     byte ptr ds:[si], 20h ; Fill Blank to Second
                mov     byte ptr ds:[si-4], 20h ; Fill Blank to First
                and     byte ptr ds:[si+3], not (dbcsA1+dbcsA2) ;Clear J-KK1031
                and     byte ptr ds:[si-1], not (dbcsA1+dbcsA2) ;Clear J-KK1031
            .endif                      ; 

            .if     < di ge 4 >  and    ; 
            test    byte ptr es:[di+3],dbcsA2 ; Target Head is DBCS 2nd ?
            .if     nz                  ; Overwrite DBCS 1st
                mov     byte ptr es:[di-4],20h ;set space
                and     byte ptr es:[di-1], not (dbcsA1+dbcsA2) ;Clear J-KK1031
            .endif                      ; 

            rep     movsw               ; Move Cells

;;                                      ; SI/DI-Pointed to Last+2 Cell
            .if     < si lt [bp].Sub_Buffsize > and
            test    byte ptr ds:[si+3],dbcsA2 ; Source Tail is DBCS 1st ?
            .if     nz                  ; Overwrite DBCS 2nd
                mov     byte ptr ds:[si], 20h ; Fill Blank to Second
                mov     byte ptr ds:[si-4], 20h ; Fill Blank to First
                and     byte ptr ds:[si+3], not (dbcsA1+dbcsA2) ;Clear J-KK1031
                and     byte ptr ds:[si-1], not (dbcsA1+dbcsA2) ;Clear J-KK1031
                mov     byte ptr es:[di-4],20h ;Change Copied Byte to Space
                and     byte ptr es:[di-1], not (dbcsA1+dbcsA2) ;Clear J-KK1031
            .endif

            .if     < di lt [bp].Sub_Buffsize > and
            test    byte ptr es:[di+3],dbcsA2 ; Target Tail is DBCS 1st ?
            .if     nz                  ; Overwrite DBCS 2nd
                mov     byte ptr es:[di],20h ;set space
                and     byte ptr es:[di+3], not (dbcsA1+dbcsA2) ;Clear J-KK1031
            .endif                      ; 
            ret
ATLAS3UpLeft endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     ATLAS3DnRight                                   *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Down/Right          *
;*                      Move a one line.                                *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGASCROL.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  STD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
ATLAS3DnRight proc
            public  ATLAS3DnRight
            push    ax

            mov     ax, [bp].Sub_Buffsize ; 
            sub     ax, 4               ; 
            push    ax                  ; Save Last Size
            .if     < si lt ax > and    ; 
            mov     al, ds:[si+1]       ; Source Head is DBCS 1st ?           ;j-ys911
            and     al, dbcsA1+dbcsA2   ; 
            .if     < al e dbcsA1 >     ; 
                mov     byte ptr ds:[si-2], 20h ; Fill Blank to First       ;j-ys911
                mov     byte ptr ds:[si+2], 20h ; Fill Blank to Second      ;j-ys911
                and     byte ptr ds:[si+1], not (dbcsA1+dbcsA2) ;Clear J-KK1031
                and     byte ptr ds:[si+5], not (dbcsA1+dbcsA2) ;Clear J-KK1031
            .endif
            pop     ax                  ; Restore Last Size

            .if     < di lt ax > and    ; 
            mov     al, es:[di+1]       ; Target Head is DBCS 1st ?           ;j-ys911
            and     al, dbcsA1+dbcsA2   ; 
            .if     < al e dbcsA1 >     ; Overwrite DBCS 2nd
                mov     byte ptr es:[di+2],20h ;set space                   ;j-ys911
                and     byte ptr es:[di+5], not (dbcsA1+dbcsA2) ;Clear J-KK1031
            .endif                      ; 

            rep     movsw               ; Move Cells
;;                                      ; SI/DI-Pointed to Last Cell-1
            .if     < si ge 2 > and     ;                            ;j-ys911
            mov     al, ds:[si+1]       ; Source Tail is DBCS 2nd ?        ;j-ys911
            and     al, dbcsA1+dbcsA2   ; 
            .if     < al e dbcsA1 >     ; 
                mov     byte ptr ds:[si-2], 20h ; Fill Blank to First       ;j-ys911
                mov     byte ptr ds:[si+2], 20h ; Fill Blank to Second      ;j-ys911
                and     byte ptr ds:[si+1], not (dbcsA1+dbcsA2) ;Clear J-KK1031
                and     byte ptr ds:[si+5], not (dbcsA1+dbcsA2) ;Clear J-KK1031
                mov     byte ptr es:[di+2],20h ; Change Copied byte to Space;j-ys911
                and     byte ptr es:[di+5], not (dbcsA1+dbcsA2) ;Clear J-KK1031
            .endif

            .if     < di ge 0 > and     ; 
            mov     al, es:[di+1]       ; Target Tail is DBCS 2nd ?           ;j-ys911
            and     al, dbcsA1+dbcsA2   ; 
            .if     < al e dbcsA1 >     ; Overwrite DBCS 1st
                mov     byte ptr es:[di-2],20h ;set space               ;j-ys911
                and     byte ptr es:[di+1], not (dbcsA1+dbcsA2) ;Clear J-KK1031
            .endif                      ; 

            pop     ax

            ret
ATLAS3DnRight endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     ATLAS3CFill                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Fill Cell           *
;*                      Fill one line with Cell into LVB.               *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  Tartget LVB Address             (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  CLD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
ATLAS3CFill proc
            public  ATLAS3CFill

            shr     cx,1                ;j-ys727

            .if     < di ge 4 > and     ; 
            test    byte ptr es:[di+3],dbcsA2 ; Target Head is DBCS 2nd ?
            .if     nz                  ; Overwrite DBCS 1st
                mov     byte ptr es:[di-4],20h ;set space
                and     byte ptr es:[di-1], not (dbcsA1+dbcsA2) ;Clear J-KK1031
            .endif                      ; 

            push    dx                  ;                               ;j-ys718
            mov     ax,[bp].FillCellLow
            mov     dx,[bp].FillCellHigh ;                          ;j-ys718
            and     dh, not (dbcsA1+dbcsA2) ; Clear DBCS bits       J-KK1101
            .repeat                     ;                               ;j-ys718
                stosw                   ; Fill char and attr0
                xchg    ax,dx           ;                               ;j-ys718
                stosw                   ; Fill attr1 and attr2          ;j-ys718
                xchg    ax,dx           ;                               ;j-ys718
            .loop                       ;                               ;j-ys718
            pop     dx                  ;                               ;j-ys718

            .if     < di lt [bp].Sub_Buffsize > and ; 
            test    byte ptr es:[di+3],dbcsA2 ; Target Tail is DBCS 1st ?
            .if     nz                  ; Overwrite DBCS 2nd
                mov     byte ptr es:[di],20h ;set space
                and     byte ptr es:[di+3], not (dbcsA1+dbcsA2) ;Clear J-KK1031
            .endif                      ; 

            ret
ATLAS3CFill endp

        ENDIF

R2CSEG  ENDS
        END
