;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    ,132
        NAME    VVVTEXTA
        TITLE   Virtual Video Vtext Support

;/*****************************************************************************
;*
;* SOURCE FILE NAME = VVVTEXTA.ASM
;*
;* DESCRIPTIVE NAME = Virtual Video Device Vtext Support
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/10/93
;*
;* DESCRIPTION  This module contains the VVD's Vtext support routines.
;*
;* FUNCTIONS
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*   03/10/93                     Created.
;*
;*****************************************************************************/

        .xlist
        include mvdm.inc
        include vddseg.inc
        include struc30.inc
        .list
        include vvd.inc
        include vvdp.inc


        DefCode     IMPORT,SWAP,PASCAL
        DefFn       vvAddEvent
        DefFn       mapc
        DefFn       IsKanjiGale
        EndCode


        DefCode     EXPORT,SWAP,PASCAL

IFDEF   VTEXT

        DefFn       vvUpdateCursorDataVtext
        DefFn       vvCopyLVBToLVBVtext

;***LP  vvUpdateCursorDataVtext() - Return current cursor data for Vtext
;
;   Returns current row, column, start and end scan lines, and
;   current visibility for cursor.
;
;   ENTRY
;       hvdm -> VDM
;   EXIT
;       None
;   USES
;       All but EBX, ESI, EDI, EBP, DS and ES
;
;   CONTEXT
;       Task-time
;
;   PSEUDO-CODE                                     REFERENCES
;
        align   4
Procedure vvUpdateCursorDataVtext
        ArgVar  hvdm,HVDM

        EnterProc
        push    ebx
        push    edx
        push    edi

        mov     ebx, [hvdm]
        lea     edi, VDMData.vvCursor[ebx]
        mov     dx, VDMBase.rb_nVCharHeight[ebx]

        mov     cx, VDMBase.rb_wVCursorMode[ebx]
        mov     al, dl
        call    mapc
        .if     <ch ae dl> or                   ; hidden cursor
        .if     <ch a cl>                       ; or invalid type
            mov     [edi].vvc_fVisible, FALSE
        .else
            mov     [edi].vvc_fVisible, TRUE
        .endif
        .if     <cl ae dl>                      ; too large cursor
            mov     cl, dl
            dec     cl
        .endif
        movzx   eax, cl
        mov     [edi].vvc_ulScanEnd, eax
        movzx   eax, ch
        mov     [edi].vvc_ulScanStart, eax
        movzx   eax, byte ptr VDMBase.rb_awVCursorPos[ebx]
        mov     [edi].vvc_col, eax
        movzx   eax, byte ptr VDMBase.rb_awVCursorPos[ebx+1]
        mov     [edi].vvc_row, eax

        CallFn  vvAddEvent, <ebx, VVDEVENT_CURSOR, edi, 0>

        pop     edi
        pop     edx
        pop     ebx
        ExitProc
EndProc   vvUpdateCursorDataVtext

;***LP  vvCopyLVBToLVBVText() - Copy rectangle of LVB to specfied LVB
;
;   WARNING: This only supports text mode!
;
;   ENTRY
;       hvdm  -> VDM
;       prcl  -> rectangle description
;       pBuff -> destination LVB buffer
;   EXIT
;       None
;   USES
;       32-bit small-model PASCAL calling/register conventions
;   CONTEXT
;       Task-time
;
        align   4
Procedure vvCopyLVBToLVBVtext
        ArgVar  hvdm,HVDM
        ArgVar  prcl,PRECTL
        ArgVar  pBuff,PVOID
IFDEF   XVIO
        ArgVar  fFrom,BOOL
ENDIF   ;XVIO

        LocalVar    Rows,      DWORD
        LocalVar    Cols,      DWORD
        LocalVar    SkipCount, DWORD
        LocalVar    KanjiFlag, BYTE

        EnterProc
        push    ebx
        push    esi
        push    edi

        mov     ebx, [hvdm]
        mov     esi, VDMData.GaleData.pVtextLVB[ebx]
        .if     <esi eq 0>
            jmp     LVBToLVBVTextExit
        .endif
        add     esi, ebx                        ; source LVB addr
        mov     edi, [pBuff]                    ; target buffer

        mov     edx, [prcl]                     ; get rect ptr

        mov     eax, [edx].xRight
        sub     eax, [edx].xLeft
        inc     eax
        mov     [Cols], eax                     ; copy cols count
        jz      LVBToLVBVTextExit

        mov     eax, [edx].yBottom
        sub     eax, [edx].yTop
        inc     eax
        mov     [Rows], eax                     ; copy rows count
        jz      LVBToLVBVTextExit

        mov     eax, VDMData.vvMode.vvm_nCols[ebx]
        sub     eax, [Cols]
        shl     eax, 1
        mov     [SkipCount], eax                ; line skip byte count

        mov     eax, VDMData.vvMode.vvm_nCols[ebx]
        imul    eax, [edx].yTop
        add     eax, [edx].xLeft
        shl     eax, 1                          ; top offset

        mov     ecx, VDMData.ulBIOSMode[ebx]    ; get video mode
        .if     <cl eq 03h> or                  ; CGA format ?
        .if     <cl eq 70h>                     ; 

            add     esi, eax                    ; skip ptrs to top
            add     edi, eax

LVBToLVBVtextLoop1:
            mov     ecx, [Cols]                 ; copy one row
            rep movsw

            add     esi, [SkipCount]            ; skip to next row
            add     edi, [SkipCount]
            dec     [Rows]
            jnz     LVBToLVBVtextLoop1

        .elseif <cl eq 73h> or                  ; Common format ?
        .if     <cl eq 71h>                     ; 
            shl     eax, 1                      ; adjust bytes/cell
            shl     [SkipCount], 1

            add     esi, eax                    ; skip ptrs to top
            add     edi, eax

LVBToLVBVtextLoop2:
            mov     ecx, [Cols]                 ; copy one row
            mov     KanjiFlag, 0                ; clear kanji flag

LVBToLVBVtextLoop3:
            lodsd
            and     eax, 008cffffh              ; clear reserved attribute
            .if     <KanjiFlag eq 0>            ; Not DBCS 2nd ?
                call    IsKanjiGale
                .if     <c>                     ; DBCS 1st ?
                    mov     KanjiFlag, 1
                    or      eax, 01000000h
                .endif
            .else                               ; DBCS 2nd
                or      eax, 81000000h
                mov     KanjiFlag, 0
            .endif
            stosd
            loop    LVBToLVBVtextLoop3

            add     esi, [SkipCount]            ; skip to next row
            add     edi, [SkipCount]
            dec     [Rows]
            jnz     LVBToLVBVtextLoop2
        .endif

LVBToLVBVTextExit:
        pop     edi
        pop     esi
        pop     ebx
        ExitProc
EndProc   vvCopyLVBToLVBVtext

ENDIF   ;VTEXT

        EndCode     EXPORT,SWAP,PASCAL


        END
