;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    ,132
        NAME    VVSTUB
        TITLE   Virtual Video Device Driver VTEXT V86 Stub Code

;/*****************************************************************************
;*
;* SOURCE FILE NAME = VVSTUB.ASM
;*
;* DESCRIPTIVE NAME = Virtual Video Device Driver VTEXT V86 Stub Code
;*
;*
;* VERSION      V2.0
;*
;* DATE         93/05/12
;*
;* DESCRIPTION This module contains
;*              - int 10h pre/pos hook.
;*              - mouse pointer draw/erase routine for VTEXT mode
;*                using int 10h that must run in V86 mode.
;*
;* FUNCTIONS
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*   05/12/93                     Created.
;*
;*****************************************************************************/

        .xlist
        include struc30.inc
        .list

        .8086           ; This is run in real mode

; The next few lines are used by an awk script.
;
; #### HEADERFILE=vvstub.h
; #### ENTRYPOINT=VtextStubEntry
; #### LENGTH=VTEXT_STUB_LENGTH
;
; #### BEGIN EXTRACTION
;  It is used by n awk script to convert the listing file into an .ASM file.

code    segment byte public 'CODE'

        assume cs:code, ds:code, es:code

VtextStubEntry  proc far
        ret
VtextStubEntry  endp

IFDEF   VTEXT

;
; INT 10H hook routine to support VTEXT
;

Int10HookEntry  label byte              ; #### LABEL=VTEXT_INT10_HOOK_ENTRY
VtextInt10Hook  proc far
        inc     byte ptr cs:[inflag]
        cmp     byte ptr cs:[inflag], 1
        jnz     Int10HookCallOrg
        mov     word ptr cs:[axlog], ax
        mov     word ptr cs:[bxlog], bx

Int10HookCallOrg:
        pushf
;       call $DISP
        db      9ah
Int10OrgAddr1   label byte              ; #### LABEL=VTEXT_INT10_ORG_ADDR1
        db      0, 0, 0, 0
        dec     byte ptr cs:[inflag]
        jnz     Int10HookSkipHook

;       call    HookEntry
        db      9ah
Int10HookAddr1  label byte              ; #### LABEL=VTEXT_INT10_HOOK_ADDR1
        db      0, 0, 0, 0

Int10HookSkipHook:
        iret
VtextInt10Hook  endp

StatInflag      label byte              ; #### LABEL=VTEXT_INT10_STAT_INFLAG
inflag  db      0
StatAX          label byte              ; #### LABEL=VTEXT_INT10_STAT_AX
axlog   dw      0
StatBX          label byte              ; #### LABEL=VTEXT_INT10_STAT_BX
bxlog   dw      0

;
; INT 10H pre-hook routine to support VTEXT
;

Int10PreHookEntry   label byte          ; #### LABEL=VTEXT_INT10_PREHOOK_ENTRY
VtextInt10PreHook   proc far
;       call    HookEntry
        db      9ah
Int10HookAddr2  label byte              ; #### LABEL=VTEXT_INT10_HOOK_ADDR2
        db      0, 0, 0, 0
        pushf
;       call    $DISP
        db      9ah
Int10OrgAddr2   label byte              ; #### LABEL=VTEXT_INT10_ORG_ADDR2
        db      0, 0, 0, 0
        iret
VtextInt10PreHook   endp

;
; Screen redrawing routine when the screen is switched
; from PM to fullscreen VDM
;

RerawEntry      label byte              ; #### LABEL=VTEXT_REDRAW_ENTRY
vvVtextRerawScreen  proc far

        mov     ax, 4002h               ; notify the screen switch
        int     2fh
        retf
;
;        mov     ax, 40h                 ; save set mode MSB value
;        mov     ds, ax
;        mov     al, ds:[87h]
;        mov     cs:[RedrawVstat], al
;
;        mov     ah, 03h                 ; get cursor position
;        xor     bh, bh
;        int     10h
;
;        mov     cs:[RedrawCsrPos], dx   ; save cursor type & position
;        mov     cs:[RedrawCsrType], cx
;
;        xor     ah, ah                  ; int 10h set mode function
;        mov     al, cs:[RedrawMode]     ; mode number
;        or      al, 80h
;        int     10h
;
;        mov     al, cs:[RedrawVstat]    ; restore set mode MSB value
;        and     al, 80h
;        and     byte ptr ds:[87h], 7fh
;        or      ds:[87h], al
;
;        cmp     cs:[RedrawMode], 03h
;        jz      RedrawScreen0
;        cmp     cs:[RedrawMode], 73h
;        jnz     RedrawScreen1
;
;RedrawScreen0:
;        cmp     cs:[RedrawRow], 25
;        jz      RedrawScreen1
;
;        mov     ax, 1118h               ; int 10h character generator function
;        xor     bl, bl
;        int     10h
;
;RedrawScreen1:
;        mov     ah, 01h                 ; restore cursor type & position
;        mov     cx, cs:[RedrawCsrType]
;        int     10h
;
;        mov     ah, 02h
;        mov     dx, cs:[RedrawCsrPos]
;        xor     bh, bh
;        int     10h
;
;        retf
vvVtextRerawScreen  endp

RedrawCsrPos    dw      0
RedrawCsrType   dw      0
RedrawVstat     db      0
RdwMode         label byte              ; #### LABEL=VTEXT_REDRAW_MODE
RedrawMode      db      0
RdwRow          label byte              ; #### LABEL=VTEXT_REDRAW_ROW
RedrawRow       dw      0

;
; Mouse pointer drawing routine
;

DrawEntry       label byte              ; #### LABEL=VTEXT_PTR_DRAW_ENTRY
vvVtextPtrDraw  proc near
        mov     ax, cs
        mov     ds, ax
        mov     es, ax                  ; setup segment registers

        mov     di, offset IsKanji

        mov     ax,1310h
        mov     bh, 0
        mov     cx, xNew
        inc     cx
        inc     cx
        mov     dh, byte ptr yNew
        mov     dl, 0
        mov     bp, offset ReadString
        int     10h                     ; read the line where ptr is.

        mov     si, offset ReadString
        mov     cx, xNew
        add     si, cx
        add     si, cx
        dec     si
        dec     si
        .if     <cx eq 0>               ; pointer is at the top of line ?
            jmp     CheckTargetChar
        .endif

DBCSScanLoop:                           ; check DBCS
        mov     al, [si]
        call    di
        jnc     DBCSScanLoopExit
        dec     si
        dec     si
        loop    DBCSScanLoop

DBCSScanLoopExit:
        sub     cx, xNew
        and     cx, 0001h
        jnz     CharDBCS2nd

CheckTargetChar:
        mov     si, offset ReadString
        add     si, xNew
        add     si, xNew
        mov     al, [si]
        call    di
        jc      CharDBCS1st

CharSBCS:                               ; target char is SBCS
        mov     ax, [si]
        mov     SaveChars, ax
        mov     cx, 1
        mov     CharType, 0
        jmp     DrawPointer

CharDBCS1st:                            ; target char is DBCS 1st
        mov     ax, [si    ]
        mov     SaveChars,     ax
        mov     ax, [si + 2]
        mov     SaveChars + 2, ax
        mov     cx, 2
        mov     CharType, 1
        jmp     DrawPointer

CharDBCS2nd:                            ; target char is DBCS 2nd
        mov     si, offset ReadString
        add     si, xNew
        add     si, xNew

        mov     ax, [si - 2]
        mov     SaveChars,     ax
        mov     ax, [si    ]
        mov     SaveChars + 2, ax
        mov     cx, 2
        mov     CharType, 3

DrawPointer:
        mov     ax, SaveChars           ; copy saved chars
        mov     WriteString,     ax
        mov     ax, SaveChars + 2
        mov     WriteString + 2, ax

        mov     dh, byte ptr yNew
        mov     dl, byte ptr xNew

        mov     si, AttrAnd
        mov     di, AttrXor
        .if     <CharType ne 3>
            mov     bl, byte ptr WriteString
            and     WriteString, si
            xor     WriteString, di
            .if     <CharType eq 1> and
            .if     <bl ne <byte ptr WriteString>>
                mov     byte ptr WriteString + 2, 20h
            .endif
        .else
            mov     bl, byte ptr WriteString + 2
            and     WriteString + 2, si
            xor     WriteString + 2, di
            dec     dl
            .if     <bl ne <byte ptr WriteString + 2>>
                mov     byte ptr WriteString, 20h
            .endif
        .endif

        mov     CharSaved, 1

        mov     CharPos, dx             ; save char position

        mov     ax, 1320h
        mov     bh, 0
        mov     bp, offset WriteString
        int     10h

        retf
vvVtextPtrDraw  endp

;
; Mouse pointer erasing routine
;

EraseEntry      label byte              ; #### LABEL=VTEXT_PTR_ERASE_ENTRY
vvVtextPtrErase proc near
        mov     ax, cs
        mov     ds, ax
        mov     es, ax                  ; setup segment registers

        .if     <CharSaved ne 0>
            mov     ax, 1320h
            mov     bh, 0
            mov     cx, CharType
            and     cx, 01h
            inc     cx
            mov     dx, CharPos
            mov     bp, offset SaveChars
            int     10h

            mov     CharSaved, 0
        .endif

        retf
vvVtextPtrErase endp

;
; Mouse pointer updating routine
;

UpdateEntry     label byte              ; #### LABEL=VTEXT_PTR_UPDATE_ENTRY
vvVtextPtrUpdate proc near
        push    cs
        mov     di, offset vvVtextPtrErase
        call    di
        push    cs
        mov     di, offset vvVtextPtrDraw
        call    di
        retf
vvVtextPtrUpdate endp

;
; DBCS 1st range chack routine
;

IsKanji proc    near
        .if     <al ae DBCSVect[0]> and
        .if     <al be DBCSVect[1]>
            ret
        .endif
        .if     <al ae DBCSVect[2]> and
        .if     <al be DBCSVect[3]>
            ret
        .endif

        clc
        ret
IsKanji endp

xNewParam       label byte              ; #### LABEL=VTEXT_PTR_PARAM_XNEW
xNew    dw      0
yNewParam       label byte              ; #### LABEL=VTEXT_PTR_PARAM_YNEW
yNew    dw      0
AttrAndParam    label byte              ; #### LABEL=VTEXT_PTR_PARAM_ATTRAND
AttrAnd dw      0
AttrXorParam    label byte              ; #### LABEL=VTEXT_PTR_PARAM_ATTRXOR
AttrXor dw      0
DBCSVectParam   label byte              ; #### LABEL=VTEXT_PTR_PARAM_DBCSVECT
DBCSVect db     0, 0, 0, 0

WriteString dw  0, 0
ReadString  dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            dw  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
SaveChars   dw  0, 0
CharPos     dw  0
CharType    dw  0
CharSaved   dw  0

VtextPtrEnd     label byte              ; This line is a dummy to keep the AWK
                                        ; happy with the byte length count
                                        ; PUT ALL DATA/CODE ABOVE THIS LABEL

ENDIF   ;VTEXT

;
; #### END EXTRACTION

code    ends

        end
