;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE        ,132
        TITLE        Virtual Video I/O Processing for OEM-specific ports

;/*****************************************************************************
;*
;* SOURCE FILE NAME = VVOEM.ASM
;*
;* DESCRIPTIVE NAME = Virtual Video I/O Processing for OEM-specific ports 
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/02/88
;*
;* DESCRIPTION  This module contains the VVD's OEM-specific I/O handlers.
;*
;* FUNCTIONS    VVReadCompaqCtrlBgnd()      Read Compaq Control Mode byte background
;*              VVWriteCompaqCtrlBgnd()     Write Compaq Control Mode byte background
;*              VVReadATIIndxBgnd()         Read ATI index byte background
;*              VVWriteATIIndxBgnd()        Write ATI index byte background
;*              VVReadATIDataBgnd()         Read ATI data byte background
;*              VVWriteATIDataBgnd()        Write ATI data byte background
;*              
;* NOTES        25-May-90 ATI EGA/VGA Wonder support added
;*
;*                  Besides the stuff you see below, it also turns out the ATI
;*                  VGA ROM accesses the CGAMODE and CGACOLOR registers (3D8/3D9) at
;*                  times.  However, ignoring the accesses appears to do no harm,
;*                  so for now we'll just assume it's a bit of useless old support.
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*   03/02/88                     JTP - Created.
;*
;*   02/26/92                     Added more ATI support for SVGA.
;*
;*   02/27/92                     B733211 - Performance enhancement to
;*                                320x200 mode.
;*
;*   10/15/92                     ATI background virtualisation.
;*                                                                                      
;*   12/04/92                     Update shadow before vvMapBank call.
;*                                                                                      
;*****************************************************************************/


        .xlist
        include mvdm.inc
        include vddseg.inc
        .list
        include vvd.inc
        include vvdp.inc


       IFDEF SVGA						;          
        DefCode     IMPORT,SWAP,PASCAL				;          
        DefFn       	 vvMapBank				;          
        EndCode							;          
       ENDIF							;          

        DefCode     EXPORT,SWAP,PASCAL

       IFDEF COMPAQ
       IFDEF EGA
        DefFn            VVReadCompaqCtrlBgnd
        DefFn            VVWriteCompaqCtrlBgnd
       ENDIF
       ENDIF

       IFDEF ATI
       IFDEF EGAVGA
        DefFn            VVReadATIIndxBgnd
        DefFn            VVWriteATIIndxBgnd
        DefFn            VVReadATIDataBgnd
        DefFn            VVWriteATIDataBgnd
       ENDIF
       ENDIF


       IFDEF COMPAQ
       IFDEF EGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVReadCompaqCtrlBgnd()
;*
;* DESCRIPTION   = Read Compaq Control Mode byte background 
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM reads a byte from the COMPAQ_CTRL register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = EBX -> VDM register frame
;*                 EDX == port number (PORT_COMPAQ_CTRL)
;*
;* OUTPUT        = AL  == data read
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVReadCompaqCtrlBgnd
        mov        al,VDMData.regCompaqCtrl    ;return mode value
        ExitProc
EndProc   VVReadCompaqCtrlBgnd

       ENDIF ;EGA
       ENDIF ;COMPAQ


       IFDEF COMPAQ
       IFDEF EGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVWriteCompaqCtrlBgnd()
;*
;* DESCRIPTION   = Write Compaq Control Mode byte background 
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM writes a byte to the COMPAQ_CTRL register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = AL == data to write
;*                 EBX -> VDM register frame
;*                 EDX == port number (PORT_COMPAQ_CTRL)
;*
;* OUTPUT        =
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVWriteCompaqCtrlBgnd
        mov        VDMData.regCompaqCtrl,al    ;stash the COMPAQ_CTRL value
        ExitProc
EndProc   VVWriteCompaqCtrlBgnd

       ENDIF ;EGA
       ENDIF ;COMPAQ


       IFDEF ATI
       IFDEF EGAVGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVReadATIIndxBgnd()
;*
;* DESCRIPTION   = Read ATI index byte background 
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM reads a byte from the ATIINDX register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;*                 Currently, this routine allows the access to hit the actual
;*                 hardware, because we have no data on virtualization for these
;*                 ATI-specific registers.
;*
;* INPUT         = EBX -> VDM register frame
;*                 EDX == port number (PORT_ATIEGA_INDX)
;*
;* OUTPUT        = AL  == data read                      
;*                                                       
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVReadATIIndxBgnd
IFDEF        SVGA
        mov        al,VDMData.regATIIndx       ;return true value
ELSE
        INB        al,dx                            ;return real h/w value
ENDIF
        ExitProc
EndProc   VVReadATIIndxBgnd

       ENDIF ;EGAVGA
       ENDIF ;ATI


       IFDEF ATI
       IFDEF EGAVGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVWriteATIIndxBgnd()
;*
;* DESCRIPTION   = Write ATI index byte background
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM writes a byte to the ATIINDX register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;*                 Currently, this routine allows the access to hit the actual
;*                 hardware, because we have no data on virtualization for
;*                 these ATI-specific registers.
;*
;* INPUT         = AL == data to write
;*                 EBX -> VDM register frame
;*                 EDX == port number (PORT_ATIEGA_INDX)
;*
;* OUTPUT        = None                                  
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVWriteATIIndxBgnd
IFDEF        SVGA
        mov        VDMData.regATIIndx,al       ;reflect true index value
ELSE
        OUTB        dx,al                            ;set real h/w value
ENDIF
        ExitProc
EndProc   VVWriteATIIndxBgnd

       ENDIF ;EGAVGA
       ENDIF ;ATI


       IFDEF ATI
       IFDEF EGAVGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVReadATIDataBgnd()
;*
;* DESCRIPTION   = Read ATI data byte background 
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM reads a byte from the ATIDATA register (see VDHInstallIOHook
;*                 for complete semantics).
;*
;*                 Currently, this routine allows the access to hit the actual hardware,
;*                 because we have no data on virtualization for these ATI-specific registers.
;*
;* INPUT         = EBX -> VDM register frame
;*                 EDX == port number (PORT_ATIEGA_DATA)
;*
;* OUTPUT        = AL  == data read
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVReadATIDataBgnd
IFDEF        SVGA
        movzx        ecx,VDMData.regATIIndx            ;get index
        and        cl,MAX_ATIREGS-1            ;don't over-index
        mov        al,VDMData.aregATIData[ecx] ;get indexed data
ELSE
        INB        al,dx                            ;return real h/w value
ENDIF
        ExitProc
EndProc   VVReadATIDataBgnd

       ENDIF ;EGAVGA
       ENDIF ;ATI


       IFDEF ATI
       IFDEF EGAVGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVWriteATIDataBgnd()
;*
;* DESCRIPTION   = Write ATI data byte background 
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM writes a byte to the ATIDATA register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;*                 Currently, this routine allows the access to hit the actual
;*                 hardware, because we have no data on virtualization for
;*                 these ATI-specific registers.
;*
;* INPUT         = AL == data to write
;*                 EBX -> VDM register frame
;*                 EDX == port number (PORT_ATIEGA_DATA)
;*
;* OUTPUT        = None                                   
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVWriteATIDataBgnd
IFDEF        SVGA
        LocalVar ulPrevBank,ULONG			;          
	
        EnterProc					;          

	push	eax					;          
        movzx   ecx,VDMData.regATIIndx			;get index
        and     cl,MAX_ATIREGS-1			;don't over-index
	mov	al,VDMData.aregATIData[ecx]		;          
	mov	ulPrevBank,eax				;          
	pop	eax					;          
        mov     VDMData.aregATIData[ecx],al		;save indexed data

	cmp	cl,0b2h					;          
	jne	@F					;          
	test	VDMData.flVDMVideo,VDM_FGND		;          
	jnz	@F					;          
	cmp	VDMData.mstateVideo,MEMORY_GRFX256	;          
	jne	@F					;          
	shr	al,1					;          
	and	eax,0fh					;          
	shr	ulPrevBank,1				;          
	and	ulPrevBank,0fh				;          
	cmp	eax,ulPrevBank				;          
	je	@F					;          
	push	eax					;          
	mov	eax,ulPrevBank				;          
	mov	VDMData.ulDirtyBankEvent,eax		;          
	call	vvMapBank				;          
@@:							;          

ELSE
        OUTB        dx,al                            ;set real h/w value
ENDIF
        ExitProc
EndProc   VVWriteATIDataBgnd

       ENDIF ;EGAVGA
       ENDIF ;ATI


        EndCode     EXPORT,SWAP,PASCAL


        END
