/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VVGALE.H
 *
 * DESCRIPTIVE NAME = Virtual Video Private Definitions for Gale VDM
 *
 *
 * VERSION = V2.0
 *
 * DATE      91/07/22
 *
 * DESCRIPTION  VVD private constants, types, and function prototypes
 *              for Gale VDM
 *
 * FUNCTIONS    None
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define GALE_SBCS_FONT_SIZE         (19 * 256)      // SBCS 16 font buffer size
#define GALE_LVB_SIZE               (80 * 30 * 4)   // LVB size
#define GALE_WIDTH                  80              // screen width
#define GALE_HEIGHT                 25              // screen height

#define GALE_DEFAULT_CHAR_ATTR0     0x0720          // default char/attr0
#define GALE_DEFAULT_ATTR1_ATTR2    0x0000          // default attr1/attr2

#define MAX_PAGESPERPLANE_VGA       0x10            // max page of VGA

typedef struct {                                    // graphics mode
    BYTE brightness;                                // print screen
    BYTE pattern[8];                                // brightness emulation
} PRINT_BOX_PATTERN;                                // pattern

#define GALE_HS_OFF                 0x00            // hardware scroll off
#define GALE_HS_ON                  0x01            // hardware scroll on
#define GALE_HS_LC                  0x02            // hardware scroll with
                                                    // line compare reg.

#define DOT_WIDTH_COMPACT           640             // screen dot width
#define DOT_WIDTH_WIDE              1024            // screen dot width
