;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;**************************************************************************
;
;  SOURCE FILE NAME = VVDP.INC
;
;  DESCRIPTIVE NAME = Virtual Video Private Definitions
;
;
;  VERSION = V2.0
;
;  DATE	     11/10/88
;
;  DESCRIPTION	VVD private constants, types, and function prototypes
;
;  FUNCTIONS	None
;
;  NOTES
;
;  STRUCTURES
;
;  EXTERNAL REFERENCES
;
;  EXTERNAL FUNCTIONS
;
;  CHANGE ACTIVITY =
;    DATE      FLAG	   APAR	  CHANGE DESCRIPTION
;    --------  ----------  -----  --------------------------------------
;    04/22/91	          	  XGA enhancements to control whether
;				  VGA should save/restore the video
;				  state on a single XGA configuration
;				  system (i.e.  P75 or PS/2 with monitor
;				  attached only to the XGA) where the
;				  XGA boots up in VGA mode.
;    05/09/91	          	  fix PM video corruption when session
;				  switch back to PM while the VDM in a
;				  multi-plane graphics mode.  (B790553,
;				  B722596)
;    05/23/91	          	  Reenable video on destruction of a
;				  VDM not successfully created.
;				  (B714830)
;    06/13/91	          	  B723811 - Avoid arming the TimerEvent
;					    hook routine more than once.
;    06/20/91	          	  Fix video corruption problem when
;				  session switch away from PM while
;				  window VDMs are in the mist of
;				  updating the off-screen VRAM through
;				  the PMVDMP thread.
;    07/18/91	          	  B767777 On a MPA, save/restore 4K of
;				  VRAM not the 16k required for EGA/VGA
;				  MONO emulation.
;    09/14/91	          	  Delete window syncronization references
;				  (tag B726840)
;    12/19/91	          	  B731047 - Changed Int 2f code for DPMI
;				  applications
;    02/04/92	          	  B731109 - Use LVB size for validation
;    02/15/92	          	  B733006 - Performance enhancement to
;				  copy routines
;    02/20/92	          	  SVGA additions
;    03/17/92	          	  B728098 - Complete VDM codepage support
;    03/27/92	          	  B735007 - avoid screen corruption on
;					    Starlight
;    05/15/92	          	  SM11856 - changes for 32-bit DISPLAY
;					    driver
;    05/18/92	          	  Add event for DDE support
;    07/09/92	          	  IBM SVGA enhancements
;    07/14/92	          	  xxxxxxx - Edit video tables prototype
;		          	  Unknown
;		          	  Unknown
;		          	  Unknown
;    09/25/92	            53355 Search through install drives for
;				  svgadata.pmi
;    09/18/92	            24801 Track recursive _INT 10 calls
;    09/28/92	            53954 Number of lock commands increased
;    10/16/92	          	  Background virtualisation support.
;    10/29/92	            53954 Save/restore lock state changes.
;    11/06/92	            55199 Add HVDM to GetLockState().
;    11/10/92	          	  Keep track of linear buffer growth
;    11/11/92	          	  Shadow state of Orchid Clock select reg 3DD
;    11/17/92	            57000 Logical line length added to instance data and VRAMSize to global data.
;    12/04/92	            56883 Don't disable 8514 if not present
;    12/18/92	          	  Cirrus Logic support.
;    12/28/92	          	  Use chip detection logic in SCREENDD.
;    12/29/92	          	  SVGA common definitions moved to SVGADEFS.C.
;    02/08/93	          	  Diamond SpeedStar modifications
;    02/08/93	          	  New function in vvpage.c
;    02/15/93	          	  SVGA _INT 2F processing.
;    02/25/93	           62876  Added another instance flag flVDMX2Video.
;    03/02/93	           62837  New vvSVGASetBgnd function.
;    03/08/93	           56402  Don't allow overindexing into ATC on SVGA's.
;    03/08/93	           63354  Let VVGA know that VXGA is also installed
;    03/09/93	          	  Unmap VRAM for VXGA
;    03/11/93	          	  Allow IO trapping off in full-screen VDM.
;    03/30/93	           65283  Let VVGA know that v8514 is also present.
;    03/31/93	           64902  SVGA port trap list constant.
;    04/02/93	           65532  PrepareForTransfer.
;    04/26/93	           62914  Invalid Hook Handle
;    06/04/93	           F69306 Add support for S3
;    06/17/93	           70710  Hi-color support for S3
;    06/24/93	           70168  Add vvDisableVRAM routine
;    10/06/93	           72687  Support Number Nine adapters with S3
;    10/22/93	           73003  Save/Restore DAC for hi-color modes on S3
;    11/02/93	           75458  S3 Merge
;    08/18/93	J-TS0818  JS05766 ET4000 VTEXT driver cannot be installed
;				  in windowed VDM.
;    08/27/93	J-TS0827  JS05740 Screen switch of WinJOS2 session sometimes
;				  becomes black.
;    12/22/93  Changeteam  75466  Added debug routine prototype vvDebugSaveInfo
;				  (to fix build break defect #76938).
;    03/31/94	J-TS0331  JS06539 Using Stealth-PRO, 1280*1024 256 color
;				  fullscreen WinJOS2 isn't invoked correctly.
;
; *********************************************************************


ifdef  XVIO							       ;J-TS00V
	include	vxvio.inc
endif  ;XVIO							      //J-TS00V

COMPAQ	EQU 1		;provide built-in Compaq support
TSENG	EQU 1		;provide built-in Tseng Labs support
ATI	EQU 1		;provide built-in ATI EGA/VGA Wonder support

ifdef SVGA
  VGA	EQU 1
	include	svgadefs.inc		;          
endif

ifdef CGA
  CGAEGA	EQU 1		;define CGAEGA to mean "CGA or EGA"
  ADAPTER_TYPE	EQU	<ADAPTER_CGA>
else
  ifdef EGA
    CGAEGA	EQU 1
  endif
endif

ifdef EGA
  EGAVGA	EQU 1		;define EGAVGA to mean "EGA or VGA"
  ADAPTER_TYPE	EQU	<ADAPTER_EGA>
else
  ifdef VGA
    EGAVGA	EQU 1
  endif
endif

ifdef VGA
  ADAPTER_TYPE	EQU	<ADAPTER_VGA>
endif

ifdef MONO
  MONOCGA	EQU 1		;define MONOCGA to mean "MONO or CGA"
  ADAPTER_TYPE	EQU	<ADAPTER_MONO>
else
  ifdef CGA
    MONOCGA	EQU 1
  endif
endif

ifndef MONO
PROPERTIES	EQU 1		;include properties support
endif



; * Physical constants (non-configurable)
;

BELL	EQU	007h
BS	EQU	008h
CR	EQU	00Dh
LF	EQU	00Ah
ESCAPE	EQU	01Bh


;/

	include	int2f.inc
INT2F_VDMENABLESR	EQU	04000h
INT2F_SYSBGND	EQU	04001h
INT2F_SYSFGND	EQU	04002h
INT2F_VDMENTERCRITSEC	EQU	04003h
INT2F_VDMEXITCRITSEC	EQU	04004h
INT2F_SYSSAVEREGS	EQU	04005h
INT2F_SYSRESTOREREGS	EQU	04006h
INT2F_VDMDISABLESR	EQU	04007h


ifdef MONO
VRAM_START	EQU	<MONOMEM_START>
VRAM_LEN	EQU	(4*1024)    ;true MPA has 4K of VRAM	               
MAX_PLANES	EQU	1
MAX_PLANESIZE	EQU	<VRAM_LEN>		;          
endif

ifdef CGA
VRAM_START	EQU	<CGAMEM_START>
VRAM_LEN	EQU	<CGAMEM_LEN>
MAX_PLANES	EQU	1
MAX_PLANESIZE	EQU	<CGAMEM_LEN>
endif

ifdef EGAVGA
VRAM_START	EQU	<EGAVGAMEM_START>
VRAM_LEN	EQU	<EGAVGAMEM_LEN>
MAX_PLANES	EQU	4
MAX_PLANESIZE	EQU	(64*1024)
endif

ifdef SVGA		       ;This allows us up to 1Meg Video Memory
MAX_BANKS	EQU	4	;with 4 planes and 4 banks of 64k each.
else
MAX_BANKS	EQU	1
endif

BANK0	EQU	0
BANKSIZE	EQU	(64*1024)	;banks are 64k bytes           





MAX_PAGESPERPLANE equ ((MAX_PLANESIZE+PAGESIZE-1)/PAGESIZE)






VRAM_PAGES equ ((VRAM_LEN+PAGESIZE-1)/PAGESIZE)




; * Configurable constants
;

BELL_FREQ	EQU	896	;(hz)
BELL_DURATION	EQU	125	;(ms)

TICKS_DIRTY	EQU	1	;check for dirt every n ticks (default)
PEEKS_CHECK	EQU	10	;check for events every n peeks
TIMER_CHECK	EQU	125	;wait 1/8 sec between event checks
TIMER_DELAY	EQU	3000	;3000ms (3 sec) maximum update delay

MAX_RTRCLOOP	EQU	04000h	;maximum # iterations to wait for retrace

MAX_ALTSTACK	EQU	256	;256 bytes should be sufficient

MAX_TITLESIZE	EQU	13	;enough space for 8.3 filename + NULL

ifdef SVGA

MAX_VDM_WAIT	EQU	15000	;max screen-switch delay (ms)           
MAX_ENGINE_WAIT		EQU	1000   ;wait for engine (ms)	               
MASK_ALL_LOCKED		EQU	0FFFFh	;For non WD, mark first 15 LOCKED           

CRTOVFL_VERTDSPEND2	EQU	0040h	    ;bit 9 of Vertical Display End

DEFAULT_VRAM_SIZE	EQU	1024*1024	     ;          

				;           S3 support start

; * NOTE: this list of registers MUST be kept in sync with aportWReg.
; * The array reflects the range of 8514 compatible regs on S3 chip.
;
				;private indexes into aportWReg
WREG_SUBSYSCTRL		EQU	0
WREG_ADVCTRL	EQU	1
WREG_COMMAND	EQU	2
WREG_CURRENTY	EQU	3
WREG_CURRENTX	EQU	4
WREG_DESTYAXSTP		EQU	5
WREG_DESTXDIASTP	EQU	6
WREG_ERRORTERM	EQU	7
WREG_MAJORAXISCNT	EQU	8
WREG_BGNDCOLOR	EQU	9
WREG_FGNDCOLOR	EQU	10
WREG_WRITEMASK	EQU	11
WREG_READMASK	EQU	12
WREG_COLORCOMPARE	EQU	13
WREG_BGNDMIX	EQU	14
WREG_FGNDMIX	EQU	15
WREG_SHORTSTROKE	EQU	16
WREG_PIXELTRANSFER	EQU	17
WREG_PIXELTRANSFER_EXT	EQU	18
WREG_TOTAL	EQU	19

MFINDX_MISCCTRL		EQU	0E000h

MFREG_MINORAXISCNT	EQU	(MFINDX_MINORAXISCNT	SHR  MFINDX_INDXSHIFT)
MFREG_TOPSCISSORS	EQU	(MFINDX_TOPSCISSORS	SHR  MFINDX_INDXSHIFT)
MFREG_LEFTSCISSORS	EQU	(MFINDX_LEFTSCISSORS	SHR  MFINDX_INDXSHIFT)
MFREG_BOTTOMSCISSORS	EQU	(MFINDX_BOTTOMSCISSORS	SHR  MFINDX_INDXSHIFT)
MFREG_RIGHTSCISSORS	EQU	(MFINDX_RIGHTSCISSORS	SHR  MFINDX_INDXSHIFT)
MFREG_PIXELCTRL		EQU	(MFINDX_PIXELCTRL	SHR  MFINDX_INDXSHIFT)
MFREG_MISCCTRL	EQU	(MFINDX_MISCCTRL	SHR  MFINDX_INDXSHIFT)
					;           S3 support end

SierraDAC	EQU	0		;          
ATTDAC	EQU	1		;          
MusicDAC	EQU	2		;          
S3_BT485DAC	EQU	3		;          
SGSDAC	EQU	4		;          
DEFAULT_DAC	EQU	-1		 ;          
endif


 ;Adapter types
; *
; *  For the most part, we'd prefer to always implement a single solution
; *  for any given problem for all existing adapters, but inevitably
; *  certain adapters need something a little different.  Where possible,
; *  we will try to determine the adapter-type automatically.  Where
; *  impossible, we may provide a switch to specify the adapter type on
; *  the DEVICE= line in CONFIG.SYS.  The following is a list of
; *  supported adapter types it is recorded in ulAdapter (which starts
; *  out as ADAPTER_IBM until we discover otherwise).
; *
; * Note that the adapter categories are fairly broad at this
; *	point.  There's no reason for it to remain that way however
; *	(ie, we may well want to add different adapter codes for
; *	different adapters from a single manufacturer).
;

ADAPTER_IBM	EQU	1	;IBM adapter
ADAPTER_COMPAQ	EQU	2	;Compaq adapter
ADAPTER_TSENG	EQU	3	;Tseng Labs adapter
ADAPTER_VIDEO7	EQU	4	;Video Seven adapter
ADAPTER_ATI	EQU	5	;ATI Wonder adapter

ifdef SVGA			       ;          

SVGA_PMIFILENAME	EQU	"c:\\os2\\svgadata.pmi"	 ;          
PMICMD_RMWB	EQU	7				  ;          
PMICMD_RMWW	EQU	8				  ;          

MAX_ATCREGS	EQU	020h	;           do not allow overindexing
					;index 20-3F writes to 0-1F with PAL enable
MAX_SEQREGS	EQU	0100h
MAX_GDCREGS	EQU	0100h
MAX_CRTREGS	EQU	0100h
MAX_DACREGS	EQU	0100h
MAX_ATIREGS	EQU	0100h

ATI_START_EXTREGS	EQU	0a0h
ATI_END_EXTREGS		EQU	0c0h
ATI_TOTAL_INITREGS	EQU	(ATI_END_EXTREGS - ATI_START_EXTREGS)

DefType PFNSVGASETBANK,dd
DefType PFNSVGAGETBANK,dd

PORT_TSENG_SEGSELECT	EQU	03cdh
PORT_TSENG_UNLOCK	EQU	03d8h
PORT_HERC_COMPATIBILITY		EQU	03bfh

INDX_TRIDENT_REGDEF	EQU	00bh	;sequencer indexed port
INDX_TRIDENT_MODECTRL	EQU	00dh	;     "       "

else




;*
;* This whole section is one gigantic FLAG: that would be deleted if
;* H2INC and MASM could handle the macros above.  Handle with care!
;/



MAX_ATCREGS equ 20h
MAX_SEQREGS equ 08h
MAX_GDCREGS equ 10h
ifndef TSENG
MAX_CRTREGS equ 20h
else
MAX_CRTREGS equ 40h
endif
MAX_DACREGS equ 100h





endif


; * Global Video Flags
;

VVD_PRIMARY	EQU	000000001h ;Display is primary display
VVD_MONOPRESENT		EQU	000000002h ;MONO adapter is present in system
VVD_8514PRESENT		EQU	000000004h ;8514 adapter is present in system           
VVD_CTLLOCKED	EQU	000000010h ;Video controller locked by VDD
VVD_CTLWAITING	EQU	000000020h ;Video controller is being requested
VVD_VRAMISTOAST		EQU	000000040h ;VRAM has been trashed by VDD
VVD_THREADEXIT	EQU	000000080h ;Event thread must exit
VVD_REPAINT	EQU	000000100h ;Reset VRAMISTOAST bit	                
VVD_PMBGND	EQU	000000200h ;PM is currently background
VVD_NOPHYSPAGES		EQU	000000400h ;Inhibit PhysPage allocation
VVD_TIMERARMED	EQU	000000800h ;Timerhook armed		                
VVD_GRFXALLOWED		EQU	080000000h ;Windowed graphics allowed for all VDMs



; * Per-VDM Video Flags
;

VDM_WINDOWED	EQU	000000001h ;VDM is windowed
VDM_PMWINDOWED	EQU	000000002h ;VDM is windowed by PM
VDM_MINIMIZED	EQU	000000004h ;VDM is minimized, inhibit events
VDM_FGND	EQU	000000008h ;VDM is foreground
VDM_FGNDREADY	EQU	000000010h ;VDM foreground I/O hooks installed
VDM_BGNDREADY	EQU	000000020h ;VDM background I/O hooks installed
VDM_FOCUS	EQU	000000040h ;VDM has focus
VDM_IOINIT	EQU	000000080h ;VDM I/O initialization is done
VDM_STATEINIT	EQU	000000100h ;Internal state initialization done
VDM_IOUPDATED	EQU	000000200h ;Complete I/O state known
VDM_UNKNOWNFAULT	EQU	000000400h ;Unknown page fault occurred
VDM_MOTIONTRAP	EQU	000000800h ;VRAM motion trapping is in effect
VDM_SPECIALTRAP		EQU	000001000h ;GDC/SEQ trapping is in effect
VDM_UNMAPPED	EQU	000002000h ;All linear mappings currently disabled
VDM_IGNOREFAULT		EQU	000004000h ;Page faults to be ignored
VDM_MODECHANGED		EQU	000008000h ;Mode-change posted but not processed
VDM_MODECHANGING	EQU	000010000h ;Video mode-change in progress
VDM_FROZEN	EQU	000020000h ;We have suspended VDM
VDM_KEYREAD	EQU	000040000h ;Key read recently
VDM_KEYPASTED	EQU	000080000h ;Key pasted recently
VDM_INPUTPOSTED		EQU	000100000h ;No event has been posted since INPUT
VDM_DYING	EQU	000200000h ;VDM is dying
VDM_FGNDHOOK	EQU	000400000h ;FgndContext hook armed
VDM_BGNDHOOK	EQU	000800000h ;BgndContext hook armed
VDM_UPDATEHOOK	EQU	001000000h ;UpdateContext hook armed
VDM_PHYSHOOK	EQU	002000000h ;UpdatePhysContext hook armed
VDM_SHADOWINVALID	EQU	004000000h ;Shadow buffer is invalid
VDM_DIRTYPALETTE	EQU	008000000h ;Virtual palette has been changed
VDM_PHYSPAGE	EQU	010000000h ;VDM owns 1 or more PAGE_PHYSICAL pages
VDM_PHYSPAGECHK		EQU	020000000h ;Toggled with each dirty PHYSPAGE check
VDM_UPDATING	EQU	040000000h ;VDM window is being updated
VDM_GRFXALLOWED		EQU	080000000h ;Windowed graphics is allowed

VDMX_ACTIVE	EQU	000000001h ;Display active (primary or secondary)
VDMX_DEVOWNER	EQU	000000002h ;VDD owns device for this VDM
VDMX_DSPOWNER	EQU	000000004h ;VDD owns display for this VDM
VDMX_INITHOOK	EQU	000000008h ;InitContext hook armed
VDMX_PTRHOOK	EQU	000000010h ;UpdatePtrContext hook armed
VDMX_DEVREQUEST		EQU	000000020h ;DEVREQUEST from this VDD in progress
VDMX_DSPREQUEST		EQU	000000040h ;DSPREQUEST from this VDD in progress
VDMX_INT10INIT	EQU	000000080h ;_INT 10h initialization in progress
VDMX_VDDFAULT	EQU	000000100h ;VDD may cause VDM page fault
VDMX_INT10EMULATE	EQU	000000200h ;_INT 10h emulation in effect
VDMX_RTRCEMULATE	EQU	000000400h ;horz/vert retrace emulation in effect
VDMX_RTRCOVERRIDE	EQU	000000800h ;retrace emulation setting being overridden
VDMX_CGARESTRICT	EQU	000001000h ;CGA restriction in effect
VDMX_MONORESTRICT	EQU	000002000h ;MONO restriction in effect
VDMX_RTRCTRAP	EQU	000004000h ;retrace port trapped
VDMX_SYNCOUTPUT		EQU	000008000h ;synchronous window output
VDMX_WDWSEMREQ	EQU	000010000h ;_INT 10h emulation code has taken sem.
VDMX_CREATEDONE		EQU	000020000h ;VDM creation complete	                
VDMX_INT2FPENDING	EQU	000040000h ;Issue 2F int in SVGA BgndContext           
VDMX_INT2FREGIST	EQU	000080000h ;Another device registered with us for 2F int           
VDMX_SAVERESTORE	EQU	000100000h ;Save/Restore VGA		                
VDMX_RESTOREBTDAC	EQU	000200000h ;Restore Brooktree DAC	                
VDMX_ENHANCEDMODE	EQU	001000000h ;VDM is in enhanced mode	                
VDMX_NOIOTRAPPING	EQU	002000000h ;don't trap foreground IO accesses            
VDMX_UNMAPHOOK	EQU	004000000h ;VVUnMapPhysContext hook armed               
VDMX_SEAMLESS	EQU	008000000h ;Seamless         session	                
VDMX_32DSP	EQU	010000000h ;32-bit DISPLAY Driver call	                
VDMX_ONDEMAND	EQU	020000000h ;Enable on-demand memory allocation
VDMX_INT2F	EQU	040000000h ;Enable _INT 2Fh notifications
VDMX_V86MACHINE		EQU	080000000h ;running as a virtual 8086 machine

ifdef  XVIO							       ;J-TS00V
VDMJ_GRAPHICSWRITE	EQU	000000001h  ;Graph mode str write req.	  ;J-TS00V
VDMJ_CANCELWRITE	EQU	000000002h  ;Cancel GRAPHICSWRITE	  ;J-TS00V
VDMJ_XVIOGACTIVE	EQU	000000004h  ;Graphics mode XVIO is now active. ;J-TS00V
VDMJ_XVIOGHIDE	EQU	000000008h  ;Graphics mode XVIO hide is requested. ;J-TS00V
endif  ;XVIO							      //J-TS00V

ifdef  GALE							       ;J-TS00V
;***	DBCS input environment type				      ;J-TS00V
									;J-TS00V
DBCS_INPUT_SINGLE	EQU	0					;J-TS00V
DBCS_INPUT_DUAL		EQU	1					;J-TS00V
DBCS_INPUT_DOS_KKC	EQU	2					;J-TS00V
endif  ;GALE							      //J-TS00V

VDMX2_FIRSTFGND		EQU	000000001h ;First set foreground           
VDMX2_8514IOINIT	EQU	000000002h ;I/O initialization is done           
VDMX2_8514BLOCKED	EQU	000000004h ;We have blocked VDM I/O           
VDMX2_8514IOOWNED	EQU	000000008h ;I/O ownership flag
VDMX2_8514IOWAKEME	EQU	000000010h ;I/O ownership notify flag
VDMX2_8514ENGBUSY	EQU	000000020h ;engine busy flag

; * Session states
; *
; *  These indicate the state of a VDM session as dictated by foreground
; *  and background notifications.
;

SESSION_NONE	EQU	0	;undefined (only during creation)
SESSION_FGND	EQU	1	;last screen-switch event was SetFgnd
SESSION_BGND	EQU	2	;last screen-switch event was SetBgnd



; * Frozen states
; *
; *  A VDM can be frozen by the video VDD whenever it is background
; *  and tries to access memory in a graphics mode.
;

FROZEN_NONE	EQU	0	;VDM not frozen (by us anyway)
FROZEN_BGND	EQU	1	;frozen due to unsupported memory access



; * Memory states
; *
; *  These indicate the overall state of a VDM's virtual or physical
; *  memory.  Determination is based on registers/bits that define current
; *  addressibility (see vvUpdateVideoState).  For the states of individual
; *  pages of virtual or physical memory, see the PAGE_* constants.
;

MEMORY_LATCH	EQU	-1	 ;private memory state (all planes enabled)
MEMORY_NONE	EQU	0	;no state (only during creation)
MEMORY_TEXT	EQU	1	;single-plane TEXT memory in use
MEMORY_FONT	EQU	2	;plane 2 GRAPHICS memory in use
MEMORY_CGAX	EQU	3	;single-plane GRAPHICS memory in use
MEMORY_GRFX	EQU	4	;multiple-plane GRAPHICS memory in use
MEMORY_GRFX2	EQU	5	;2-color single-plane GRAPHICS memory in use
MEMORY_GRFX256	EQU	6	;256-color single-plane GRAPHICS memory in use

MEMMODE_TEXT	EQU	0	;these are the memory modes described
MEMMODE_FONT	EQU	1	;in each of the RLE entries
MEMMODE_GRFX	EQU	2
MEMMODE_GRFX256		EQU	3
MEMMODE_STATES	EQU	4	;and this is the total unique memory modes



; * Page states
; *
; *  These specify the state of individual pages which comprise a VDM's
; *  virtual memory.  For every plane of virtual video memory, there is an
; *  entry in an array (aapstate) containing one of these state values.
; *  Normally, the values found in that array will be consistent with the
; *  VDM's memory state (mstate), except for brief periods when the virtual
; *  buffer has not yet been converted (see vvUpdatePageStates for details).
;

PAGE_NONE	EQU	000h ;page unaccessed -- no type
PAGE_TEXT	EQU	001h ;page contains text info
PAGE_FONT	EQU	002h ;page contains font info
PAGE_CGAX	EQU	003h ;page contains single-plane graphics info
PAGE_GRFX	EQU	004h ;page contains graphics info
PAGE_GRFX256	EQU	006h ;page contains 256-color graphics info
PAGE_TYPE	EQU	007h ;mask for data type bits
PAGE_PHYSICAL	EQU	008h ;page being emulated using physical VRAM

PAGE_BLANK	EQU	010h ;page is blank (1st of the type modifiers)
PAGE_INVRAM	EQU	020h ;page is currently in physical VRAM
PAGE_VIRTUAL	EQU	040h ;page is mapped to "virtual" VRAM memory
PAGE_SHADOWINVALID	EQU	080h ;page shadow data is not valid

PAGE_VALID	EQU	(PAGE_TYPE OR PAGE_PHYSICAL OR PAGE_BLANK)

ALL_GRFX	EQU	(PAGE_GRFX     OR PAGE_GRFX SHL 8     OR PAGE_GRFX SHL 16     OR PAGE_GRFX SHL 24)
ALL_GRFX256	EQU	(PAGE_GRFX256  OR PAGE_GRFX256 SHL 8  OR PAGE_GRFX256 SHL 16  OR PAGE_GRFX256 SHL 24)
ALL_BLANK	EQU	(PAGE_BLANK    OR PAGE_BLANK SHL 8    OR PAGE_BLANK SHL 16    OR PAGE_BLANK SHL 24)
ALL_INVRAM	EQU	(PAGE_INVRAM   OR PAGE_INVRAM SHL 8   OR PAGE_INVRAM SHL 16   OR PAGE_INVRAM SHL 24)
ALL_VIRTUAL	EQU	(PAGE_VIRTUAL  OR PAGE_VIRTUAL SHL 8  OR PAGE_VIRTUAL SHL 16  OR PAGE_VIRTUAL SHL 24)
ALL_VALID	EQU	(PAGE_VALID    OR PAGE_VALID SHL 8    OR PAGE_VALID SHL 16    OR PAGE_VALID SHL 24)
ALL_PHYSICAL	EQU	(PAGE_PHYSICAL OR PAGE_PHYSICAL SHL 8 OR PAGE_PHYSICAL SHL 16 OR PAGE_PHYSICAL SHL 24)

PHYSPAGE_RESERVED	EQU	(-1)
PHYSPAGE_AVAILABLE	EQU	0
PHYSPAGE_ALLOCATED	EQU	<PAGESIZE>




 ;Bank states
; *
; *            
; *
; *  These specify the state of banks which comprise a VDM's virtual memory
; *  when in linear graphics modes.
;

BANK_NONE	EQU	000h	;bank unaccessed
BANK_BLANK	EQU	001h	;bank is blank
BANK_INVRAM	EQU	002h	;bank is currently in physical VRAM
BANK_VIRTUAL	EQU	004h	;bank is mapped to "virtual" VRAM memory
BANK_INVALID	EQU	008h	;bank shadow data is not valid



; * Controller owner definitions
;

NO_OWNER	EQU	(0)
DISPLAY_OWNER	EQU	(1)
MISC_OWNER	EQU	(2)
MAXNONVDM_OWNER		EQU	<MISC_OWNER>

LOCKBUTDONOTBLOCK	EQU	2 ;don't block when controller is not locked             


; * Misc. definitions
;

GROW_MAXIMUM	EQU	-1
ALL_PLANES	EQU	-1
INVALID_HVDM	EQU	(-2)



; * ATC (Attribute Controller) states
; *
; *  These are the states that the ATC on an EGA/VGA can be in.  They have
; *  been selected not only because they are complementary, but also because
; *  they can be OR'ed with a index into the virtual ATC data (aregATCData),
; *  to produce a properly adjusted index (I rely on the fact that regATCIndx
; *  precedes aregATCData by 1 byte).
;

ATC_DATA	EQU	0	;ready for data byte
ATC_INDEX	EQU	-1	;ready for index byte



; * DAC (Digital-to-Analog Color-lookup) states
; *
; *  These are the states that the DAC hardware on a VGA can be in.
;

DAC_DATA0	EQU	00000h	;ready first 1st byte of data
DAC_DATA1	EQU	00001h	;ready first 2nd byte of data
DAC_DATA2	EQU	00002h	;ready first 3rd byte of data
DAC_DATAMASK	EQU	00003h
DAC_READ	EQU	00300h	;read mode (high byte simulates state reg.)
DAC_WRITE	EQU	00000h	;write mode (high byte simulates state reg.)
DAC_RWMASK	EQU	00300h



; * Port flags (for use in xxx_port fields)
;

PORT_MASK	EQU	000FFFFh
PORTF_NOTRAP	EQU	0010000h;no trapping for this port
PORTF_CHOOK	EQU	0020000h;I/O hook is C-based
PORTF_INDEXDATA		EQU	0040000h;this port is both an index and data port
PORTF_AUTOINC	EQU	0080000h;this port's index register auto-increments 
PORTF_COLRMONO	EQU	0100000h;the actual port address varies (see MISCOUT)
PORTF_CRTCTRL	EQU	0200000h;CRT controller port, may be write-protected
PORTF_REQUIRED	EQU	0400000h;port is required for MEMMODE reprogramming
PORTF_SVGA	EQU	0800000h;port is defined only on some SVGA adapters           



; * Hook-list constants
;

HLE_NOHOOK	EQU	<NULL>		;no hook for corresponding I/O operation
HLE_END		EQU	-1    ;end of entry within list
HLE_ENDPORT	EQU	-1    ;end of list



; * Port-list flags (for use in the ple_flxxx fields)
;

PLE_RESETSEQ	EQU	000000001h ;sequencer must be reset before writing
PLE_WAITVERT	EQU	000000001h ;wait for vertical retrace before writing
PLE_WAITHORZ	EQU	000000001h ;wait for horizontal retrace before writing



; * Register-list flags (for use in the rle_fbCond field)
;

REGCOND_RESETSEQ	EQU	001h  ;sequencer must be reset before writing
REGCOND_WAITVERT	EQU	002h  ;wait for vertical retrace before writing
REGCOND_WAITHORZ	EQU	004h  ;wait for horizontal retrace before writing
REGCOND_USEINDEX	EQU	008h  ;setup the index register first	              



; * Register-list index values (for mode-specific pointer support)
;

PTRMODE_NOPLANE		EQU	-1	;no reprogramming needed
PTRMODE_4PLANE	EQU	0      ;all planes enabled
PTRMODE_1PLANE	EQU	1      ;only first plane enabled
PTRMODE_ODDPLANE	EQU	2      ;chained-plane mode



; * Pointer flags
;

PTR_ACTIVE	EQU	00001h	;set if pointer drawing active
PTR_DRAWN	EQU	00002h	;set if pointer image currently on-screen
PTR_INVERSE	EQU	00004h	;set if inverse image (use slow update code)
PTR_HARDWARE	EQU	00008h	;set if hardware pointer enabled
PTR_PTRSAVE	EQU	00010h	;set if pointer save-area is valid
PTR_ODDEVEN	EQU	00020h	;set if 64k EGA mode in effect
PTR_BYTEPIXEL	EQU	00040h	;set if byte-pixel mode (mode 13h)
PTR_SUPPORTED	EQU	00080h	;set if video mode supported, clear if not
PTR_LPENEM	EQU	01000h	;set if light-pen emulation enabled
PTR_HWDIRTY	EQU	02000h	;set if hardware cursor moved by app
PTR_INTERNAL	EQU	08000h	;set if internal hide/show call in progress
PTR_RESETMASK	EQU	(PTR_ACTIVE OR PTR_INVERSE OR PTR_HARDWARE OR PTR_LPENEM OR PTR_INTERNAL)



; * Event flags (see VVD.INC for the public POSTEVENT_* flags subset)
; *
; *  Note:  There is no internal equivalent to POSTEVENT_ADD because if
; *  we want to add an event, we simply call vvAddEvent	 otherwise,
; *  we call vvFlushEvent.
; *
; *  Also note:	 The EVENT_OWNER flag could be removed now that we have new
; *  semaphore services that can nest requests, but I leave it in as an
; *  optimization.
;

EVENT_FLUSH	EQU	<POSTEVENT_FLUSH>		;flush event immediately
EVENT_ASYNC	EQU	00008h		;asynchronous event
EVENT_OWNER	EQU	01000h		;caller owns EventUpdate semaphore



; * _INT 10 Return Hook storage structure
;

DefStruc ,int10_s			;_INT 10 return hook storage	     ;            */
    ULONG  reg_eax	       ;saved EAX or VVSTRING row	   ;            */
    ULONG  reg_ebx	       ;saved EBX or VVSTRING col	   ;            */
    ULONG  func_type	       ;function type or VVSTRING nChars   ;            */
    ULONG  reg_saved	       ;0 - didn't save regs below         ;            */
    ULONG  reg_ecx	       ;saved ECX			   ;            */
    ULONG  reg_edx	       ;saved EDX			   ;            */
    ULONG  reg_ebp	       ;saved EBP			   ;            */
    USHORT reg_es	       ;saved ES			   ;            */
    USHORT reg_ds	       ;saved DS			   ;            */
EndStruc VVINT10S							      ;          
DefType NPVVINT10S,dd			;          
DefType PVVINT10S,dd			;          



; * Private types
; *
; *  These state-types refer to sets of ordinal values representing
; *  various states.
;

DefType MSTATE,_INT			;for memory-state values
DefType PSTATE,_BYTE			;for page-state values
DefType BSTATE,_BYTE			;for bank-state values		    ;            */

DefType PSYSFUN,dd
DefType PDEVFUN,dd



; * Hook-list entry
; *
; *  This is the header for hook-list entries, which list a port to trap (or
; *  not to trap, as the case may be) and associated I/O hooks to be installed,
; *  if any.
;

DefStruc ,hle_s			;hle
    PORT  hle_port	       ;port # (and optional port flags)
    PFN	  hle_pfn,,1	       ;address of I/O trap handler, NULL if none
EndStruc HLE
DefType PHLE,dd			;phle



; * Port-list entry
; *
; *  This is the structure for port-list entries, which list a port, a
; *  range of indexed registers accessible through the port (or in the case
; *  of 0 in ple_nRegs, a single non-indexed register), the address of the
; *  associated virtual register storage, and several flag words to specify
; *  any special conditions for the port/registers.
; *
; *  Note:
; *	    The 'ple_flResetSeq' flags are not large enough to handle
; *	    extended sequencers, such as used by Video7 chips, which
; *	    set clock-specific registers. These registers have indices
; *	    up to 0ffh. The current fix is to check for them during
; *	    vvRestoreIOState() and set the flag, not so pretty.
;

DefStruc ,ple_s			;ple
    PORT  ple_port	       ;port # (and optional port flags)
    ULONG ple_nRegs	       ;number of registers (0 if non-indexed)
    PBYTE ple_pregIndx	       ;location of virtual index register
    PBYTE ple_pregData	       ;location of virtual data register
    FLAGS ple_flResetSeq       ;bits 0-31
    FLAGS ple_flWaitVert       ;  correspond to
    FLAGS ple_flWaitHorz       ;    registers 0-31 (see PLE_* constants)
EndStruc PLE
DefType PPLE,dd			;pple



; * Register-list entry
; *
; *  This is the structure for register-list entries, which list a port, a
; *  register index, the address of the associated virtual register storage,
; *  values used to reprogram the register for standard memory access, and
; *  a flag byte to specify any special conditions for the register.
;


; * Options for vvSetIOState()
;

SETIO_SHADOWED	EQU	-1 ;set registers to shadowed values
SETIO_LIMIT_SHADOWED	EQU	-2 ;set selected bits in regs to shadowed values

DefStruc ,rle_s			;rle
    PORT  rle_port	       ;port # (and optional port flags)
    CHAR  rle_indx	       ;starting reg index (-1 if non-indexed)
    _BYTE  rle_pad
    _BYTE  rle_fbCond		;(see REGCOND_* constants)
    _BYTE  rle_fbMask		;contains bits that can be modified
    _BYTE  rle_bMode,,MEMMODE_STATES
    PBYTE rle_pregIndx	       ;location of virtual index register
    PBYTE rle_pregData	       ;location of virtual data register
    PBYTE rle_pbExtShadowIndx  ;pointer to external shadow indx, NULL if none
    PBYTE rle_pbExtShadowData  ;pointer to external shadow data, NULL if none
EndStruc RLE
DefType PRLE,dd			;prle



; * DAC color register structure
; *
; *  This structure contains the 3x6 bits (total of 18 bits) that make up
; *  the DAC information for one color register.
;

DefStruc ,dac_s			;dac
    _BYTE  dac_bRed
    _BYTE  dac_bGreen
    _BYTE  dac_bBlue
EndStruc DACREG
DefType PDACREG,dd			;pdac



; * List entry structure
; *
; *  There is one such entry for each VDM (in the instance data structure),
; *  and a top-of-list pointer in the global data.  A VDM's list entry will
; *  be initialized and added to the list at VDM creation time, and will be
; *  pulled out of the list and inserted at the head whenever a synchronous
; *  video event has been posted for it.
;

DefStruc ,lse_s			;lse
    HVDM   lse_hvdm
    PVOID lse_plseNext
    PVOID lse_plsePrevious
EndStruc LSENTRY
DefType PLSENTRY,dd			;plse


; * To add an entry at the HEAD of the
; * list, use ADD/INSERTENTRY(hvdm, &lseHeadActive)
;







; *    Values for VVCheckForEvents flag
;

PERIODIC_TIMER	EQU	1   ;indicates periodic call from timer hook
PERIODIC_KBDPEEK	EQU	2   ;indicates periodic call from kbd peek hook
PERIODIC_KBDREAD	EQU	3   ;indicates periodic call from kbd read hook


; * Semaphore prototype macros
;

DefType HEVSEM,HVDHSEM
DefType HMXSEM,HVDHSEM




; * Pointer support
; *
; *  When we remove or redraw the pointer ourselves, as part of switching
; *  background/foreground, we inc/dec fPtrFrozen to disable/enable pointer
; *  drawing at interrupt-time.
; *
; *  vmssVideo is updated by vvUpdateScreenState, if so requested.  The mouse
; *  driver is notified once the update is complete.
; *
; *  xPtr and yPtr contain the coordinates of the current pointer image	 the
; *  units are mode-dependent (ie, cells or pixels) to facilitate checks for
; *  pointer image motion.
; *
; *  ausGraphMasks records the last pointer shape received by VVDefinePtr
; *  via VMD.  See VVPTR.C for a description of the how ausPtrShape is defined.
;

DefStruc ,ptrdata_s			;beginning of PTRDATA structure

FLAGS	flPtrVideo	       ;pointer flags

BOOL	fPtrFrozenVideo	       ;TRUE to disable show/hide (internal
				;draw/erase interfaces are still functional)

VMSSIZE vmssVideo	       ;current display mode data (for mouse)

VMSTAT	vmstatVideo	       ;last queried mouse status

ULONG	xPtrVideo	       ;current pointer position
ULONG	yPtrVideo	       ;(updated with new pos. by vvPtrDraw)

ULONG	xCell		       ;converted current pointer position
ULONG	yCell		       ;(ie, mode-dependent units)

ULONG	ulPtrPage	       ;video page # to contain pointer

_INT	 iPtrMode		;ptr mode index (for arlePtrState), -1 if none

PFN	pfnPutImage	       ;offsets of
PFN	pfnMoveMasks	       ; appropriate transfer routines

ULONG	nBitsRotate	       ;bits of rotation

ULONG	xCorner		       ;upper-left corner of position
ULONG	yCorner		       ; to mask in pointer (ie, hot-spot adjusted)

ULONG	xCornerPrev	       ;upper-left corner of previous
ULONG	yCornerPrev	       ; pointer location

ULONG	offScrBuff	       ;screen offset of (xScrBuff, yScrBuff)

ULONG	xScrBuff	       ;screen coords of
ULONG	yScrBuff	       ; upper-left of screen-save buffer

ULONG	htScrBuff	       ;current height, changes each redraw

ULONG	offPtrSave	       ;offset of pointer-save buffer
ULONG	offScrSave	       ;offset of screen-save buffer

ULONG	ulTextScrSave	       ;save area for screen data under text image

ifdef  GALE							       ;J-TS00V
ULONG	ulTextCharType	       ;type of saved char SBCS/DBCS 1st/DBCS 2nd    ;J-TS00V
_BYTE	 abPtrSaveGale,,19*4*2	;bitmapped text image save area	      ;J-TS00V
endif  ;GALE							      //J-TS00V

ULONG	ulTextANDMaskVideo     ;also called the screen mask
ULONG	ulTextXORMaskVideo     ;also called the pointer mask

ULONG	xHotVideo	       ;graphics pointer hot-spot
ULONG	yHotVideo

_BYTE	 abANDMask,,PTRSAVSIZE
_BYTE	 abXORMask,,PTRSAVSIZE

_BYTE	 abPtrSave1,,PTRSAVSIZE
_BYTE	 abPtrSave2,,PTRSAVSIZE

_BYTE	 abScrSave1,,SCRSAVSIZE
_BYTE	 abScrSave2,,SCRSAVSIZE

EndStruc PTRDATA		      ;end of PTRDATA structure

ifdef  GALE							       ;J-TS00V
;***	VIO Mode Data tables					      ;J-TS00V
DefStruc ,VIOMode_s			;J-TS00V
USHORT mode_cb							       ;J-TS00V
UCHAR  mode_fbType						       ;J-TS00V
UCHAR  mode_color						       ;J-TS00V
USHORT mode_col							       ;J-TS00V
USHORT mode_row							       ;J-TS00V
USHORT mode_hres						       ;J-TS00V
USHORT mode_vres						       ;J-TS00V
UCHAR  mode_FormatID						       ;J-TS00V
UCHAR  mode_attrib						       ;J-TS00V
EndStruc VIOMODEDATA							      ;J-TS00V
									;J-TS00V
DefStruc ,ModeDataTable_s			;J-TS00V
_BYTE	      ModeNumber						;J-TS00V
VIOMODEDATA  ModeData						       ;J-TS00V
EndStruc MODEDATATABLE							      ;J-TS00V
									;J-TS00V
ifdef  VTEXT							       ;J-TS00V
DefStruc ,VtextModeTable_s			;J-TS00V
UCHAR	ExtModeNum						       ;J-TS00V
UCHAR	ExtModeInfo						       ;J-TS00V
UCHAR	ExtModeCols						       ;J-TS00V
UCHAR	ExtModeRows						       ;J-TS00V
UCHAR	ExtModeCelWidth						       ;J-TS00V
UCHAR	ExtModeCelHeight					       ;J-TS00V
UCHAR	ExtModeFontWidth					       ;J-TS00V
UCHAR	ExtModeFontHeight					       ;J-TS00V
USHORT	ExtModeHorzResolution					       ;J-TS00V
USHORT	ExtModeVertResolution					       ;J-TS00V
UCHAR	ExtModeReserved,,4					       ;J-TS00V
EndStruc VTEXTMODETABLE							      ;J-TS00V
DefType PVTEXTMODETABLE,dd			;J-TS00V
									;J-TS00V
DefStruc ,VtextExtParam_s			;J-TS00V
UCHAR	ExtDrvMajorVersion					       ;J-TS00V
UCHAR	ExtDrvMinorVersion					       ;J-TS00V
USHORT	PtrPrimFuncTable					       ;J-TS00V
USHORT	PtrVideoModeTable					       ;J-TS00V
USHORT	CntModeTable						       ;J-TS00V
USHORT	PtrExtDrvString						       ;J-TS00V
EndStruc VTEXTEXTPARAM							      ;J-TS00V
DefType PVTEXTEXTPARAM,dd			;J-TS00V
									;J-TS00V
DefStruc ,VtextExtInfo_s			;J-TS00V
UCHAR	       $DispMajorVersion				       ;J-TS00V
UCHAR	       $DispMinorVersion				       ;J-TS00V
USHORT	       VideoExtState					       ;J-TS00V
USHORT	       SegTextBuffer					       ;J-TS00V
USHORT	       SizeTextBuffer					       ;J-TS00V
USHORT	       ExtDrvParamOff					       ;J-TS00V
USHORT	       ExtDrvParamSeg					       ;J-TS00V
USHORT	       LockCnounter					       ;J-TS00V
ULONG	       OrgInt10Entry					       ;J-TS00V
USHORT	       PtrFontQuality					       ;J-TS00V
USHORT	       PtrTextDensity					       ;J-TS00V
USHORT	       PtrPaletteSave					       ;J-TS00V
UCHAR	       CurrentModeIndex					       ;J-TS00V
EndStruc VTEXTEXTINFO							      ;J-TS00V
DefType PVTEXTEXTINFO,dd			;J-TS00V
									;J-TS00V
VTEXT_EXT_STATE_REGISTERED	EQU	001h	;ext driver installed.  ;J-TS00V
VTEXT_EXT_STATE_ACVITE	EQU	002h	;ext mode activated.	;J-TS00V
									;J-TS00V
endif  ;VTEXT							      //J-TS00V
									;J-TS00V
DefStruc ,GaleCursor_s			;J-TS00V
USHORT	GaleCurPos	       ;cursor position			     ;J-TS00V
USHORT	GaleCurMode	       ;cursor type			     ;J-TS00V
FLAGS	GaleCurDisp	       ;cursor display ON/OFF flag	     ;J-TS00V
EndStruc GALECURSOR							      ;J-TS00V
									;J-TS00V
DefStruc ,Int2FStack_s			;J-TS0827
ULONG	EventCnt						       ;J-TS0827
ULONG	LastEvent						       ;J-TS0827
BOOL	flProcessing						       ;J-TS0827
EndStruc INT2FSTACK							      ;J-TS0827
									;J-TS0827
DefStruc ,GaleData_s			;J-TS00V
PBYTE	   GaleLVB	       ;LVB (User shadow buffer)	     ;J-TS00V
PBYTE	   GaleSBCS	       ;SBCS font buffer in Gale	     ;J-TS00V
ULONG	   GaleDBCSInpEnv      ;DBCS input environment		     ;J-TS00V
FLAGS	   GaleInternalAccess  ;screen access mode		     ;J-TS00V
PBYTE	   GaleLPTWork	       ;APA data for VLPT		     ;J-TS00V
GALECURSOR GaleCursor	       ;cursor attribute		     ;J-TS00V
FLAGS	   flGaleFlags	       ;Gale unique flags		     ;J-TS0331
ifdef	  VTEXT							       ;J-TS00V
FLAGS	   flVtext	       ;flags to support VTEXT		     ;J-TS00V
HHOOK	   hhookVtextReturn    ;hook handle for Int 10h & 15h	     ;J-TS00V
HHOOK	   hhookVtextHook      ;hook handle for post $DISP.SYS	     ;J-TS00V
HHOOK	   hhookVtextPreHook   ;hook handle for pre $DISP.SYS	     ;J-TS00V
HHOOK	   hhookVtextRedrawReturn  ;return hook for redraw screen    ;J-TS00V
HHOOK	   hhookVextPtrContext ;context hook for ptr draw	     ;J-TS00V
HHOOK	   hhookVextPtrReturn  ;return hook for ptr draw	     ;J-TS00V
VPVOID	   pBreakPointAddr     ;BP address			     ;J-TS00V
PBYTE	   pVtextLVB	       ;LVB addr in $DISP.SYS		     ;J-TS00V
PBYTE	   pVtextPVB	       ;memory to be mapped as video buff    ;J-TS00V
PVTEXTEXTINFO pVtextExtInfo    ;Vtext extension mode infomation	     ;J-TS00V
ifdef  SVGA							       ;J-TS00V
				;Following registers are specially    ;J-TS00V
				;shadowed to enable the installation  ;J-TS00V
				;of VTEXT driver in windowed VDM.     ;J-TS00V
UCHAR	   S3RegLock2	       ;shadow of S3 lock reg.		     ;J-TS00V
UCHAR	   TsengExtStartAddr   ;shadow of tseng ext. start addr reg. ;J-TS0818
endif  ;SVGA							      //J-TS00V
endif  ;VTEXT							      //J-TS00V
INT2FSTACK Int2FStack	       ;_INT 2F notify request controler      ;J-TS0827
EndStruc GALEDATA							      ;J-TS00V
									;J-TS00V
;***	Per-VDM flGaleFlags						;J-TS0331
;									;J-TS0331
VDMV_GALE_VESA_SET_MODE		EQU	000000001h  ;In VESA Set Mode	   ;J-TS0331
									;J-TS00V
ifdef  VTEXT							       ;J-TS00V
;***	Per-VDM VTEXT Flags						;J-TS00V
;									;J-TS00V
VDMV_VTEXT_INSTALLED	EQU	000000001h  ;$DISP is installed	  ;J-TS00V
VDMV_VTEXT_INITIALIZING		EQU	000000002h  ;$DISP is initializing;J-TS00V
VDMV_PROCESSED_BY_MYSELF	EQU	000000004h  ;_INT 15H is proc by me;J-TS00V
VDMV_SUPPORTED_TEXT_MODE	EQU	000000008h  ;Known text mode	  ;J-TS00V
VDMV_GET_LVB	EQU	000000010h  ;GET_LVB indicator	  ;J-TS00V
VDMV_CHECK_VTEXT	EQU	000000020h  ;check $DISP indicator;J-TS00V
VDMV_GET_EXT_INFO	EQU	000000040h  ;get ext info indictr ;J-TS00V
VDMV_VTEXT_CALLING	EQU	000000080h  ;$DISP is calling	  ;J-TS00V
VDMV_CURSOR_UPDATED	EQU	000000100h  ;cursor updated	  ;J-TS00V
VDMV_LVB_UPDATED	EQU	000000200h  ;LVB updated	  ;J-TS00V
VDMV_DELAYED_REDRAW_SCREEN	EQU	000001000h  ;redraw scrn is posted;J-TS00V
VDMV_DELAYED_UPDATE_FLAG	EQU	000002000h  ;update dflg is posted;J-TS00V
VDMV_PTR_REQUEST_DRAW	EQU	000010000h  ;mou ptr draw req	  ;J-TS00V
VDMV_PTR_REQUEST_UPDATE		EQU	000020000h  ;mou ptr update req	  ;J-TS00V
VDMV_PTR_REQUEST_ERASE	EQU	000040000h  ;mou ptr erase req	  ;J-TS00V
VDMV_PTR_CONTEXT_HOOK	EQU	000100000h  ;mou ptr cntxt hook	  ;J-TS00V
VDMV_PTR_V86_EXECUTING	EQU	000200000h  ;mou ptr in V86 mode  ;J-TS00V
VDMV_PTR_REQ_ERASE_SP1	EQU	000400000h  ;special erase req 1  ;J-TS00V
VDMV_PTR_REQ_ERASE_SP2	EQU	000800000h  ;special erase req 2  ;J-TS00V
VDMV_REDRAW_SCREEN	EQU	001000000h  ;redraw screen req.	  ;J-TS00V
VDMV_REDRAW_AGAIN	EQU	002000000h  ;redraw screen req. 2 ;J-TS00V
endif  ;VTEXT							      //J-TS00V
									;J-TS00V
endif  ;GALE							      //J-TS00V
									;J-TS00V
ifdef  XVIO							       ;J-TS00V
DefStruc ,xviodata_s			;beginning of XVIODATA structure      ;J-TS00V
PBYTE	    GaleXVIOLVB	       ;2nd LVB for XVIO		     ;J-TS00V
VXMODE	    vxMode	       ;mode data			     ;J-TS00V
VXCURSOR    vxCursor	       ;cursor data			     ;J-TS00V
VXCURSOR    vxCursorPrev       ;previously reported cursor data	     ;J-TS00V
VXWSTR	    vxWStr	       ;write string data		     ;J-TS00V
PBYTE apPlaneXVIO,,MAX_PLANES  ;pointer(s) to saved screen buffers.  ;J-TS00V
ULONG anpgPlaneXVIO,,MAX_PLANES;size(s) for each of the above buffs. ;J-TS00V
EndStruc XVIODATA		      ;end of XVIODATA structure	    ;J-TS00V
endif  ;XVIO							      //J-TS00V

DefStruc ,vdmdatax_s			;PERVDMDATA extension		                
ULONG	nDiffPrev	       ;# of differences reported last LVB event
CHAR	DACreg,,4	       ;save contents of DAC		               
EndStruc VDMDATAX		      ;end of PERVDMDATA extension struct             

DefStruc ,vdmdata_s			;beginning of PERVDMDATA structure


; * Per-VDM data
; *
; *  In flVDM, the OWNER bit indicates whether or not this VVD is actively
; *  responsible for the associated display.  If another VVD "requests" control
; *  away from us, the OWNER bit is cleared until we are "requested" to regain
; *  control.  For the interim, all I/O and page-fault hooks are undone, as are
; *  all VRAM mappings.
; *
; *  ioh is simply some scratch storage that we use to install/deinstall all
; *  our I/O hooks  for security, the VDH services require that the caller
; *  supply the same address to VDHSetIOHookState and VDHDeInstallIOHook that
; *  it supplied to VDHInstallIOHook.
; *
; *  mstateCopy records the last state selected by vvSetCopyState, and is an
; *  optimization  it allows vvSetCopyState to ignore a request for a state
; *  already in effect, and it is cleared by vvRestoreCopyState.
;

FLAGS	flVDMVideo	       ;per-VDM flags
FLAGS	flVDMXVideo	       ;extended per-VDM flags
FLAGS	flVDMX2Video	       ;extended per-VDM flags           

HVDM	hvdmVideo	       ;handle for this VDM

ULONG	sgIDVideo	       ;screen group # for this VDM

IOH	iohVideo	       ;scratch ioh

MSTATE	mstateCopy	       ;currently selected copy-state

ULONG	ulBIOSMode	       ;last BIOS mode # set

HMXSEM	hmxVideoState	       ;semaphore for internal state protection
HMXSEM	hmxWindowedState
HEVSEM	hevFreezeThaw	       ;set on freeze, cleared on thaw
ifdef SVGA		       ;          
HEVSEM	hevInt2FDelaySwitch    ;set on vvBgndContext to delay BGND switch for 2F processing
HEVSEM	hev8514WakeUp	       ;8514 IO semaphore	           
HEVSEM	hev8514Busy	       ;8514 engine busy sem	           

endif
HHOOK	hhookFgndContext       ;hook handle for VVFgndContext
HHOOK	hhookBgndContext       ;hook handle for VVBgndContext
HHOOK	hhookInitContext       ;hook handle for VVInitContext
HHOOK	hhookUpdatePtrContext  ;hook handle for VVUpdatePtrContext
ifdef EGAVGA
HHOOK	hhookUpdateContext     ;hook handle for VVUpdateContext
HHOOK	hhookUpdatePhysContext ;hook handle for VVUpdatePhysContext
HHOOK	hhookUnMapPhysContext  ;hook handle for VVUnMapPhysContext            
endif
HHOOK	hhookInt10SetModeReturn;;hook handle for VVInt10SetModeReturn
HHOOK	hhookInt10Return       ;hook handle for VVInt10Return
HHOOK	hhookInt2FReturn       ;hook handle for VVInt2FReturn
PVOID	pInt10ReturnData
BOOL	flV86mode	       ;VPM mode flag           
ULONG	nInt10Setmode;;# of recursive int 10 setmode calls           
PTRDATA PtrData		       ;pointer data



; * Virtual/shadow hardware information (modified)
; *
; *  pvdmPhysVRAMActive is starting address of active VRAM.  On an EGA/VGA,
; *  active VRAM is the region of physical addresses that VRAM is/should be
; *  currently responding to.  This region always lies somewhere within
; *  the pvdmPhysVRAM region, and is controlled by REG_GDCMISC.
; *
; *  npgPhysVRAMActive is the length (in pages) of the active VRAM region.
; *  On supported adapters, the active region can only be at one of a handful
; *  of locations (A0000, B0000 or B8000), and is always a whole number of
; *  pages.
; *
; *  pvdmPhysVRAMVisible is the area WITHIN pvdmPhysVRAMActive that's currently
; *  visible.  This is important for clipboard requests, pointer support, etc.
; *
; *  nbPhysVRAMVisible is the length of the visible active VRAM region, in
; *  bytes.  nbVRAMRow is the length of a row (cells or pixels, depending on
; *  the video mode), also in bytes.  offVRAMOddEven is the offset between
; *  even and odd scan lines  normally, they are sequential and so this value
; *  is zero, but for CGA graphics modes, it will be 8192 (8kb).  Finally,
; *  nBitsPerPlane is the number bits in a single plane that encode the color
; *  of one pixel on the screen it is only a count of bits within a plane, not
; *  across planes, and the total number of bits per pixel should be
; *  calculated as (nBitsPerPixel * nPlanes) -- although in every CGA/EGA/VGA
; *  mode, one of those values is always 1.
; *
; *  mstate is the VDM's current memory state.  It may not match the true
; *  hardware state at any instant for a foreground VDM undergoing limited
; *  trapping, but in those cases we use vvUpdateVideoState to "refresh" our
; *  understanding of the current state.
;

VVMODE	vvMode		       ;current mode information
VVCURSOR vvCursor	       ;current cursor information

ULONG	nbVRAMRow	       ;width of a scan line, in bytes
ULONG	offOddBank	       ;offset between odd/even rows, in bytes
ULONG	nBitsPixel	       ;bits per pixel (within each plane)
ULONG	nPixelsByte	       ;pixels ber byte (within each plane)
ULONG	nPlanes		       ;number of active planes

PBVDM	pvdmPhysVRAMActive     ;address of VDM's active VRAM, which is 
				;a subset of physical VRAM (pvdmPhysVRAM)

ULONG	offPhysVRAMActive      ;offset of active VRAM, relative to both
				;pvdmPhysVRAM & pPhysVRAM

ULONG	npgPhysVRAMActive      ;# of pages in active VRAM
				;this is a subset of pvdmPhysVRAM

PBVDM	pvdmPhysVRAMVisible    ;address of VDM's active/visible VRAM 
				;this is a subset of pvdmPhysVRAMActive

ULONG	offPhysVRAMVisible     ;offset of visible VRAM, relative to
				;pvdmPhysVRAMActive

ULONG	nbPhysVRAMVisible      ;# of bytes in active/visible VRAM
				;this is a subset of pvdmPhysVRAMActive

MSTATE	mstateVideo	       ;VDM memory state (TEXT, FONT, GRFX, ...)



; * Virtual buffer management
; *
; *  What is referred throughout the VVD as the "virtual buffer" is
; *  actually 1 or more "plane" buffers.
; *
; *  If a VDM is MEMORY_TEXT, apPlane[0] will point to a plane buffer
; *  containing the VDM's text information, and appropriate entries in
; *  aapstate[0..m*0] will be set to PAGE_TEXT	apPlane[2] will point to
; *  a buffer containing the VDM's font information, and entries in
; *  aapstate[0..n*2] will be set to PAGE_FONT	apPlane[1] and
; *  apPlane[3] will generally either point to buffers whose individual page
; *  states are NONE, or point to nothing (ie, not even allocated).
; *
; *  When a VDM is MEMORY_FONT, the same basic set of assumptions
; *  applies (ie, we treat this like a text-mode configuration to avoid
; *  freezing VDMs when they are loading fonts).
; *
; *  Finally, when a VDM is MEMORY_GRFX, each plane buffer simply contains the
; *  contents for the associated plane and aapstate[0..n*x] will be set to
; *  PAGE_GRFX.  When a VDM switches from a MEMORY_TEXT mode to a MEMORY_GRFX
; *  mode, the virtual buffer format is converted:  all pages containing
; *  PAGE_TEXT information are converted to appropriate pages of PAGE_GRFX
; *  information, since character data is really only the even bytes in plane
; *  0 and attributes all the even bytes in plane 1, meaning that for pages in
; *  the TEXT state, we only have partial graphics information for planes 0 and
; *  1 (ie, the EVEN bytes), none at all for plane 3, and some limited amount
; *  for plane 2 (this is where the VDM's font(s) are stored).  The conversion
; *  step rounds out this limited information, promoting the appropriate pages
; *  to GRFX status.
; *
; *  When a foreground VDM is created, a virtual buffer of size (nPlanes *
; *  npgPlane * PAGESIZE) is allocated.  After the first SetFgnd call, the
; *  VDM's entire VRAM address range becomes invalidated, since we have
; *  no valid data at this time.  The screen may have already been cleared by
; *  the Session Manager, but only insofar as the video signal is concerned
; *  underneath, the contents of the last foreground screen group remain in
; *  place.  As soon as the VDM begins running, it will perform an Int 10h
; *  that we initiated (see VVCreate), which in turn will initialize all of the
; *  VDM's active VRAM (generally the 32kb from B8000h-BFFFFh).  We trap that
; *  initialization page-by-page, first verifying that a virtual page is
; *  available (which it must be for a foreground VDM), and then exchanging
; *  the page with physical memory  the state for a such a page becomes
; *  PAGE_TEXT.  When it touches a page in the A0000h-AFFFFh range and the
; *  range is active and the mode is MEMORY_FONT, we follow a similar validation
; *  process, but for the plane 2 portion of the virtual buffer	 the state of
; *  the associated page becomes PAGE_FONT.  And so on....
; *
; *  Later, when the foreground VDM is switched into background, we update
; *  the VDM's state, exchange all valid pages, thereby restoring the previous
; *  screen group's contents, and then map all valid virtual pages into the
; *  VDM's VRAM address space.  A context hook is also established to shrink the
; *  virtual buffer down to some smaller size.
; *
; *             SVGA: Added an extra array dimension to apPlane, anpgPlane and
; *		      aapstate to allow more virtual memory to be handled.
; *		      Using up to 4 banks together with the current
; *		      structures, up to 1Meg of memory is kept track of.  Note
; *		      that putting the new BANK index first allows the
; *		      structure to be consistent with its old definition when
; *		      setting an index of zero (this courtesy of the way 'C'
; *		      stores arrays).  In linear modes, banks together with
; *		      planes give up to 16 pieces of 64k memory (16 pages).
; *		      The concept of planes then falls away and the
; *		      combination keeps track of all the memory.
; *
; *             SVGA: Change linear-mode virtual buffer management to 64k (bank)
; *		      granular. Now keep a single pointer to a buffer for linear
; *		      modes and a state array (as per aapstate) on a bank basis.
; *		      This allows simpler virtualisation, more efficient save
; *		      and restore of physical VRAM and bitmap copying.
; *
;

ULONG	ulLinearPages	       ;no of pages			          
PBYTE	pLinearBuffer	       ;virtual buffer for linear modes           

PBYTE	apPlane,,MAX_BANKS*MAX_PLANES	 ;pointer(s) to virtual memory buffers
ULONG	anpgPlane,,MAX_BANKS*MAX_PLANES	 ;size(s) for each of the above buffers

PBYTE	pShadowPlane	       ;shadow buffer (for single-plane graphics)
ULONG	npgShadowPlane

PBYTE	pBonusBuffer	       ;buffer for CGA/MONO restriction
ULONG	npgBonusBuffer	       ;NOTE: unlike apPlane and pShadowPlane,
				;this is per-VDM memory (freed automatically)

VPVOID	vpOldStack	       ;original VDM stack (if we had to switch)
PBVDM	pvdmAltStack	       ;alternate stack we can switch to, if needed

				;page states (NONE, TEXT, FONT, etc)
				;SVGA add 3rd dimension		               




PSTATE	      aapstate,,MAX_BANKS*MAX_PAGESPERPLANE*MAX_PLANES


				;bank-based states (64k granular aapstate[])
BSTATE	abstate,,MAX_BANKS*MAX_PLANES			       ;          


; * for a given PAGE_PHYSICAL video page index,
; * the corresponding entry in aiVirtToPhys
; * contains an index into ahPhysPage
;

ULONG	aiVirtToPhys,,MAX_PAGESPERPLANE

ULONG	aoffPhysDiff,,MAX_PAGESPERPLANE
ULONG	anbPhysDiff,,MAX_PAGESPERPLANE

MSTATE	mstateBuffer	       ;memory state of buffer (not the VDM!)

FLAGS	flDirtyPages	       ;dirty page info accumulator

ULONG	ulDirtyBankEvent       ;dirty bank number for 256-colour mode           


; * VDHMapPages data structures
;

ULONG	ulMapCur,,VRAM_PAGES   ;Current VRAM contents
VDHMAPTARGET avdhmt,,VRAM_PAGES;VRAM map targets
VDHMAPSOURCE vdhms	       ;VDH map source descriptor
ifdef VGA
VDHMAPTARGET vdhmt						       ;          
endif



; * Window support data
;

ULONG	pidVideo	       ;PID of exclusive access owner, if any

LSENTRY lseActive	       ;Active list entry for this VDM

FLAGS	flEventsPending	       ;event ordinals 1 through n are
FLAGS	flEventsHolding	       ;represented by bits 0 through n-1
FLAGS	flEventsFlushing

ULONG	nPeriodic	       ;periodic counter
ULONG	nPeriodicLimit	       ;threshold required
ULONG	nPeeks		       ;peek counter

HEVSEM	hevShieldSynced	       ;synchronizes windowed VDM with Shield

VVMODE	 vvModeEvent	       ;next mode event to process
VVSCROLL vvScrollEvent	       ;next scroll event to process
VVSTRING vvStringEvent	       ;next string event to process
VVCURSOR vvCursorEvent	       ;next cursor event to process
VVCURSOR vvInputEvent	       ;location where next input request made
FLAGS	 flDirtyPageEvent      ;last dirty pages reported

ULONG	nPhysPages	       ;# of PHYSPAGES owned by this VDM

;ULONG	 nDiffPrev	      ;# of differences reported last LVB event
;			      ;above field moved to VDMDATA extension           
VDMDATAX VdmDataX	       ;VDMDATA extension		                 
RECTL	rclDiffPrev	       ;if nDiffPrev == 1, rclDiffPrev == difference

CHAR	szVDMTitle,,MAX_TITLESIZE
USHORT	fDDEflag	       ;Set/Clear DDE flag		                 



; * Virtual/shadow hardware information
; *
; *  This storage is dedicated to saving I/O state information.  This is
; *  put at the end of the instance data structure because much of it is byte-
; *  oriented, and would tend to       up the dword-alignment of everything
; *  above without explicit padding.
;

ifdef MONOCGA
_BYTE	 regMode		;shadows PORT_MONOMODE/CGAMODE
endif

ifdef CGA
_BYTE	 regColor		;shadows PORT_CGACOLOR
endif

_BYTE	 regCRTIndx		;shadows PORT_MONOCRTINDX/COLRCRTINDX
_BYTE	aregCRTData,,MAX_CRTREGS;shadows PORT_MONOCTRDATA/COLRCRTDATA[]
_INT	 stateStatus1		;state of STATUS1 register
				;(see abNextStatusState)
ifdef EGAVGA
_BYTE	 regFeature		;shadows PORT_MONOFEATURE/COLRFEATURE
_BYTE	 regMiscOut		;shadows PORT_MISCOUT
_BYTE	 regATCIndx		;shadows PORT_ATC0
_BYTE	aregATCData,,MAX_ATCREGS;shadows PORT_ATC1[MAX_ATCREGS]
_BYTE	 regSEQIndx		;shadows PORT_SEQINDX
_BYTE	aregSEQData,,MAX_SEQREGS;shadows PORT_SEQDATA[MAX_SEQREGS]
_BYTE	 regGDCPos1		;shadows PORT_GDCPOS1
_BYTE	 regGDCPos2		;shadows PORT_GDCPOS2
_BYTE	 regGDCIndx		;shadows PORT_GDCINDX
_BYTE	aregGDCData,,MAX_GDCREGS;shadows PORT_GDCDATA[MAX_GDCREGS]
_INT	 stateATC		;state of ATC controller
endif

ifdef VGA
_BYTE	 regDACMask		;shadows PORT_VGADACMASK
_BYTE	 regDACIndx		;shadows PORT_VGADACREAD/VGADACWRITE
DACREG adacDACData,,MAX_DACREGS;shadows PORT_VGADACDATA[MAX_DACREGS]
DACREG	dacDACDataCur	       ;current DAC data register
_INT	 stateDAC		;state of VGA's DAC                  
endif

ifdef SVGA		       ;          

BOOL	flBgndExecEnabled      ;          
ULONG	ulLogicalBytes	       ;          
ULONG	ulregLockState	       ;           bit-mask of lock commands state
				

_BYTE	 aregXGAData,,AXGA_TOTAL;XGA Compatible registers		          

_BYTE	 regTsengSegSelect	;Tseng Seg Select register (Bank Select)
_BYTE	 regOrchidClockSelect	;          

_BYTE	 stateTridentRegDef	;Trident register definition register state
_BYTE	 regTridentModeCtrl2	;non-zero (TRUE) => 'new' definition

ifdef ATI
_BYTE	 regATIIndx		;shadows PORT_ATIVGA_INDX
_BYTE	aregATIData,,MAX_ATIREGS;shadows PORT_ATIVGA_DATA[MAX_ATIREGS]
endif

_WORD	 wreg8514MFIndx		;for interim settings (for byte I/O)
_WORD	 awreg8514Data,,WREG_TOTAL
_WORD	 awreg8514MFData,,MFINDX_INDXTOTAL
endif			       ;          

ifdef COMPAQ
_BYTE	 regCompaqCtrl		;Compaq Control Mode register
endif

ifdef EGAVGA
_BYTE	 bLatches,,MAX_PLANES	;storage for latches
PBVDM	pCPBuff		       ;codepage buffer			               
USHORT	ROMint1fSeg	       ;Graphics Character Table Segment               
endif

ifdef  GALE							       ;J-TS00V
endif  ;GALE							      //J-TS00V
									;J-TS00V
ifdef  XVIO							       ;J-TS00V
endif  ;XVIO							      //J-TS00V


EndStruc PERVDMDATA		      ;end of PERVDMDATA structure

DefStruc ,dbcsdata_s
PERVDMDATA    OrgPerVDMData
ifdef	  GALE
FLAGS	      flVDMGale
GALEDATA      GaleData
endif
ifdef	  XVIO
FLAGS	      flVDMVideoJ
XVIODATA      XVIOData
endif
EndStruc DBCSDATA


DefType PVDMDATA,dd




DefData IMPORT,INSTANCE,C
PERVDMDATA VVData
VDMData catstr VVData
EndData






; * C function prototypes
;


; *  vvinit.c
;


EXPENTRY VDDInit		<PSZ>
ifdef EGAVGA
PRIVENTRY vvEditVideoTables		<PVOID>
endif
PRIVENTRY vvFindMono		<PVOID>


; *  vvuser.c
;

EXPENTRY VVCreate		<HVDM>
EXPENTRY VVCreateDone		<HVDM>				 ;          
ifdef SVGA
PRIVENTRY vvSVGAEditVideoTables		<ULONG, ULONG>		;          
PRIVENTRY vvSVGASetBgnd		<HVDM hvdm>			;          
endif
EXPENTRY VVSetFgnd		<HVDM>
EXPENTRY VVSetBgnd		<HVDM>
EXPENTRY VVChangeCodePage		<ULONG>
EXPENTRY VVChangeTitle		<PSZ>
EXPENTRY VVDestroy		<HVDM>
ifdef PROPERTIES
EXPENTRY VVSetInt10Emulation		<ULONG, HVDM, ULONG, PSZ>
EXPENTRY VVSetRetraceEmulation		<ULONG, HVDM, ULONG, PSZ>
EXPENTRY VVSetUpdateFrequency		<ULONG, HVDM, ULONG, PSZ>
EXPENTRY VVSetSyncOutput		<ULONG, HVDM, ULONG, PSZ>	@V2.0WKB01
EXPENTRY VVSetInt2F		<ULONG, HVDM, ULONG, PSZ>
EXPENTRY VVSetOnDemandAlloc		<ULONG, HVDM, ULONG, PSZ>
endif
HOOKENTRY VVFgndContext		<PVOID, PCRF>
HOOKENTRY VVBgndContext		<PVOID, PCRF>
PRIVENTRY vvFreezeVDM		<HVDM, BOOL>
PRIVENTRY vvThawVDM		<HVDM>
PRIVENTRY vvInt2FNotify		<ULONG, PCRF>
HOOKENTRY VVInt2FReturn		<PVOID, PCRF>


; *  vvport.c
;

PRIVENTRY vvSetIOHooks		<PHLE, BOOL, BOOL>
PRIVENTRY vvEnableIO		<VOID>
HOOKENTRY VVSpecialCaseIO		<HHOOK, PCRF>
PRIVENTRY vvAdjustedPort		<HVDM, PORT>
ifdef EGAVGA
PRIVENTRY vvQueryLatchAddress		<HVDM>
PRIVENTRY vvSaveLatches		<HVDM, BOOL>
PRIVENTRY vvRestoreLatches		<HVDM, BOOL>
endif
ifdef VGA
PRIVENTRY vvSaveDACState		<HVDM>			       ;          
PRIVENTRY vvRestoreDACState		<HVDM>
PRIVENTRY vvDisableVRAM		<HVDM>				;          
endif
PRIVENTRY vvDisableDisplay		<HVDM>
PRIVENTRY vvEnableDisplay		<HVDM>
ifdef CGA
EXPENTRY VVForceDisplay		<VOID>
endif



; *  vvpage.c
;

PRIVENTRY vvSetFaultHooks		<BOOL, BOOL>
HOOKENTRY VVFaultHook		<PVDM>
HOOKENTRY VVEnableBuffer		<BOOL, PCRF>
PRIVENTRY vvTransferBuffer		<HVDM, _INT, BOOL>
ifdef SVGA
PRIVENTRY vvTransferLinearBuffer		<HVDM, _INT, BOOL>
EXPENTRY vvPrepareForTransfer		<HVDM, BOOL, ULONG>	 ;                      
endif
PRIVENTRY vvTransferPage		<HVDM, _INT, _INT, _INT, BOOL>
PRIVENTRY vvValidatePage		<_INT, _INT>
PRIVENTRY vvMapBank		<_INT>				     ;          
PRIVENTRY vvUnMapBuffer		<VOID>				;          
ifdef EGAVGA
PRIVENTRY vvUnvalidatePage		<HVDM, HVDM, _INT, _INT>
endif
PRIVENTRY vvUpdatePageStates		<HVDM>
PRIVENTRY vvMapPage		<PBVDM, PVOID, _INT, _INT, FLAGS>     ;          
PRIVENTRY vvFlushPages		<HVDM>
PRIVENTRY vvRectsFromPageMap		<HVDM, FLAGS, ULONG, PVVLVB>
PRIVENTRY vvRectsFromShadowBuffer		<HVDM, ULONG, PVVLVB>
PRIVENTRY vvRectFromOffset		<HVDM, ULONG, ULONG, PRECTL>



; *  vvphys.c
;

PRIVENTRY vvUpdatePhysPageMap		<PVVDRQ>
PRIVENTRY vvGetPhysPage		<_INT>
PRIVENTRY vvFreePhysPage		<HVDM, _INT>
PRIVENTRY vvFreeAllPhysPages		<HVDM, BOOL>
PRIVENTRY vvGetPhysBytes		<ULONG>
PRIVENTRY vvFreePhysBytes		<ULONG, ULONG>
HOOKENTRY VVUnmapPhysContext		<HHOOK, PCRF>
HOOKENTRY VVUpdateContext		<PVOID, PCRF>
HOOKENTRY VVUpdatePhysContext		<PVOID, PCRF>



; *  vvbuff.c
;

PRIVENTRY vvGrowLinearBuffer		<HVDM, _INT>		    ;          
PRIVENTRY vvGrowBuffer		<HVDM, _INT, _INT, _INT>
PRIVENTRY vvShrinkBuffer		<HVDM, BOOL>
PRIVENTRY vvGrowPlane		<HVDM, _INT, _INT, _INT>
PRIVENTRY vvShrinkPlane		<HVDM, _INT, _INT, _INT>
PRIVENTRY vvAllocShadowBuffer		<HVDM>



; *  vvstate.c
;

PRIVENTRY vvUpdateAll		<HVDM, BOOL>
ifdef EGAVGA
PRIVENTRY vvUpdateIOState		<HVDM, BOOL>
endif
ifdef VGA
PRIVENTRY vvGetIOState		<HVDM, PRLE>
endif
PRIVENTRY vvUpdateMemoryState		<HVDM>
PRIVENTRY vvUpdateScreenState		<HVDM, BOOL>
PRIVENTRY vvUpdateModeData		<HVDM>
ifdef EGAVGA
PRIVENTRY vvSetCopyState		<HVDM, MSTATE, _INT>
PRIVENTRY vvRestoreCopyState		<HVDM, _INT>
PRIVENTRY vvSetIOState		<HVDM, PRLE, _INT>
endif
PRIVENTRY vvRestoreIOState		<HVDM>



; *  vvmode.c
;

PRIVENTRY vvInt10Initialize		<PCRF>
HOOKENTRY vvInt10SetMode		<PCRF>
HOOKENTRY VVInt10SetModeReturn		<PVOID, PCRF>
ifdef EGAVGA
PRIVENTRY vvLoadCodePageFont		<VOID>
PRIVENTRY vvGetCodePageFont		<ULONG, ULONG, PBVDM>	    ;          
endif

ifdef SVGA
PRIVENTRY vvFixSVGARegisters		<VOID>	   ;          
PRIVENTRY vvLockSVGARegisters		<ULONG>	  ;          
PRIVENTRY vvUnLockSVGARegisters		<VOID>	;          
PRIVENTRY vvSVGAFixSetBgnd		<HVDM>	     ;          
endif



; *  vvevent.c
;

PRIVENTRY vvAddEvent		<HVDM, _INT, PVOID, FLAGS>
PRIVENTRY vvFlushEvent		<HVDM, _INT, FLAGS>
PRIVENTRY vvFlushEventNotify		<HVDM, _INT>
PRIVENTRY vvDeleteEvent		<HVDM, _INT, FLAGS>
PRIVENTRY vvGetEvent		<PHVDM, BOOL>
PRIVENTRY VVCheckForEvents		<HVDM, BOOL>
PRIVENTRY vvCheckForDirtyLVB		<HVDM, FLAGS>
PRIVENTRY vvCheckForDirtyPalette		<HVDM, FLAGS>
PRIVENTRY vvEnumerateVDMs		<PENUMHOOK, BOOL>
HOOKENTRY VVEventTimer		<PVOID, PCRF>



; *  vvdevrq.c
;

EXPENTRY VVDevReqProc		<HVDM, ULONG, PVOID, PVOID>
PRIVENTRY vvDevPostPeek		<HVDM, BOOL>
PRIVENTRY vvDevPostRead		<HVDM, BOOL>
PRIVENTRY vvDevPostPaste		<HVDM, BOOL>
PRIVENTRY vvDevPostMouse		<HVDM, BOOL>
PRIVENTRY vvDevAcceptAdapter		<HVDM, BOOL>
PRIVENTRY vvDevReleaseAdapter		<HVDM, BOOL>
PRIVENTRY vvDevAcceptDisplay		<HVDM, BOOL>
PRIVENTRY vvDevReleaseDisplay		<HVDM, BOOL>
PRIVENTRY vvDevPostVideoEvent		<HVDM, PVVPOST>
PRIVENTRY vvKeyboardCheck		<HVDM, BOOL>
HOOKENTRY VVInitContext		<PBOOL, PCRF>
PRIVENTRY vvDevSaveRestoreAdapter		<HVDM, BOOL>	      ;          
PRIVENTRY vvDevRepaint		<HVDM, BOOL>			 ;          
PRIVENTRY vvDevRequestController		<HVDM, BOOL>	       ;          
PRIVENTRY vvDevFreeController		<HVDM, BOOL>		  ;          
PRIVENTRY vvDevWindowsDeskTop		<HVDM, BOOL>		  ;          
PRIVENTRY vvDevEnableDDE		<HVDM, BOOL>		       ;          
PRIVENTRY vvDevXGAPresent		<HVDM,BOOL>		      ;          
PRIVENTRY vvDevUnmapVRAM		<HVDM,BOOL>		       ;          
PRIVENTRY vvDev8514Present		<HVDM,BOOL>		     ;          
ifdef  GALE							       ;J-TS00V
PRIVENTRY vvDevGetVideoBuffer		<HVDM, PVOID, PVOID>		  ;J-TS00V
PRIVENTRY vvMakePaletteTableGale		<HVDM, _BYTE *>			;J-TS00V
PRIVENTRY vvGetVIOModeData		<HVDM, PVOID>			     ;J-TS00V
PRIVENTRY vvDevSetVtextNotification		<HVDM, PVOID, PVOID>	    ;J-TS00V
endif  ;GALE							      //J-TS00V



; *  vvsysrq.c
;

EXPENTRY VVSysReqProc		<SGID, ULONG, ULONG, PVOID, ULONG, PVOID>
PRIVENTRY vvSysSetAccess		<HVDM, ULONG, PVOID, ULONG, PVOID>
PRIVENTRY vvSysSetFocus		<HVDM, ULONG, PVOID, ULONG, PVOID>
PRIVENTRY vvSysSetLock		<HVDM, ULONG, PVOID, ULONG, PVOID>
PRIVENTRY vvSysQueryMode		<HVDM, ULONG, PVOID, ULONG, PVVMODE>
PRIVENTRY vvSysQueryCursor		<HVDM, ULONG, PVOID, ULONG, PVVCURSOR>
PRIVENTRY vvSysQueryPalette		<HVDM, ULONG, PVOID, ULONG, PRGB>
PRIVENTRY vvSysCopyLVB		<HVDM, ULONG, PRECTL, ULONG, PBYTE>
ifdef  XVIO							       ;J-TS00V
PRIVENTRY vvSysCopyLVBSub		<HVDM, ULONG, PRECTL, ULONG, PBYTE, BOOL> ;J-TS00V
endif  ;XVIO							      //J-TS00V
PRIVENTRY vvSysCopyBitmap		<HVDM, ULONG, PVVRECT, ULONG, PBYTE>
PRIVENTRY vvSysWaitEvent		<HVDM, ULONG, PVOID, ULONG, PVVEVENT>
PRIVENTRY vvSysControlEvent		<HVDM, ULONG, PVOID, ULONG, PVOID>
PRIVENTRY vvSysSetDisplayReq		<HVDM, ULONG, PVVDRQ, ULONG, PVOID>
PRIVENTRY vvSysRequestMemory		<HVDM, ULONG, PVOID, ULONG, PULONG>
PRIVENTRY vvSysFreeMemory		<HVDM, ULONG, PVOID, ULONG, PULONG>
PRIVENTRY vvSysRequestController		<HVDM, ULONG, PVOID, ULONG, PVOID>
PRIVENTRY vvSysFreeController		<HVDM, ULONG, PVOID, ULONG, PVOID>
PRIVENTRY vvSysQueryVRAMStatus		<HVDM, ULONG, PVOID, ULONG, PVOID>
PRIVENTRY vvSysSetOEMFlag		<HVDM, ULONG, PVOID, ULONG, PVOID>    ;          


; *  vvptr.c
;

EXPENTRY VVShowPtr		<HVDM, ULONG, ULONG>
EXPENTRY VVHidePtr		<HVDM>
EXPENTRY VVDefineTextPtr		<HVDM, ULONG, ULONG, BOOL>
EXPENTRY VVDefineGraphPtr		<HVDM, PUSHORT, ULONG, ULONG>
EXPENTRY VVSetPtrPage		<HVDM, ULONG>
EXPENTRY VVSetLPenEmulation		<HVDM, BOOL>
HOOKENTRY VVUpdatePtrContext		<PULONG, PCRF>

ifdef  VTEXT							       ;J-TS00V
;vvvtext.c							       //J-TS00V
HOOKENTRY VVInt10VtextHook		<PVOID, PCRF>			     ;J-TS00V
HOOKENTRY VVInt10VtextPreHook		<PVOID, PCRF>			  ;J-TS00V
PRIVENTRY vvCheckDispDD		<PCRF>					;J-TS00V
HOOKENTRY VVCheckVtextReturn		<PVOID, PCRF>			   ;J-TS00V
PRIVENTRY vvCheckForDirtyLVBVtext		<HVDM, FLAGS>		      ;J-TS00V
PRIVENTRY vvMapVtextPVB		<PVDM>					;J-TS00V
PRIVENTRY vvUnmapVtextPVB		<VOID>				      ;J-TS00V
PRIVENTRY vvFgndContextVtext		<PCRF>				   ;J-TS00V
PRIVENTRY vvBgndContextVtext		<PCRF>				   ;J-TS00V
PRIVENTRY vvRedrawVtext		<PCRF>					;J-TS00V
HOOKENTRY VVVtextRedrawReturn		<PVOID, PCRF>			  ;J-TS00V
PRIVENTRY vvCheckSetModeVtext		<PCRF>				  ;J-TS00V
PRIVENTRY vvCheckCallerVtext		<PCRF>				   ;J-TS00V
PRIVENTRY vvSet$DispDrawingFlag		<HVDM, BOOL>			;J-TS00V
PRIVENTRY vvSetSupportedModeFlag		<BOOL>			       ;J-TS00V
PRIVENTRY vvGetRowCountVtext		<HVDM>				   ;J-TS00V
PRIVENTRY vvPtrDrawVtext		<HVDM, ULONG, ULONG>		       ;J-TS00V
PRIVENTRY vvPtrEraseVtext		<HVDM>				      ;J-TS00V
PRIVENTRY vvPtrSetupDrawVtext		<ULONG, ULONG>			  ;J-TS00V
PRIVENTRY vvPtrSetupUpdateVtext		<ULONG, ULONG>			;J-TS00V
PRIVENTRY vvPtrSetupDrawUpdateVtext		<ULONG, ULONG, FPFN>	    ;J-TS00V
PRIVENTRY vvPtrSetupEraseVtext		<VOID>				 ;J-TS00V
HOOKENTRY VVVtextUpdatePtrContext		<PVOID, PCRF>		      ;J-TS00V
HOOKENTRY VVVtextPtrReturn		<PVOID, PCRF>			     ;J-TS00V
endif  ;VTEXT							      //J-TS00V
									;J-TS00V
ifdef  XVIO							       ;J-TS00V
;vvxvio.c							       //J-TS00V
PRIVENTRY vxSetCursor		<HVDM, ULONG, PVXCURSOR, ULONG, PVOID>	  ;J-TS00V
PRIVENTRY vxGetCursor		<HVDM, ULONG, PVOID, ULONG, PVXCURSOR>	  ;J-TS00V
PRIVENTRY vxCopyLVB		<HVDM, ULONG, PVXLVB, ULONG, PBYTE>	    ;J-TS00V
PRIVENTRY vxWriteString		<HVDM, ULONG, PVXWSTR, ULONG, PBYTE>	;J-TS00V
PRIVENTRY vxSaveScreen		<HVDM, ULONG, PVOID, ULONG, PVOID>	 ;J-TS00V
PRIVENTRY vxRestoreScreen		<HVDM, ULONG, PVOID, ULONG, PVOID>    ;J-TS00V
PRIVENTRY vxSetVVDType		<HVDM, ULONG>				 ;J-TS00V
PRIVENTRY vxAddEvent		<HVDM, _INT, PVOID, FLAGS>		    ;J-TS00V
PRIVENTRY vxFlushEvent		<HVDM, _INT, FLAGS>			  ;J-TS00V
PRIVENTRY vxSetStatus		<HVDM, ULONG, ULONG>			  ;J-TS00V
endif  ;XVIO							      //J-TS00V



; *  vvptra.asm
;

PRIVENTRY vvPtrReset		<HVDM>
PRIVENTRY vvPtrSetMasks		<HVDM, PUSHORT>
PRIVENTRY vvPtrDraw		<HVDM, ULONG, ULONG>
PRIVENTRY vvPtrErase		<HVDM>



; *  vvint10.asm
;

HOOKENTRY VVInt10Hook		<PCRF>
HOOKENTRY VVInt10Return		<PVOID, PCRF>



; *  vvcopy.asm
;

ifdef  XVIO							       ;J-TS00V
PRIVENTRY vvCopyLVBToLVB		<HVDM, PRECTL, PVOID, ULONG, BOOL>     ;J-TS00V
else   ;XVIO							      //J-TS00V
PRIVENTRY vvCopyLVBToLVB		<HVDM, PRECTL, PVOID, ULONG>	       ;          
endif  ;XVIO							      //J-TS00V
PRIVENTRY vvCopyBlankToLVB		<HVDM, PRECTL, PVOID, ULONG>	     ;          
PRIVENTRY vvCopyGraphicsToBitmap		<HVDM, PVVRECT, PVOID>
PRIVENTRY vvCopyGraphicsToBitmap256		<HVDM, PVVRECT, PVOID>
PRIVENTRY vvCopyGraphicsToDDBitmap		<HVDM, PVVRECT, PVOID>
PRIVENTRY vvConvertPalette		<HVDM, ULONG, PVOID>
PRIVENTRY vvFillShadowBuffer		<HVDM, PRECTL>
PRIVENTRY vvDiffShadowBuffer		<HVDM, PRECTL>
ifdef EGAVGA
PRIVENTRY vvDiffPhysPage		<HVDM, _INT, PULONG, PULONG, BOOL>
endif



; *  vvphysio.asm
;

PRIVENTRY vvSetupShadowPtrs		<PVVREG, ULONG, PRLE>
PRIVENTRY vvSetPhysIOState		<VOID>
PRIVENTRY vvAdjustShadowOutput		<PRLE, _BYTE>
PRIVENTRY vvShadowOutput		<HVDM, PORT, PORT, LONG, ULONG, PBYTE, PBYTE, FLAGS>
PRIVENTRY vvRequestController		<HVDM, BOOL>
PRIVENTRY vvLockController		<VOID>
PRIVENTRY vvUnlockController		<VOID>
PRIVENTRY vvFreeController		<HVDM>
PRIVENTRY vvDebugSaveInfo		<_BYTE, HVDM, BOOL>    ;75466

ifdef SVGA


; *  vvpmi.c
;

PRIVENTRY vvProcessPMIFile		<CHAR *>


; *  vvsvgaid.asm
;

PRIVENTRY GetPortBase		<VOID>
PRIVENTRY IdentifySVGA		<VOID>
PRIVENTRY IsATI		<VOID>
PRIVENTRY IsTrident		<VOID>
PRIVENTRY IsTseng		<VOID>
PRIVENTRY IsVideo7		<VOID>
PRIVENTRY IsWesternDig		<VOID>
PRIVENTRY Video7DisableExt		<VOID>
PRIVENTRY Video7EnableExt		<VOID>
PRIVENTRY WhichATI		<VOID>
PRIVENTRY WhichTrident		<VOID>
PRIVENTRY WhichTseng		<VOID>
PRIVENTRY WhichVideo7		<VOID>
PRIVENTRY WhichWesternDig		<VOID>
PRIVENTRY vvMaxBanks		<HVDM>


; *  vvsvga.c
;

PRIVENTRY vvSVGAGetLockState		<HVDM>			   ;          

PRIVENTRY vvNOPSetBank		<HVDM, ULONG, BOOL>
PRIVENTRY vvVideo7SetBank		<HVDM, ULONG, BOOL>
PRIVENTRY vvTsengSetBank		<HVDM, ULONG, BOOL>
PRIVENTRY vvTridentSetBank		<HVDM, ULONG, BOOL>
PRIVENTRY vvWDSetBank		<HVDM, ULONG, BOOL>
PRIVENTRY vvATISetBank		<HVDM, ULONG, BOOL>
PRIVENTRY vvIBMSetBank		<HVDM, ULONG, BOOL>		 ;          
PRIVENTRY vvCirrusSetBank		<HVDM, ULONG, BOOL>	      ;          
PRIVENTRY vvS3SetBank		<HVDM, ULONG, BOOL>		  ;          

PRIVENTRY vvNOPGetBank		<HVDM, BOOL>
PRIVENTRY vvVideo7GetBank		<HVDM, BOOL>
PRIVENTRY vvTsengGetBank		<HVDM, BOOL>
PRIVENTRY vvTridentGetBank		<HVDM, BOOL>
PRIVENTRY vvWDGetBank		<HVDM, BOOL>
PRIVENTRY vvATIGetBank		<HVDM, BOOL>
PRIVENTRY vvIBMGetBank		<HVDM, BOOL>			 ;          
PRIVENTRY vvCirrusGetBank		<HVDM, BOOL>		      ;          
PRIVENTRY vvS3GetBank		<HVDM, BOOL>			  ;          

PRIVENTRY vvSVGALinearMode		<HVDM>


; *  vv8514sv.c							             
;
PRIVENTRY v8514InstallIOHooks		<VOID>
PRIVENTRY v8514SetIOHooks		<FLAGS>
PRIVENTRY v8514SetPixelIOHooks		<FLAGS>
PRIVENTRY v8514UpdateModeData		<HVDM>
PRIVENTRY v8514AddEvent		<HVDM, _INT, PVOID, FLAGS>
PRIVENTRY v8514DeleteEvent		<HVDM, _INT>
PRIVENTRY v8514EnableVGA		<VOID>
PRIVENTRY v8514EnableBankAdd		<HVDM>
PRIVENTRY v8514RestoreIOState		<HVDM>
PRIVENTRY v8514ReturnLineLen		<HVDM>
PRIVENTRY v8514Accelerated		<HVDM>
PRIVENTRY v8514WaitOnEngine		<HVDM>
PRIVENTRY v8514ockIO		<HVDM>
PRIVENTRY v8514UnlockIO		<HVDM>
PRIVENTRY v8514EnterIO		<ULONG, ULONG>
PRIVENTRY v8514ExitIO		<VOID>
HOOKENTRY V8514ReadWRegByteL		<ULONG, PCRF>
HOOKENTRY V8514WriteWRegByteL		<_BYTE, ULONG, PCRF>
HOOKENTRY V8514ReadWRegByteH		<ULONG, PCRF>
HOOKENTRY V8514WriteWRegByteH		<_BYTE, ULONG, PCRF>
HOOKENTRY V8514ReadWRegWord		<ULONG, PCRF>
HOOKENTRY V8514WriteWRegWord		<_WORD, ULONG, PCRF>

HOOKENTRY V8514ReadMFRegByteL		<ULONG, PCRF>
HOOKENTRY V8514WriteMFRegByteL		<_BYTE, ULONG, PCRF>
HOOKENTRY V8514ReadMFRegByteH		<ULONG, PCRF>
HOOKENTRY V8514WriteMFRegByteH		<_BYTE, ULONG, PCRF>
HOOKENTRY V8514ReadMFRegWord		<ULONG, PCRF>
HOOKENTRY V8514WriteMFRegWord		<_WORD, ULONG, PCRF>


; *  vvsvgaio.asm
;

EXPENTRY VVWriteTsengUnlock1Fgnd		<>
EXPENTRY VVWriteTsengUnlock1Bgnd		<>
EXPENTRY VVWriteTsengUnlock2Fgnd		<>
EXPENTRY VVWriteTsengUnlock2Bgnd		<>
EXPENTRY VVReadTsengSegSelectFgnd		<>
EXPENTRY VVWriteTsengSegSelectFgnd		<>
EXPENTRY VVReadTsengSegSelectBgnd		<>
EXPENTRY VVWriteTsengSegSelectBgnd		<>
EXPENTRY VVGetTridentRegDef		<>
EXPENTRY VVWriteIBMApertureCtrlFgnd		<>			   ;          
EXPENTRY VVReadIBMApertureCtrlBgnd		<>			    ;          
EXPENTRY VVWriteIBMApertureCtrlBgnd		<>			   ;          
EXPENTRY VVReadIBMRegistersBgnd		<>
EXPENTRY VVWriteIBMRegistersBgnd		<>
EXPENTRY VVReadOrchidClockSelectFgnd		<>			  ;          
EXPENTRY VVReadOrchidClockSelectBgnd		<>			  ;          
EXPENTRY VVWriteOrchidClockSelectFgnd		<>			 ;          
EXPENTRY VVWriteOrchidClockSelectBgnd		<>			 ;          

PRIVENTRY SETDIAMONDCLK		<HVDM, ULONG, ULONG>			;          
PRIVENTRY Prog_Clock		<>		   ;          
PRIVENTRY Send_Serial		<>		  ;          
PRIVENTRY GetCRTCAddr		<>		  ;          
PRIVENTRY GetDACTypeRtn		<>		;          
PRIVENTRY SetDACCMDReg		<>		 ;          
PRIVENTRY WaitVertRetrace		<>	      ;          

PRIVENTRY SETNUMBER9CLK		<HVDM, ULONG>				;          
endif


; *   MASM function prototypes
; *
; *   None of these functions are callable they are declared
; *   so that they can be referenced in various function tables.  The
; *   one current exception is in vvcrtio.asm:	vvUpdateCursorData.
;

 ; vvatcio.asm
; *
;

ifdef EGA
EXPENTRY VVReadATCFgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVReadATCBgnd		<>
EXPENTRY VVWriteATCFgnd		<>
EXPENTRY VVWriteATCBgnd		<>
endif
ifdef EGA
EXPENTRY VVReadATCFgndW		<>
EXPENTRY VVWriteATCFgndW		<>
endif
ifdef EGA
EXPENTRY VVReadATC1Fgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVReadATC1Bgnd		<>
endif



; *  vvcrtio.asm
;

ifndef VGA
EXPENTRY VVReadCRTIndxFgnd		<>
endif
EXPENTRY VVReadCRTIndxBgnd		<>
ifndef VGA
EXPENTRY VVWriteCRTIndxFgnd		<>
endif
EXPENTRY VVWriteCRTIndxBgnd		<>
ifndef VGA
EXPENTRY VVReadCRTIndxFgndW		<>
endif
EXPENTRY VVWriteCRTIndxFgndW		<>
EXPENTRY VVWriteCRTIndxBgndW		<>
ifndef VGA
EXPENTRY VVReadCRTDataFgnd		<>
endif
EXPENTRY VVReadCRTDataBgnd		<>
ifndef VGA
EXPENTRY VVWriteCRTDataFgnd		<>
endif
EXPENTRY VVWriteCRTDataBgnd		<>
PRIVENTRY vvUpdateCursorData		<HVDM>
ifdef  XVIO							       ;J-TS00V
PRIVENTRY vxUpdateCursorData		<HVDM>				   ;J-TS00V
endif  ;XVIO							      //J-TS00V


; *  vvdacio.asm
;

ifdef VGA
EXPENTRY VVWriteDACReadFgnd		<>
EXPENTRY VVWriteDACWriteFgnd		<>
EXPENTRY VVReadDACDataFgnd		<>
EXPENTRY VVWriteDACDataFgnd		<>
EXPENTRY VVReadDACMaskBgnd		<>
EXPENTRY VVWriteDACMaskBgnd		<>
EXPENTRY VVReadDACStateBgnd		<>
EXPENTRY VVWriteDACReadBgnd		<>
EXPENTRY VVReadDACIndxBgnd		<>
EXPENTRY VVWriteDACWriteBgnd		<>
EXPENTRY VVReadDACDataBgnd		<>
EXPENTRY VVWriteDACDataBgnd		<>
endif



; *  vvgdcio.asm
;

ifdef EGA
EXPENTRY VVWriteGDC2Fgnd		<>
EXPENTRY VVWriteGDC2Bgnd		<>
EXPENTRY VVWriteGDC1Fgnd		<>
EXPENTRY VVWriteGDC1Bgnd		<>
endif
ifdef EGA
EXPENTRY VVReadGDCIndxFgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVReadGDCIndxBgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVWriteGDCIndxFgnd		<>
EXPENTRY VVWriteGDCIndxBgnd		<>
endif
ifdef EGA
EXPENTRY VVReadGDCIndxFgndW		<>
EXPENTRY VVWriteGDCIndxFgndW		<>
endif
ifdef EGA
EXPENTRY VVReadGDCDataFgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVReadGDCDataBgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVWriteGDCDataFgnd		<>
EXPENTRY VVWriteGDCDataBgnd		<>
endif



; *  vvmscio.asm
;

ifdef MONOCGA
EXPENTRY VVReadModeFgnd		<>
EXPENTRY VVReadModeBgnd		<>
EXPENTRY VVWriteModeFgnd		<>
EXPENTRY VVWriteModeBgnd		<>
endif
ifdef CGA
EXPENTRY VVReadCGAColorFgnd		<>
EXPENTRY VVReadCGAColorBgnd		<>
EXPENTRY VVWriteCGAColorFgnd		<>
EXPENTRY VVWriteCGAColorBgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVReadStatus0Bgnd		<>
endif
ifdef EGAVGA							       ;          
EXPENTRY VVWriteMiscOutFgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVWriteMiscOutBgnd		<>
endif
ifdef EGA
EXPENTRY VVReadFeatureFgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVReadFeatureBgnd		<>
endif
ifdef EGA
EXPENTRY VVReadMiscOutFgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVReadMiscOutBgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVReadStatus1Fgnd		<>
endif
EXPENTRY VVReadStatus1Bgnd		<>
ifdef EGA
EXPENTRY VVWriteFeatureFgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVWriteFeatureBgnd		<>
endif
ifndef MONO
EXPENTRY VVReadUnknownBgnd		<>
endif
EXPENTRY VVWriteUnknownBgnd		<>
EXPENTRY VVWriteUnknownBgnd		<>
ifdef SVGA						  ;          
EXPENTRY VVReadVVReservedFgnd		<>		    ;          
EXPENTRY VVWriteVVReservedFgnd		<>		   ;          
EXPENTRY VVReadVVReservedBgnd		<>		    ;          
EXPENTRY VVWriteVVReservedBgnd		<>		   ;          
endif							  ;          



; *  vvseqio.asm
;

ifdef EGA
EXPENTRY VVReadSEQIndxFgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVReadSEQIndxBgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVWriteSEQIndxFgnd		<>
EXPENTRY VVWriteSEQIndxBgnd		<>
endif
ifdef EGA
EXPENTRY VVReadSEQIndxFgndW		<>
EXPENTRY VVWriteSEQIndxFgndW		<>
endif
ifdef EGA
EXPENTRY VVReadSEQDataFgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVReadSEQDataBgnd		<>
endif
ifdef EGAVGA
EXPENTRY VVWriteSEQDataFgnd		<>
EXPENTRY VVWriteSEQDataBgnd		<>
endif



; *  vvoem.asm
;

ifdef COMPAQ
ifdef EGA
EXPENTRY VVReadCompaqCtrlBgnd		<>
EXPENTRY VVWriteCompaqCtrlBgnd		<>
endif
endif

ifdef ATI
ifdef EGAVGA
EXPENTRY VVReadATIIndxBgnd		<>
EXPENTRY VVWriteATIIndxBgnd		<>
EXPENTRY VVReadATIDataBgnd		<>
EXPENTRY VVWriteATIDataBgnd		<>
endif
endif

ifdef  GALE							       ;J-TS00V
;vvgale.asm							       //J-TS00V
HOOKENTRY VVInt15Hook		<PCRF>					  ;J-TS00V
EXPENTRY VVInitScreen		<>					 ;J-TS00V
EXPENTRY VVRedrawScreen		<>				       ;J-TS00V
EXPENTRY VVLoadDefaultSBCS		<>				    ;J-TS00V
EXPENTRY VVCheckXGAAdapter		<>				    ;J-TS00V
EXPENTRY VVInitDBCSTable		<>				      ;J-TS00V
EXPENTRY vvExtWriteStrGale		<>				    ;J-TS00V
EXPENTRY vvSetCurPosGale		<>				      ;J-TS00V
EXPENTRY vvSetCurTypeGale		<>				     ;J-TS00V
PRIVENTRY vvMakePaletteTableGale		<HVDM, _BYTE *>			;J-TS00V
EXPENTRY vvConvAPAToPrtGale		<PBYTE *, PBYTE, PBYTE, BOOL>	   ;J-TS00V
endif  ;GALE							      //J-TS00V
ifdef  XVIO							       ;J-TS00V
EXPENTRY vvExtWriteStrGale		<>				    ;J-TS00V
EXPENTRY vvSetCurPosGale		<>				      ;J-TS00V
EXPENTRY vvSetCurTypeGale		<>				     ;J-TS00V
endif  ;XVIO							      //J-TS00V
									;J-TS00V
ifdef  VTEXT							       ;J-TS00V
;vvvtexta.asm							       //J-TS00V
PRIVENTRY vvUpdateCursorDataVtext		<HVDM>			      ;J-TS00V
ifdef  XVIO							       ;J-TS00V
PRIVENTRY vvCopyLVBToLVBVtext		<HVDM, PRECTL, PVOID, ULONG, BOOL> ;J-TS00V
else   ;XVIO							      //J-TS00V
PRIVENTRY vvCopyLVBToLVBVtext		<HVDM, PRECTL, PVOID, ULONG>	  ;J-TS00V
endif  ;XVIO							      //J-TS00V
endif  ;VTEXT							      //J-TS00V



word_s struc
  lo  db  ?
  hi  db  ?
word_s ends

dword_s struc
  off dw  ?
  sel dw  ?
dword_s ends




; * Random macro support
; *
; *   If VDDSTRICT is defined, the Assert macros generate appropriate code.
; *
; *   If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
; *   exception of AssertRC, in which case the function is still called, but
; *   the return code is not checked).
; *
; *   If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
; *   failed assertions (assuming VDDSTRICT is defined) break at the assertion
; *   rather than in the kernel's "panic" service.  VDDDEBUG requires the
; *   kernel debugger, in other words.
; *
; *   If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
; *   generated, and failed assertions (assuming VDDSTRICT is defined) simply
; *   panic.
;

ifdef VDDSTRICT





?ASSERT macro	cond,msg,args
	local	l1
	ifnb	<cond>
	j&cond	short l1
	endif
	ifdef	VDDDEBUG
	DBPRINT <msg>,<args>
	int 3
	else
	PANIC	<msg>,<args>
	endif
	ifnb	<cond>
l1:
	endif
	endm



else





?ASSERT macro cond,msg,args
	endm



endif



ASSERT	 equ   <?ASSERT ,>
ASSERTC	 equ   <?ASSERT c,>
ASSERTNC equ   <?ASSERT nc,>
ASSERTZ	 equ   <?ASSERT z,>
ASSERTNZ equ   <?ASSERT nz,>
ASSERTE	 equ   <?ASSERT e,>
ASSERTNE equ   <?ASSERT ne,>
ASSERTB	 equ   <?ASSERT b,>
ASSERTBE equ   <?ASSERT be,>
ASSERTA	 equ   <?ASSERT a,>
ASSERTAE equ   <?ASSERT ae,>




; * Random debugging support
;


ifdef VDDDEBUG





DefData IMPORT,INSTANCE,C
SZ szModule
EndData

DBPRINT macro msg,args
	PRINTDEBUG <szModule>,<00>
	PRINTDEBUG <msg>,<args>
	endm



else



DBPRINT macro msg,args
	endm



endif



; * LOOP alternative to enhance performance				            
;



hploop	macro	target
	dec	ecx
	jnz	target
	endm


