/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VVDP.H
 *
 * DESCRIPTIVE NAME = Virtual Video Private Definitions
 *
 *
 * VERSION = V2.0
 *
 * DATE      11/10/88
 *
 * DESCRIPTION  VVD private constants, types, and function prototypes
 *
 * FUNCTIONS    None
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#ifdef  XVIO                                                            //J-TS00V
#include <vxvio.h>
#endif  //XVIO                                                          //J-TS00V

#define COMPAQ          /* provide built-in Compaq support             */
#define TSENG           /* provide built-in Tseng Labs support         */
#define ATI             /* provide built-in ATI EGA/VGA Wonder support */

#ifdef SVGA
  #define VGA
#include <svgadefs.h>                   /*            */
#endif

#ifdef CGA
  #define CGAEGA        /* define CGAEGA to mean "CGA or EGA"          */
  #define ADAPTER_TYPE  ADAPTER_CGA
#else
  #ifdef EGA
    #define CGAEGA
  #endif
#endif

#ifdef EGA
  #define EGAVGA        /* define EGAVGA to mean "EGA or VGA"          */
  #define ADAPTER_TYPE  ADAPTER_EGA
#else
  #ifdef VGA
    #define EGAVGA
  #endif
#endif

#ifdef VGA
  #define ADAPTER_TYPE  ADAPTER_VGA
#endif

#ifdef MONO
  #define MONOCGA       /* define MONOCGA to mean "MONO or CGA"        */
  #define ADAPTER_TYPE  ADAPTER_MONO
#else
  #ifdef CGA
    #define MONOCGA
  #endif
#endif

#ifndef MONO
#define PROPERTIES      /* include properties support                  */
#endif


 /*
 ** Physical constants (non-configurable)
 */

#define BELL    0x07
#define BS      0x08
#define CR      0x0D
#define LF      0x0A
#define ESCAPE  0x1B

/*
*/

#include <int2f.h>
#define INT2F_VDMENABLESR       0x4000
#define INT2F_SYSBGND           0x4001
#define INT2F_SYSFGND           0x4002
#define INT2F_VDMENTERCRITSEC   0x4003
#define INT2F_VDMEXITCRITSEC    0x4004
#define INT2F_SYSSAVEREGS       0x4005
#define INT2F_SYSRESTOREREGS    0x4006
#define INT2F_VDMDISABLESR      0x4007


#ifdef MONO
#define VRAM_START      MONOMEM_START
#define VRAM_LEN        (4*1024)    /* true MPA has 4K of VRAM                    */
#define MAX_PLANES      1
#define MAX_PLANESIZE   VRAM_LEN                                     /*            */
#endif

#ifdef CGA
#define VRAM_START      CGAMEM_START
#define VRAM_LEN        CGAMEM_LEN
#define MAX_PLANES      1
#define MAX_PLANESIZE   CGAMEM_LEN
#endif

#ifdef EGAVGA
#define VRAM_START      EGAVGAMEM_START
#define VRAM_LEN        EGAVGAMEM_LEN
#define MAX_PLANES      4
#define MAX_PLANESIZE   (64*1024)
#endif

#ifdef SVGA                     /* This allows us up to 1Meg Video Memory */
#define MAX_BANKS       4       /* with 4 planes and 4 banks of 64k each. */
#else
#define MAX_BANKS       1
#endif

#define BANK0           0
#define BANKSIZE        (64*1024)       /* banks are 64k bytes            */


//c-begin

#ifdef MAX_PLANESIZE
#define MAX_PAGESPERPLANE PAGESFROMBYTES(MAX_PLANESIZE)
#endif

//c-end


//masm-begin

//MAX_PAGESPERPLANE equ ((MAX_PLANESIZE+PAGESIZE-1)/PAGESIZE)

//masm-end


//c-begin

#define VRAM_PAGES PAGESFROMBYTES(VRAM_LEN)

//c-end


//masm-begin

//VRAM_PAGES equ ((VRAM_LEN+PAGESIZE-1)/PAGESIZE)

//masm-end


 /*
 ** Configurable constants
 */

#define BELL_FREQ       896     /* (hz)                                */
#define BELL_DURATION   125     /* (ms)                                */

#define TICKS_DIRTY     1       /* check for dirt every n ticks (default) */
#define PEEKS_CHECK     10      /* check for events every n peeks      */
#define TIMER_CHECK     125     /* wait 1/8 sec between event checks   */
#define TIMER_DELAY     3000    /* 3000ms (3 sec) maximum update delay */

#define MAX_RTRCLOOP    0x4000  /* maximum # iterations to wait for retrace */

#define MAX_ALTSTACK    256     /* 256 bytes should be sufficient      */

#define MAX_TITLESIZE   13      /* enough space for 8.3 filename + NULL */

#ifdef SVGA

#define MAX_VDM_WAIT    15000   /* max screen-switch delay (ms)            */
#define MAX_ENGINE_WAIT  1000   /* wait for engine (ms)                    */
#define MASK_ALL_LOCKED 0xFFFF  /* For non WD, mark first 15 LOCKED           */

#define CRTOVFL_VERTDSPEND2 0x040       /* bit 9 of Vertical Display End */

#define DEFAULT_VRAM_SIZE  1024*1024            /*            */

                                /*            S3 support start */
 /*
 ** NOTE: this list of registers MUST be kept in sync with aportWReg.
 ** The array reflects the range of 8514 compatible regs on S3 chip.
 */
                                /* private indexes into aportWReg             */
#define WREG_SUBSYSCTRL     0
#define WREG_ADVCTRL        1
#define WREG_COMMAND        2
#define WREG_CURRENTY       3
#define WREG_CURRENTX       4
#define WREG_DESTYAXSTP     5
#define WREG_DESTXDIASTP    6
#define WREG_ERRORTERM      7
#define WREG_MAJORAXISCNT   8
#define WREG_BGNDCOLOR      9
#define WREG_FGNDCOLOR      10
#define WREG_WRITEMASK      11
#define WREG_READMASK       12
#define WREG_COLORCOMPARE   13
#define WREG_BGNDMIX        14
#define WREG_FGNDMIX        15
#define WREG_SHORTSTROKE    16
#define WREG_PIXELTRANSFER  17
#define WREG_PIXELTRANSFER_EXT  18
#define WREG_TOTAL          19

#define MFINDX_MISCCTRL    0xE000

#define MFREG_MINORAXISCNT   (MFINDX_MINORAXISCNT   >> MFINDX_INDXSHIFT)
#define MFREG_TOPSCISSORS    (MFINDX_TOPSCISSORS    >> MFINDX_INDXSHIFT)
#define MFREG_LEFTSCISSORS   (MFINDX_LEFTSCISSORS   >> MFINDX_INDXSHIFT)
#define MFREG_BOTTOMSCISSORS (MFINDX_BOTTOMSCISSORS >> MFINDX_INDXSHIFT)
#define MFREG_RIGHTSCISSORS  (MFINDX_RIGHTSCISSORS  >> MFINDX_INDXSHIFT)
#define MFREG_PIXELCTRL      (MFINDX_PIXELCTRL      >> MFINDX_INDXSHIFT)
#define MFREG_MISCCTRL       (MFINDX_MISCCTRL       >> MFINDX_INDXSHIFT)
                                        /*            S3 support end */

#define SierraDAC       0               /*            */
#define ATTDAC          1               /*            */
#define MusicDAC        2               /*            */
#define S3_BT485DAC     3               /*            */
#define SGSDAC          4               /*            */
#define DEFAULT_DAC    -1               /*            */
#endif


 /* Adapter types
 **
 **  For the most part, we'd prefer to always implement a single solution
 **  for any given problem for all existing adapters, but inevitably
 **  certain adapters need something a little different.  Where possible,
 **  we will try to determine the adapter-type automatically.  Where
 **  impossible, we may provide a switch to specify the adapter type on
 **  the DEVICE= line in CONFIG.SYS.  The following is a list of
 **  supported adapter types; it is recorded in ulAdapter (which starts
 **  out as ADAPTER_IBM until we discover otherwise).
 **
 ** Note that the adapter categories are fairly broad at this
 **     point.  There's no reason for it to remain that way however
 **     (ie, we may well want to add different adapter codes for
 **     different adapters from a single manufacturer).
 */

#define ADAPTER_IBM     1       /* IBM adapter                         */
#define ADAPTER_COMPAQ  2       /* Compaq adapter                      */
#define ADAPTER_TSENG   3       /* Tseng Labs adapter                  */
#define ADAPTER_VIDEO7  4       /* Video Seven adapter                 */
#define ADAPTER_ATI     5       /* ATI Wonder adapter                  */

#ifdef SVGA                             /*                             */

#define SVGA_PMIFILENAME        "c:\\os2\\svgadata.pmi"  /*            */
#define PMICMD_RMWB    7                                 /*            */
#define PMICMD_RMWW    8                                 /*            */

#define MAX_ATCREGS             0x20    /*            do not allow overindexing */
                                        /* index 20-3F writes to 0-1F with PAL enable */
#define MAX_SEQREGS             0x100
#define MAX_GDCREGS             0x100
#define MAX_CRTREGS             0x100
#define MAX_DACREGS             0x100
#define MAX_ATIREGS             0x100

#define ATI_START_EXTREGS       0xa0
#define ATI_END_EXTREGS         0xc0
#define ATI_TOTAL_INITREGS      (ATI_END_EXTREGS - ATI_START_EXTREGS)

typedef VOID (PRIVENTRY *PFNSVGASETBANK)(HVDM, ULONG, BOOL);
typedef ULONG (PRIVENTRY *PFNSVGAGETBANK)(HVDM, BOOL);

#define PORT_TSENG_SEGSELECT    0x3cd
#define PORT_TSENG_UNLOCK       0x3d8
#define PORT_HERC_COMPATIBILITY 0x3bf

#define INDX_TRIDENT_REGDEF     0x0b    /* sequencer indexed port      */
#define INDX_TRIDENT_MODECTRL   0x0d    /*      "       "              */

#else

//c-begin

#ifndef TSENG
#define TOTAL_IBM_CRTREGS   0x19
#define MAX_ATCREGS     (EXP2(LOG2(TOTAL_IBM_ATCREGS)))
#define MAX_SEQREGS     (EXP2(LOG2(TOTAL_IBM_SEQREGS)))
#define MAX_GDCREGS     (EXP2(LOG2(TOTAL_IBM_GDCREGS)))
#define MAX_CRTREGS     (EXP2(LOG2(TOTAL_IBM_CRTREGS)))
#else
#define MAX_ATCREGS     (EXP2(LOG2(TOTAL_TSENG_ATCREGS)))
#define MAX_SEQREGS     (EXP2(LOG2(TOTAL_TSENG_SEQREGS)))
#define MAX_GDCREGS     (EXP2(LOG2(TOTAL_TSENG_GDCREGS)))
#define MAX_CRTREGS     (EXP2(LOG2(TOTAL_TSENG_CRTREGS)))
#endif
#define MAX_DACREGS     (EXP2(LOG2(TOTAL_DACREGS)))

//c-end


/*
**
** This whole section is one gigantic FLAG: that would be deleted if
** H2INC and MASM could handle the macros above.  Handle with care!
*/


//masm-begin

//MAX_ATCREGS equ 20h
//MAX_SEQREGS equ 08h
//MAX_GDCREGS equ 10h
//ifndef TSENG
//MAX_CRTREGS equ 20h
//else
//MAX_CRTREGS equ 40h
//endif
//MAX_DACREGS equ 100h

//masm-end


//c-begin

//#if MAX_ATCREGS!=0x20||MAX_SEQREGS!=0x08||MAX_GDCREGS!=0x10||MAX_CRTREGS!=0x40
//#error Mismatch in C/MASM constants
//#endif

//c-end


#endif

 /*
 ** Global Video Flags
 */

#define VVD_PRIMARY       0x00000001 /* Display is primary display     */
#define VVD_MONOPRESENT   0x00000002 /* MONO adapter is present in system */
#define VVD_8514PRESENT   0x00000004 /* 8514 adapter is present in system            */
#define VVD_CTLLOCKED     0x00000010 /* Video controller locked by VDD */
#define VVD_CTLWAITING    0x00000020 /* Video controller is being requested */
#define VVD_VRAMISTOAST   0x00000040 /* VRAM has been trashed by VDD   */
#define VVD_THREADEXIT    0x00000080 /* Event thread must exit         */
#define VVD_REPAINT       0x00000100 /* Reset VRAMISTOAST bit                        */
#define VVD_PMBGND        0x00000200 /* PM is currently background     */
#define VVD_NOPHYSPAGES   0x00000400 /* Inhibit PhysPage allocation    */
#define VVD_TIMERARMED    0x00000800 /* Timerhook armed                              */
#define VVD_GRFXALLOWED   0x80000000 /* Windowed graphics allowed for all VDMs */


 /*
 ** Per-VDM Video Flags
 */

#define VDM_WINDOWED      0x00000001 /* VDM is windowed                */
#define VDM_PMWINDOWED    0x00000002 /* VDM is windowed by PM          */
#define VDM_MINIMIZED     0x00000004 /* VDM is minimized, inhibit events */
#define VDM_FGND          0x00000008 /* VDM is foreground              */
#define VDM_FGNDREADY     0x00000010 /* VDM foreground I/O hooks installed */
#define VDM_BGNDREADY     0x00000020 /* VDM background I/O hooks installed */
#define VDM_FOCUS         0x00000040 /* VDM has focus                  */
#define VDM_IOINIT        0x00000080 /* VDM I/O initialization is done */
#define VDM_STATEINIT     0x00000100 /* Internal state initialization done */
#define VDM_IOUPDATED     0x00000200 /* Complete I/O state known       */
#define VDM_UNKNOWNFAULT  0x00000400 /* Unknown page fault occurred    */
#define VDM_MOTIONTRAP    0x00000800 /* VRAM motion trapping is in effect */
#define VDM_SPECIALTRAP   0x00001000 /* GDC/SEQ trapping is in effect  */
#define VDM_UNMAPPED      0x00002000 /* All linear mappings currently disabled */
#define VDM_IGNOREFAULT   0x00004000 /* Page faults to be ignored      */
#define VDM_MODECHANGED   0x00008000 /* Mode-change posted but not processed */
#define VDM_MODECHANGING  0x00010000 /* Video mode-change in progress  */
#define VDM_FROZEN        0x00020000 /* We have suspended VDM          */
#define VDM_KEYREAD       0x00040000 /* Key read recently              */
#define VDM_KEYPASTED     0x00080000 /* Key pasted recently            */
#define VDM_INPUTPOSTED   0x00100000 /* No event has been posted since INPUT */
#define VDM_DYING         0x00200000 /* VDM is dying                   */
#define VDM_FGNDHOOK      0x00400000 /* FgndContext hook armed         */
#define VDM_BGNDHOOK      0x00800000 /* BgndContext hook armed         */
#define VDM_UPDATEHOOK    0x01000000 /* UpdateContext hook armed       */
#define VDM_PHYSHOOK      0x02000000 /* UpdatePhysContext hook armed   */
#define VDM_SHADOWINVALID 0x04000000 /* Shadow buffer is invalid       */
#define VDM_DIRTYPALETTE  0x08000000 /* Virtual palette has been changed */
#define VDM_PHYSPAGE      0x10000000 /* VDM owns 1 or more PAGE_PHYSICAL pages */
#define VDM_PHYSPAGECHK   0x20000000 /* Toggled with each dirty PHYSPAGE check */
#define VDM_UPDATING      0x40000000 /* VDM window is being updated    */
#define VDM_GRFXALLOWED   0x80000000 /* Windowed graphics is allowed   */

#define VDMX_ACTIVE       0x00000001 /* Display active (primary or secondary) */
#define VDMX_DEVOWNER     0x00000002 /* VDD owns device for this VDM   */
#define VDMX_DSPOWNER     0x00000004 /* VDD owns display for this VDM  */
#define VDMX_INITHOOK     0x00000008 /* InitContext hook armed         */
#define VDMX_PTRHOOK      0x00000010 /* UpdatePtrContext hook armed    */
#define VDMX_DEVREQUEST   0x00000020 /* DEVREQUEST from this VDD in progress */
#define VDMX_DSPREQUEST   0x00000040 /* DSPREQUEST from this VDD in progress */
#define VDMX_INT10INIT    0x00000080 /* INT 10h initialization in progress */
#define VDMX_VDDFAULT     0x00000100 /* VDD may cause VDM page fault   */
#define VDMX_INT10EMULATE 0x00000200 /* INT 10h emulation in effect    */
#define VDMX_RTRCEMULATE  0x00000400 /* horz/vert retrace emulation in effect */
#define VDMX_RTRCOVERRIDE 0x00000800 /* retrace emulation setting being overridden */
#define VDMX_CGARESTRICT  0x00001000 /* CGA restriction in effect      */
#define VDMX_MONORESTRICT 0x00002000 /* MONO restriction in effect     */
#define VDMX_RTRCTRAP     0x00004000 /* retrace port trapped           */
#define VDMX_SYNCOUTPUT   0x00008000 /* synchronous window output      */
#define VDMX_WDWSEMREQ    0x00010000 /* INT 10h emulation code has taken sem. */
#define VDMX_CREATEDONE   0x00020000 /* VDM creation complete                        */
#define VDMX_INT2FPENDING 0x00040000 /* Issue 2F int in SVGA BgndContext             */
#define VDMX_INT2FREGIST  0x00080000 /* Another device registered with us for 2F int             */
#define VDMX_SAVERESTORE  0x00100000 /* Save/Restore VGA                             */
#define VDMX_RESTOREBTDAC 0x00200000 /* Restore Brooktree DAC                        */
#define VDMX_ENHANCEDMODE 0x01000000 /* VDM is in enhanced mode                      */
#define VDMX_NOIOTRAPPING 0x02000000 /* don't trap foreground IO accesses            */
#define VDMX_UNMAPHOOK    0x04000000 /* VVUnMapPhysContext hook armed                */
#define VDMX_SEAMLESS     0x08000000 /* Seamless         session                     */
#define VDMX_32DSP        0x10000000 /* 32-bit DISPLAY Driver call                   */
#define VDMX_ONDEMAND     0x20000000 /* Enable on-demand memory allocation */
#define VDMX_INT2F        0x40000000 /* Enable INT 2Fh notifications   */
#define VDMX_V86MACHINE   0x80000000 /* running as a virtual 8086 machine */

#ifdef  XVIO                                                            //J-TS00V
#define VDMJ_GRAPHICSWRITE  0x00000001  // Graph mode str write req.    //J-TS00V
#define VDMJ_CANCELWRITE    0x00000002  // Cancel GRAPHICSWRITE         //J-TS00V
#define VDMJ_XVIOGACTIVE    0x00000004  // Graphics mode XVIO is now active. //J-TS00V
#define VDMJ_XVIOGHIDE      0x00000008  // Graphics mode XVIO hide is requested. //J-TS00V
#endif  //XVIO                                                          //J-TS00V

#ifdef  GALE                                                            //J-TS00V
/***LK+ DBCS input environment type */                                  //J-TS00V
                                                                        //J-TS00V
#define DBCS_INPUT_SINGLE       0                                       //J-TS00V
#define DBCS_INPUT_DUAL         1                                       //J-TS00V
#define DBCS_INPUT_DOS_KKC      2                                       //J-TS00V
#endif  //GALE                                                          //J-TS00V

#define VDMX2_FIRSTFGND   0x00000001 /* First set foreground            */
#define VDMX2_8514IOINIT   0x00000002 /* I/O initialization is done            */
#define VDMX2_8514BLOCKED  0x00000004 /* We have blocked VDM I/O            */
#define VDMX2_8514IOOWNED  0x00000008 /* I/O ownership flag                 */
#define VDMX2_8514IOWAKEME 0x00000010 /* I/O ownership notify flag          */
#define VDMX2_8514ENGBUSY  0x00000020 /* engine busy flag                   */
 /*
 ** Session states
 **
 **  These indicate the state of a VDM session as dictated by foreground
 **  and background notifications.
 */

#define SESSION_NONE    0       /* undefined (only during creation)    */
#define SESSION_FGND    1       /* last screen-switch event was SetFgnd */
#define SESSION_BGND    2       /* last screen-switch event was SetBgnd */


 /*
 ** Frozen states
 **
 **  A VDM can be frozen by the video VDD whenever it is background
 **  and tries to access memory in a graphics mode.
 */

#define FROZEN_NONE     0       /* VDM not frozen (by us anyway)       */
#define FROZEN_BGND     1       /* frozen due to unsupported memory access */


 /*
 ** Memory states
 **
 **  These indicate the overall state of a VDM's virtual or physical
 **  memory.  Determination is based on registers/bits that define current
 **  addressibility (see vvUpdateVideoState).  For the states of individual
 **  pages of virtual or physical memory, see the PAGE_* constants.
 */

#define MEMORY_LATCH   -1       /* private memory state (all planes enabled) */
#define MEMORY_NONE     0       /* no state (only during creation)     */
#define MEMORY_TEXT     1       /* single-plane TEXT memory in use     */
#define MEMORY_FONT     2       /* plane 2 GRAPHICS memory in use      */
#define MEMORY_CGAX     3       /* single-plane GRAPHICS memory in use */
#define MEMORY_GRFX     4       /* multiple-plane GRAPHICS memory in use */
#define MEMORY_GRFX2    5       /* 2-color single-plane GRAPHICS memory in use */
#define MEMORY_GRFX256  6       /* 256-color single-plane GRAPHICS memory in use */

#define MEMMODE_TEXT    0       /* these are the memory modes described */
#define MEMMODE_FONT    1       /* in each of the RLE entries          */
#define MEMMODE_GRFX    2
#define MEMMODE_GRFX256 3
#define MEMMODE_STATES  4       /* and this is the total unique memory modes */


 /*
 ** Page states
 **
 **  These specify the state of individual pages which comprise a VDM's
 **  virtual memory.  For every plane of virtual video memory, there is an
 **  entry in an array (aapstate) containing one of these state values.
 **  Normally, the values found in that array will be consistent with the
 **  VDM's memory state (mstate), except for brief periods when the virtual
 **  buffer has not yet been converted (see vvUpdatePageStates for details).
 */

#define PAGE_NONE          0x00 /* page unaccessed -- no type          */
#define PAGE_TEXT          0x01 /* page contains text info             */
#define PAGE_FONT          0x02 /* page contains font info             */
#define PAGE_CGAX          0x03 /* page contains single-plane graphics info */
#define PAGE_GRFX          0x04 /* page contains graphics info         */
#define PAGE_GRFX256       0x06 /* page contains 256-color graphics info */
#define PAGE_TYPE          0x07 /* mask for data type bits             */
#define PAGE_PHYSICAL      0x08 /* page being emulated using physical VRAM */

#define PAGE_BLANK         0x10 /* page is blank (1st of the type modifiers) */
#define PAGE_INVRAM        0x20 /* page is currently in physical VRAM  */
#define PAGE_VIRTUAL       0x40 /* page is mapped to "virtual" VRAM memory */
#define PAGE_SHADOWINVALID 0x80 /* page shadow data is not valid       */

#define PAGE_VALID   (PAGE_TYPE|PAGE_PHYSICAL|PAGE_BLANK)

#define ALL_GRFX     (PAGE_GRFX    |PAGE_GRFX<<8    |PAGE_GRFX<<16    |PAGE_GRFX<<24)
#define ALL_GRFX256  (PAGE_GRFX256 |PAGE_GRFX256<<8 |PAGE_GRFX256<<16 |PAGE_GRFX256<<24)
#define ALL_BLANK    (PAGE_BLANK   |PAGE_BLANK<<8   |PAGE_BLANK<<16   |PAGE_BLANK<<24)
#define ALL_INVRAM   (PAGE_INVRAM  |PAGE_INVRAM<<8  |PAGE_INVRAM<<16  |PAGE_INVRAM<<24)
#define ALL_VIRTUAL  (PAGE_VIRTUAL |PAGE_VIRTUAL<<8 |PAGE_VIRTUAL<<16 |PAGE_VIRTUAL<<24)
#define ALL_VALID    (PAGE_VALID   |PAGE_VALID<<8   |PAGE_VALID<<16   |PAGE_VALID<<24)
#define ALL_PHYSICAL (PAGE_PHYSICAL|PAGE_PHYSICAL<<8|PAGE_PHYSICAL<<16|PAGE_PHYSICAL<<24)

#define PHYSPAGE_RESERVED  ((ULONG)-1)
#define PHYSPAGE_AVAILABLE 0
#define PHYSPAGE_ALLOCATED PAGESIZE


//c-begin

#define VDMOWNSPHYSPAGE(i) (ahPhysPage[i] > PHYSPAGE_ALLOCATED && ahPhysPage[i] != PHYSPAGE_RESERVED)
#define THISVDMOWNSPHYSPAGE(hvdm,i) (ahPhysPage[i] == (ULONG)(pVDMData(hvdm)->hvdmVideo))

//c-end


 /* Bank states
 **
 **            
 **
 **  These specify the state of banks which comprise a VDM's virtual memory
 **  when in linear graphics modes.
 */

#define BANK_NONE       0x00    // bank unaccessed
#define BANK_BLANK      0x01    // bank is blank
#define BANK_INVRAM     0x02    // bank is currently in physical VRAM
#define BANK_VIRTUAL    0x04    // bank is mapped to "virtual" VRAM memory
#define BANK_INVALID    0x08    // bank shadow data is not valid


 /*
 ** Controller owner definitions
 */

#define NO_OWNER           ((HVDM)0)
#define DISPLAY_OWNER      ((HVDM)1)
#define MISC_OWNER         ((HVDM)2)
#define MAXNONVDM_OWNER    MISC_OWNER

#define LOCKBUTDONOTBLOCK  2 /* don't block when controller is not locked             */

 /*
 ** Misc. definitions
 */

#define GROW_MAXIMUM    -1
#define ALL_PLANES      -1
#define INVALID_HVDM    ((HVDM)-2)


 /*
 ** ATC (Attribute Controller) states
 **
 **  These are the states that the ATC on an EGA/VGA can be in.  They have
 **  been selected not only because they are complementary, but also because
 **  they can be OR'ed with a index into the virtual ATC data (aregATCData),
 **  to produce a properly adjusted index (I rely on the fact that regATCIndx
 **  precedes aregATCData by 1 byte).
 */

#define ATC_DATA        0       /* ready for data byte                 */
#define ATC_INDEX       -1      /* ready for index byte                */


 /*
 ** DAC (Digital-to-Analog Color-lookup) states
 **
 **  These are the states that the DAC hardware on a VGA can be in.
 */

#define DAC_DATA0       0x0000  /* ready first 1st byte of data        */
#define DAC_DATA1       0x0001  /* ready first 2nd byte of data        */
#define DAC_DATA2       0x0002  /* ready first 3rd byte of data        */
#define DAC_DATAMASK    0x0003
#define DAC_READ        0x0300  /* read mode (high byte simulates state reg.) */
#define DAC_WRITE       0x0000  /* write mode (high byte simulates state reg.) */
#define DAC_RWMASK      0x0300


 /*
 ** Port flags (for use in xxx_port fields)
 */

#define PORT_MASK       0x00FFFF
#define PORTF_NOTRAP    0x010000/* no trapping for this port           */
#define PORTF_CHOOK     0x020000/* I/O hook is C-based                 */
#define PORTF_INDEXDATA 0x040000/* this port is both an index and data port */
#define PORTF_AUTOINC   0x080000/* this port's index register auto-increments */
#define PORTF_COLRMONO  0x100000/* the actual port address varies (see MISCOUT) */
#define PORTF_CRTCTRL   0x200000/* CRT controller port, may be write-protected */
#define PORTF_REQUIRED  0x400000/* port is required for MEMMODE reprogramming */
#define PORTF_SVGA      0x800000/* port is defined only on some SVGA adapters           */


 /*
 ** Hook-list constants
 */

#define HLE_NOHOOK      NULL    /* no hook for corresponding I/O operation */
#define HLE_END      (PFN)-1    /* end of entry within list            */
#define HLE_ENDPORT (PORT)-1    /* end of list                         */


 /*
 ** Port-list flags (for use in the ple_flxxx fields)
 */

#define PLE_RESETSEQ 0x00000001 /* sequencer must be reset before writing */
#define PLE_WAITVERT 0x00000001 /* wait for vertical retrace before writing */
#define PLE_WAITHORZ 0x00000001 /* wait for horizontal retrace before writing */


 /*
 ** Register-list flags (for use in the rle_fbCond field)
 */

#define REGCOND_RESETSEQ  0x01  /* sequencer must be reset before writing */
#define REGCOND_WAITVERT  0x02  /* wait for vertical retrace before writing */
#define REGCOND_WAITHORZ  0x04  /* wait for horizontal retrace before writing */
#define REGCOND_USEINDEX  0x08  /* setup the index register first                  */


 /*
 ** Register-list index values (for mode-specific pointer support)
 */

#define PTRMODE_NOPLANE -1      /* no reprogramming needed             */
#define PTRMODE_4PLANE   0      /* all planes enabled                  */
#define PTRMODE_1PLANE   1      /* only first plane enabled            */
#define PTRMODE_ODDPLANE 2      /* chained-plane mode                  */


 /*
 ** Pointer flags
 */

#define PTR_ACTIVE      0x0001  /* set if pointer drawing active       */
#define PTR_DRAWN       0x0002  /* set if pointer image currently on-screen */
#define PTR_INVERSE     0x0004  /* set if inverse image (use slow update code) */
#define PTR_HARDWARE    0x0008  /* set if hardware pointer enabled     */
#define PTR_PTRSAVE     0x0010  /* set if pointer save-area is valid   */
#define PTR_ODDEVEN     0x0020  /* set if 64k EGA mode in effect       */
#define PTR_BYTEPIXEL   0x0040  /* set if byte-pixel mode (mode 13h)   */
#define PTR_SUPPORTED   0x0080  /* set if video mode supported, clear if not */
#define PTR_LPENEM      0x1000  /* set if light-pen emulation enabled  */
#define PTR_HWDIRTY     0x2000  /* set if hardware cursor moved by app */
#define PTR_INTERNAL    0x8000  /* set if internal hide/show call in progress */
#define PTR_RESETMASK   (PTR_ACTIVE|PTR_INVERSE|PTR_HARDWARE|PTR_LPENEM|PTR_INTERNAL)


 /*
 ** Event flags (see VVD.H for the public POSTEVENT_* flags subset)
 **
 **  Note:  There is no internal equivalent to POSTEVENT_ADD because if
 **  we want to add an event, we simply call vvAddEvent;  otherwise,
 **  we call vvFlushEvent.
 **
 **  Also note:  The EVENT_OWNER flag could be removed now that we have new
 **  semaphore services that can nest requests, but I leave it in as an
 **  optimization.
 */

#define EVENT_FLUSH     POSTEVENT_FLUSH /* flush event immediately     */
#define EVENT_ASYNC     0x0008          /* asynchronous event          */
#define EVENT_OWNER     0x1000          /* caller owns EventUpdate semaphore */


 /*
 ** INT 10 Return Hook storage structure
 */

typedef struct int10_s {        /* INT 10 return hook storage       */  /*            */
    ULONG  reg_eax;             /* saved EAX or VVSTRING row        */  /*            */
    ULONG  reg_ebx;             /* saved EBX or VVSTRING col        */  /*            */
    ULONG  func_type;           /* function type or VVSTRING nChars */  /*            */
    ULONG  reg_saved;           /* 0 - didn't save regs below       */  /*            */
    ULONG  reg_ecx;             /* saved ECX                        */  /*            */
    ULONG  reg_edx;             /* saved EDX                        */  /*            */
    ULONG  reg_ebp;             /* saved EBP                        */  /*            */
    USHORT reg_es;              /* saved ES                         */  /*            */
    USHORT reg_ds;              /* saved DS                         */  /*            */
} VVINT10S;                                                             /*            */
typedef VVINT10S *NPVVINT10S;                                           /*            */
typedef VVINT10S FAR *PVVINT10S;                                        /*            */


 /*
 ** Private types
 **
 **  These state-types refer to sets of ordinal values representing
 **  various states.
 */

typedef INT   MSTATE;           /* for memory-state values   */
typedef BYTE  PSTATE;           /* for page-state values     */
typedef BYTE  BSTATE;           /* for bank-state values     */         /*            */

typedef LONG (PRIVENTRY *PSYSFUN)(HVDM, ULONG, PVOID, ULONG, PVOID);
typedef LONG (PRIVENTRY *PDEVFUN)(HVDM, BOOL);


 /*
 ** Hook-list entry
 **
 **  This is the header for hook-list entries, which list a port to trap (or
 **  not to trap, as the case may be) and associated I/O hooks to be installed,
 **  if any.
 */

typedef struct hle_s {          /* hle                                 */
    PORT  hle_port;             /* port # (and optional port flags)    */
    PFN   hle_pfn[1];           /* address of I/O trap handler, NULL if none */
} HLE;
typedef HLE *PHLE;              /* phle                                */


 /*
 ** Port-list entry
 **
 **  This is the structure for port-list entries, which list a port, a
 **  range of indexed registers accessible through the port (or in the case
 **  of 0 in ple_nRegs, a single non-indexed register), the address of the
 **  associated virtual register storage, and several flag words to specify
 **  any special conditions for the port/registers.
 **
 **  Note:
 **         The 'ple_flResetSeq' flags are not large enough to handle
 **         extended sequencers, such as used by Video7 chips, which
 **         set clock-specific registers. These registers have indices
 **         up to 0xff. The current fix is to check for them during
 **         vvRestoreIOState() and set the flag, not so pretty.
 */

typedef struct ple_s {          /* ple                                 */
    PORT  ple_port;             /* port # (and optional port flags)    */
    ULONG ple_nRegs;            /* number of registers (0 if non-indexed) */
    PBYTE ple_pregIndx;         /* location of virtual index register  */
    PBYTE ple_pregData;         /* location of virtual data register   */
    FLAGS ple_flResetSeq;       /* bits 0-31                           */
    FLAGS ple_flWaitVert;       /*   correspond to                     */
    FLAGS ple_flWaitHorz;       /*     registers 0-31 (see PLE_* constants) */
} PLE;
typedef PLE *PPLE;              /* pple                                */


 /*
 ** Register-list entry
 **
 **  This is the structure for register-list entries, which list a port, a
 **  register index, the address of the associated virtual register storage,
 **  values used to reprogram the register for standard memory access, and
 **  a flag byte to specify any special conditions for the register.
 */

 /*
 ** Options for vvSetIOState()
 */

#define SETIO_SHADOWED       -1 /* set registers to shadowed values    */
#define SETIO_LIMIT_SHADOWED -2 /* set selected bits in regs to shadowed values */

typedef struct rle_s {          /* rle                                 */
    PORT  rle_port;             /* port # (and optional port flags)    */
    CHAR  rle_indx;             /* starting reg index (-1 if non-indexed) */
    BYTE  rle_pad;
    BYTE  rle_fbCond;           /* (see REGCOND_* constants)           */
    BYTE  rle_fbMask;           /* contains bits that can be modified  */
    BYTE  rle_bMode[MEMMODE_STATES];
    PBYTE rle_pregIndx;         /* location of virtual index register  */
    PBYTE rle_pregData;         /* location of virtual data register   */
    PBYTE rle_pbExtShadowIndx;  /* pointer to external shadow indx, NULL if none */
    PBYTE rle_pbExtShadowData;  /* pointer to external shadow data, NULL if none */
} RLE;
typedef RLE *PRLE;              /* prle                                */


 /*
 ** DAC color register structure
 **
 **  This structure contains the 3x6 bits (total of 18 bits) that make up
 **  the DAC information for one color register.
 */

typedef struct dac_s {          /* dac                                 */
    BYTE  dac_bRed;
    BYTE  dac_bGreen;
    BYTE  dac_bBlue;
} DACREG;
typedef DACREG *PDACREG;        /* pdac                                */


 /*
 ** List entry structure
 **
 **  There is one such entry for each VDM (in the instance data structure),
 **  and a top-of-list pointer in the global data.  A VDM's list entry will
 **  be initialized and added to the list at VDM creation time, and will be
 **  pulled out of the list and inserted at the head whenever a synchronous
 **  video event has been posted for it.
 */

typedef struct lse_s {          /* lse                                 */
    HVDM   lse_hvdm;
    struct lse_s *lse_plseNext;
    struct lse_s *lse_plsePrevious;
} LSENTRY;
typedef LSENTRY *PLSENTRY;      /* plse                                */

 /*
 ** To add an entry at the HEAD of the
 ** list, use ADD/INSERTENTRY(hvdm, &lseHeadActive);
 */


//c-begin

#define ADDENTRY(hvdm,list) \
    pVDMData(hvdm)->lse##list.lse_hvdm = pVDMData(hvdm)->hvdmVideo; \
    INSERTENTRY(hvdm,list);

#define INSERTENTRY(hvdm,list) \
    if (!pVDMData(hvdm)->lse##list.lse_plsePrevious) { \
        pVDMData(hvdm)->lse##list.lse_plsePrevious = &lseHead##list; \
        pVDMData(hvdm)->lse##list.lse_plseNext = lseHead##list.lse_plseNext; \
        if (lseHead##list.lse_plseNext) \
            lseHead##list.lse_plseNext->lse_plsePrevious = \
                &pVDMData(pVDMData(hvdm)->hvdmVideo)->lse##list; \
        lseHead##list.lse_plseNext = &pVDMData(pVDMData(hvdm)->hvdmVideo)->lse##list; \
    }

#define REMOVEENTRY(hvdm,list) \
    if (pVDMData(hvdm)->lse##list.lse_plsePrevious) { \
        pVDMData(hvdm)->lse##list.lse_plsePrevious->lse_plseNext = \
            pVDMData(hvdm)->lse##list.lse_plseNext; \
        if (pVDMData(hvdm)->lse##list.lse_plseNext) \
            pVDMData(hvdm)->lse##list.lse_plseNext->lse_plsePrevious = \
            pVDMData(hvdm)->lse##list.lse_plsePrevious; \
        pVDMData(hvdm)->lse##list.lse_plsePrevious = NULL; \
    }

#define FIRSTENTRY(hvdm,list) \
    (pVDMData(hvdm)->lse##list.lse_plsePrevious == &lseHead##list)

//c-end


//c-begin

 /*
 **   The following macros allow me to dynamically allocate/free context
 **   hooks easily, with an arbitrary amount of storage.  It does so by
 **   redefining the hhook variable as a pointer to the reference data, and
 **   stuffing what the kernel considers the hook handle into the first dword
 **   of the reference data.  Since HHOOK is the same as PVOID, the context
 **   hook itself can also be written as if it received a hook handle.
 **
 **    fnRandom()
 **    {
 **      if (ALLOCHOOK(pfnContext, 2, hhook, t)) {
 **          HOOKDATA(hhook, 0) = TRUE;          ** set first ULONG     **
 **          HOOKDATA(hhook, 1) = FALSE;         ** set second ULONG    **
 **      }
 **    }
 **
 **    fnContext(hhook, pcrf)
 **    {
 **      if (HOOKDATA(hhook, 0) == TRUE)
 **         ...
 **      FREEHOOK(hhook);
 **    }
 */

#define ALLOCHOOK(pfn,nul,hh,t) ( \
          (hh = VDHAllocHook(VDH_CONTEXT_HOOK, \
                             pfn, sizeof(HHOOK)+nul*sizeof(ULONG))) \
         && \
          ((PVOID)t = VDHQueryHookData(hh)) \
         && \
          (*(HHOOK *)t = hh) \
         && \
          (hh = (HHOOK)t) )

#define ARMHOOK(hh,hvdm) VDHArmContextHook(*(HHOOK *)hh, hvdm)

#define HOOKDATA(hh,i)  *(PULONG)((ULONG)hh+sizeof(HHOOK)+i*sizeof(ULONG))

#define FREEHOOK(hh)    VDHFreeHook(*(HHOOK *)hh)

//c-end


 /*
 **    Values for VVCheckForEvents flag
 */

#define PERIODIC_TIMER      1   /* indicates periodic call from timer hook    */
#define PERIODIC_KBDPEEK    2   /* indicates periodic call from kbd peek hook */
#define PERIODIC_KBDREAD    3   /* indicates periodic call from kbd read hook */

 /*
 ** Semaphore prototype macros
 */

typedef HVDHSEM HEVSEM;
typedef HVDHSEM HMXSEM;

//c-begin

#define CreateEventSem(phev) \
            VDHCreateSem(phev, VDH_EVENTSEM)
#define DestroyEventSem(hev) \
            VDHDestroySem(hev)
#define ResetEventSem(hev) \
            VDHResetEventSem(hev)
#define PostEventSem(hev) \
            VDHPostEventSem(hev)
#define WaitEventSem(hev) \
            VDHWaitEventSem(hev, SEM_INDEFINITE_WAIT)
#define CreateMutexSem(phmx) \
            VDHCreateSem(phmx, VDH_MUTEXSEM)
#define DestroyMutexSem(hmx) \
            VDHDestroySem(hmx)
#define RequestMutexSem(hmx) \
            VDHRequestMutexSem(hmx, SEM_INDEFINITE_WAIT)
#define ReleaseMutexSem(hmx) \
            VDHReleaseMutexSem(hmx)

//c-end


 /*
 ** Pointer support
 **
 **  When we remove or redraw the pointer ourselves, as part of switching
 **  background/foreground, we inc/dec fPtrFrozen to disable/enable pointer
 **  drawing at interrupt-time.
 **
 **  vmssVideo is updated by vvUpdateScreenState, if so requested.  The mouse
 **  driver is notified once the update is complete.
 **
 **  xPtr and yPtr contain the coordinates of the current pointer image;  the
 **  units are mode-dependent (ie, cells or pixels) to facilitate checks for
 **  pointer image motion.
 **
 **  ausGraphMasks records the last pointer shape received by VVDefinePtr
 **  via VMD.  See VVPTR.C for a description of the how ausPtrShape is defined.
 */

typedef struct ptrdata_s {      /* beginning of PTRDATA structure      */

FLAGS   flPtrVideo;             /* pointer flags                       */

BOOL    fPtrFrozenVideo;        /* TRUE to disable show/hide (internal */
                                /* draw/erase interfaces are still functional) */

VMSSIZE vmssVideo;              /* current display mode data (for mouse) */

VMSTAT  vmstatVideo;            /* last queried mouse status           */

ULONG   xPtrVideo;              /* current pointer position            */
ULONG   yPtrVideo;              /* (updated with new pos. by vvPtrDraw) */

ULONG   xCell;                  /* converted current pointer position  */
ULONG   yCell;                  /* (ie, mode-dependent units)          */

ULONG   ulPtrPage;              /* video page # to contain pointer     */

INT     iPtrMode;               /* ptr mode index (for arlePtrState), -1 if none */

PFN     pfnPutImage;            /* offsets of                          */
PFN     pfnMoveMasks;           /*  appropriate transfer routines      */

ULONG   nBitsRotate;            /* bits of rotation                    */

ULONG   xCorner;                /* upper-left corner of position       */
ULONG   yCorner;                /*  to mask in pointer (ie, hot-spot adjusted) */

ULONG   xCornerPrev;            /* upper-left corner of previous       */
ULONG   yCornerPrev;            /*  pointer location                   */

ULONG   offScrBuff;             /* screen offset of (xScrBuff, yScrBuff) */

ULONG   xScrBuff;               /* screen coords of                    */
ULONG   yScrBuff;               /*  upper-left of screen-save buffer   */

ULONG   htScrBuff;              /* current height, changes each redraw */

ULONG   offPtrSave;             /* offset of pointer-save buffer       */
ULONG   offScrSave;             /* offset of screen-save buffer        */

ULONG   ulTextScrSave;          /* save area for screen data under text image */

#ifdef  GALE                                                            //J-TS00V
ULONG   ulTextCharType;         // type of saved char SBCS/DBCS 1st/DBCS 2nd    //J-TS00V
BYTE    abPtrSaveGale[19*4*2];  // bitmapped text image save area       //J-TS00V
#endif  //GALE                                                          //J-TS00V

ULONG   ulTextANDMaskVideo;     /* also called the screen mask         */
ULONG   ulTextXORMaskVideo;     /* also called the pointer mask        */

ULONG   xHotVideo;              /* graphics pointer hot-spot           */
ULONG   yHotVideo;

BYTE    abANDMask[PTRSAVSIZE];
BYTE    abXORMask[PTRSAVSIZE];

BYTE    abPtrSave1[PTRSAVSIZE];
BYTE    abPtrSave2[PTRSAVSIZE];

BYTE    abScrSave1[SCRSAVSIZE];
BYTE    abScrSave2[SCRSAVSIZE];

} PTRDATA;                      /* end of PTRDATA structure            */

#ifdef  GALE                                                            //J-TS00V
/***LT+ VIO Mode Data tables */                                         //J-TS00V
typedef struct VIOMode_s {                                              //J-TS00V
USHORT mode_cb;                                                         //J-TS00V
UCHAR  mode_fbType;                                                     //J-TS00V
UCHAR  mode_color;                                                      //J-TS00V
USHORT mode_col;                                                        //J-TS00V
USHORT mode_row;                                                        //J-TS00V
USHORT mode_hres;                                                       //J-TS00V
USHORT mode_vres;                                                       //J-TS00V
UCHAR  mode_FormatID;                                                   //J-TS00V
UCHAR  mode_attrib;                                                     //J-TS00V
} VIOMODEDATA;                                                          //J-TS00V
                                                                        //J-TS00V
typedef struct ModeDataTable_s  {                                       //J-TS00V
BYTE         ModeNumber;                                                //J-TS00V
VIOMODEDATA  ModeData;                                                  //J-TS00V
} MODEDATATABLE;                                                        //J-TS00V
                                                                        //J-TS00V
#ifdef  VTEXT                                                           //J-TS00V
typedef struct VtextModeTable_s {                                       //J-TS00V
UCHAR   ExtModeNum;                                                     //J-TS00V
UCHAR   ExtModeInfo;                                                    //J-TS00V
UCHAR   ExtModeCols;                                                    //J-TS00V
UCHAR   ExtModeRows;                                                    //J-TS00V
UCHAR   ExtModeCelWidth;                                                //J-TS00V
UCHAR   ExtModeCelHeight;                                               //J-TS00V
UCHAR   ExtModeFontWidth;                                               //J-TS00V
UCHAR   ExtModeFontHeight;                                              //J-TS00V
USHORT  ExtModeHorzResolution;                                          //J-TS00V
USHORT  ExtModeVertResolution;                                          //J-TS00V
UCHAR   ExtModeReserved[4];                                             //J-TS00V
} VTEXTMODETABLE;                                                       //J-TS00V
typedef VTEXTMODETABLE *PVTEXTMODETABLE;                                //J-TS00V
                                                                        //J-TS00V
typedef struct VtextExtParam_s {                                        //J-TS00V
UCHAR   ExtDrvMajorVersion;                                             //J-TS00V
UCHAR   ExtDrvMinorVersion;                                             //J-TS00V
USHORT  PtrPrimFuncTable;                                               //J-TS00V
USHORT  PtrVideoModeTable;                                              //J-TS00V
USHORT  CntModeTable;                                                   //J-TS00V
USHORT  PtrExtDrvString;                                                //J-TS00V
} VTEXTEXTPARAM;                                                        //J-TS00V
typedef VTEXTEXTPARAM *PVTEXTEXTPARAM;                                  //J-TS00V
                                                                        //J-TS00V
typedef struct VtextExtInfo_s {                                         //J-TS00V
UCHAR          $DispMajorVersion;                                       //J-TS00V
UCHAR          $DispMinorVersion;                                       //J-TS00V
USHORT         VideoExtState;                                           //J-TS00V
USHORT         SegTextBuffer;                                           //J-TS00V
USHORT         SizeTextBuffer;                                          //J-TS00V
USHORT         ExtDrvParamOff;                                          //J-TS00V
USHORT         ExtDrvParamSeg;                                          //J-TS00V
USHORT         LockCnounter;                                            //J-TS00V
ULONG          OrgInt10Entry;                                           //J-TS00V
USHORT         PtrFontQuality;                                          //J-TS00V
USHORT         PtrTextDensity;                                          //J-TS00V
USHORT         PtrPaletteSave;                                          //J-TS00V
UCHAR          CurrentModeIndex;                                        //J-TS00V
} VTEXTEXTINFO;                                                         //J-TS00V
typedef VTEXTEXTINFO *PVTEXTEXTINFO;                                    //J-TS00V
                                                                        //J-TS00V
#define VTEXT_EXT_STATE_REGISTERED  0x01    /* ext driver installed. */ //J-TS00V
#define VTEXT_EXT_STATE_ACVITE      0x02    /* ext mode activated. */   //J-TS00V
                                                                        //J-TS00V
#endif  //VTEXT                                                         //J-TS00V
                                                                        //J-TS00V
typedef struct GaleCursor_s {                                           //J-TS00V
USHORT  GaleCurPos;             // cursor position                      //J-TS00V
USHORT  GaleCurMode;            // cursor type                          //J-TS00V
FLAGS   GaleCurDisp;            // cursor display ON/OFF flag           //J-TS00V
} GALECURSOR;                                                           //J-TS00V
                                                                        //J-TS00V
typedef struct Int2FStack_s {                                           //J-TS0827
ULONG   EventCnt;                                                       //J-TS0827
ULONG   LastEvent;                                                      //J-TS0827
BOOL    flProcessing;                                                   //J-TS0827
} INT2FSTACK;                                                           //J-TS0827
                                                                        //J-TS0827
typedef struct GaleData_s {                                             //J-TS00V
PBYTE      GaleLVB;             // LVB (User shadow buffer)             //J-TS00V
PBYTE      GaleSBCS;            // SBCS font buffer in Gale             //J-TS00V
ULONG      GaleDBCSInpEnv;      // DBCS input environment               //J-TS00V
FLAGS      GaleInternalAccess;  // screen access mode                   //J-TS00V
PBYTE      GaleLPTWork;         // APA data for VLPT                    //J-TS00V
GALECURSOR GaleCursor;          // cursor attribute                     //J-TS00V
FLAGS      flGaleFlags;         // Gale unique flags                    //J-TS0331
#ifdef     VTEXT                                                        //J-TS00V
FLAGS      flVtext;             // flags to support VTEXT               //J-TS00V
HHOOK      hhookVtextReturn;    // hook handle for Int 10h & 15h        //J-TS00V
HHOOK      hhookVtextHook;      // hook handle for post $DISP.SYS       //J-TS00V
HHOOK      hhookVtextPreHook;   // hook handle for pre $DISP.SYS        //J-TS00V
HHOOK      hhookVtextRedrawReturn;  // return hook for redraw screen    //J-TS00V
HHOOK      hhookVextPtrContext; // context hook for ptr draw            //J-TS00V
HHOOK      hhookVextPtrReturn;  // return hook for ptr draw             //J-TS00V
VPVOID     pBreakPointAddr;     // BP address                           //J-TS00V
PBYTE      pVtextLVB;           // LVB addr in $DISP.SYS                //J-TS00V
PBYTE      pVtextPVB;           // memory to be mapped as video buff    //J-TS00V
PVTEXTEXTINFO pVtextExtInfo;    // Vtext extension mode infomation      //J-TS00V
#ifdef  SVGA                                                            //J-TS00V
                                // Following registers are specially    //J-TS00V
                                // shadowed to enable the installation  //J-TS00V
                                // of VTEXT driver in windowed VDM.     //J-TS00V
UCHAR      S3RegLock2;          // shadow of S3 lock reg.               //J-TS00V
UCHAR      TsengExtStartAddr;   // shadow of tseng ext. start addr reg. //J-TS0818
#endif  //SVGA                                                          //J-TS00V
#endif  //VTEXT                                                         //J-TS00V
INT2FSTACK Int2FStack;          // INT 2F notify request controler      //J-TS0827
} GALEDATA;                                                             //J-TS00V
                                                                        //J-TS00V
/***LK+ Per-VDM flGaleFlags                                             //J-TS0331
 */                                                                     //J-TS0331
#define VDMV_GALE_VESA_SET_MODE    0x00000001  // In VESA Set Mode      //J-TS0331
                                                                        //J-TS00V
#ifdef  VTEXT                                                           //J-TS00V
/***LK+ Per-VDM VTEXT Flags                                             //J-TS00V
 */                                                                     //J-TS00V
#define VDMV_VTEXT_INSTALLED        0x00000001  // $DISP is installed   //J-TS00V
#define VDMV_VTEXT_INITIALIZING     0x00000002  // $DISP is initializing//J-TS00V
#define VDMV_PROCESSED_BY_MYSELF    0x00000004  // INT 15H is proc by me//J-TS00V
#define VDMV_SUPPORTED_TEXT_MODE    0x00000008  // Known text mode      //J-TS00V
#define VDMV_GET_LVB                0x00000010  // GET_LVB indicator    //J-TS00V
#define VDMV_CHECK_VTEXT            0x00000020  // check $DISP indicator//J-TS00V
#define VDMV_GET_EXT_INFO           0x00000040  // get ext info indictr //J-TS00V
#define VDMV_VTEXT_CALLING          0x00000080  // $DISP is calling     //J-TS00V
#define VDMV_CURSOR_UPDATED         0x00000100  // cursor updated       //J-TS00V
#define VDMV_LVB_UPDATED            0x00000200  // LVB updated          //J-TS00V
#define VDMV_DELAYED_REDRAW_SCREEN  0x00001000  // redraw scrn is posted//J-TS00V
#define VDMV_DELAYED_UPDATE_FLAG    0x00002000  // update dflg is posted//J-TS00V
#define VDMV_PTR_REQUEST_DRAW       0x00010000  // mou ptr draw req     //J-TS00V
#define VDMV_PTR_REQUEST_UPDATE     0x00020000  // mou ptr update req   //J-TS00V
#define VDMV_PTR_REQUEST_ERASE      0x00040000  // mou ptr erase req    //J-TS00V
#define VDMV_PTR_CONTEXT_HOOK       0x00100000  // mou ptr cntxt hook   //J-TS00V
#define VDMV_PTR_V86_EXECUTING      0x00200000  // mou ptr in V86 mode  //J-TS00V
#define VDMV_PTR_REQ_ERASE_SP1      0x00400000  // special erase req 1  //J-TS00V
#define VDMV_PTR_REQ_ERASE_SP2      0x00800000  // special erase req 2  //J-TS00V
#define VDMV_REDRAW_SCREEN          0x01000000  // redraw screen req.   //J-TS00V
#define VDMV_REDRAW_AGAIN           0x02000000  // redraw screen req. 2 //J-TS00V
#endif  //VTEXT                                                         //J-TS00V
                                                                        //J-TS00V
#endif  //GALE                                                          //J-TS00V
                                                                        //J-TS00V
#ifdef  XVIO                                                            //J-TS00V
typedef struct xviodata_s {     // beginning of XVIODATA structure      //J-TS00V
PBYTE       GaleXVIOLVB;        // 2nd LVB for XVIO                     //J-TS00V
VXMODE      vxMode;             // mode data                            //J-TS00V
VXCURSOR    vxCursor;           // cursor data                          //J-TS00V
VXCURSOR    vxCursorPrev;       // previously reported cursor data      //J-TS00V
VXWSTR      vxWStr;             // write string data                    //J-TS00V
PBYTE apPlaneXVIO[MAX_PLANES];  // pointer(s) to saved screen buffers.  //J-TS00V
ULONG anpgPlaneXVIO[MAX_PLANES];// size(s) for each of the above buffs. //J-TS00V
} XVIODATA;                     // end of XVIODATA structure            //J-TS00V
#endif  //XVIO                                                          //J-TS00V

typedef struct vdmdatax_s{      /* PERVDMDATA extension                            */
ULONG   nDiffPrev;              /* # of differences reported last LVB event */
CHAR    DACreg[4];              /* save contents of DAC                            */
} VDMDATAX;                     /* end of PERVDMDATA extension struct              */

typedef struct vdmdata_s { /* beginning of PERVDMDATA structure        */

 /*
 ** Per-VDM data
 **
 **  In flVDM, the OWNER bit indicates whether or not this VVD is actively
 **  responsible for the associated display.  If another VVD "requests" control
 **  away from us, the OWNER bit is cleared until we are "requested" to regain
 **  control.  For the interim, all I/O and page-fault hooks are undone, as are
 **  all VRAM mappings.
 **
 **  ioh is simply some scratch storage that we use to install/deinstall all
 **  our I/O hooks;  for security, the VDH services require that the caller
 **  supply the same address to VDHSetIOHookState and VDHDeInstallIOHook that
 **  it supplied to VDHInstallIOHook.
 **
 **  mstateCopy records the last state selected by vvSetCopyState, and is an
 **  optimization;  it allows vvSetCopyState to ignore a request for a state
 **  already in effect, and it is cleared by vvRestoreCopyState.
 */

FLAGS   flVDMVideo;             /* per-VDM flags                       */
FLAGS   flVDMXVideo;            /* extended per-VDM flags              */
FLAGS   flVDMX2Video;           /* extended per-VDM flags              */

HVDM    hvdmVideo;              /* handle for this VDM                 */

ULONG   sgIDVideo;              /* screen group # for this VDM         */

IOH     iohVideo;               /* scratch ioh                         */

MSTATE  mstateCopy;             /* currently selected copy-state       */

ULONG   ulBIOSMode;             /* last BIOS mode # set                */

HMXSEM  hmxVideoState;          /* semaphore for internal state protection */
HMXSEM  hmxWindowedState;
HEVSEM  hevFreezeThaw;          /* set on freeze, cleared on thaw      */
#ifdef SVGA                     /*            */
HEVSEM  hevInt2FDelaySwitch;    /* set on vvBgndContext to delay BGND switch for 2F processing */
HEVSEM  hev8514WakeUp;          /* 8514 IO semaphore                   */
HEVSEM  hev8514Busy;            /* 8514 engine busy sem                */

#endif
HHOOK   hhookFgndContext;       /* hook handle for VVFgndContext       */
HHOOK   hhookBgndContext;       /* hook handle for VVBgndContext       */
HHOOK   hhookInitContext;       /* hook handle for VVInitContext       */
HHOOK   hhookUpdatePtrContext;  /* hook handle for VVUpdatePtrContext  */
#ifdef EGAVGA
HHOOK   hhookUpdateContext;     /* hook handle for VVUpdateContext     */
HHOOK   hhookUpdatePhysContext; /* hook handle for VVUpdatePhysContext */
HHOOK   hhookUnMapPhysContext;  /* hook handle for VVUnMapPhysContext             */
#endif
HHOOK   hhookInt10SetModeReturn;/* hook handle for VVInt10SetModeReturn */
HHOOK   hhookInt10Return;       /* hook handle for VVInt10Return       */
HHOOK   hhookInt2FReturn;       /* hook handle for VVInt2FReturn       */
PVOID   pInt10ReturnData;
BOOL    flV86mode;              /* VPM mode flag                       */
ULONG   nInt10Setmode;/* # of recursive int 10 setmode calls            */
PTRDATA PtrData;                /* pointer data                        */


 /*
 ** Virtual/shadow hardware information (modified)
 **
 **  pvdmPhysVRAMActive is starting address of active VRAM.  On an EGA/VGA,
 **  active VRAM is the region of physical addresses that VRAM is/should be
 **  currently responding to.  This region always lies somewhere within
 **  the pvdmPhysVRAM region, and is controlled by REG_GDCMISC.
 **
 **  npgPhysVRAMActive is the length (in pages) of the active VRAM region.
 **  On supported adapters, the active region can only be at one of a handful
 **  of locations (A0000, B0000 or B8000), and is always a whole number of
 **  pages.
 **
 **  pvdmPhysVRAMVisible is the area WITHIN pvdmPhysVRAMActive that's currently
 **  visible.  This is important for clipboard requests, pointer support, etc.
 **
 **  nbPhysVRAMVisible is the length of the visible active VRAM region, in
 **  bytes.  nbVRAMRow is the length of a row (cells or pixels, depending on
 **  the video mode), also in bytes.  offVRAMOddEven is the offset between
 **  even and odd scan lines;  normally, they are sequential and so this value
 **  is zero, but for CGA graphics modes, it will be 8192 (8kb).  Finally,
 **  nBitsPerPlane is the number bits in a single plane that encode the color
 **  of one pixel on the screen; it is only a count of bits within a plane, not
 **  across planes, and the total number of bits per pixel should be
 **  calculated as (nBitsPerPixel * nPlanes) -- although in every CGA/EGA/VGA
 **  mode, one of those values is always 1.
 **
 **  mstate is the VDM's current memory state.  It may not match the true
 **  hardware state at any instant for a foreground VDM undergoing limited
 **  trapping, but in those cases we use vvUpdateVideoState to "refresh" our
 **  understanding of the current state.
 */

VVMODE  vvMode;                 /* current mode information            */
VVCURSOR vvCursor;              /* current cursor information          */

ULONG   nbVRAMRow;              /* width of a scan line, in bytes      */
ULONG   offOddBank;             /* offset between odd/even rows, in bytes */
ULONG   nBitsPixel;             /* bits per pixel (within each plane)  */
ULONG   nPixelsByte;            /* pixels ber byte (within each plane) */
ULONG   nPlanes;                /* number of active planes             */

PBVDM   pvdmPhysVRAMActive;     /* address of VDM's active VRAM, which is */
                                /* a subset of physical VRAM (pvdmPhysVRAM) */

ULONG   offPhysVRAMActive;      /* offset of active VRAM, relative to both */
                                /* pvdmPhysVRAM & pPhysVRAM            */

ULONG   npgPhysVRAMActive;      /* # of pages in active VRAM           */
                                /* this is a subset of pvdmPhysVRAM    */

PBVDM   pvdmPhysVRAMVisible;    /* address of VDM's active/visible VRAM */
                                /* this is a subset of pvdmPhysVRAMActive */

ULONG   offPhysVRAMVisible;     /* offset of visible VRAM, relative to */
                                /* pvdmPhysVRAMActive                  */

ULONG   nbPhysVRAMVisible;      /* # of bytes in active/visible VRAM   */
                                /* this is a subset of pvdmPhysVRAMActive */

MSTATE  mstateVideo;            /* VDM memory state (TEXT, FONT, GRFX, ...) */


 /*
 ** Virtual buffer management
 **
 **  What is referred throughout the VVD as the "virtual buffer" is
 **  actually 1 or more "plane" buffers.
 **
 **  If a VDM is MEMORY_TEXT, apPlane[0] will point to a plane buffer
 **  containing the VDM's text information, and appropriate entries in
 **  aapstate[0..m][0] will be set to PAGE_TEXT;  apPlane[2] will point to
 **  a buffer containing the VDM's font information, and entries in
 **  aapstate[0..n][2] will be set to PAGE_FONT;  apPlane[1] and
 **  apPlane[3] will generally either point to buffers whose individual page
 **  states are NONE, or point to nothing (ie, not even allocated).
 **
 **  When a VDM is MEMORY_FONT, the same basic set of assumptions
 **  applies (ie, we treat this like a text-mode configuration to avoid
 **  freezing VDMs when they are loading fonts).
 **
 **  Finally, when a VDM is MEMORY_GRFX, each plane buffer simply contains the
 **  contents for the associated plane and aapstate[0..n][x] will be set to
 **  PAGE_GRFX.  When a VDM switches from a MEMORY_TEXT mode to a MEMORY_GRFX
 **  mode, the virtual buffer format is converted:  all pages containing
 **  PAGE_TEXT information are converted to appropriate pages of PAGE_GRFX
 **  information, since character data is really only the even bytes in plane
 **  0 and attributes all the even bytes in plane 1, meaning that for pages in
 **  the TEXT state, we only have partial graphics information for planes 0 and
 **  1 (ie, the EVEN bytes), none at all for plane 3, and some limited amount
 **  for plane 2 (this is where the VDM's font(s) are stored).  The conversion
 **  step rounds out this limited information, promoting the appropriate pages
 **  to GRFX status.
 **
 **  When a foreground VDM is created, a virtual buffer of size (nPlanes *
 **  npgPlane * PAGESIZE) is allocated.  After the first SetFgnd call, the
 **  VDM's entire VRAM address range becomes invalidated, since we have
 **  no valid data at this time.  The screen may have already been cleared by
 **  the Session Manager, but only insofar as the video signal is concerned;
 **  underneath, the contents of the last foreground screen group remain in
 **  place.  As soon as the VDM begins running, it will perform an Int 10h
 **  that we initiated (see VVCreate), which in turn will initialize all of the
 **  VDM's active VRAM (generally the 32kb from B8000h-BFFFFh).  We trap that
 **  initialization page-by-page, first verifying that a virtual page is
 **  available (which it must be for a foreground VDM), and then exchanging
 **  the page with physical memory;  the state for a such a page becomes
 **  PAGE_TEXT.  When it touches a page in the A0000h-AFFFFh range and the
 **  range is active and the mode is MEMORY_FONT, we follow a similar validation
 **  process, but for the plane 2 portion of the virtual buffer;  the state of
 **  the associated page becomes PAGE_FONT.  And so on....
 **
 **  Later, when the foreground VDM is switched into background, we update
 **  the VDM's state, exchange all valid pages, thereby restoring the previous
 **  screen group's contents, and then map all valid virtual pages into the
 **  VDM's VRAM address space.  A context hook is also established to shrink the
 **  virtual buffer down to some smaller size.
 **
 **             SVGA: Added an extra array dimension to apPlane, anpgPlane and
 **                   aapstate to allow more virtual memory to be handled.
 **                   Using up to 4 banks together with the current
 **                   structures, up to 1Meg of memory is kept track of.  Note
 **                   that putting the new BANK index first allows the
 **                   structure to be consistent with its old definition when
 **                   setting an index of zero (this courtesy of the way 'C'
 **                   stores arrays).  In linear modes, banks together with
 **                   planes give up to 16 pieces of 64k memory (16 pages).
 **                   The concept of planes then falls away and the
 **                   combination keeps track of all the memory.
 **
 **             SVGA: Change linear-mode virtual buffer management to 64k (bank)
 **                   granular. Now keep a single pointer to a buffer for linear
 **                   modes and a state array (as per aapstate) on a bank basis.
 **                   This allows simpler virtualisation, more efficient save
 **                   and restore of physical VRAM and bitmap copying.
 **
 */

ULONG   ulLinearPages;          /* no of pages                                */
PBYTE   pLinearBuffer;          /* virtual buffer for linear modes            */

PBYTE   apPlane[MAX_BANKS][MAX_PLANES];    /* pointer(s) to virtual memory buffers */
ULONG   anpgPlane[MAX_BANKS][MAX_PLANES];  /* size(s) for each of the above buffers */

PBYTE   pShadowPlane;           /* shadow buffer (for single-plane graphics) */
ULONG   npgShadowPlane;

PBYTE   pBonusBuffer;           /* buffer for CGA/MONO restriction     */
ULONG   npgBonusBuffer;         /* NOTE: unlike apPlane and pShadowPlane, */
                                /* this is per-VDM memory (freed automatically) */

VPVOID  vpOldStack;             /* original VDM stack (if we had to switch) */
PBVDM   pvdmAltStack;           /* alternate stack we can switch to, if needed */

                                /* page states (NONE, TEXT, FONT, etc) */
                                /* SVGA add 3rd dimension                         */

//c-begin

PSTATE  aapstate[MAX_BANKS][MAX_PAGESPERPLANE][MAX_PLANES];

//c-end


//masm-begin

//PSTATE        aapstate,,MAX_BANKS*MAX_PAGESPERPLANE*MAX_PLANES

//masm-end

                                /* bank-based states (64k granular aapstate[])*/
BSTATE  abstate[MAX_BANKS*MAX_PLANES];                          /*            */

 /*
 ** for a given PAGE_PHYSICAL video page index,
 ** the corresponding entry in aiVirtToPhys
 ** contains an index into ahPhysPage
 */

ULONG   aiVirtToPhys[MAX_PAGESPERPLANE];

ULONG   aoffPhysDiff[MAX_PAGESPERPLANE];
ULONG   anbPhysDiff[MAX_PAGESPERPLANE];

MSTATE  mstateBuffer;           /* memory state of buffer (not the VDM!) */

FLAGS   flDirtyPages;           /* dirty page info accumulator         */

ULONG   ulDirtyBankEvent;       /* dirty bank number for 256-colour mode            */

 /*
 ** VDHMapPages data structures
 */

ULONG   ulMapCur[VRAM_PAGES];   /* Current VRAM contents               */
VDHMAPTARGET avdhmt[VRAM_PAGES];/* VRAM map targets                    */
VDHMAPSOURCE vdhms;             /* VDH map source descriptor           */
#ifdef VGA
VDHMAPTARGET vdhmt;                                                     /*            */
#endif


 /*
 ** Window support data
 */

ULONG   pidVideo;               /* PID of exclusive access owner, if any */

LSENTRY lseActive;              /* Active list entry for this VDM      */

FLAGS   flEventsPending;        /* event ordinals 1 through n are      */
FLAGS   flEventsHolding;        /* represented by bits 0 through n-1   */
FLAGS   flEventsFlushing;

ULONG   nPeriodic;              /* periodic counter                    */
ULONG   nPeriodicLimit;         /* threshold required                  */
ULONG   nPeeks;                 /* peek counter                        */

HEVSEM  hevShieldSynced;        /* synchronizes windowed VDM with Shield */

VVMODE   vvModeEvent;           /* next mode event to process          */
VVSCROLL vvScrollEvent;         /* next scroll event to process        */
VVSTRING vvStringEvent;         /* next string event to process        */
VVCURSOR vvCursorEvent;         /* next cursor event to process        */
VVCURSOR vvInputEvent;          /* location where next input request made */
FLAGS    flDirtyPageEvent;      /* last dirty pages reported           */

ULONG   nPhysPages;             /* # of PHYSPAGES owned by this VDM    */

//ULONG   nDiffPrev;            /* # of differences reported last LVB event */
//                              /* above field moved to VDMDATA extension            */
VDMDATAX VdmDataX;              /* VDMDATA extension                                 */
RECTL   rclDiffPrev;            /* if nDiffPrev == 1, rclDiffPrev == difference */

CHAR    szVDMTitle[MAX_TITLESIZE];
USHORT  fDDEflag;               /* Set/Clear DDE flag                                */


 /*
 ** Virtual/shadow hardware information
 **
 **  This storage is dedicated to saving I/O state information.  This is
 **  put at the end of the instance data structure because much of it is byte-
 **  oriented, and would tend to       up the dword-alignment of everything
 **  above without explicit padding.
 */

#ifdef MONOCGA
BYTE    regMode;                /* shadows PORT_MONOMODE/CGAMODE       */
#endif

#ifdef CGA
BYTE    regColor;               /* shadows PORT_CGACOLOR               */
#endif

BYTE    regCRTIndx;             /* shadows PORT_MONOCRTINDX/COLRCRTINDX */
BYTE   aregCRTData[MAX_CRTREGS];/* shadows PORT_MONOCTRDATA/COLRCRTDATA[] */
INT     stateStatus1;           /* state of STATUS1 register           */
                                /* (see abNextStatusState)             */
#ifdef EGAVGA
BYTE    regFeature;             /* shadows PORT_MONOFEATURE/COLRFEATURE */
BYTE    regMiscOut;             /* shadows PORT_MISCOUT                */
BYTE    regATCIndx;             /* shadows PORT_ATC0                   */
BYTE   aregATCData[MAX_ATCREGS];/* shadows PORT_ATC1[MAX_ATCREGS]      */
BYTE    regSEQIndx;             /* shadows PORT_SEQINDX                */
BYTE   aregSEQData[MAX_SEQREGS];/* shadows PORT_SEQDATA[MAX_SEQREGS]   */
BYTE    regGDCPos1;             /* shadows PORT_GDCPOS1                */
BYTE    regGDCPos2;             /* shadows PORT_GDCPOS2                */
BYTE    regGDCIndx;             /* shadows PORT_GDCINDX                */
BYTE   aregGDCData[MAX_GDCREGS];/* shadows PORT_GDCDATA[MAX_GDCREGS]   */
INT     stateATC;               /* state of ATC controller             */
#endif

#ifdef VGA
BYTE    regDACMask;             /* shadows PORT_VGADACMASK             */
BYTE    regDACIndx;             /* shadows PORT_VGADACREAD/VGADACWRITE */
DACREG adacDACData[MAX_DACREGS];/* shadows PORT_VGADACDATA[MAX_DACREGS] */
DACREG  dacDACDataCur;          /* current DAC data register           */
INT     stateDAC;               /* state of VGA's DAC                  */
#endif

#ifdef SVGA                     /*                                     */

BOOL    flBgndExecEnabled;      /*            */
ULONG   ulLogicalBytes;         /*            */
ULONG   ulregLockState;         /*            bit-mask of lock commands state */
                                

BYTE    aregXGAData[AXGA_TOTAL];/* XGA Compatible registers                          */

BYTE    regTsengSegSelect;      /* Tseng Seg Select register (Bank Select) */
BYTE    regOrchidClockSelect;   /*            */

BYTE    stateTridentRegDef;     /* Trident register definition register state */
BYTE    regTridentModeCtrl2;    /* non-zero (TRUE) => 'new' definition */

#ifdef ATI
BYTE    regATIIndx;             /* shadows PORT_ATIVGA_INDX            */
BYTE   aregATIData[MAX_ATIREGS];/* shadows PORT_ATIVGA_DATA[MAX_ATIREGS] */
#endif

WORD    wreg8514MFIndx;         /* for interim settings (for byte I/O) */
WORD    awreg8514Data[WREG_TOTAL];
WORD    awreg8514MFData[MFINDX_INDXTOTAL];
#endif                          /*                                     */

#ifdef COMPAQ
BYTE    regCompaqCtrl;          /* Compaq Control Mode register        */
#endif

#ifdef EGAVGA
BYTE    bLatches[MAX_PLANES];   /* storage for latches                 */
PBVDM   pCPBuff;                /* codepage buffer                                 */
USHORT  ROMint1fSeg;            /* Graphics Character Table Segment                */
#endif

#ifdef  GALE                                                            //J-TS00V
//c-begin                                                               //J-TS00V
FLAGS    flVDMGale;             // indicates US or Gale                 //J-TS00V
GALEDATA GaleData;              // Gale support data                    //J-TS00V
//c-end                                                                 //J-TS00V
#endif  //GALE                                                          //J-TS00V
                                                                        //J-TS00V
#ifdef  XVIO                                                            //J-TS00V
//c-begin                                                               //J-TS00V
FLAGS    flVDMVideoJ;           // extended per-VDM flags for Japanese  //J-TS00V
XVIODATA XVIOData;              // XVIO data                            //J-TS00V
//c-end                                                                 //J-TS00V
#endif  //XVIO                                                          //J-TS00V


} PERVDMDATA;                   /* end of PERVDMDATA structure         */

//masm-begin
//DefStruc ,dbcsdata_s
//PERVDMDATA    OrgPerVDMData
//ifdef     GALE
//FLAGS         flVDMGale
//GALEDATA      GaleData
//endif
//ifdef     XVIO
//FLAGS         flVDMVideoJ
//XVIODATA      XVIOData
//endif
//EndStruc DBCSDATA
//masm-end


typedef PERVDMDATA *PVDMDATA;



//masm-begin

//DefData IMPORT,INSTANCE,C
//PERVDMDATA VVData
//VDMData catstr VVData
//EndData

//masm-end


//c-begin

#pragma BEGIN_SWAP_INSTANCE
extern  PERVDMDATA VVData;
#define VDMData VVData
#pragma END_SWAP_INSTANCE

//c-end


 /*
 ** C function prototypes
 */

 /*
 **  vvinit.c
 */


BOOL    EXPENTRY  VDDInit(PSZ);
#ifdef EGAVGA
VOID    PRIVENTRY vvEditVideoTables(PVOID);
#endif
VOID    PRIVENTRY vvFindMono(PVOID);

 /*
 **  vvuser.c
 */

BOOL    EXPENTRY  VVCreate(HVDM);
VOID    EXPENTRY  VVCreateDone(HVDM);                           /*            */
#ifdef SVGA
VOID    PRIVENTRY vvSVGAEditVideoTables(ULONG, ULONG);          /*            */
VOID    PRIVENTRY vvSVGASetBgnd(HVDM hvdm);                     /*            */
#endif
VOID    EXPENTRY  VVSetFgnd(HVDM);
VOID    EXPENTRY  VVSetBgnd(HVDM);
BOOL    EXPENTRY  VVChangeCodePage(ULONG);
BOOL    EXPENTRY  VVChangeTitle(PSZ);
VOID    EXPENTRY  VVDestroy(HVDM);
#ifdef PROPERTIES
ULONG   EXPENTRY  VVSetInt10Emulation(ULONG, HVDM, ULONG, PSZ);
ULONG   EXPENTRY  VVSetRetraceEmulation(ULONG, HVDM, ULONG, PSZ);
ULONG   EXPENTRY  VVSetUpdateFrequency(ULONG, HVDM, ULONG, PSZ);
/* ULONG   EXPENTRY  VVSetSyncOutput(ULONG, HVDM, ULONG, PSZ);                  */
ULONG   EXPENTRY  VVSetInt2F(ULONG, HVDM, ULONG, PSZ);
ULONG   EXPENTRY  VVSetOnDemandAlloc(ULONG, HVDM, ULONG, PSZ);
#endif
VOID    HOOKENTRY VVFgndContext(PVOID, PCRF);
VOID    HOOKENTRY VVBgndContext(PVOID, PCRF);
BOOL    PRIVENTRY vvFreezeVDM(HVDM, BOOL);
VOID    PRIVENTRY vvThawVDM(HVDM);
VOID    PRIVENTRY vvInt2FNotify(ULONG, PCRF);
VOID    HOOKENTRY VVInt2FReturn(PVOID, PCRF);

 /*
 **  vvport.c
 */

BOOL    PRIVENTRY vvSetIOHooks(PHLE, BOOL, BOOL);
VOID    PRIVENTRY vvEnableIO(VOID);
VOID    HOOKENTRY VVSpecialCaseIO(HHOOK, PCRF);
PORT    PRIVENTRY vvAdjustedPort(HVDM, PORT);
#ifdef EGAVGA
PBYTE   PRIVENTRY vvQueryLatchAddress(HVDM);
VOID    PRIVENTRY vvSaveLatches(HVDM, BOOL);
VOID    PRIVENTRY vvRestoreLatches(HVDM, BOOL);
#endif
#ifdef VGA
VOID    PRIVENTRY vvSaveDACState(HVDM);                         /*            */
VOID    PRIVENTRY vvRestoreDACState(HVDM);
VOID    PRIVENTRY vvDisableVRAM(HVDM);                          /*            */
#endif
VOID    PRIVENTRY vvDisableDisplay(HVDM);
VOID    PRIVENTRY vvEnableDisplay(HVDM);
#ifdef CGA
VOID    EXPENTRY  VVForceDisplay(VOID);
#endif


 /*
 **  vvpage.c
 */

BOOL    PRIVENTRY vvSetFaultHooks(BOOL, BOOL);
VOID    HOOKENTRY VVFaultHook(PVDM);
VOID    HOOKENTRY VVEnableBuffer(BOOL, PCRF);
BOOL    PRIVENTRY vvTransferBuffer(HVDM, INT, BOOL);
#ifdef SVGA
BOOL    PRIVENTRY vvTransferLinearBuffer(HVDM, INT, BOOL);
VOID    EXPENTRY  vvPrepareForTransfer(HVDM, BOOL, ULONG);      /*                        */
#endif
BOOL    PRIVENTRY vvTransferPage(HVDM, INT, INT, INT, BOOL);
VOID    PRIVENTRY vvValidatePage(INT, INT);
VOID    PRIVENTRY vvMapBank(INT);                               /*            */
VOID    PRIVENTRY vvUnMapBuffer(VOID);                          /*            */
#ifdef EGAVGA
VOID    PRIVENTRY vvUnvalidatePage(HVDM, HVDM, INT, INT);
#endif
BOOL    PRIVENTRY vvUpdatePageStates(HVDM);
VOID    PRIVENTRY vvMapPage(PBVDM, PVOID, INT, INT, FLAGS);     /*            */
VOID    PRIVENTRY vvFlushPages(HVDM);
ULONG   PRIVENTRY vvRectsFromPageMap(HVDM, FLAGS, ULONG, PVVLVB);
ULONG   PRIVENTRY vvRectsFromShadowBuffer(HVDM, ULONG, PVVLVB);
VOID    PRIVENTRY vvRectFromOffset(HVDM, ULONG, ULONG, PRECTL);


 /*
 **  vvphys.c
 */

VOID    PRIVENTRY vvUpdatePhysPageMap(PVVDRQ);
BOOL    PRIVENTRY vvGetPhysPage(INT);
VOID    PRIVENTRY vvFreePhysPage(HVDM, INT);
VOID    PRIVENTRY vvFreeAllPhysPages(HVDM, BOOL);
ULONG   PRIVENTRY vvGetPhysBytes(ULONG);
VOID    PRIVENTRY vvFreePhysBytes(ULONG, ULONG);
VOID    HOOKENTRY VVUnmapPhysContext(HHOOK, PCRF);
VOID    HOOKENTRY VVUpdateContext(PVOID, PCRF);
VOID    HOOKENTRY VVUpdatePhysContext(PVOID, PCRF);


 /*
 **  vvbuff.c
 */

BOOL    PRIVENTRY vvGrowLinearBuffer(HVDM, INT);                /*            */
BOOL    PRIVENTRY vvGrowBuffer(HVDM, INT, INT, INT);
VOID    PRIVENTRY vvShrinkBuffer(HVDM, BOOL);
BOOL    PRIVENTRY vvGrowPlane(HVDM, INT, INT, INT);
VOID    PRIVENTRY vvShrinkPlane(HVDM, INT, INT, INT);
BOOL    PRIVENTRY vvAllocShadowBuffer(HVDM);


 /*
 **  vvstate.c
 */

VOID    PRIVENTRY vvUpdateAll(HVDM, BOOL);
#ifdef EGAVGA
VOID    PRIVENTRY vvUpdateIOState(HVDM, BOOL);
#endif
#ifdef VGA
VOID    PRIVENTRY vvGetIOState(HVDM, PRLE);
#endif
VOID    PRIVENTRY vvUpdateMemoryState(HVDM);
VOID    PRIVENTRY vvUpdateScreenState(HVDM, BOOL);
VOID    PRIVENTRY vvUpdateModeData(HVDM);
#ifdef EGAVGA
VOID    PRIVENTRY vvSetCopyState(HVDM, MSTATE, INT);
VOID    PRIVENTRY vvRestoreCopyState(HVDM, INT);
VOID    PRIVENTRY vvSetIOState(HVDM, PRLE, INT);
#endif
VOID    PRIVENTRY vvRestoreIOState(HVDM);


 /*
 **  vvmode.c
 */

VOID    PRIVENTRY vvInt10Initialize(PCRF);
BOOL    HOOKENTRY vvInt10SetMode(PCRF);
VOID    HOOKENTRY VVInt10SetModeReturn(PVOID, PCRF);
#ifdef EGAVGA
BOOL    PRIVENTRY vvLoadCodePageFont(VOID);
BOOL    PRIVENTRY vvGetCodePageFont(ULONG, ULONG, PBVDM);       /*            */
#endif

#ifdef SVGA
VOID    PRIVENTRY vvFixSVGARegisters(VOID);     /*                     */
VOID    PRIVENTRY vvLockSVGARegisters(ULONG);   /*                     */
VOID    PRIVENTRY vvUnLockSVGARegisters(VOID);  /*                     */
VOID    PRIVENTRY vvSVGAFixSetBgnd(HVDM);       /*                     */
//c-begin
BOOL   PRIVENTRY vvIdentifySVGA(OEMSVGAINFO *);         /*             */
//c-end
#endif


 /*
 **  vvevent.c
 */

VOID    PRIVENTRY vvAddEvent(HVDM, INT, PVOID, FLAGS);
VOID    PRIVENTRY vvFlushEvent(HVDM, INT, FLAGS);
VOID    PRIVENTRY vvFlushEventNotify(HVDM, INT);
VOID    PRIVENTRY vvDeleteEvent(HVDM, INT, FLAGS);
INT     PRIVENTRY vvGetEvent(PHVDM, BOOL);
BOOL    PRIVENTRY VVCheckForEvents(HVDM, BOOL);
BOOL    PRIVENTRY vvCheckForDirtyLVB(HVDM, FLAGS);
BOOL    PRIVENTRY vvCheckForDirtyPalette(HVDM, FLAGS);
BOOL    PRIVENTRY vvEnumerateVDMs(PENUMHOOK, BOOL);
VOID    HOOKENTRY VVEventTimer(PVOID, PCRF);


 /*
 **  vvdevrq.c
 */

LONG    EXPENTRY  VVDevReqProc(HVDM, ULONG, PVOID, PVOID);
LONG    PRIVENTRY vvDevPostPeek(HVDM, BOOL);
LONG    PRIVENTRY vvDevPostRead(HVDM, BOOL);
LONG    PRIVENTRY vvDevPostPaste(HVDM, BOOL);
LONG    PRIVENTRY vvDevPostMouse(HVDM, BOOL);
LONG    PRIVENTRY vvDevAcceptAdapter(HVDM, BOOL);
LONG    PRIVENTRY vvDevReleaseAdapter(HVDM, BOOL);
LONG    PRIVENTRY vvDevAcceptDisplay(HVDM, BOOL);
LONG    PRIVENTRY vvDevReleaseDisplay(HVDM, BOOL);
LONG    PRIVENTRY vvDevPostVideoEvent(HVDM, PVVPOST);
VOID    PRIVENTRY vvKeyboardCheck(HVDM, BOOL);
VOID    HOOKENTRY VVInitContext(PBOOL, PCRF);
LONG    PRIVENTRY vvDevSaveRestoreAdapter(HVDM, BOOL);          /*            */
LONG    PRIVENTRY vvDevRepaint(HVDM, BOOL);                     /*            */
LONG    PRIVENTRY vvDevRequestController(HVDM, BOOL);           /*            */
LONG    PRIVENTRY vvDevFreeController(HVDM, BOOL);              /*            */
LONG    PRIVENTRY vvDevWindowsDeskTop(HVDM, BOOL);              /*            */
VOID    PRIVENTRY vvDevEnableDDE(HVDM, BOOL);                   /*            */
VOID    PRIVENTRY vvDevXGAPresent(HVDM,BOOL);                   /*            */
LONG    PRIVENTRY vvDevUnmapVRAM(HVDM,BOOL);                    /*            */
VOID    PRIVENTRY vvDev8514Present(HVDM,BOOL);                  /*            */
#ifdef  GALE                                                            //J-TS00V
LONG    PRIVENTRY vvDevGetVideoBuffer(HVDM, PVOID, PVOID);              //J-TS00V
VOID    PRIVENTRY vvMakePaletteTableGale(HVDM, BYTE *);                 //J-TS00V
BOOL    PRIVENTRY vvGetVIOModeData(HVDM, PVOID);                        //J-TS00V
LONG    PRIVENTRY vvDevSetVtextNotification(HVDM, PVOID, PVOID);        //J-TS00V
#endif  //GALE                                                          //J-TS00V


 /*
 **  vvsysrq.c
 */

LONG    EXPENTRY  VVSysReqProc(SGID, ULONG, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysSetAccess(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysSetFocus(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysSetLock(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysQueryMode(HVDM, ULONG, PVOID, ULONG, PVVMODE);
LONG    PRIVENTRY vvSysQueryCursor(HVDM, ULONG, PVOID, ULONG, PVVCURSOR);
LONG    PRIVENTRY vvSysQueryPalette(HVDM, ULONG, PVOID, ULONG, PRGB);
LONG    PRIVENTRY vvSysCopyLVB(HVDM, ULONG, PRECTL, ULONG, PBYTE);
#ifdef  XVIO                                                            //J-TS00V
LONG    PRIVENTRY vvSysCopyLVBSub(HVDM, ULONG, PRECTL, ULONG, PBYTE, BOOL); //J-TS00V
#endif  //XVIO                                                          //J-TS00V
LONG    PRIVENTRY vvSysCopyBitmap(HVDM, ULONG, PVVRECT, ULONG, PBYTE);
LONG    PRIVENTRY vvSysWaitEvent(HVDM, ULONG, PVOID, ULONG, PVVEVENT);
LONG    PRIVENTRY vvSysControlEvent(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysSetDisplayReq(HVDM, ULONG, PVVDRQ, ULONG, PVOID);
LONG    PRIVENTRY vvSysRequestMemory(HVDM, ULONG, PVOID, ULONG, PULONG);
LONG    PRIVENTRY vvSysFreeMemory(HVDM, ULONG, PVOID, ULONG, PULONG);
LONG    PRIVENTRY vvSysRequestController(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysFreeController(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysQueryVRAMStatus(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysSetOEMFlag(HVDM, ULONG, PVOID, ULONG, PVOID);    /*            */

 /*
 **  vvptr.c
 */

BOOL    EXPENTRY  VVShowPtr(HVDM, ULONG, ULONG);
BOOL    EXPENTRY  VVHidePtr(HVDM);
BOOL    EXPENTRY  VVDefineTextPtr(HVDM, ULONG, ULONG, BOOL);
BOOL    EXPENTRY  VVDefineGraphPtr(HVDM, PUSHORT, ULONG, ULONG);
BOOL    EXPENTRY  VVSetPtrPage(HVDM, ULONG);
BOOL    EXPENTRY  VVSetLPenEmulation(HVDM, BOOL);
VOID    HOOKENTRY VVUpdatePtrContext(PULONG, PCRF);

#ifdef  VTEXT                                                           //J-TS00V
//vvvtext.c                                                             //J-TS00V
VOID    HOOKENTRY VVInt10VtextHook(PVOID, PCRF);                        //J-TS00V
VOID    HOOKENTRY VVInt10VtextPreHook(PVOID, PCRF);                     //J-TS00V
VOID    PRIVENTRY vvCheckDispDD(PCRF);                                  //J-TS00V
VOID    HOOKENTRY VVCheckVtextReturn(PVOID, PCRF);                      //J-TS00V
BOOL    PRIVENTRY vvCheckForDirtyLVBVtext(HVDM, FLAGS);                 //J-TS00V
BOOL    PRIVENTRY vvMapVtextPVB(PVDM);                                  //J-TS00V
VOID    PRIVENTRY vvUnmapVtextPVB(VOID);                                //J-TS00V
VOID    PRIVENTRY vvFgndContextVtext(PCRF);                             //J-TS00V
VOID    PRIVENTRY vvBgndContextVtext(PCRF);                             //J-TS00V
VOID    PRIVENTRY vvRedrawVtext(PCRF);                                  //J-TS00V
VOID    HOOKENTRY VVVtextRedrawReturn(PVOID, PCRF);                     //J-TS00V
VOID    PRIVENTRY vvCheckSetModeVtext(PCRF);                            //J-TS00V
VOID    PRIVENTRY vvCheckCallerVtext(PCRF);                             //J-TS00V
VOID    PRIVENTRY vvSet$DispDrawingFlag(HVDM, BOOL);                    //J-TS00V
VOID    PRIVENTRY vvSetSupportedModeFlag(BOOL);                         //J-TS00V
ULONG   PRIVENTRY vvGetRowCountVtext(HVDM);                             //J-TS00V
VOID    PRIVENTRY vvPtrDrawVtext(HVDM, ULONG, ULONG);                   //J-TS00V
VOID    PRIVENTRY vvPtrEraseVtext(HVDM);                                //J-TS00V
VOID    PRIVENTRY vvPtrSetupDrawVtext(ULONG, ULONG);                    //J-TS00V
VOID    PRIVENTRY vvPtrSetupUpdateVtext(ULONG, ULONG);                  //J-TS00V
VOID    PRIVENTRY vvPtrSetupDrawUpdateVtext(ULONG, ULONG, FPFN);        //J-TS00V
VOID    PRIVENTRY vvPtrSetupEraseVtext(VOID);                           //J-TS00V
VOID    HOOKENTRY VVVtextUpdatePtrContext(PVOID, PCRF);                 //J-TS00V
VOID    HOOKENTRY VVVtextPtrReturn(PVOID, PCRF);                        //J-TS00V
#endif  //VTEXT                                                         //J-TS00V
                                                                        //J-TS00V
#ifdef  XVIO                                                            //J-TS00V
//vvxvio.c                                                              //J-TS00V
LONG    PRIVENTRY vxSetCursor(HVDM, ULONG, PVXCURSOR, ULONG, PVOID);    //J-TS00V
LONG    PRIVENTRY vxGetCursor(HVDM, ULONG, PVOID, ULONG, PVXCURSOR);    //J-TS00V
LONG    PRIVENTRY vxCopyLVB(HVDM, ULONG, PVXLVB, ULONG, PBYTE);         //J-TS00V
LONG    PRIVENTRY vxWriteString(HVDM, ULONG, PVXWSTR, ULONG, PBYTE);    //J-TS00V
LONG    PRIVENTRY vxSaveScreen(HVDM, ULONG, PVOID, ULONG, PVOID);       //J-TS00V
LONG    PRIVENTRY vxRestoreScreen(HVDM, ULONG, PVOID, ULONG, PVOID);    //J-TS00V
VOID    PRIVENTRY vxSetVVDType(HVDM, ULONG);                            //J-TS00V
VOID    PRIVENTRY vxAddEvent(HVDM, INT, PVOID, FLAGS);                  //J-TS00V
VOID    PRIVENTRY vxFlushEvent(HVDM, INT, FLAGS);                       //J-TS00V
VOID    PRIVENTRY vxSetStatus(HVDM, ULONG, ULONG);                      //J-TS00V
#endif  //XVIO                                                          //J-TS00V


 /*
 **  vvptra.asm
 */

VOID    PRIVENTRY vvPtrReset(HVDM);
VOID    PRIVENTRY vvPtrSetMasks(HVDM, PUSHORT);
VOID    PRIVENTRY vvPtrDraw(HVDM, ULONG, ULONG);
VOID    PRIVENTRY vvPtrErase(HVDM);


 /*
 **  vvint10.asm
 */

VOID    HOOKENTRY VVInt10Hook(PCRF);
VOID    HOOKENTRY VVInt10Return(PVOID, PCRF);


 /*
 **  vvcopy.asm
 */

#ifdef  XVIO                                                            //J-TS00V
VOID    PRIVENTRY vvCopyLVBToLVB(HVDM, PRECTL, PVOID, ULONG, BOOL);     //J-TS00V
#else   //XVIO                                                          //J-TS00V
VOID    PRIVENTRY vvCopyLVBToLVB(HVDM, PRECTL, PVOID, ULONG);           /*            */
#endif  //XVIO                                                          //J-TS00V
VOID    PRIVENTRY vvCopyBlankToLVB(HVDM, PRECTL, PVOID, ULONG);         /*            */
VOID    PRIVENTRY vvCopyGraphicsToBitmap(HVDM, PVVRECT, PVOID);
VOID    PRIVENTRY vvCopyGraphicsToBitmap256(HVDM, PVVRECT, PVOID);
VOID    PRIVENTRY vvCopyGraphicsToDDBitmap(HVDM, PVVRECT, PVOID);
VOID    PRIVENTRY vvConvertPalette(HVDM, ULONG, PVOID);
BOOL    PRIVENTRY vvFillShadowBuffer(HVDM, PRECTL);
BOOL    PRIVENTRY vvDiffShadowBuffer(HVDM, PRECTL);
#ifdef EGAVGA
BOOL    PRIVENTRY vvDiffPhysPage(HVDM, INT, PULONG, PULONG, BOOL);
#endif


 /*
 **  vvphysio.asm
 */

VOID    PRIVENTRY vvSetupShadowPtrs(PVVREG, ULONG, PRLE);
VOID    PRIVENTRY vvSetPhysIOState(VOID);
BYTE    PRIVENTRY vvAdjustShadowOutput(PRLE, BYTE);
VOID    PRIVENTRY vvShadowOutput(HVDM, PORT, PORT, LONG, ULONG, PBYTE, PBYTE, FLAGS);
HVDM    PRIVENTRY vvRequestController(HVDM, BOOL);
VOID    PRIVENTRY vvLockController(VOID);
VOID    PRIVENTRY vvUnlockController(VOID);
VOID    PRIVENTRY vvFreeController(HVDM);
VOID    PRIVENTRY vvDebugSaveInfo(BYTE, HVDM, BOOL);    /* 75466 */

#ifdef SVGA

 /*
 **  vvpmi.c
 */

BOOL    PRIVENTRY vvProcessPMIFile(CHAR *);

 /*
 **  vvsvgaid.asm
 */

VOID    PRIVENTRY GetPortBase(VOID);
USHORT  PRIVENTRY IdentifySVGA(VOID);
VOID    PRIVENTRY IsATI(VOID);
VOID    PRIVENTRY IsTrident(VOID);
VOID    PRIVENTRY IsTseng(VOID);
VOID    PRIVENTRY IsVideo7(VOID);
VOID    PRIVENTRY IsWesternDig(VOID);
VOID    PRIVENTRY Video7DisableExt(VOID);
VOID    PRIVENTRY Video7EnableExt(VOID);
VOID    PRIVENTRY WhichATI(VOID);
VOID    PRIVENTRY WhichTrident(VOID);
VOID    PRIVENTRY WhichTseng(VOID);
VOID    PRIVENTRY WhichVideo7(VOID);
VOID    PRIVENTRY WhichWesternDig(VOID);
ULONG   PRIVENTRY vvMaxBanks(HVDM);

 /*
 **  vvsvga.c
 */

BOOL    PRIVENTRY vvSVGAGetLockState(HVDM);                     /*            */

VOID    PRIVENTRY vvNOPSetBank(HVDM, ULONG, BOOL);
VOID    PRIVENTRY vvVideo7SetBank(HVDM, ULONG, BOOL);
VOID    PRIVENTRY vvTsengSetBank(HVDM, ULONG, BOOL);
VOID    PRIVENTRY vvTridentSetBank(HVDM, ULONG, BOOL);
VOID    PRIVENTRY vvWDSetBank(HVDM, ULONG, BOOL);
VOID    PRIVENTRY vvATISetBank(HVDM, ULONG, BOOL);
VOID    PRIVENTRY vvIBMSetBank(HVDM, ULONG, BOOL);              /*            */
VOID    PRIVENTRY vvCirrusSetBank(HVDM, ULONG, BOOL);           /*            */
VOID    PRIVENTRY vvS3SetBank(HVDM, ULONG, BOOL);               /*            */

ULONG   PRIVENTRY vvNOPGetBank(HVDM, BOOL);
ULONG   PRIVENTRY vvVideo7GetBank(HVDM, BOOL);
ULONG   PRIVENTRY vvTsengGetBank(HVDM, BOOL);
ULONG   PRIVENTRY vvTridentGetBank(HVDM, BOOL);
ULONG   PRIVENTRY vvWDGetBank(HVDM, BOOL);
ULONG   PRIVENTRY vvATIGetBank(HVDM, BOOL);
ULONG   PRIVENTRY vvIBMGetBank(HVDM, BOOL);                     /*            */
ULONG   PRIVENTRY vvCirrusGetBank(HVDM, BOOL);                  /*            */
ULONG   PRIVENTRY vvS3GetBank(HVDM, BOOL);                      /*            */

BOOL    PRIVENTRY vvSVGALinearMode(HVDM);

 /*
 **  vv8514sv.c                                                              
 */
VOID    PRIVENTRY v8514InstallIOHooks(VOID);
VOID    PRIVENTRY v8514SetIOHooks(FLAGS);
VOID    PRIVENTRY v8514SetPixelIOHooks(FLAGS);
BOOL    PRIVENTRY v8514UpdateModeData(HVDM);
VOID    PRIVENTRY v8514AddEvent(HVDM, INT, PVOID, FLAGS);
VOID    PRIVENTRY v8514DeleteEvent(HVDM, INT);
VOID    PRIVENTRY v8514EnableVGA(VOID);
VOID    PRIVENTRY v8514EnableBankAdd(HVDM);
VOID    PRIVENTRY v8514RestoreIOState(HVDM);
ULONG   PRIVENTRY v8514ReturnLineLen(HVDM);
BOOL    PRIVENTRY v8514Accelerated(HVDM);
VOID    PRIVENTRY v8514WaitOnEngine(HVDM);
VOID    PRIVENTRY v8514LockIO(HVDM);
VOID    PRIVENTRY v8514UnlockIO(HVDM);
BOOL    PRIVENTRY v8514EnterIO(ULONG, ULONG);
VOID    PRIVENTRY v8514ExitIO(VOID);
BYTE    HOOKENTRY V8514ReadWRegByteL(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteWRegByteL(BYTE, ULONG, PCRF);
BYTE    HOOKENTRY V8514ReadWRegByteH(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteWRegByteH(BYTE, ULONG, PCRF);
WORD    HOOKENTRY V8514ReadWRegWord(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteWRegWord(WORD, ULONG, PCRF);

BYTE    HOOKENTRY V8514ReadMFRegByteL(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteMFRegByteL(BYTE, ULONG, PCRF);
BYTE    HOOKENTRY V8514ReadMFRegByteH(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteMFRegByteH(BYTE, ULONG, PCRF);
WORD    HOOKENTRY V8514ReadMFRegWord(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteMFRegWord(WORD, ULONG, PCRF);

 /*
 **  vvsvgaio.asm
 */

BYTE    EXPENTRY  VVWriteTsengUnlock1Fgnd();
BYTE    EXPENTRY  VVWriteTsengUnlock1Bgnd();
BYTE    EXPENTRY  VVWriteTsengUnlock2Fgnd();
BYTE    EXPENTRY  VVWriteTsengUnlock2Bgnd();
BYTE    EXPENTRY  VVReadTsengSegSelectFgnd();
BYTE    EXPENTRY  VVWriteTsengSegSelectFgnd();
BYTE    EXPENTRY  VVReadTsengSegSelectBgnd();
BYTE    EXPENTRY  VVWriteTsengSegSelectBgnd();
BOOL    EXPENTRY  VVGetTridentRegDef();
BYTE    EXPENTRY  VVWriteIBMApertureCtrlFgnd();                         /*            */
BYTE    EXPENTRY  VVReadIBMApertureCtrlBgnd();                          /*            */
BYTE    EXPENTRY  VVWriteIBMApertureCtrlBgnd();                         /*            */
BYTE    EXPENTRY  VVReadIBMRegistersBgnd();
BYTE    EXPENTRY  VVWriteIBMRegistersBgnd();
BYTE    EXPENTRY  VVReadOrchidClockSelectFgnd();                        /*            */
BYTE    EXPENTRY  VVReadOrchidClockSelectBgnd();                        /*            */
BYTE    EXPENTRY  VVWriteOrchidClockSelectFgnd();                       /*            */
BYTE    EXPENTRY  VVWriteOrchidClockSelectBgnd();                       /*            */

VOID    PRIVENTRY SETDIAMONDCLK(HVDM, ULONG, ULONG);                    /*            */
VOID    PRIVENTRY Prog_Clock();                 /*            */
VOID    PRIVENTRY Send_Serial();                /*            */
VOID    PRIVENTRY GetCRTCAddr();                /*            */
VOID    PRIVENTRY GetDACTypeRtn();              /*            */
VOID    PRIVENTRY SetDACCMDReg();               /*            */
VOID    PRIVENTRY WaitVertRetrace();            /*            */

VOID    PRIVENTRY SETNUMBER9CLK(HVDM, ULONG);                           /*            */
#endif

 /*
 **   MASM function prototypes
 **
 **   None of these functions are callable; they are declared
 **   so that they can be referenced in various function tables.  The
 **   one current exception is in vvcrtio.asm:  vvUpdateCursorData.
 */

 /*  vvatcio.asm
 **
 */

#ifdef EGA
BYTE    EXPENTRY  VVReadATCFgnd();
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadATCBgnd();
VOID    EXPENTRY  VVWriteATCFgnd();
VOID    EXPENTRY  VVWriteATCBgnd();
#endif
#ifdef EGA
WORD    EXPENTRY  VVReadATCFgndW();
VOID    EXPENTRY  VVWriteATCFgndW();
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadATC1Fgnd();
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadATC1Bgnd();
#endif


 /*
 **  vvcrtio.asm
 */

#ifndef VGA
BYTE    EXPENTRY  VVReadCRTIndxFgnd();
#endif
BYTE    EXPENTRY  VVReadCRTIndxBgnd();
#ifndef VGA
VOID    EXPENTRY  VVWriteCRTIndxFgnd();
#endif
VOID    EXPENTRY  VVWriteCRTIndxBgnd();
#ifndef VGA
WORD    EXPENTRY  VVReadCRTIndxFgndW();
#endif
VOID    EXPENTRY  VVWriteCRTIndxFgndW();
VOID    EXPENTRY  VVWriteCRTIndxBgndW();
#ifndef VGA
BYTE    EXPENTRY  VVReadCRTDataFgnd();
#endif
BYTE    EXPENTRY  VVReadCRTDataBgnd();
#ifndef VGA
VOID    EXPENTRY  VVWriteCRTDataFgnd();
#endif
VOID    EXPENTRY  VVWriteCRTDataBgnd();
VOID    PRIVENTRY vvUpdateCursorData(HVDM);
#ifdef  XVIO                                                            //J-TS00V
VOID    PRIVENTRY vxUpdateCursorData(HVDM);                             //J-TS00V
#endif  //XVIO                                                          //J-TS00V

 /*
 **  vvdacio.asm
 */

#ifdef VGA
VOID    EXPENTRY  VVWriteDACReadFgnd();
VOID    EXPENTRY  VVWriteDACWriteFgnd();
BYTE    EXPENTRY  VVReadDACDataFgnd();
VOID    EXPENTRY  VVWriteDACDataFgnd();
BYTE    EXPENTRY  VVReadDACMaskBgnd();
VOID    EXPENTRY  VVWriteDACMaskBgnd();
BYTE    EXPENTRY  VVReadDACStateBgnd();
VOID    EXPENTRY  VVWriteDACReadBgnd();
BYTE    EXPENTRY  VVReadDACIndxBgnd();
VOID    EXPENTRY  VVWriteDACWriteBgnd();
BYTE    EXPENTRY  VVReadDACDataBgnd();
VOID    EXPENTRY  VVWriteDACDataBgnd();
#endif


 /*
 **  vvgdcio.asm
 */

#ifdef EGA
VOID    EXPENTRY  VVWriteGDC2Fgnd();
VOID    EXPENTRY  VVWriteGDC2Bgnd();
VOID    EXPENTRY  VVWriteGDC1Fgnd();
VOID    EXPENTRY  VVWriteGDC1Bgnd();
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadGDCIndxFgnd();
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadGDCIndxBgnd();
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteGDCIndxFgnd();
VOID    EXPENTRY  VVWriteGDCIndxBgnd();
#endif
#ifdef EGA
WORD    EXPENTRY  VVReadGDCIndxFgndW();
VOID    EXPENTRY  VVWriteGDCIndxFgndW();
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadGDCDataFgnd();
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadGDCDataBgnd();
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteGDCDataFgnd();
VOID    EXPENTRY  VVWriteGDCDataBgnd();
#endif


 /*
 **  vvmscio.asm
 */

#ifdef MONOCGA
BYTE    EXPENTRY  VVReadModeFgnd();
BYTE    EXPENTRY  VVReadModeBgnd();
VOID    EXPENTRY  VVWriteModeFgnd();
VOID    EXPENTRY  VVWriteModeBgnd();
#endif
#ifdef CGA
BYTE    EXPENTRY  VVReadCGAColorFgnd();
BYTE    EXPENTRY  VVReadCGAColorBgnd();
VOID    EXPENTRY  VVWriteCGAColorFgnd();
VOID    EXPENTRY  VVWriteCGAColorBgnd();
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadStatus0Bgnd();
#endif
#ifdef EGAVGA                                                           /*            */
VOID    EXPENTRY  VVWriteMiscOutFgnd();
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteMiscOutBgnd();
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadFeatureFgnd();
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadFeatureBgnd();
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadMiscOutFgnd();
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadMiscOutBgnd();
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadStatus1Fgnd();
#endif
BYTE    EXPENTRY  VVReadStatus1Bgnd();
#ifdef EGA
VOID    EXPENTRY  VVWriteFeatureFgnd();
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteFeatureBgnd();
#endif
#ifndef MONO
BYTE    EXPENTRY  VVReadUnknownBgnd();
#endif
VOID    EXPENTRY  VVWriteUnknownBgnd();
VOID    EXPENTRY  VVWriteUnknownBgnd();
#ifdef SVGA                                                /*            */
BYTE    EXPENTRY  VVReadVVReservedFgnd();                  /*            */
BYTE    EXPENTRY  VVWriteVVReservedFgnd();                 /*            */
BYTE    EXPENTRY  VVReadVVReservedBgnd();                  /*            */
BYTE    EXPENTRY  VVWriteVVReservedBgnd();                 /*            */
#endif                                                     /*            */


 /*
 **  vvseqio.asm
 */

#ifdef EGA
BYTE    EXPENTRY  VVReadSEQIndxFgnd();
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadSEQIndxBgnd();
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteSEQIndxFgnd();
VOID    EXPENTRY  VVWriteSEQIndxBgnd();
#endif
#ifdef EGA
WORD    EXPENTRY  VVReadSEQIndxFgndW();
VOID    EXPENTRY  VVWriteSEQIndxFgndW();
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadSEQDataFgnd();
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadSEQDataBgnd();
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteSEQDataFgnd();
VOID    EXPENTRY  VVWriteSEQDataBgnd();
#endif


 /*
 **  vvoem.asm
 */

#ifdef COMPAQ
#ifdef EGA
BYTE    EXPENTRY  VVReadCompaqCtrlBgnd();
VOID    EXPENTRY  VVWriteCompaqCtrlBgnd();
#endif
#endif

#ifdef ATI
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadATIIndxBgnd();
VOID    EXPENTRY  VVWriteATIIndxBgnd();
BYTE    EXPENTRY  VVReadATIDataBgnd();
VOID    EXPENTRY  VVWriteATIDataBgnd();
#endif
#endif

#ifdef  GALE                                                            //J-TS00V
//vvgale.asm                                                            //J-TS00V
VOID    HOOKENTRY VVInt15Hook(PCRF);                                    //J-TS00V
VOID    EXPENTRY  VVInitScreen();                                       //J-TS00V
VOID    EXPENTRY  VVRedrawScreen();                                     //J-TS00V
VOID    EXPENTRY  VVLoadDefaultSBCS();                                  //J-TS00V
VOID    EXPENTRY  VVCheckXGAAdapter();                                  //J-TS00V
VOID    EXPENTRY  VVInitDBCSTable();                                    //J-TS00V
VOID    EXPENTRY  vvExtWriteStrGale();                                  //J-TS00V
VOID    EXPENTRY  vvSetCurPosGale();                                    //J-TS00V
VOID    EXPENTRY  vvSetCurTypeGale();                                   //J-TS00V
VOID    PRIVENTRY vvMakePaletteTableGale(HVDM, BYTE *);                 //J-TS00V
VOID    EXPENTRY  vvConvAPAToPrtGale(PBYTE *, PBYTE, PBYTE, BOOL);      //J-TS00V
#endif  //GALE                                                          //J-TS00V
#ifdef  XVIO                                                            //J-TS00V
VOID    EXPENTRY  vvExtWriteStrGale();                                  //J-TS00V
VOID    EXPENTRY  vvSetCurPosGale();                                    //J-TS00V
VOID    EXPENTRY  vvSetCurTypeGale();                                   //J-TS00V
#endif  //XVIO                                                          //J-TS00V
                                                                        //J-TS00V
#ifdef  VTEXT                                                           //J-TS00V
//vvvtexta.asm                                                          //J-TS00V
VOID    PRIVENTRY vvUpdateCursorDataVtext(HVDM);                        //J-TS00V
#ifdef  XVIO                                                            //J-TS00V
VOID    PRIVENTRY vvCopyLVBToLVBVtext(HVDM, PRECTL, PVOID, ULONG, BOOL); //J-TS00V
#else   //XVIO                                                          //J-TS00V
VOID    PRIVENTRY vvCopyLVBToLVBVtext(HVDM, PRECTL, PVOID, ULONG);      //J-TS00V
#endif  //XVIO                                                          //J-TS00V
#endif  //VTEXT                                                         //J-TS00V


//masm-begin

//word_s struc
//  lo  db  ?
//  hi  db  ?
//word_s ends
//
//dword_s struc
//  off dw  ?
//  sel dw  ?
//dword_s ends

//masm-end


 /*
 ** Random macro support
 **
 **   If VDDSTRICT is defined, the Assert macros generate appropriate code.
 **
 **   If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
 **   exception of AssertRC, in which case the function is still called, but
 **   the return code is not checked).
 **
 **   If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
 **   failed assertions (assuming VDDSTRICT is defined) break at the assertion
 **   rather than in the kernel's "panic" service.  VDDDEBUG requires the
 **   kernel debugger, in other words.
 **
 **   If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
 **   generated, and failed assertions (assuming VDDSTRICT is defined) simply
 **   panic.
 */

#ifdef VDDSTRICT


//c-begin

extern CHAR szAssertMsg[];
#define MODNAME static CHAR szFile[]

#ifdef VDDDEBUG
#define Assert(t) { \
                    if (!(t)) { \
                      PRINTDEBUG(szAssertMsg, szFile, __LINE__); \
                      INT3(); \
                    } \
                  }
#else
#define Assert(t) { \
                    if (!(t)) { \
                      PANIC(szAssertMsg, szFile, __LINE__); \
                    } \
                  }
#endif

#define AssertTRUE(t)   Assert(t)
#define AssertFALSE(t)  Assert(!(t))
#define AssertZERO(t)   Assert(!(t))
#define AssertNONZERO(t)Assert(t)
#define AssertERROR()   Assert(FALSE)
#define AssertRC(t)     Assert(t)       /* verify function return code good */

//c-end


//masm-begin

//?ASSERT macro   cond,msg,args
//        local   l1
//        ifnb    <cond>
//        j&cond  short l1
//        endif
//        ifdef   VDDDEBUG
//        DBPRINT <msg>,<args>
//        int 3
//        else
//        PANIC   <msg>,<args>
//        endif
//        ifnb    <cond>
//l1:
//        endif
//        endm

//masm-end


#else


//c-begin

#define Assert(t)
#define AssertTRUE(t)
#define AssertFALSE(t)
#define AssertZERO(t)
#define AssertNONZERO(t)
#define AssertERROR()
#define AssertRC(t)     (t)             /* perform function, but don't verify */

//c-end


//masm-begin

//?ASSERT macro cond,msg,args
//        endm

//masm-end


#endif


//masm-begin

//ASSERT   equ   <?ASSERT ,>
//ASSERTC  equ   <?ASSERT c,>
//ASSERTNC equ   <?ASSERT nc,>
//ASSERTZ  equ   <?ASSERT z,>
//ASSERTNZ equ   <?ASSERT nz,>
//ASSERTE  equ   <?ASSERT e,>
//ASSERTNE equ   <?ASSERT ne,>
//ASSERTB  equ   <?ASSERT b,>
//ASSERTBE equ   <?ASSERT be,>
//ASSERTA  equ   <?ASSERT a,>
//ASSERTAE equ   <?ASSERT ae,>

//masm-end


 /*
 ** Random debugging support
 */


#ifdef VDDDEBUG


//c-begin

extern CHAR szModule[];
extern CHAR *apszPageStates[];

#undef  PRINTDEBUG
#define PRINTDEBUG  printf(szModule); printf

/* Maybe someday... */
/* #undef  INB */
/* #define INB(p)      vvINB(p) */
/* #undef  OUTB */
/* #define OUTB(p,b)   vvOUTB(p,b,NULL) */
/* #undef  OUTW */
/* #define OUTW(p,w)   vvOUTW(p,w,NULL,NULL) */

//c-end


//masm-begin

//DefData IMPORT,INSTANCE,C
//SZ szModule
//EndData
//
//DBPRINT macro msg,args
//        PRINTDEBUG <szModule>,<00>
//        PRINTDEBUG <msg>,<args>
//        endm

//masm-end


#else


//masm-begin

//DBPRINT macro msg,args
//        endm

//masm-end


#endif


 /*
 ** LOOP alternative to enhance performance                                         
 */


//masm-begin

//hploop  macro   target
//        dec     ecx
//        jnz     target
//        endm

//masm-end

