/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VVDATA.C
 *
 * DESCRIPTIVE NAME = Virtual Video Private Data
 *
 *
 * VERSION = V2.0
 *
 * DATE      11/10/88
 *
 * DESCRIPTION  This module contains the VVD's private data.
 *
 *
 * FUNCTIONS    None
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#include <mvdm.h>
#include <vvd.h>
#include "vvdp.h"
#ifdef  GALE                                                            //J-TS00V
#include <vfntv.h>                                                      //J-TS00V
#include "vvgale.h"                                                     //J-TS00V
#endif  //GALE                                                          //J-TS00V


#pragma BEGIN_SWAP_INSTANCE

PERVDMDATA VDMData;

#pragma END_SWAP_INSTANCE



#pragma BEGIN_SWAP_DATA


 /*
 ** Global port trapping lists, per adapter per screen-state
 **
 **  The format of each port list is as follows:
 **
 **      Port # to trap, handler, handler, ..., -1
 **      Port # to trap, handler, handler, ..., -1
 **      ...
 **      -1
 **
 **  Note that if a port # to trap is not followed by ANY handlers, then
 **  nothing is installed AND I/O trapping is disabled for the port.  This
 **  is done for ports that the VDM can have complete unrestricted access to.
 **  When handlers ARE listed, they must be in the same order as given in
 **  the IOH structure (see V8086.H).  NULL (ie, HLE_NOHOOK) can appear in
 **  place of a handler address, in which case no handler is specified for
 **  that particular I/O action entry (NULL is what V8086 expects for default
 **  action hook).
 **
 **  I/O trapping will also be disabled for ports that have the PORTF_NOTRAP
 **  bit set within the port #, but any handlers will still be installed.
 **  This is for ports that normally have no need of trapping until certain
 **  circumstances arise, at which time we do an explicit VDHSetIOHookState().
 **
 **  Two potential video problems related to virtualizing the interrupt flag:
 **
 **  On a CGA, we might preempt an application in the middle of a video
 **  update, thereby causing snow (this risk exists in real-mode today,
 **  it's just that the odds are somewhat greater in our case).  Also, if
 **  we preempted a foreground application for a long time while it had the
 **  sequencer reset, VRAM could become garbled, since it is not being
 **  refreshed.  This is a potentially much more serious problem for which
 **  there is no work-around.  Again, since we shouldn't be virtualizing
 **  the interrupt flag all that often, this situation should be rare enough.
 */

#ifdef MONO

CONST PORT ahleFgnd[] =
{
                PORT_MONOCRTINDX,
                    (PORT)VVReadCRTIndxFgnd,
                    (PORT)VVWriteCRTIndxFgnd,
                    (PORT)VVReadCRTIndxFgndW,
                    (PORT)VVWriteCRTIndxFgndW,
                    HLE_ENDPORT,
                PORT_MONOCRTDATA,
                    (PORT)VVReadCRTDataFgnd,
                    (PORT)VVWriteCRTDataFgnd,
                    HLE_ENDPORT,
                PORT_MONOMODE,
                    (PORT)VVReadModeFgnd,
                    (PORT)VVWriteModeFgnd,
                    HLE_ENDPORT,
                PORT_MONOSTATUS1,
                    HLE_ENDPORT,
                HLE_ENDPORT
};

CONST PORT ahleBgnd[] =
{
                PORT_MONOCRTINDX,
                    (PORT)VVReadCRTIndxBgnd,
                    (PORT)VVWriteCRTIndxBgnd,
                    HLE_ENDPORT,
                PORT_MONOCRTDATA,
                    (PORT)VVReadCRTDataBgnd,
                    (PORT)VVWriteCRTDataBgnd,
                    HLE_ENDPORT,
                PORT_MONOMODE,
                    (PORT)VVReadModeBgnd,
                    (PORT)VVWriteModeBgnd,
                    HLE_ENDPORT,
                PORT_MONOSTATUS1,
                    (PORT)VVReadStatus1Bgnd,
                    (PORT)VVWriteUnknownBgnd,
                    HLE_ENDPORT,
                HLE_ENDPORT
};

#endif


#ifdef CGA

CONST PORT ahleFgnd[] =
{
                PORT_COLRCRTINDX,
                    (PORT)VVReadCRTIndxFgnd,
                    (PORT)VVWriteCRTIndxFgnd,
                    (PORT)VVReadCRTIndxFgndW,
                    (PORT)VVWriteCRTIndxFgndW,
                    HLE_ENDPORT,
                PORT_COLRCRTDATA,
                    (PORT)VVReadCRTDataFgnd,
                    (PORT)VVWriteCRTDataFgnd,
                    HLE_ENDPORT,
                PORT_CGAMODE,
                    (PORT)VVReadModeFgnd,
                    (PORT)VVWriteModeFgnd,
                    HLE_ENDPORT,
                PORT_CGACOLOR,
                    (PORT)VVReadCGAColorFgnd,
                    (PORT)VVWriteCGAColorFgnd,
                    HLE_ENDPORT,
                PORT_COLRSTATUS1,
                    HLE_ENDPORT,
                PORT_CGALPENRESET,
                    HLE_ENDPORT,
                PORT_CGALPENSET,
                    HLE_ENDPORT,
                HLE_ENDPORT
};

CONST PORT ahleBgnd[] =
{
                PORT_COLRCRTINDX,
                    (PORT)VVReadCRTIndxBgnd,
                    (PORT)VVWriteCRTIndxBgnd,
                    HLE_ENDPORT,
                PORT_COLRCRTDATA,
                    (PORT)VVReadCRTDataBgnd,
                    (PORT)VVWriteCRTDataBgnd,
                    HLE_ENDPORT,
                PORT_CGAMODE,
                    (PORT)VVReadModeBgnd,
                    (PORT)VVWriteModeBgnd,
                    HLE_ENDPORT,
                PORT_CGACOLOR,
                    (PORT)VVReadCGAColorBgnd,
                    (PORT)VVWriteCGAColorBgnd,
                    HLE_ENDPORT,
                PORT_COLRSTATUS1,
                    (PORT)VVReadStatus1Bgnd,
                    (PORT)VVWriteUnknownBgnd,
                    HLE_ENDPORT,
                PORT_CGALPENRESET,
                    (PORT)VVReadUnknownBgnd,
                    (PORT)VVWriteUnknownBgnd,
                    HLE_ENDPORT,
                PORT_CGALPENSET,
                    (PORT)VVReadUnknownBgnd,
                    (PORT)VVWriteUnknownBgnd,
                    HLE_ENDPORT,
                HLE_ENDPORT
};

#endif


#ifdef EGA

CONST PORT ahleFgnd[] =
{
                PORT_MONOCRTINDX,
                    (PORT)VVReadCRTIndxFgnd,
                    (PORT)VVWriteCRTIndxFgnd,
                    (PORT)VVReadCRTIndxFgndW,
                    (PORT)VVWriteCRTIndxFgndW,
                    HLE_ENDPORT,
                PORT_MONOCRTDATA,
                    (PORT)VVReadCRTDataFgnd,
                    (PORT)VVWriteCRTDataFgnd,
                    HLE_ENDPORT,
                PORT_MONOSTATUS1,
                    (PORT)VVReadStatus1Fgnd,
                    (PORT)VVWriteFeatureFgnd,
                    HLE_ENDPORT,
                PORT_ATC0,
                    (PORT)VVReadATCFgnd,
                    (PORT)VVWriteATCFgnd,
                    (PORT)VVReadATCFgndW,
                    (PORT)VVWriteATCFgndW,
                    HLE_ENDPORT,
                PORT_ATC1,
                    (PORT)VVReadATC1Fgnd,
                    (PORT)VVWriteATCFgnd,
                    HLE_ENDPORT,
                PORT_STATUS0,
                    HLE_NOHOOK,
                    (PORT)VVWriteMiscOutFgnd,
                    HLE_ENDPORT,
                PORT_SEQINDX,
                    (PORT)VVReadSEQIndxFgnd,
                    (PORT)VVWriteSEQIndxFgnd,
                    (PORT)VVReadSEQIndxFgndW,
                    (PORT)VVWriteSEQIndxFgndW,
                    HLE_ENDPORT,
                PORT_SEQDATA,
                    (PORT)VVReadSEQDataFgnd,
                    (PORT)VVWriteSEQDataFgnd,
                    HLE_ENDPORT,
                PORT_GDCPOS2,
                    (PORT)VVReadFeatureFgnd,
                    (PORT)VVWriteGDC2Fgnd,
                    HLE_ENDPORT,
                PORT_GDCPOS1,
                    (PORT)VVReadMiscOutFgnd,
                    (PORT)VVWriteGDC1Fgnd,
                    HLE_ENDPORT,
                PORT_GDCINDX,
                    (PORT)VVReadGDCIndxFgnd,
                    (PORT)VVWriteGDCIndxFgnd,
                    (PORT)VVReadGDCIndxFgndW,
                    (PORT)VVWriteGDCIndxFgndW,
                    HLE_ENDPORT,
                PORT_GDCDATA,
                    (PORT)VVReadGDCDataFgnd,
                    (PORT)VVWriteGDCDataFgnd,
                    HLE_ENDPORT,
                PORT_COLRCRTINDX,
                    (PORT)VVReadCRTIndxFgnd,
                    (PORT)VVWriteCRTIndxFgnd,
                    (PORT)VVReadCRTIndxFgndW,
                    (PORT)VVWriteCRTIndxFgndW,
                    HLE_ENDPORT,
                PORT_COLRCRTDATA,
                    (PORT)VVReadCRTDataFgnd,
                    (PORT)VVWriteCRTDataFgnd,
                    HLE_ENDPORT,
                PORT_CGAMODE,
                    HLE_ENDPORT,                /*  FLAG: nonexistent on EGA,       */
                PORT_COLRSTATUS1,               /*  but some ROMs fiddle with it(?) */
                    (PORT)VVReadStatus1Fgnd,
                    (PORT)VVWriteFeatureFgnd,
                    HLE_ENDPORT,
                PORT_CGALPENRESET,              /*  FLAG: undocumented,             */
                    HLE_ENDPORT,                /*  but EGA has it...               */
               #ifdef COMPAQ
                PORT_COMPAQ_CTRL,               /*  R/W, save on screen-switch */
                    HLE_ENDPORT,
                PORT_COMPAQ_ENV,                /*  R/O port, needs no handlers */
                    HLE_ENDPORT,
                PORT_COMPAQ_DSP,                /*  R/O port, needs no handlers */
                    HLE_ENDPORT,
                PORT_COMPAQ_MODE,               /*  R/O port, needs no handlers */
                    HLE_ENDPORT,
               #endif
               #ifdef ATI
                PORT_ATIEGA_INDX,               /*  R/W, not saved on screen-switch */
                    HLE_ENDPORT,                /*   (because we don't know the format) */
                PORT_ATIEGA_DATA,               /*  R/W, not saved on screen-switch */
                    HLE_ENDPORT,                /*   (because we don't know the format) */
               #endif
                HLE_ENDPORT
};

CONST PORT ahleBgnd[] =
{
                PORT_MONOCRTINDX,
                    (PORT)VVReadCRTIndxBgnd,
                    (PORT)VVWriteCRTIndxBgnd,
                    HLE_ENDPORT,
                PORT_MONOCRTDATA,
                    (PORT)VVReadCRTDataBgnd,
                    (PORT)VVWriteCRTDataBgnd,
                    HLE_ENDPORT,
                PORT_MONOSTATUS1,
                    (PORT)VVReadStatus1Bgnd,
                    (PORT)VVWriteFeatureBgnd,
                    HLE_ENDPORT,
                PORT_ATC0,
                    (PORT)VVReadATCBgnd,
                    (PORT)VVWriteATCBgnd,
                    HLE_ENDPORT,
                PORT_ATC1,
                    (PORT)VVReadATC1Bgnd,
                    (PORT)VVWriteATCBgnd,
                    HLE_ENDPORT,
                PORT_STATUS0,
                    (PORT)VVReadStatus0Bgnd,
                    (PORT)VVWriteMiscOutBgnd,
                    HLE_ENDPORT,
                PORT_SEQINDX,
                    (PORT)VVReadSEQIndxBgnd,
                    (PORT)VVWriteSEQIndxBgnd,
                    HLE_ENDPORT,
                PORT_SEQDATA,
                    (PORT)VVReadSEQDataBgnd,
                    (PORT)VVWriteSEQDataBgnd,
                    HLE_ENDPORT,
                PORT_GDCPOS2,
                    (PORT)VVReadFeatureBgnd,
                    (PORT)VVWriteGDC2Bgnd,
                    HLE_ENDPORT,
                PORT_GDCPOS1,
                    (PORT)VVReadMiscOutBgnd,
                    (PORT)VVWriteGDC1Bgnd,
                    HLE_ENDPORT,
                PORT_GDCINDX,
                    (PORT)VVReadGDCIndxBgnd,
                    (PORT)VVWriteGDCIndxBgnd,
                    HLE_ENDPORT,
                PORT_GDCDATA,
                    (PORT)VVReadGDCDataBgnd,
                    (PORT)VVWriteGDCDataBgnd,
                    HLE_ENDPORT,
                PORT_COLRCRTINDX,
                    (PORT)VVReadCRTIndxBgnd,
                    (PORT)VVWriteCRTIndxBgnd,
                    HLE_ENDPORT,
                PORT_COLRCRTDATA,
                    (PORT)VVReadCRTDataBgnd,
                    (PORT)VVWriteCRTDataBgnd,
                    HLE_ENDPORT,
                PORT_CGAMODE,
                    HLE_ENDPORT,                /* FLAG: nonexistent on EGA,       */
                PORT_COLRSTATUS1,               /* but some ROMs fiddle with it(?) */
                    (PORT)VVReadStatus1Bgnd,
                    (PORT)VVWriteFeatureBgnd,
                    HLE_ENDPORT,
                PORT_CGALPENRESET,              /* FLAG: undocumented,             */
                    (PORT)VVReadUnknownBgnd,    /* but EGA has it...               */
                    (PORT)VVWriteUnknownBgnd,
                    HLE_ENDPORT,
               #ifdef COMPAQ
                PORT_COMPAQ_CTRL,
                    (PORT)VVReadCompaqCtrlBgnd,
                    (PORT)VVWriteCompaqCtrlBgnd,
                    HLE_ENDPORT,
                PORT_COMPAQ_ENV,                /* R/O port, needs no handlers */
                    HLE_ENDPORT,
                PORT_COMPAQ_DSP,                /* R/O port, needs no handlers */
                    HLE_ENDPORT,
                PORT_COMPAQ_MODE,               /* R/O port, needs no handlers */
                    HLE_ENDPORT,
               #endif
               #ifdef ATI
                PORT_ATIEGA_INDX,               /* R/W, not saved on screen-switch */
                    (PORT)VVReadATIIndxBgnd,    /*  (because we don't know the format) */
                    (PORT)VVWriteATIIndxBgnd,
                    HLE_ENDPORT,
                PORT_ATIEGA_DATA,               /* R/W, not saved on screen-switch */
                    (PORT)VVReadATIDataBgnd,    /*  (because we don't know the format) */
                    (PORT)VVWriteATIDataBgnd,
                    HLE_ENDPORT,
               #endif
                HLE_ENDPORT
};

#endif


#ifdef VGA

/*
** Mark all SVGA ports SVGA and NOTRAP, so that ports are enabled on
** the corresponding adapter only! See vvSVGAEditVideoTables.           
*/
CONST PORT ahleFgnd[] =
{
               #ifdef ATI
                PORT_ATIVGA_INDX | PORTF_NOTRAP | PORTF_SVGA,/* R/W, not saved on screen-switch */
                    HLE_ENDPORT,                /*  (because we don't know the format) */
                PORT_ATIVGA_DATA | PORTF_NOTRAP | PORTF_SVGA,/* R/W, not saved on screen-switch */
                    HLE_ENDPORT,                /*  (because we don't know the format) */
               #endif
                PORT_MONOCRTINDX,
                    HLE_ENDPORT,
                PORT_MONOCRTDATA,
                    HLE_ENDPORT,
                PORT_MONOSTATUS1,
                    (PORT)VVReadStatus1Fgnd,
                    HLE_ENDPORT,
                PORT_ATC0,
                    HLE_NOHOOK,
                    (PORT)VVWriteATCFgnd,
                    HLE_ENDPORT,
                PORT_ATC1,
                    HLE_ENDPORT,
                PORT_STATUS0,
                    HLE_NOHOOK,                                         /*            */
                    (PORT)VVWriteMiscOutFgnd,                           /*            */
                    HLE_ENDPORT,
                PORT_SEQINDX + PORTF_NOTRAP,
                    HLE_NOHOOK,
                    (PORT)VVWriteSEQIndxFgnd,
                    HLE_ENDPORT,
                PORT_SEQDATA + PORTF_NOTRAP,
                    HLE_NOHOOK,
                    (PORT)VVWriteSEQDataFgnd,
                    HLE_ENDPORT,
                PORT_VGADACMASK,
                    HLE_ENDPORT,
                PORT_VGADACREAD,
                    HLE_NOHOOK,
                    (PORT)VVWriteDACReadFgnd,
                    HLE_ENDPORT,
                PORT_VGADACWRITE,
                    HLE_NOHOOK,
                    (PORT)VVWriteDACWriteFgnd,
                    HLE_ENDPORT,
                PORT_VGADACDATA,
                    (PORT)VVReadDACDataFgnd,
                    (PORT)VVWriteDACDataFgnd,
                    HLE_ENDPORT,
                PORT_GDCPOS2,
                    HLE_ENDPORT,
                PORT_GDCPOS1,
                    HLE_ENDPORT,
                  PORT_GDCINDX + PORTF_NOTRAP,
                    HLE_NOHOOK,
                    (PORT)VVWriteGDCIndxFgnd,
                    HLE_ENDPORT,
                PORT_GDCDATA + PORTF_NOTRAP,
                    HLE_NOHOOK,
                    (PORT)VVWriteGDCDataFgnd,
                    HLE_ENDPORT,
                PORT_COLRCRTINDX,
                    HLE_ENDPORT,
                PORT_COLRCRTDATA,
                    HLE_ENDPORT,
                PORT_COLRSTATUS1,
                    (PORT)VVReadStatus1Fgnd,
                    HLE_ENDPORT,
                PORT_IBMP70_INDX,
                    HLE_ENDPORT,
                PORT_IBMP70_DATA,
                    HLE_ENDPORT,
                #ifdef SVGA                             /*            */
                PORT_TSENG_SEGSELECT | PORTF_NOTRAP | PORTF_SVGA,
                    HLE_NOHOOK,
                    (PORT)VVWriteTsengSegSelectFgnd,
                    HLE_ENDPORT,
                PORT_HERC_COMPATIBILITY | PORTF_NOTRAP | PORTF_SVGA,
                    HLE_NOHOOK,
                    (PORT)VVWriteTsengUnlock1Fgnd,
                    HLE_ENDPORT,
                PORT_TSENG_UNLOCK | PORTF_NOTRAP | PORTF_SVGA,
                    HLE_NOHOOK,
                    (PORT)VVWriteTsengUnlock2Fgnd,
                    HLE_ENDPORT,
                0x3D6,                                                  /*            */
                    (PORT)VVReadVVReservedFgnd,                         /*            */
                    (PORT)VVWriteVVReservedFgnd,                        /*            */
                    HLE_ENDPORT,                                        /*            */
                0x3DD | PORTF_NOTRAP | PORTF_SVGA,                      /*            */
                    (PORT)VVReadOrchidClockSelectFgnd,                  /*            */
                    (PORT)VVWriteOrchidClockSelectFgnd,                 /*            */
                    HLE_ENDPORT,                                        /*            */
                0x2100 + AXGA_APERTURE_CONTROL | PORTF_NOTRAP | PORTF_SVGA,/*            */
                    HLE_NOHOOK,                                         /*            */
                    (PORT)VVWriteIBMApertureCtrlFgnd,                   /*            */
                    HLE_ENDPORT,                                        /*            */
                #endif
                HLE_ENDPORT
};

CONST PORT ahleBgnd[] =
{
               #ifdef ATI
                PORT_ATIVGA_INDX | PORTF_NOTRAP | PORTF_SVGA,/* R/W, not saved on screen-switch */
                    (PORT)VVReadATIIndxBgnd,    /*  (because we don't know the format) */
                    (PORT)VVWriteATIIndxBgnd,
                    HLE_ENDPORT,
                PORT_ATIVGA_DATA | PORTF_NOTRAP | PORTF_SVGA,/* R/W, not saved on screen-switch */
                    (PORT)VVReadATIDataBgnd,    /*  (because we don't know the format) */
                    (PORT)VVWriteATIDataBgnd,
                    HLE_ENDPORT,
               #endif
                PORT_MONOCRTINDX,
                    (PORT)VVReadCRTIndxBgnd,
                    (PORT)VVWriteCRTIndxBgnd,
                    HLE_ENDPORT,
                PORT_MONOCRTDATA,
                    (PORT)VVReadCRTDataBgnd,
                    (PORT)VVWriteCRTDataBgnd,
                    HLE_ENDPORT,
                PORT_MONOSTATUS1,
                    (PORT)VVReadStatus1Bgnd,
                    (PORT)VVWriteFeatureBgnd,
                    HLE_ENDPORT,
                PORT_ATC0,
                    (PORT)VVReadATCBgnd,
                    (PORT)VVWriteATCBgnd,
                    HLE_ENDPORT,
                PORT_ATC1,
                    (PORT)VVReadATC1Bgnd,
                    (PORT)VVWriteUnknownBgnd,
                    HLE_ENDPORT,
                PORT_STATUS0,
                    (PORT)VVReadStatus0Bgnd,
                    (PORT)VVWriteMiscOutBgnd,
                    HLE_ENDPORT,
                PORT_SEQINDX,
                    (PORT)VVReadSEQIndxBgnd,
                    (PORT)VVWriteSEQIndxBgnd,
                    HLE_ENDPORT,
                PORT_SEQDATA,
                    (PORT)VVReadSEQDataBgnd,
                    (PORT)VVWriteSEQDataBgnd,
                    HLE_ENDPORT,
                PORT_VGADACMASK,
                    (PORT)VVReadDACMaskBgnd,
                    (PORT)VVWriteDACMaskBgnd,
                    HLE_ENDPORT,
                PORT_VGADACREAD,
                    (PORT)VVReadDACStateBgnd,
                    (PORT)VVWriteDACReadBgnd,
                    HLE_ENDPORT,
                PORT_VGADACWRITE,
                    (PORT)VVReadDACIndxBgnd,
                    (PORT)VVWriteDACWriteBgnd,
                    HLE_ENDPORT,
                PORT_VGADACDATA,
                    (PORT)VVReadDACDataBgnd,
                    (PORT)VVWriteDACDataBgnd,
                    HLE_ENDPORT,
                PORT_GDCPOS2,
                    (PORT)VVReadFeatureBgnd,
                    HLE_ENDPORT,
                PORT_GDCPOS1,
                    (PORT)VVReadMiscOutBgnd,
                    HLE_ENDPORT,
                PORT_GDCINDX,
                    (PORT)VVReadGDCIndxBgnd,
                    (PORT)VVWriteGDCIndxBgnd,
                    HLE_ENDPORT,
                PORT_GDCDATA,
                    (PORT)VVReadGDCDataBgnd,
                    (PORT)VVWriteGDCDataBgnd,
                    HLE_ENDPORT,
                PORT_COLRCRTINDX,
                    (PORT)VVReadCRTIndxBgnd,
                    (PORT)VVWriteCRTIndxBgnd,
                    HLE_ENDPORT,
                PORT_COLRCRTDATA,
                    (PORT)VVReadCRTDataBgnd,
                    (PORT)VVWriteCRTDataBgnd,
                    HLE_ENDPORT,
                PORT_COLRSTATUS1,
                    (PORT)VVReadStatus1Bgnd,
                    (PORT)VVWriteFeatureBgnd,
                    HLE_ENDPORT,
                PORT_IBMP70_INDX,               /* FLAG: 26-Jul-90               */
                    (PORT)VVReadUnknownBgnd,    /* More complete virtualization? */
                    (PORT)VVWriteUnknownBgnd,
                    HLE_ENDPORT,
                PORT_IBMP70_DATA,               /* FLAG: 26-Jul-90               */
                    (PORT)VVReadUnknownBgnd,    /* More complete virtualization? */
                    (PORT)VVWriteUnknownBgnd,
                    HLE_ENDPORT,
                #ifdef SVGA                             /*            */
                PORT_TSENG_SEGSELECT | PORTF_NOTRAP | PORTF_SVGA,
                    (PORT)VVReadTsengSegSelectBgnd,
                    (PORT)VVWriteTsengSegSelectBgnd,
                    HLE_ENDPORT,
                PORT_HERC_COMPATIBILITY | PORTF_NOTRAP | PORTF_SVGA,
                    HLE_NOHOOK,
                    (PORT)VVWriteTsengUnlock1Bgnd,
                    HLE_ENDPORT,
                PORT_TSENG_UNLOCK | PORTF_NOTRAP | PORTF_SVGA,
                    HLE_NOHOOK,
                    (PORT)VVWriteTsengUnlock2Bgnd,
                    HLE_ENDPORT,
                0x3D6,                                                  /*            */
                    (PORT)VVReadVVReservedBgnd,                         /*            */
                    (PORT)VVWriteVVReservedBgnd,                        /*            */
                    HLE_ENDPORT,                                        /*            */
                0x3DD | PORTF_NOTRAP | PORTF_SVGA,                      /*            */
                    (PORT)VVReadOrchidClockSelectBgnd,                  /*            */
                    (PORT)VVWriteOrchidClockSelectBgnd,                 /*            */
                    HLE_ENDPORT,                                        /*            */
                0x2100 + AXGA_OPERATING_MODE | PORTF_NOTRAP | PORTF_SVGA,/*            */
                    (PORT)VVReadIBMRegistersBgnd,                       /*            */
                    (PORT)VVWriteIBMRegistersBgnd,                      /*            */
                    HLE_ENDPORT,                                        /*            */
                0x2100 + AXGA_APERTURE_CONTROL | PORTF_NOTRAP | PORTF_SVGA,/*            */
                    (PORT)VVReadIBMApertureCtrlBgnd,                    /*            */
                    (PORT)VVWriteIBMApertureCtrlBgnd,                   /*            */
                    HLE_ENDPORT,                                        /*            */
                #endif
                HLE_ENDPORT
};

#endif

 /*
 **  Port and Register lists
 **
 **  The format of each port list (eg, apleAll) is:
 **
 **      Port #, total regs, offsets of virtual index & data, flags, ...
 **      Port #, total regs, offsets of virtual index & data, flags, ...
 **      ...
 **      0
 **  The format of each register list (eg, arleMemory) is:
 **
 **      Port #, starting index, total regs, offsets, copy states, flags, ...
 **      Port #, starting index, total regs, offsets, copy states, flags, ...
 **      ...
 **      0
 **
 **  apleAll lists all I/O ports that contain indexed or non-indexed
 **  registers that can be automatically transferred during foreground screen
 **  switches.  Note that there are a variety of registers that require
 **  special treatment when writing, and most of these special cases can be
 **  handled with the flag words (flResetSeq, flWaitVert and flWaitHorz).  Any
 **  other special cases are handled directly in vvRestoreIOState().
 **
 **  apleNoTrap lists all sets of registers that are untrapped for foreground
 **  VDMs (this is for VGAs -- and some other non-IBM adapters -- only).
 **
 **  arleMemory lists the minimum set of registers that are needed to
 **  determine (or change) a VDM's memory state.  These lists are used by
 **  vvUpdateIOState(), as well as vvSetCopyState() and vvRestoreCopyState().
 */

#ifdef MONO

CONST PLE apleAll[] =
{
                {PORT_MONOCRTINDX,
                    TOTAL_CGA_CRTREGS,
                    &VDMData.regCRTIndx,
                    &VDMData.aregCRTData[0]},
                {PORT_MONOMODE,
                    0,
                    NULL,
                    &VDMData.regMode},
                {0}
};

#endif


#ifdef CGA

CONST PLE apleAll[] =
{
                {PORT_COLRCRTINDX,
                    TOTAL_CGA_CRTREGS,
                    &VDMData.regCRTIndx,
                    &VDMData.aregCRTData[0]},
                {PORT_CGAMODE,
                    0,
                    NULL,
                    &VDMData.regMode},
                {PORT_CGACOLOR,
                    0,
                    NULL,
                    &VDMData.regColor},
                {0}
};

#endif


#ifdef EGA

CONST PLE apleAll[] =
{
                {PORT_ATC0 + PORTF_INDEXDATA,
                    TOTAL_EGA_ATCREGS,
                    &VDMData.regATCIndx,
                    &VDMData.aregATCData[0]},
                {PORT_MISCOUT,
                    0,
                    NULL,
                    &VDMData.regMiscOut},
                {PORT_SEQINDX,
                    TOTAL_IBM_SEQREGS,
                    &VDMData.regSEQIndx,
                    &VDMData.aregSEQData[0],
                    PLE_RESETSEQ << REG_SEQCLKMODE |
                    PLE_RESETSEQ << REG_SEQMEMMODE},
               #ifdef COMPAQ
                {PORT_COMPAQ_CTRL,
                    0,
                    NULL,
                    &VDMData.regCompaqCtrl},
               #endif
                {PORT_GDCPOS2,
                    0,
                    NULL,
                    &VDMData.regGDCPos2},
                {PORT_GDCPOS1,
                    0,
                    NULL,
                    &VDMData.regGDCPos1},
                {PORT_GDCINDX,
                    TOTAL_IBM_GDCREGS,
                    &VDMData.regGDCIndx,
                    &VDMData.aregGDCData[0],
                    PLE_RESETSEQ << REG_GDCMISC},
                {PORT_COLRCRTINDX + PORTF_COLRMONO + PORTF_CRTCTRL,
                    TOTAL_IBM_CRTREGS,
                    &VDMData.regCRTIndx,
                    &VDMData.aregCRTData[0]},
                {PORT_COLRFEATURE + PORTF_COLRMONO,
                    0,
                    NULL,
                    &VDMData.regFeature},
                {0}
};


 /*
 ** list of untrapped ports for EGA
 */

CONST PLE apleNoTrap[] =
{
               #ifdef COMPAQ
                {PORT_COMPAQ_CTRL,
                    0,
                    NULL,
                    &VDMData.regCompaqCtrl},
               #endif
                {0}
};

#endif


#ifdef VGA

CONST PLE apleAll[] =
{
                #ifdef SVGA                                       /*            */
                {0x2100 + AXGA_OPERATING_MODE,                    /*            start */
                    0,
                    NULL,
                    &VDMData.aregXGAData[AXGA_OPERATING_MODE]},
                {0x2100 + AXGA_APERTURE_CONTROL,
                    0,
                    NULL,
                    &VDMData.aregXGAData[AXGA_APERTURE_CONTROL]},
                {0x2100 + AXGA_APERTURE_INDEX,
                    0,
                    NULL,
                    &VDMData.aregXGAData[AXGA_APERTURE_INDEX]},   /*            end */
                #endif                                            /*            */
                {PORT_ATC0 +                          /* 3C0h (R/W) */
                 PORTF_INDEXDATA,                     /* both Index and Data */
                    TOTAL_IBM_ATCREGS,                /* 15h registers */
                    &VDMData.regATCIndx,
                    &VDMData.aregATCData[0],
                    0,
                    PLE_WAITVERT << REG_ATCMODECTRL},
                {PORT_MISCOUT,                        /* 3C2h (W/O) */
                    0,                                /* non-Index register */
                    NULL,
                    &VDMData.regMiscOut},
                {PORT_SEQINDX,                        /* 3C4h (R/W) */
                    TOTAL_IBM_SEQREGS,                /* 05h registers */
                    &VDMData.regSEQIndx,
                    &VDMData.aregSEQData[0],
                    PLE_RESETSEQ << REG_SEQCLKMODE |
                    PLE_RESETSEQ << REG_SEQMEMMODE},
                {PORT_VGADACMASK,                     /* 3C6h (R/W) */
                    0,                                /* non-Index register */
                    NULL,
                    &VDMData.regDACMask},
                {PORT_VGADACWRITE +                   /* 3C8h (R/W) */
                 PORTF_AUTOINC,                       /* auto-increment register */
                    TOTAL_DACREGS*sizeof(DACREG),     /* 256 (R,G,B) values */
                    &VDMData.regDACIndx,
                    &VDMData.adacDACData[0].dac_bRed},
                {PORT_GDCINDX,                        /* 3CEh (R/W) */
                    TOTAL_IBM_GDCREGS,                /* 09h registers */
                    &VDMData.regGDCIndx,
                    &VDMData.aregGDCData[0],
                    PLE_RESETSEQ << REG_GDCMISC,
                    PLE_WAITVERT << REG_GDCMISC},
                {PORT_COLRCRTINDX +                   /* 3D4h (R/W) */
                 PORTF_COLRMONO   +                   /* becomes 3B4h when */
                                                      /*  bit 0 of MISCOUT is 0 */
                 PORTF_CRTCTRL,                       /* can be write protected */
                    TOTAL_IBM_CRTREGS,                /* 19h registers */
                    &VDMData.regCRTIndx,
                    &VDMData.aregCRTData[0]},
                {PORT_COLRFEATURE +                   /* 3DAh (R/O) */
                 PORTF_COLRMONO,                      /* becomes 3BAh when */
                                                      /*  bit 0 of MISCOUT is 0 */
                    0,
                    NULL,
                    &VDMData.regFeature},
                #ifdef SVGA                                       /*            */
                {PORT_TSENG_SEGSELECT,
                    0,
                    NULL,
                    &VDMData.regTsengSegSelect},
                {PORT_ATIVGA_INDX,
                    MAX_ATIREGS,
                    &VDMData.regATIIndx,
                    &VDMData.aregATIData[0]},
                #endif                                            /*            */
                {0}
};


 /*
 ** list of untrapped ports for VGA
 */

CONST PLE apleNoTrap[] =
{
                {PORT_GDCPOS2,                        /* 3CA (R/O) */
                    0,
                    NULL,
                    &VDMData.regFeature},
                {PORT_GDCPOS1,                        /* 3CC (R/O) */
                    0,
                    NULL,
                    &VDMData.regMiscOut},
                {PORT_SEQINDX,                        /* 3C4 (R/W) */
                    TOTAL_IBM_SEQREGS,                /*           */
                    &VDMData.regSEQIndx,
                    &VDMData.aregSEQData[0]},
                {PORT_GDCINDX,                        /* 3CEh (R/W) */
                    TOTAL_IBM_GDCREGS,                /*            */
                    &VDMData.regGDCIndx,
                    &VDMData.aregGDCData[0]},
                {PORT_VGADACMASK,                     /* 3C6h (R/W) */
                    0,
                    NULL,
                    &VDMData.regDACMask},
                {PORT_COLRCRTINDX + PORTF_COLRMONO + PORTF_CRTCTRL,
                    TOTAL_IBM_CRTREGS,                /*            */
                    &VDMData.regCRTIndx,
                    &VDMData.aregCRTData[0]},
                #ifdef SVGA
                {PORT_ATIVGA_INDX,                    /* 1CEh (R/W) */
                    MAX_ATIREGS,                      /* */
                    &VDMData.regATIIndx,
                    &VDMData.aregATIData[0]},
                {0x2100 + AXGA_OPERATING_MODE,                    /*            start */
                    0,
                    NULL,
                    &VDMData.aregXGAData[AXGA_OPERATING_MODE]},
                {0x2100 + AXGA_APERTURE_CONTROL,
                    0,
                    NULL,
                    &VDMData.aregXGAData[AXGA_APERTURE_CONTROL]},
                {0x2100 + AXGA_APERTURE_INDEX,
                    0,
                    NULL,
                    &VDMData.aregXGAData[AXGA_APERTURE_INDEX]},   /*            end */
                #endif
                {0}
};

#endif


#ifdef EGAVGA


 /*
 ** list of memory state-related ports
 */

RLE arleMemory[] =
{
                {PORT_SEQINDX | PORTF_REQUIRED,
                 REG_SEQMEMMODE, 0,
                 REGCOND_RESETSEQ,
                 SEQMEM_ODDEVENSAME,
                 {!SEQMEM_ODDEVENSAME | SEQMEM_EXTENDED,
                   SEQMEM_ODDEVENSAME | SEQMEM_EXTENDED,
                   SEQMEM_ODDEVENSAME | SEQMEM_EXTENDED,
                   SEQMEM_ODDEVENSAME | SEQMEM_EXTENDED | SEQMEM_CHAIN4},
                 &VDMData.regSEQIndx,
                 &VDMData.aregSEQData[REG_SEQMEMMODE],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX | PORTF_REQUIRED,
                 REG_GDCMISC, 0,
                 REGCOND_RESETSEQ,
                 GDCMISC_ODDTOEVEN | GDCMISC_ADDRMASK,
                 { GDCMISC_ODDTOEVEN | GDCMISC_64K_A0000,   /* MEMMODE_TEXT */
                  !GDCMISC_ODDTOEVEN | GDCMISC_64K_A0000,   /* MEMMODE_FONT */
                  !GDCMISC_ODDTOEVEN | GDCMISC_64K_A0000,   /* MEMMODE_GRFX */
                  !GDCMISC_ODDTOEVEN | GDCMISC_64K_A0000},  /* MEMMODE_GRFX256 */
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCMISC],
                 NULL,
                 NULL,
                },
                {PORT_SEQINDX | PORTF_REQUIRED,
                 REG_SEQMAPMASK, 0,
                 0,
                 SEQMAP_ALL,
                 {SEQMAP_PLANE0|SEQMAP_PLANE1,
                  SEQMAP_PLANE2,
                  SEQMAP_ALL,
                  SEQMAP_ALL},
                 &VDMData.regSEQIndx,
                 &VDMData.aregSEQData[REG_SEQMAPMASK],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX,
                 REG_GDCSR, 0,
                 0,
                 GDCSR_ALL,
                 {0x00, 0x00, 0x00, 0x00},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCSR],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX | PORTF_REQUIRED,
                 REG_GDCESR, 0,
                 0,
                 GDCESR_ALL,
                 {0x00, 0x00, 0x00, 0x00},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCESR],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX,
                 REG_GDCCLRCMP, 0,
                 0,
                 GDCCLRCMP_ALL,
                 {0x00, 0x00, 0x00, 0x00},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCCLRCMP],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX | PORTF_REQUIRED,
                 REG_GDCROTATE, 0,
                 0,
                 GDCROTATE_ALL,
                 {0x00, 0x00, 0x00, 0x00},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCROTATE],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX | PORTF_REQUIRED,
                 REG_GDCREADMAP, 0,
                 0,
                 GDCREADMAP_ALL,
                 {PLANE0, PLANE2, 0x00, 0x00},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCREADMAP],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX | PORTF_REQUIRED,
                 REG_GDCMODE, 0,
                 0,
                 GDCMODE_WRITE3 | GDCMODE_READ1 | GDCMODE_ODDEVENDIFF,
                 { GDCMODE_WRITE0 |
                    GDCMODE_READ0 |
                     GDCMODE_ODDEVENDIFF,
                   GDCMODE_WRITE0 |
                    GDCMODE_READ0 |
                    !GDCMODE_ODDEVENDIFF,
                   GDCMODE_WRITE0 |
                    GDCMODE_READ0 |
                    !GDCMODE_ODDEVENDIFF,
                   GDCMODE_WRITE0 |
                    GDCMODE_READ0 |
                    !GDCMODE_ODDEVENDIFF |
                      GDCMODE_256COLOR},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCMODE],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX,
                 REG_GDCDONTCARE, 0,
                 0,
                 GDCDONTCARE_ALL,
                 {0x00, 0x00, 0x00, 0x00},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCDONTCARE],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX | PORTF_REQUIRED,
                 REG_GDCBITMASK, 0,
                 0,
                 GDCBITMASK_ALL,
                 {GDCBITMASK_ALL, GDCBITMASK_ALL, GDCBITMASK_ALL, GDCBITMASK_ALL},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCBITMASK],
                 NULL,
                 NULL,
                },
#ifdef SVGA                                                     //          
                {PORT_ATIVGA_INDX | PORTF_REQUIRED | PORTF_NOTRAP | PORTF_SVGA, /* 1CEh (R/W) */
                 0xB0, 0,
                 0,
                 0xF6,
                 {0x08,0x08,0x09,0x28},
                 &VDMData.regATIIndx,
                 &VDMData.aregATIData[0xB0],
                 NULL,
                 NULL,
                },
#endif
                {0}
};



 /*
 ** list of pointer state-related ports
 */

RLE arlePtrState[] =
{
                {PORT_SEQINDX | PORTF_REQUIRED,
                 REG_SEQMAPMASK, 0,     /* this MUST be the 1st entry! */
                 0,                     /* see vvPtrCopyPtrSaveToScreen for why */
                 SEQMAP_ALL,
                 {SEQMAP_ALL, SEQMAP_PLANE0, SEQMAP_ALL},
                 &VDMData.regSEQIndx,
                 &VDMData.aregSEQData[REG_SEQMAPMASK],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX | PORTF_REQUIRED,
                 REG_GDCESR, 0,
                 0,
                 GDCESR_ALL,
                 {0x00, 0x00, 0x00},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCESR],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX | PORTF_REQUIRED,
                 REG_GDCROTATE, 0,
                 0,
                 GDCROTATE_ALL,
                 {0x00, 0x00, 0x00},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCROTATE],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX | PORTF_REQUIRED,
                 REG_GDCMODE, 0,        /* this MUST be the 4th entry! */
                 0,                     /* see vvPtrPutPointerInScrSave for why */
                 GDCMODE_WRITE3 | GDCMODE_READ1 | GDCMODE_ODDEVENDIFF,
                 { GDCMODE_WRITE1 |
                    GDCMODE_READ0 |
                     !GDCMODE_ODDEVENDIFF,
                   GDCMODE_WRITE1 |
                    GDCMODE_READ0 |
                     !GDCMODE_ODDEVENDIFF,
                   GDCMODE_WRITE0 |
                    GDCMODE_READ0 |
                     GDCMODE_ODDEVENDIFF},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCMODE],
                 NULL,
                 NULL,
                },
                {PORT_GDCINDX | PORTF_REQUIRED,
                 REG_GDCBITMASK, 0,
                 0,
                 GDCBITMASK_ALL,
                 {GDCBITMASK_ALL, GDCBITMASK_ALL, GDCBITMASK_ALL},
                 &VDMData.regGDCIndx,
                 &VDMData.aregGDCData[REG_GDCBITMASK],
                 NULL,
                 NULL,
                },
                {0}
};

#endif


 /*
 ** Other global data
 **
 **  pPhysVRAM is a global address giving us access to all physical VRAM,
 **  which lets us play with physical video memory whenever we please (although
 **  we will NEVER do so except on behalf of a foreground VDM).
 **
 **  pvdmPhysVRAM contains the physical address of VRAM as it should appear
 **  within each VDM.  Since we don't virtualize non-native video hardware,
 **  this is the same as the actual physical address of system VRAM.
 **
 **  npgPhysVRAM is the no. of pages that physical VRAM extends across.  All
 **  the video hardware we support uses single, contiguous ranges of physical
 **  memory for VRAM.
 **
 **  npgPlane is the size of each video plane, in pages.  This is the size that
 **  each plane in our virtual video buffer is grown to when a VDM has been
 **  switched foreground.
 */

#ifndef EGAVGA
FLAGS   flVVD = VVD_GRFXALLOWED;        /* VVD flags (for CGA and MONO) */
#endif

ULONG   ulAdapter = ADAPTER_IBM;        /* adapter type */

PSZ     pszVVDName = NULL;

PBYTE   pPhysVRAM = (PBYTE)NULL;        /* global pointer to physical VRAM */

PBVDM   pvdmPhysVRAM =(PBVDM)VRAM_START;/* address of physical VRAM range */

                                        /* # of pages in physical VRAM range */
ULONG   npgPhysVRAM = PAGESFROMBYTES(VRAM_LEN);

ULONG   npgPlane = MAX_PAGESPERPLANE;   /* # of pages in every plane */

#ifdef EGAVGA
HMXSEM  hmxPhysLatch = (HMXSEM)0;       /* controls access to latch data */
#endif

LSENTRY lseHeadActive;                  /* head of active VDM list */

HVDM    hvdmFocus;                      /* handle of focus VDM, if any */

HVDM    hvdmUpdate;                     /* handle of next VDM to update (temp.) */

ULONG   nWindowedEvents = 0;            /* total outstanding events */

HMXSEM  hmxWindowedEvent = (HMXSEM)0;   /* controls access to video event data */

HEVSEM  hevWindowedEvent = (HEVSEM)0;   /* cleared when a video event is posted */

ULONG   nWindowedVDMs = 0;              /* total current windowed VDMs */
ULONG   nPMWindowedVDMs = 0;            /* total VDMs being windowed by PM */
ULONG   nMinWindowedVDMs = 0;           /* total VDMs windowed but minimized */

HHOOK   hhookEventTimer;                /* hook handle for VVEventTimer */

PBOOL   pflVDMBusy = NULL;              /* offset to VKBD WakeIdle Flag               */

ULONG   npgActive[] =                                                   /*            */
{                                                                       /*            */
  EGAVGAMEM_PAGES,                                                      /*            */
  EGAVGAMEM_PAGES/2,                                                    /*            */
  MONOMEM_PAGES*2,                      /* EGA has x2 VRAM                            */
  CGAMEM_PAGES*2,                       /* EGA has x2 VRAM                            */
};                                                                      /*            */

#ifdef SVGA                                             /*            */

ULONG   ulSVGAChipType = 0;                             /*            */
ULONG   ulSVGAAdapterType = 0;                          /*            */
ULONG   ulSVGAVRAMSize = 0;                             /*            */
ULONG   ulSVGADACFamily = DEFAULT_DAC;                  /*            */
OEMSVGAINFO sSVGA;                                      /*            */
OEMINFO sOEMData;                                       /*            */
BOOL    fPMIProcessed = FALSE;                          /*            */
BOOL    fPMILoaded = FALSE;                             /*            */
BOOL    fSeqFixups = TRUE;                              /*            */
ULONG   ulNumLockCmds = 0;                              /*            */
ULONG   ulNumUnLockCmds = 0;                            /*            */
USHORT  ausLockReg[MAX_LOCKUNLOCKCMD] = {0};            /*            */
USHORT  ausLockCmd[MAX_LOCKUNLOCKCMD] = {0};            /*            */
USHORT  ausUnLockReg[MAX_LOCKUNLOCKCMD] = {0};          /*            */
USHORT  ausUnLockCmd[MAX_LOCKUNLOCKCMD] = {0};          /*            */

CLEANDATA CleanData[MAX_CLEANDATA] = {0};               /*            */
ULONG  ulWD_MASK_GDCLOCK  = 0;                          /*            */
ULONG  ulWD_MASK_CRTLOCK  = 0;                          /*            */
ULONG  ulWD_MASK_SEQLOCK  = 0;                          /*            */

 /*
 **
 **  These bit masks determine which indexed registers in each group
 **  are saved/restored. They are initialised to standard VGA registers
 **  and modified during the PMI file parsing to reflect the particular
 **  adapter's extended registers. Note, each array must end with a zero
 **  which will fill the un-initialised elements.
 */

BYTE    abCRTMask[32] = {0xff, 0xff, 0xff, 0x01, 0};    /*  25 registers             */
BYTE    abGDCMask[32] = {0xff, 0x01, 0};                /*   9                       */
BYTE    abSEQMask[32] = {0x1f, 0};                      /*   5 registers             */
BYTE    abATCMask[32] = {0xff, 0xff, 0x1f, 0};          /*  21                       */

#ifdef ATI
BYTE    abATIMask[32] = {0};                            /*            */
#endif

ULONG   ulXGAInstance;                                  /* where it is               */

BOOL    flBgndExecSupported = FALSE;                    /*            */

PFNSVGASETBANK apfnSVGASetBank[] =
{
        vvNOPSetBank,
        vvVideo7SetBank,
        vvTridentSetBank,
        vvTsengSetBank,
        vvWDSetBank,
        vvATISetBank,
        vvIBMSetBank,                                                   /*            */
        vvCirrusSetBank,                                                /*            */
        vvS3SetBank,                                                    /*            */
};

PFNSVGAGETBANK apfnSVGAGetBank[] =
{
        vvNOPGetBank,
        vvVideo7GetBank,
        vvTridentGetBank,
        vvTsengGetBank,
        vvWDGetBank,
        vvATIGetBank,
        vvIBMGetBank,                                                   /*            */
        vvCirrusGetBank,                                                /*            */
        vvS3GetBank,                                                    /*            */
};

#endif                                                                  /*            */


 /*  Data conversion tables
 **
 **  amstateMap maps MEMORY_* constants to MEMMODE_constants, which in
 **  turn serve as indexes in the bMode array of an rle (register list entry).
 **
 **  apstateMap maps MEMORY_* constants to PAGE_* constants.
 **
 **  abNextStatusState is sort of a condensed version of the real CGA/EGA/VGA
 **  retrace waveforms (condensed so that we make the apps think that they can
 **  write to virtual video memory much more frequently than they could if they
 **  were writing to *physical* video memory).  We can't just always have the
 **  bits ON because some apps look for the transitions that take place in the
 **  actual hardware, and a few apps even look for particular durations.  The
 **  longest expected duration I've seen is 10 consecutive horizontal retraces,
 **  so be sure the table always has at least that many;  it's probably also
 **  best if the table have mixed odd- and/or prime-sized sequences, to
 **  reduce the risk of falling into infinite sync with some piece of complex
 **  retrace logic.  If that still somehow happens, then the user will simply
 **  have to turn off retrace emulation.
 */

CONST MSTATE amstateMap[] =
{
    -1,                                 /* MEMORY_NONE (invalid) */
    MEMMODE_TEXT,                       /* MEMORY_TEXT */
    MEMMODE_FONT,                       /* MEMORY_FONT */
    MEMMODE_TEXT,                       /* MEMORY_CGAX */
    MEMMODE_GRFX,                       /* MEMORY_GRFX */
    MEMMODE_GRFX,                       /* MEMORY_GRFX2 */
    MEMMODE_GRFX256,                    /* MEMORY_GRFX256 */
};

CONST PSTATE apstateMap[] =
{
    PAGE_NONE,                          /* MEMORY_NONE (invalid) */
    PAGE_TEXT,                          /* MEMORY_TEXT */
    PAGE_FONT,                          /* MEMORY_FONT */
    PAGE_CGAX,                          /* MEMORY_CGAX */
    PAGE_GRFX,                          /* MEMORY_GRFX */
    PAGE_GRFX,                          /* MEMORY_GRFX2 */
    PAGE_GRFX256,                       /* MEMORY_GRFX256 */
};

CONST BYTE  abNextStatusState[] =       /* see comments above */
{
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    0,
    STATUS1_HORZRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC,
    0xff                                /* end of table marker */
};


 /*  Adapter-specific data
 **
 **  For the Genoa SuperVGA (model 5100), their ROM relies on obtaining
 **  the true setting of an undocumented register (Sequencer register #7)
 **  in order to initialize properly as a VGA.  We don't have to do anything
 **  special when the VDM is initializing in full-screen mode, because the
 **  I/O access goes to the real hardware;  but when a windowed VDM is
 **  created, we don't know how to virtualize that register, so the ROM
 **  mistakenly initializes the card as an EGA, and any attempt to make the
 **  VDM full-screen later really screws the display up (even when you try to
 **  switch back to PM).  The simplest workaround is to record the values of
 **  all the registers during initialization, and stuff them into the per-VDM
 **  data every time we create a new VDM.
 */

#ifdef VGA
BYTE    aregSEQInit[MAX_SEQREGS];
BYTE    aregGDCInit[MAX_GDCREGS];                                       /*            */
BYTE    aregCRTInit[MAX_CRTREGS];                                       /*            */
                                                   /* Set bit 0 if present, set bit 1 */
ULONG   flXGAPresent = 0;                          /* to show test done.              */
#endif

 /*
 **  ATI extended registers, range 0xa0-0xbf expect some intial values to
 **  be set. This array is initialised at vvinit time.
 */

#ifdef SVGA
BYTE    aregATIInit[ATI_TOTAL_INITREGS];
#endif


 /*
 **  Mouse data
 **
 **  hvddMouse will contain a handle to the VMD (virtual mouse driver) if it
 **  is installed. It is set up during the first VDM creation, in case we were
 **  installed BEFORE the mouse driver.
 **
 **  vmreg defines, for the VMDEVREQ_REGISTER command, our mouse services
 **  entry points, which the VMD will use at interrupt-time and/or task-time to
 **  manage the video pointer image.
 **
 **  vmfunc, if filled in by the VMD, contains the address of a mouse status
 **  query function, which we will call whenever a light-pen INT 10h request is
 **  made AND the VMD has enabled emulation (ie, PTR_LPENEM is set).
 */

HVDD  hvddMouse = NULL;                 /* non-zero if registered with mouse */


VMREG vmreg =
{
    sizeof(VMREG),
    VVShowPtr,
    VVHidePtr,
    VVDefineTextPtr,
    VVDefineGraphPtr,
    VVSetPtrPage,
    VVSetLPenEmulation,
};

VMFUNC vmfunc =
{
    sizeof(VMFUNC),
    NULL,
};

#ifdef  GALE                                                            //J-TS00V
/***LT+ VFNTV data                                                      //J-TS00V
 *                                                                      //J-TS00V
 *  hvddVfontV will contain a handle to the VMD (virtual font driver)   //J-TS00V
 *  if it is installed. It is set up during the first VDM creation,     //J-TS00V
 *  in case we were installed BEFORE the font driver.                   //J-TS00V
 *                                                                      //J-TS00V
 *  vfvfunc, if filled in by the VFNTV, contains the addresses of       //J-TS00V
 *  font functions to get SBCS/DBCS 16/24 font.                         //J-TS00V
 */                                                                     //J-TS00V
                                                                        //J-TS00V
HVDD  hvddVfontV = NULL;        // non-zero if registered with vfontv   //J-TS00V
                                                                        //J-TS00V
BOOL  (PRIVENTRY *vfvfunc[VFNTV_FUNC_ENTRY_COUNT])();                   //J-TS00V
                                                                        //J-TS00V
/*end*/                                                                 //J-TS00V
#endif  //GALE                                                          //J-TS00V


 /*
 **  Windowed multi-plane graphics data
 **
 **  ahPhysPage describes current off-screen memory consumption.  -1
 **  indicates the page is reserved and cannot be used;  0 indicates an
 **  available page, 1..4096 indicates the page was allocated to PM (and
 **  how many bytes from the top of the page PM allocated), and anything
 **  else better be a VDM handle (of the VDM using the page).
 **
 **  aiPhysToVirt maps each physical page to the virtual page in the VDM
 **  whose handle is stored in ahPhysPage.
 **
 **  atimePhysPageAlloc records the last time the corresponding physical
 **  page was assigned to a VDM.
 */

#ifdef EGAVGA
ULONG   ahPhysPage[MAX_PAGESPERPLANE];
ULONG   aiPhysToVirt[MAX_PAGESPERPLANE];
ULONG   atimePhysPageAlloc[MAX_PAGESPERPLANE];

HMXSEM  hmxPhysPageEvent = (HMXSEM)0;   /* controls access to physpage data */

PBYTE   pbSEQExtShadowIndx;             /* pointers to external shadow bytes */
PRLE    prleSEQExtShadowData[MAX_SEQREGS];
PBYTE   pbGDCExtShadowIndx;
PRLE    prleGDCExtShadowData[MAX_GDCREGS];

#endif


 /*
 ** Define array of function addresses for DosRequestVDD services
 */


PSYSFUN apfnSysReq[VVDSYSREQ_MAX] =
{
    vvSysSetAccess,
    vvSysSetFocus,
    vvSysSetLock,
    vvSysQueryMode,
    vvSysQueryCursor,
    vvSysQueryPalette,
    vvSysCopyLVB,
    vvSysCopyBitmap,
    vvSysWaitEvent,
    vvSysControlEvent,
    vvSysSetDisplayReq,
    vvSysRequestMemory,
    vvSysFreeMemory,
    vvSysRequestController,
    vvSysFreeController,
    vvSysQueryVRAMStatus,
    vvSysSetOEMFlag                                                     /*            */
};


 /*
 ** Define array of function addresses for VDHRequestVDD services
 */


PDEVFUN apfnDevReq[VVDDEVREQ_MAX] =
{
    vvDevPostPeek,
    vvDevPostRead,
    vvDevPostPaste,
    vvDevPostMouse,
    vvDevAcceptAdapter,
    vvDevReleaseAdapter,
    vvDevAcceptDisplay,
    vvDevReleaseDisplay,
    (PDEVFUN)vvDevPostVideoEvent,
    vvDevSaveRestoreAdapter,                                            /*            */
    vvDevRepaint,                                                       /*            */
    vvDevRequestController,                                             /*            */
    vvDevFreeController,                                                /*            */
    vvDevWindowsDeskTop,                                                /*            */
    vvDevEnableDDE,                                                     /*            */
    vvDevXGAPresent,                                                    /*            */
    vvDevUnmapVRAM,                                                     /*            */
    vvDev8514Present                                                    /*            */
};


#ifdef VDDSTRICT

#if   defined(SVGA)
CHAR szAssertMsg[] = "VSVGA assertion failure in %s, line %d\n";
#elif defined(CGA)
CHAR szAssertMsg[] = "VCGA assertion failure in %s, line %d\n";
#elif defined(EGA)
CHAR szAssertMsg[] = "VEGA assertion failure in %s, line %d\n";
#elif defined(VGA)
CHAR szAssertMsg[] = "VVGA assertion failure in %s, line %d\n";
#elif defined(MONO)
CHAR szAssertMsg[] = "VMONO assertion failure in %s, line %d\n";
#endif

#endif


#ifdef VDDDEBUG

#if   defined(SVGA)
CHAR szModule[] = "VSVGA: ";
#elif defined(CGA)
CHAR szModule[] = "VCGA: ";
#elif defined(EGA)
CHAR szModule[] = "VEGA: ";
#elif defined(VGA)
CHAR szModule[] = "VVGA: ";
#elif defined(MONO)
CHAR szModule[] = "VMONO: ";
#endif
CHAR *apszPageStates[] = {"NONE", "TEXT", "FONT", "CGAX", "GRFX", "NULL"};

#endif

#ifdef  XVIO                                                            //J-TS00V
HVDD  hvddVXVIO = NULL;                                                 //J-TS00V
VXREGISTER XVIOEntry;                                                   //J-TS00V
VXENTRYSV VVDEntry = {                                                  //J-TS00V
    vxGetCursor,                                                        //J-TS00V
    vxSetCursor,                                                        //J-TS00V
    vxCopyLVB,                                                          //J-TS00V
    vxWriteString,                                                      //J-TS00V
    vxSaveScreen,                                                       //J-TS00V
    vxRestoreScreen                                                     //J-TS00V
};                                                                      //J-TS00V
#endif  //XVIO                                                          //J-TS00V
                                                                        //J-TS00V
#ifdef  VTEXT                                                           //J-TS00V
BOOL  (PRIVENTRY *VtextNotify)() = NULL;                                //J-TS00V
#endif  //VTEXT                                                         //J-TS00V

#pragma END_SWAP_DATA



#pragma BEGIN_GLOBAL_DATA

#ifdef EGAVGA

FLAGS   flVVD = VVD_GRFXALLOWED;        /* VVD flags */

#ifdef  GALE                                                            //J-TS00V
CONST PRINT_BOX_PATTERN PrtBoxPattern[] = {                             //J-TS00V
    {  5, { 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 } },         //J-TS00V
    { 13, { 0x03, 0x02, 0x03, 0x02, 0x01, 0x03, 0x01, 0x03 } },         //J-TS00V
    { 20, { 0x02, 0x03, 0x02, 0x03, 0x01, 0x02, 0x01, 0x02 } },         //J-TS00V
    { 28, { 0x02, 0x01, 0x02, 0x01, 0x01, 0x02, 0x01, 0x02 } },         //J-TS00V
    { 36, { 0x02, 0x00, 0x02, 0x00, 0x01, 0x02, 0x01, 0x02 } },         //J-TS00V
    { 47, { 0x02, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00 } },         //J-TS00V
    { 58, { 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 } },         //J-TS00V
    { 63, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } }          //J-TS00V
};                                                                      //J-TS00V
                                                                        //J-TS00V
CONST MODEDATATABLE ModeDataTableGale[] = {                             //J-TS00V
      {0x03, {14, 1, 4, 80, 25, 640, 475,    0, 1}}, // CGA text            //J-TS00V
      {0x73, {14, 1, 4, 80, 25, 640, 475, 0x70, 3}}, // extended CGA text   //J-TS00V
#ifdef  VTEXT                                                               //J-TS00V
      {0x70, {14, 1, 4, 80, 25, 640, 475,    0, 1}}, // CGA text            //J-TS00V
      {0x71, {14, 1, 4, 80, 25, 640, 475, 0x70, 3}}, // extended CGA text   //J-TS00V
#endif  //VTEXT                                                             //J-TS00V
      {0x11, {14, 3, 1, 80, 30, 640, 480,    0, 1}}, // mono graphics       //J-TS00V
      {0x12, {14, 3, 4, 80, 30, 640, 480,    0, 1}}, // color graphics      //J-TS00V
      {0x72, {14, 3, 4, 80, 25, 640, 480,    0, 1}}, // ext color graphics  //J-TS00V
      {0}                                   //end mark                  //J-TS00V
};                                                                      //J-TS00V
#endif  //GALE                                                          //J-TS00V

HVDM    hvdmController = NULL;          /* handle of owning VDM, NULL if none */
HEVSEM  hevControllerEvent = (HEVSEM)0;
#ifdef VGA                                                              /*            */
FLAGS      flNotifyType = NULL;                                         /*            */
PFNINT2FP  pfnInt2FProc = (PFNINT2FP)0;                                 /*            */
ULONG   pfOEMFlags = NULL;              /* pointer to OEM flag                        */
#endif                                                                  /*            */
VVDRQ   vvdrqVideo = {0, ALL_RESERVED, NULL, 0, NULL, NULL, 0, NULL};

#endif

#ifdef VDDDEBUG                                                         /*75466*/
BYTE vvDebugInfo[128*5*2]; /* 128 bytes for 5 slots with 2 save areas *//*75466*/
#endif                                                                  /*75466*/

#pragma END_GLOBAL_DATA
