;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    ,132
        TITLE   Virtual Video DAC I/O Processing

;/*****************************************************************************
;*
;* SOURCE FILE NAME = VVDACIO.ASM
;*
;* DESCRIPTIVE NAME = Virtual Video Device Driver DAC I/O Processing 
;*
;*
;* VERSION      V2.0
;*
;* DATE         11/10/88
;*
;* DESCRIPTION  This module contains the VVD's DAC I/O handlers. 
;*              
;* FUNCTIONS    VVWriteDACReadFgnd()      Write DAC read-index foreground
;*              VVWriteDACReadBgnd()      Write DAC read-index background
;*              VVWriteDACWriteFgnd()     Write DAC write-index foreground
;*              VVWriteDACWriteBgnd()     Write DAC write-index background
;*              VVReadDACDataFgnd()       Read DAC data byte foreground
;*              VVReadDACDataBgnd()       Read DAC data byte background
;*              VVWriteDACDataFgnd()      Write DAC data byte foreground
;*              VVWriteDACDataBgnd()      Write DAC data byte background
;*              VVReadDACMaskBgnd()       Read DAC mask byte background
;*              VVWriteDACMaskBgnd()      Write DAC mask byte
;*              VVReadDACStateBgnd()      Read DAC state
;*              VVReadDACIndxBgnd()       Read DAC index
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*   11/10/88                     JTP - Created.
;*
;*   02/27/92                     B733211 - Performance enhancement to
;*                                          320x200 mode.
;*****************************************************************************/


        .xlist
        include mvdm.inc
        include vddseg.inc
        .list
        include vvd.inc
        include vvdp.inc


        DefCode     EXPORT,SWAP,PASCAL

       IFDEF VGA
        DefFn       VVWriteDACReadFgnd
        DefFn       VVWriteDACReadBgnd
        DefFn       VVWriteDACWriteFgnd
        DefFn       VVWriteDACWriteBgnd
        DefFn       VVReadDACDataFgnd
        DefFn       VVReadDACDataBgnd
        DefFn       VVWriteDACDataFgnd
        DefFn       VVWriteDACDataBgnd
        DefFn       VVReadDACMaskBgnd
        DefFn       VVWriteDACMaskBgnd
        DefFn       VVReadDACStateBgnd
        DefFn       VVReadDACIndxBgnd
       ENDIF


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVWriteDACReadFgnd()
;*
;* DESCRIPTION   = Write DAC read-index foreground
;*
;*                 This registered subroutine is called whenever a foreground
;*                 VDM writes a byte to the DAC read-index register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = AL == data to write
;*                 EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACREAD)
;*
;* OUTPUT        = None
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;* PSEUDO-CODE
;*                 update hardware
;*                 update DAC index value
;*                 set DAC state to read mode, state 0
;*                 set DAC data register and auto-increment index
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVWriteDACReadFgnd
        OUTB    dx,al                       ;output DAC index to read
        FallInto VVWriteDACReadBgnd
EndProc   VVWriteDACReadFgnd

       ENDIF ;VGA


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVWriteDACReadBgnd()
;*
;* DESCRIPTION   = Write DAC read-index background 
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM writes a byte to the DAC read-index register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = AL == data to write
;*                 EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACREAD)
;*
;* OUTPUT        = None
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;* PSEUDO-CODE
;*                 update DAC index value
;*                 set DAC state to read mode, state 0
;*                 set DAC data register and auto-increment index
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVWriteDACReadBgnd
        FallFrom VVWriteDACReadFgnd
        mov     VDMData.regDACIndx,al       ;stash DAC index to read
        mov     ecx,DAC_READ or DAC_DATA2   ;set DATA2 to force auto-increment
        mov     VDMData.stateDAC,ecx
        jmp     short vvAdvanceDACReadState
EndProc   VVWriteDACReadBgnd

       ENDIF ;VGA


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVWriteDACWriteFgnd()
;*
;* DESCRIPTION   = Write DAC write-index foreground 
;*
;*                 This registered subroutine is called whenever a foreground
;*                 VDM writes a byte to the DAC write-index register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = AL == data to write                  
;*                 EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACWRITE)
;*
;* OUTPUT        = None
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;* PSEUDO-CODE
;*                 update hardware
;*                 update DAC index value
;*                 set DAC state to write mode, state 0
;*                 
;**************************************************************************/

        align   4                                                       ;          
Procedure VVWriteDACWriteFgnd
        OUTB    dx,al                       ;output DAC index to write
        FallInto VVWriteDACWriteBgnd
EndProc   VVWriteDACWriteFgnd

       ENDIF ;VGA


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVWriteDACWriteBgnd()
;*
;* DESCRIPTION   = Write DAC write-index background 
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM writes a byte to the DAC write-index register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = AL == data to write
;*                 EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACWRITE)
;*
;* OUTPUT        = None
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;* PSEUDO-CODE
;*                 update DAC index value
;*                 set DAC state to write mode, state 0
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVWriteDACWriteBgnd
        FallFrom VVWriteDACWriteFgnd
        mov     VDMData.regDACIndx,al       ;stash DAC index to write
        mov     VDMData.stateDAC,DAC_WRITE or DAC_DATA0
        ExitProc
EndProc   VVWriteDACWriteBgnd

       ENDIF ;VGA


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVReadDACDataFgnd()
;*
;* DESCRIPTION   = Read DAC data byte foreground 
;*
;*                 This registered subroutine is called whenever a foreground
;*                 VDM reads a byte from the DAC data register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACDATA)
;*
;* OUTPUT        = AL  == data read
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;* PSEUDO-CODE
;*                 read hardware
;*                 advance DAC state
;*                             
;**************************************************************************/

        align   4                                                       ;          
Procedure VVReadDACDataFgnd
        INB     al,dx                       ;get the requested DAC data
        movzx   ecx,byte ptr VDMData.stateDAC
        jmp     short vvAdvanceDACReadState
EndProc   VVReadDACDataFgnd

       ENDIF ;VGA


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVReadDACDataBgnd()
;*
;* DESCRIPTION   = Read DAC data byte background
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM reads a byte from the DAC data register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACDATA)
;*
;* OUTPUT        = AL  == data read
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;* PSEUDO-CODE
;*                 read DAC data register
;*                 advance DAC state
;*                 load DAC data register from color table if
;*                 auto-incrementing
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVReadDACDataBgnd
        movzx   ecx,byte ptr VDMData.stateDAC
        mov     al,VDMData.dacDACDataCur[ecx];get the requested DAC data
        and     al,3Fh                      ;return only bits known to be valid
Entry     vvAdvanceDACReadState
        inc     ecx
        cmp     cl,DAC_DATA2
        jbe     short vvrdd_noinc
        movzx   edx,VDMData.regDACIndx      ;get DAC index
        mov     ecx,edx                     ;auto-increment it
        inc     ecx
        mov     VDMData.regDACIndx,cl
        .ERRNZ  MAX_DACREGS-1 NE 0FFh
        lea     edx,[edx+edx*2]             ;EDX == EDX * 3
        mov     ecx,dword ptr VDMData.adacDACData[edx]
        mov     word ptr VDMData.dacDACDataCur,cx
        ror     ecx,16
        mov     byte ptr VDMData.dacDACDataCur[2],cl
        or      VDMData.flVDMVideo,VDM_DIRTYPALETTE
        sub     ecx,ecx
        .ERRNZ  DAC_DATA0 NE 0
vvrdd_noinc:
        mov     byte ptr VDMData.stateDAC,cl
        ExitProc
EndProc   VVReadDACDataBgnd

       ENDIF ;VGA


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVWriteDACDataFgnd()
;*
;* DESCRIPTION   = Write DAC data byte foreground
;*
;*                 This registered subroutine is called whenever a foreground
;*                 VDM writes a byte to the DAC data register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         =  AL == data to write
;*                 EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACDATA)
;*
;* OUTPUT        = None
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;* PSEUDO-CODE
;*                 update hardware
;*                 fall into background logic
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVWriteDACDataFgnd
        OUTB    dx,al
        FallInto VVWriteDACDataBgnd
EndProc   VVWriteDACDataFgnd

       ENDIF ;VGA


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVWriteDACDataBgnd()
;*
;* DESCRIPTION   = Write DAC data byte background
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM writes a byte to the DAC data register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = AL == data to write
;*                 EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACDATA)
;*
;* OUTPUT        = None
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;* PSEUDO-CODE
;*                 write DAC data register
;*                 advance DAC state
;*                 transfer DAC data to color table if auto-incrementing
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVWriteDACDataBgnd
        movzx   ecx,byte ptr VDMData.stateDAC
        mov     VDMData.dacDACDataCur[ecx],al
        inc     ecx
        cmp     cl,DAC_DATA2
        jbe     short vvwdd_noinc
        movzx   edx,VDMData.regDACIndx      ;get DAC index
        mov     ecx,edx                     ;auto-increment it
        inc     ecx
        mov     VDMData.regDACIndx,cl
        .ERRNZ  MAX_DACREGS-1 NE 0FFh
        lea     edx,[edx+edx*2]             ;EDX == EDX * 3
        mov     ecx,dword ptr VDMData.dacDACDataCur
        mov     word ptr VDMData.adacDACData[edx],cx
        ror     ecx,16
        mov     byte ptr VDMData.adacDACData[edx+2],cl
        or      VDMData.flVDMVideo,VDM_DIRTYPALETTE
        sub     ecx,ecx
        .ERRNZ  DAC_DATA0 NE 0
vvwdd_noinc:
        mov     byte ptr VDMData.stateDAC,cl
        ExitProc
EndProc   VVWriteDACDataBgnd

       ENDIF ;VGA


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVReadDACMaskBgnd()
;*
;* DESCRIPTION   = Read DAC mask byte background
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM reads a byte from the DAC mask register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACMASK)
;*
;* OUTPUT        = AL  == data read                     
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVReadDACMaskBgnd
        mov     al,VDMData.regDACMask       ;return virtual DAC mask register
        ExitProc
EndProc   VVReadDACMaskBgnd

       ENDIF ;VGA


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVWriteDACMaskBgnd()
;*
;* DESCRIPTION   = Write DAC mask byte 
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM writes a byte to the DAC mask register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = AL == data to write
;*                 EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACMASK)
;*
;* OUTPUT        = None
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVWriteDACMaskBgnd
        mov     VDMData.regDACMask,al       ;update virtual DAC mask register
        ExitProc
EndProc   VVWriteDACMaskBgnd

       ENDIF ;VGA


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVReadDACStateBgnd()
;*
;* DESCRIPTION   = Read DAC state
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM reads a byte from the DAC state register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACREAD)
;*
;* OUTPUT        = AL  == data read
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;* PSEUDO-CODE
;*                 return zero if DAC state is write mode
;*                 return non-zero if DAC state is read mode
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVReadDACStateBgnd
        mov     al,byte ptr VDMData.stateDAC+1
        ExitProc
EndProc   VVReadDACStateBgnd

       ENDIF ;VGA


       IFDEF VGA

;/***************************************************************************
;*
;* FUNCTION NAME = VVReadDACIndxBgnd()
;*
;* DESCRIPTION   = Read DAC index 
;*
;*                 This registered subroutine is called whenever a background
;*                 VDM reads a byte from the DAC index register (see
;*                 VDHInstallIOHook for complete semantics).
;*
;* INPUT         = EBX -> VDM register frame
;*                 EDX == port number (PORT_VGADACWRITE)
;*
;* OUTPUT        = AL  == data read                      
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

        align   4                                                       ;          
Procedure VVReadDACIndxBgnd
        mov     al,VDMData.regDACIndx       ;return virtual DAC index register
        ExitProc
EndProc   VVReadDACIndxBgnd

       ENDIF ;VGA


        EndCode     EXPORT,SWAP,PASCAL


        END
