;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;***	Virtual Video Private Definitions for the 8514/A
;
;
;
;
;
;	DESCRIPTION
;	V8514.SYS private constants, types, and function prototypes
;
;	MODIFICATION HISTORY
;	02/07/90  JTP  Created.
;  @003 12/13/90  TPL  PTR B718889 - Complete _INT 2F notification support
;  @025 03/14/92  TPL  PTR B733768 - Remove _INT 2Fh Context Hooks
;


PROPERTIES	EQU 1		;include properties support

	include	int2f.inc		;Also			     ;0003
INT2F_SYSBGND	EQU	04001h		;    defined		     ;0003
INT2F_SYSFGND	EQU	04002h		;	    in VVDP.INC	       ;0003

MAX_HRES	EQU	1024
MAX_VRES	EQU	1024

MAX_VDM_WAIT	EQU	15000		;max screen-switch delay (ms)

MAX_DACREGS	EQU	<TOTAL_DACREGS>


ifdef SETMODE_SUPPORT

;***	Internally defined modes
;
MODE_1024x768	EQU	0
MODE_640480hx4	EQU	1
MODE_640480hx8	EQU	2

MAX_MODES	EQU	3
MAX_INITREGS	EQU	10


endif ;SETMODE_SUPPORT


;***	Per-VDM Video VDD flags (see flVDM8514)
;
;  The DEVOWNER bit is set as long as the VDD owns the device (ie,
;  is responsible for I/O trapping, buffer save/restore, etc).  It can be
;  cleared if another VDD requests the adapter from us, and set when the
;  adapter is given back.  This is to allow other VDDs to extend the
;  functionality of our VDD if they have extended modes that they need to
;  manage themselves.
;
;  The DSPOWNER bit is set if the VDD owns the display, and clear otherwise.
;  This is only important in systems where two or more adapters can drive
;  a single display (ie, planar VGA and 8514/A, with monitor connected to the
;  8514/A).  Each of the corresponding VDDs assumes a posture that corresponds
;  to the power-up configuration, and they must cooperatively request and
;  release display ownership.  On a VGA+8514/A system, when the 8514/A enters
;  "native mode" and exits "pass-thru mode", it must request display
;  ownership similarly, when returning to "pass-thru mode", it must release
;  display ownership.
;
;  Note that losing display ownership does not imply losing device ownership
;  as in the case of VGA+8514/A, even though only one of the devices can
;  drive the display at any one time, both devices are constantly active, and
;  so both VDDs must remain active as well.
;
VDM_DEVOWNER	EQU	000000002h	;VDD owns device for this VDM
VDM_DSPOWNER	EQU	000000004h	;VDD owns display for this VDM
VDM_FGND	EQU	000000008h	;VDM foreground (owns screen)
VDM_IOINIT	EQU	000000080h	;VDM I/O initialization is done
VDM_DACREADING	EQU	000000400h	;DAC color table is being read
VDM_IOOWNED	EQU	000000800h	;I/O ownership flag
VDM_IOWAKEME	EQU	000001000h	;I/O ownership notify flag
VDM_FROZEN	EQU	000020000h	;We have suspended VDM
VDM_BLOCKED	EQU	000040000h	;We have blocked VDM I/O
VDM_CONTEXTHOOK		EQU	000400000h	;VDMContext hook is armed
VDM_INT2FWAKEME		EQU	020000000h	;Int 2F completion flag	     ;0003
VDM_INT2F	EQU	040000000h	;Enable Int 2Fh notification ;0003
VDM_IOTRAPPED	EQU	080000000h	;trapping enabled at all times



INVALID_HVDM	EQU	(-2)

DefType PSYSFUN,dd
DefType PDEVFUN,dd


; NOTE: this list of registers MUST be kept in sync with aportWReg, as
;  well as the format of the aawModeInit table (see vv8514.c)
;
WREG_HORZTOTAL	EQU	0   ;private indexes into aportWReg
WREG_HORZDSP	EQU	1
WREG_HORZSSTART		EQU	2
WREG_HORZSWIDTH		EQU	3
WREG_VERTTOTAL	EQU	4
WREG_VERTDSP	EQU	5
WREG_VERTSSTART		EQU	6
WREG_VERTSWIDTH		EQU	7
WREG_DSPCTRL	EQU	8
WREG_SUBSYSCTRL		EQU	9
WREG_ROMPAGESELECT	EQU	10
WREG_ADVCTRL	EQU	11
WREG_COMMAND	EQU	12
WREG_CURRENTY	EQU	13
WREG_CURRENTX	EQU	14
WREG_DESTYAXSTP		EQU	15
WREG_DESTXDIASTP	EQU	16
WREG_ERRORTERM	EQU	17
WREG_MAJORAXISCNT	EQU	18
WREG_BGNDCOLOR	EQU	19
WREG_FGNDCOLOR	EQU	20
WREG_WRITEMASK	EQU	21
WREG_READMASK	EQU	22
WREG_COLORCOMPARE	EQU	23
WREG_BGNDMIX	EQU	24
WREG_FGNDMIX	EQU	25
WREG_SHORTSTROKE	EQU	26
WREG_PIXELTRANSFER	EQU	27
WREG_TOTAL	EQU	28

MFREG_MINORAXISCNT	EQU	(MFINDX_MINORAXISCNT	SHR  MFINDX_INDXSHIFT)
MFREG_TOPSCISSORS	EQU	(MFINDX_TOPSCISSORS	SHR  MFINDX_INDXSHIFT)
MFREG_LEFTSCISSORS	EQU	(MFINDX_LEFTSCISSORS	SHR  MFINDX_INDXSHIFT)
MFREG_BOTTOMSCISSORS	EQU	(MFINDX_BOTTOMSCISSORS	SHR  MFINDX_INDXSHIFT)
MFREG_RIGHTSCISSORS	EQU	(MFINDX_RIGHTSCISSORS	SHR  MFINDX_INDXSHIFT)
MFREG_MEMORYCTRL	EQU	(MFINDX_MEMORYCTRL	SHR  MFINDX_INDXSHIFT)
MFREG_PATTERNLOW	EQU	(MFINDX_PATTERNLOW	SHR  MFINDX_INDXSHIFT)
MFREG_PATTERNHIGH	EQU	(MFINDX_PATTERNHIGH	SHR  MFINDX_INDXSHIFT)
MFREG_PIXELCTRL		EQU	(MFINDX_PIXELCTRL	SHR  MFINDX_INDXSHIFT)


;***	DAC (Digital-to-Analog Color-lookup) states
;
;   These are the states that the DAC hardware on a VGA can be in.
;

DAC_DATA0	EQU	00000h	;ready first 1st byte of data
DAC_DATA1	EQU	00001h	;ready first 2nd byte of data
DAC_DATA2	EQU	00002h	;ready first 3rd byte of data



;***	DAC color register structure
;
;   This structure contains the 3x6 bits (total of 18 bits) that make up
;   the DAC information for one color register.
;

DefStruc ,dac_s			;dac
    _BYTE  dac_bRed
    _BYTE  dac_bGreen
    _BYTE  dac_bBlue
EndStruc DACREG
DefType PDACREG,dd			;pdac



DefType HEVSEM,HVDHSEM
DefType HMXSEM,HVDHSEM


DefStruc ,vdmdata_s			;beginning of PERVDMDATA structure

;***	Per-VDM data
;

BOOL	flVDM8514	       ;per-VDM flags (see VDM_* constants)

HVDM	hvdm8514	       ;handle for this VDM
ULONG	sgID8514	       ;screen group # for this VDM

HMXSEM	hmx8514State	       ;semaphore for internal state
HEVSEM	hev8514WakeUp	       ;semaphore for bgnd sleeping/fgnd wakeup
HHOOK	hhookVDMContext	       ;hook handle for V8514VDMContext

PBYTE	pBuffer		       ;pointer to pixel save/restore buffer
_INT	 npgBuffer		;current size of the save/restore buffer
_INT	 npgBufferReq		;required size of the save/restore buffer
VVMODE	vvm8514		       ;mode data for 8514/A

_WORD	 wreg8514MFIndx		;for interim settings (for byte I/O)
_WORD	 awreg8514Data,,WREG_TOTAL
_WORD	 awreg8514MFData,,MFINDX_INDXTOTAL

_BYTE	 regDACMask8514		;note that these byte registers are R/W
_BYTE	 regDACIndx8514
DACREG	adacDACData8514,,MAX_DACREGS
DACREG	dacDACDataCur8514      ;current DAC data register
_INT	 stateDAC8514		;state of DAC


EndStruc PERVDMDATA		      ;end of PERVDMDATA structure

DefType PVDMDATA,dd


DefData IMPORT,INSTANCE,C
PERVDMDATA V8514Data
VDMData catstr V8514Data
EndData



;*** Private function prototypes
;

;vv8514.c

EXPENTRY VDDInit		<PSZ>
EXPENTRY V8514Create		<HVDM>
EXPENTRY V8514SetFgnd		<HVDM>
EXPENTRY V8514SetBgnd		<HVDM>
EXPENTRY V8514Destroy		<HVDM>
HOOKENTRY V8514VDMContext		<PVOID, PCRF>
ifdef OLD_PROPERTIES
EXPENTRY V8514SetIOTrapping		<ULONG, HVDM, ULONG, PSZ>
endif
PRIVENTRY v8514SetIOHooks		<VOID>
PRIVENTRY v8514UpdateScreenState		<HVDM>
PRIVENTRY v8514AddEvent		<HVDM, _INT, PVOID, FLAGS>
PRIVENTRY v8514DeleteEvent		<HVDM, _INT>
PRIVENTRY v8514RestoreIOState		<HVDM>
PRIVENTRY v8514TransferBuffer		<HVDM, BOOL>
PRIVENTRY v8514DisableDisplay		<HVDM>
PRIVENTRY v8514EnableDisplay		<HVDM>
PRIVENTRY v8514GrowBuffer		<HVDM>
PRIVENTRY v8514ShrinkBuffer		<HVDM>
EXPENTRY V8514SysReqProc		<SGID, ULONG, ULONG, PVOID, ULONG, PVOID>
PRIVENTRY v8514SysQueryMode		<HVDM, ULONG, PVOID, ULONG, PVVMODE>
PRIVENTRY v8514SysQueryCursor		<HVDM, ULONG, PVOID, ULONG, PVVCURSOR>
PRIVENTRY v8514SysQueryPalette		<HVDM, ULONG, PVOID, ULONG, PRGB>
PRIVENTRY v8514SysCopyLVB		<HVDM, ULONG, PRECTL, ULONG, PBYTE>
PRIVENTRY v8514SysCopyBitmap		<HVDM, ULONG, PVVRECT, ULONG, PBYTE>
EXPENTRY V8514DevReqProc		<HVDM, ULONG, PVOID, PVOID>

PRIVENTRY v8514ockIO		<HVDM>
PRIVENTRY v8514UnlockIO		<HVDM>
PRIVENTRY v8514EnterIO		<ULONG, ULONG>
PRIVENTRY v8514ExitIO		<VOID>
PRIVENTRY v8514CheckDisplayOwner		<_WORD>
HOOKENTRY V8514ReadWRegByteL		<ULONG, PCRF>
HOOKENTRY V8514WriteWRegByteL		<_BYTE, ULONG, PCRF>
HOOKENTRY V8514ReadWRegByteH		<ULONG, PCRF>
HOOKENTRY V8514WriteWRegByteH		<_BYTE, ULONG, PCRF>
HOOKENTRY V8514ReadWRegWord		<ULONG, PCRF>
HOOKENTRY V8514WriteWRegWord		<_WORD, ULONG, PCRF>

HOOKENTRY V8514ReadMFRegByteL		<ULONG, PCRF>
HOOKENTRY V8514WriteMFRegByteL		<_BYTE, ULONG, PCRF>
HOOKENTRY V8514ReadMFRegByteH		<ULONG, PCRF>
HOOKENTRY V8514WriteMFRegByteH		<_BYTE, ULONG, PCRF>
HOOKENTRY V8514ReadMFRegWord		<ULONG, PCRF>
HOOKENTRY V8514WriteMFRegWord		<_WORD, ULONG, PCRF>

HOOKENTRY V8514ReadDACMask		<ULONG, PCRF>
HOOKENTRY V8514WriteDACMask		<_BYTE, ULONG, PCRF>
HOOKENTRY V8514ReadDACReadIndx		<ULONG, PCRF>
HOOKENTRY V8514WriteDACReadIndx		<_BYTE, ULONG, PCRF>
HOOKENTRY V8514ReadDACWriteIndx		<ULONG, PCRF>
HOOKENTRY V8514WriteDACWriteIndx		<_BYTE, ULONG, PCRF>
HOOKENTRY V8514ReadDACData		<ULONG, PCRF>
HOOKENTRY V8514WriteDACData		<_BYTE, ULONG, PCRF>
PRIVENTRY v8514AdvanceDACReadState		<VOID>
EXPENTRY V8514Int2FHandler		<HVDM, ULONG, PCRF>		    ;@025



;*** Random macro support
;
;    If VDDSTRICT is defined, the Assert macros generate appropriate code.
;
;    If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
;    exception of AssertRC, in which case the function is still called, but
;    the return code is not checked).
;
;    If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
;    failed assertions (assuming VDDSTRICT is defined) break at the assertion
;    rather than in the kernel's "panic" service.  VDDDEBUG requires the
;    kernel debugger, in other words.
;
;    If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
;    generated, and failed assertions (assuming VDDSTRICT is defined) simply
;    panics.
;

dword_s struc
  lo dw ?
  hi dw ?
dword_s ends


ifdef VDDSTRICT


?ASSERT macro	cond,msg,args
	local	l1
	ifnb	<cond>
	j&cond	short l1
	endif
	ifdef	VDDDEBUG
	DBPRINT <msg>,<args>
	int 3
	else
	PANIC	<msg>,<args>
	endif
	ifnb	<cond>
l1:
	endif
	endm

else


?ASSERT macro cond,msg,args
	endm
endif

ASSERT	 equ   <?ASSERT ,>
ASSERTC	 equ   <?ASSERT c,>
ASSERTNC equ   <?ASSERT nc,>
ASSERTZ	 equ   <?ASSERT z,>
ASSERTNZ equ   <?ASSERT nz,>
ASSERTE	 equ   <?ASSERT e,>
ASSERTNE equ   <?ASSERT ne,>
ASSERTB	 equ   <?ASSERT b,>
ASSERTBE equ   <?ASSERT be,>
ASSERTA	 equ   <?ASSERT a,>
ASSERTAE equ   <?ASSERT ae,>


;*** Random debugging support
;

ifdef VDDDEBUG


DefData IMPORT,INSTANCE,C
SZ szModule
EndData

DBPRINT macro msg,args
	PRINTDEBUG <szModule>
	PRINTDEBUG <msg>,<args>
	endm

else

DBPRINT macro msg,args
	endm

endif
