#       SCCSID = @(#)vdevsub.mak        6.3 91/09/21

#****************************************************************************
#  Dot directive definition area (usually just suffixes)
#****************************************************************************

.SUFFIXES:
.SUFFIXES:      .c .asm .h .obj .lst .def .lnk .lrf .exe .com .imt .inc
.SUFFIXES:      .doc .hpl .hp2 .ppr .ppx .txt .sci .sin .isu .stb .sym .map
.SUFFIXES:      .cga .ega .vga .mna .cgd .egd .vgd .mnd .cgl .egl .vgl .mnl
.SUFFIXES:      .lsd .ltb

#****************************************************************************
#  Environment Setup for the component(s).
#****************************************************************************

#
# Compiler Location w/ includes, libs and tools
#

H_DBCS = ..\..\..\h_dbcs
INC_DBCS = ..\..\..\inc_dbcs
LIB_DBCS= ..\..\..\lib_dbcs
H = ..\..\..\h
H386 = ..\..\..\h386
INC = ..\..\..\inc
LIB= ..\..\..\lib
TOOLSPATH=..\..\..\..\tools

#
# Define macros for language. If the macro is NOT defined, the default
# value will be the US.
#

!ifndef LANG
LANG=us
!endif

#
# Since the compiler/linker and other tools use environment
# variables ( INCLUDE, LIB, etc ) in order to get the location of files,
# the following line will check the environment for the LIFE of the
# makefile and will be specific to this set of instructions. All MAKEFILES
# are requested to use this format to insure that they are using the correct
# level of files and tools.
#

!if [set INCLUDE=$(H_DBCS);$(H);$(H386);$(INC_DBCS);$(INC)] || \
   [set LIB=$(LIB_DBCS);$(LIB)] || [set PATH=$(TOOLSPATH)]
!endif

#
# Compiler/tools Macros
#

AS=masm
CC= cl386
IMPLIB=implib
IPF=ipfc
LIBUTIL=lib
LINK=link386
LINK16=link
MAPSYM=mapsym
RC=rc

#
# Compiler and Linker Options
#

PURE    = -p
GAFLAGS =
AFLAGS  = -Ml $(PURE) -t -Z $(GAFLAGS) $(FLAGS)
AINC   =  -I. -I$(H_DBCS) -I$(H) -I$(INC_DBCS) -I$(INC)
CINC   =  -I. -I$(H386) -I$(H_DBCS) -I$(H) -I$(INC_DBCS) -I$(INC)
DFLAGS  = -DVDDSTRICT -DVDHSTRICT -DVDDDEBUG
BFLAGS  = -DVDDSTRICT -DVDHSTRICT -DSTUB_VPIC
OFLAGS  = -Owait
SFLAGS  = -G3s -Zflp -Asnw -W2 -X $(CINC) -nologo -c $(GCFLAGS) $(BFLAGS)
CFLAGS  = -G3s -Zflp -Asnw -W2 -X $(CINC) -nologo -c $(GCFLAGS) $(FLAGS)
LFLAGS = /noi /noe /nod /map:0 /exepack /align:16
L16FLAGS = /noi /noe /nod /map:0
RFLAGS = -r

LIBS    = $(LIB)\vdh.lib
DEF     = $(LIB)\vdd.def

#       Definitions for dwscript

DWSFLAGS= /n /y /t

SINC    = sinc

#****************************************************************************
#   Setup the inference rules for compiling and assembling source code to
#   obejct code.
#****************************************************************************

.asm.obj:
        $(AS) $(AFLAGS) $(AINC) $< ;

.asm.obd:
        $(AS) $(AFLAGS) $(DFLAGS) $(AINC) $<, $*.obd;

.asm.lst:
        $(AS) -l -n $(AFLAGS) $(AINC) $< ;

.asm.lsd:
        $(AS) -l -n $(AFLAGS) $(DFLAGS) $(AINC) $< ;

.c.obj:
        $(CC) $(OFLAGS) $(CFLAGS) $(CINC) $< ;

.c.obd:
        $(CC) -Zi -Oi $(CFLAGS) $(DFLAGS) $(CINC) -Fo$@ $< ;

.c.lst:
        $(CC) $(OFLAGS) $(CFLAGS) $(CINC) -Fc$*.lst $< ;

.c.lsd:
        $(CC) -Zi -Oi $(CFLAGS) $(DFLAGS) $(CINC) -Fc$*.lst $< ;

.c.stb:
        $(CC) $(OFLAGS) $(SFLAGS) $(CINC) -Fo$@ $< ;

.c.ltb:
        $(CC) $(OFLAGS) $(SFLAGS) $(CINC) -Fc$*.lst $< ;

.c.i:
        $(CC) $(OFLAGS) $(CFLAGS) $(CINC) -E $< >$*.i

.rc.obj:
        $(RC) $(RFLAGS) $< ;

.asm.imt:
        msgprof $*.asm /txt /asm
        extract $*.pro
        del $*.pro
        mkmsgf $*.txt $*.imt /asm
        del $*.txt

.lnk.lrf:
        tresp $*.lnk $*.lrf

.map.sym:
        mapsym $*.map

#       Rule for generating a .inc file from a .h file

.h.inc:
        tabify -d $*.h | sed -f $(TOOLSPATH)\h2inc32.sed | tabify >$*.inc

#       Rules for generating dwscript output for different devices

.doc.hpl:
        dwscript $*.doc $*.hpl laserjet.pro $(DWSFLAGS)
        del toc.tmp

.doc.hp2:
        dwscript $*.doc $*.hp2 laser2.pro $(DWSFLAGS)
        del toc.tmp

.doc.ppr:
        dwscript $*.doc $*.ppr ppr.pro $(DWSFLAGS)
        del toc.tmp
        ctlz $*.ppr

.doc.ppx:
        echo .cs 1 ignore> $*.tmp
        echo .im $*.doc >> $*.tmp
        dwscript $*.tmp $*.ppx ppr.pro $(DWSFLAGS)
        del $*.tmp
        del toc.tmp
        ctlz $*.ppx

.doc.txt:
        dwscript $*.doc $*.txt nopro.pro $(DWSFLAGS)
        del toc.tmp

#       Rules for generating header documents from .sin files

.sci.sin:
        $(SINC) $(SINCFLAGS) $*.sci > $*.sin

