;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;*******************************************************************************
;
; MODULE NAME: TABLES.ASM
;
; DESCRIPTION: Various tables of data, separated from the main code file for
;              clarity.
;
; CHANGE HISTORY:
;
;   17Sep92 KJE - DCR53004 (WPS Implementation for INT 10 DMQS Services).
;
;*******************************************************************************

;*******************************************************************************
; Call tables
;*******************************************************************************
Strategy_jTab LABEL WORD

   DW  OFFSET Init             ;DEVICE= init command            ;00
   DW  OFFSET Unsupported      ;media check                     ;01
   DW  OFFSET Unsupported      ;build BPB                       ;02
   DW  OFFSET Unsupported      ;reserved                        ;03
   DW  OFFSET Unsupported      ;read (input)                    ;04
   DW  OFFSET Unsupported      ;nondestructive read - no wait   ;05
   DW  OFFSET Unsupported      ;input status                    ;06
   DW  OFFSET Unsupported      ;input flush                     ;07
   DW  OFFSET Unsupported      ;write (output)                  ;08
   DW  OFFSET Unsupported      ;write with verify               ;09
   DW  OFFSET Unsupported      ;output status                   ;0A
   DW  OFFSET Unsupported      ;output flush                    ;0B
   DW  OFFSET Unsupported      ;reserved                        ;0C
   DW  OFFSET Open             ;open device                     ;0D
   DW  OFFSET Close            ;close device                    ;0E
   DW  OFFSET Unsupported      ;removable media                 ;0F
   DW  OFFSET IOctl            ;generic IOctl                   ;10
   DW  OFFSET Unsupported      ;reset media                     ;11
   DW  OFFSET Unsupported      ;get logical drive map           ;12
   DW  OFFSET Unsupported      ;set logical drive map           ;13
   DW  OFFSET Unsupported      ;deinstall driver                ;14
   DW  OFFSET Unsupported      ;reserved                        ;15
   DW  OFFSET Unsupported      ;partitionable fixed disks       ;16
   DW  OFFSET Unsupported      ;get fixed disk/logical unit map ;17
   DW  OFFSET Unsupported      ;reserved                        ;18
   DW  OFFSET Unsupported      ;reserved                        ;19
   DW  OFFSET Unsupported      ;reserved                        ;1A
   DW  OFFSET Init             ;Base DD Init command            ;1B
   DW  OFFSET Unsupported      ;reserved                        ;1C
   DW  OFFSET GetDeviceSupport ;device support request packet   ;1D
   DW  OFFSET Unsupported      ;reserved                        ;1E
   DW  OFFSET Unsupported      ;reserved                        ;1F

RequestTable LABEL WORD

   DW  0 ; was -> OFFSET lockAll          ;verify/lock all addrs in worklist
   DW  0 ; was -> OFFSET unlockAll        ;unlock all handles in worklist
   DW  0 ; was -> OFFSET initAI           ;pass back XGAINSTANCE addr etc.
   DW  0 ; was -> OFFSET tellAImgr        ;return DLL name and no. of devices
   DW  OFFSET lockpm                      ;***rjn
   DW  OFFSET unlockpm                    ;***rjn
   DW  OFFSET QueryAdapterInfo            ;adapter configuration data returned
   DW  OFFSET save_VRAM                   ;save contents of VRAM
   DW  OFFSET restore_VRAM                ;restore contents of VRAM
   DW  OFFSET set_vga_mode                ;put coprocessor in vga mode
   DW  OFFSET SetMode                     ;put coprocessor in DMQS mode
   DW  OFFSET save_coprocessor_state
   DW  OFFSET restore_coprocessor_state
   DW  OFFSET set_132_column_mode
   DW  OFFSET save_io_regs
   DW  OFFSET restore_io_regs
   DW  OFFSET save_palette
   DW  OFFSET restore_palette
   DW  OFFSET flat_lock                   ; 12h
   DW  OFFSET flat_unlock                 ; 13h
   DW  OFFSET flat_access                 ; 14h
   DW  OFFSET create_callgate             ; 15h
   DW  OFFSET global_access               ; 16h
   DW  OFFSET SetModeInfo                 ; New DMQS functions...
   DW  OFFSET GetModeInfo                 ; 18h
   DW  OFFSET SetInstanceData             ; 19h
   DW  OFFSET GetInstanceData             ; 1Ah
   DW  OFFSET QueryAdapterInfo2           ; 1Bh
   DW  OFFSET CopyDMQSData                ; 1Ch  KJE-<DCR53004>

;*******************************************************************************
; Below maximum value must be updated if any additional functions are added to
; the table above.
;*******************************************************************************
MAX_REQ_CODE EQU 1Ch

;*******************************************************************************
; Device driver variables
;*******************************************************************************
public Device_Help      ; dd
public drvError         ; dw
public GDTselectors     ; dw[20]
public GDTCount         ; dw

Device_Help     DD      0               ;address of devHlp routine
drvError        DW      0               ;error return to OS/2

;*******************************************************************************
; GDT manipulation space
;*******************************************************************************
GDTselectors    DW      20 DUP (0)      ;GDT entries for user
GDTcount        DW      2               ;offset between GDT selector banks 1&2

;*******************************************************************************
; IO registers to save - each number is an offset from the base
;*******************************************************************************
public io_reg_numbers
io_reg_numbers LABEL WORD
        db      00h                    ; operating mode     21x0
        db      01h                    ; aperture control   21x1
        db      03h                    ; interrupt control  21x4
        db      01h                    ; interrupt status   21x5
        db      03h                    ; aperture index     21x8
        db      01h                    ; memory access mode 21x9
        db     0ffh                    ; end of data
; indexed io registers to save - each number is the index to use
        db      10h                    ; horizontal total low
        db      11h                    ; horizontal total high
        db      12h                    ; horizontal display end low
        db      13h                    ; horizontal display end high
        db      14h                    ; horizontal blanking start low
        db      15h                    ; horizontal blanking start high
        db      16h                    ; horizontal blanking end low
        db      17h                    ; horizontal blanking end high
        db      18h                    ; horizontal sync pulse start low
        db      19h                    ; horizontal sync pulse start high
        db      1ah                    ; horizontal sync pulse end low
        db      1bh                    ; horizontal sync pulse end high
        db      20h                    ; vertical total low
        db      21h                    ; vertical total high
        db      22h                    ; vertical display end low
        db      23h                    ; vertical display end high
        db      24h                    ; vertical blanking start
        db      25h                    ; vertical blanking start
        db      26h                    ; vertical blanking end
        db      27h                    ; vertical blanking end
        db      28h                    ; vertical sync pulse start
        db      29h                    ; vertical sync pulse start
        db      2ah                    ; vertical sync pulse end
        db      2ch                    ; vertical line compare
        db      2dh                    ; vertical line compare
        db      30h                    ; sprite horizontal start
        db      31h                    ; sprite horizontal start
        db      32h                    ; sprite horizontal preset
        db      33h                    ; sprite vertical start
        db      34h                    ; sprite vertical start
        db      35h                    ; sprite vertical preset
        db      36h                    ; sprite control
        db      38h                    ; sprite colour 0 red
        db      39h                    ; sprite colour 0 green
        db      3ah                    ; sprite colour 0 blue
        db      3bh                    ; sprite colour 1 red
        db      3ch                    ; sprite colour 1 green
        db      3dh                    ; sprite colour 1 blue
        db      40h                    ; display pixel map offset
        db      41h                    ; display pixel map offset
        db      42h                    ; display pixel map offset
        db      43h                    ; display pixel map width
        db      44h                    ; display pixel map width
        db      50h                    ; display control 1
        db      51h                    ; display control 2
        db      54h                    ; clock frequency select
        db      55h                    ; border colour
        db      60h                    ; sprite/palette index
        db      61h                    ; sprite/palette index
        db      64h                    ; palette mask
        db      65h                    ; palette data
        db      66h                    ; palette sequence
        db      67h                    ; palette red prefetch
        db      68h                    ; palette green prefetch
        db      69h                    ; palette blue prefetch
        db      6ah                    ; sprite data
        db      6bh                    ; sprite prefetch
        db      70h                    ; external clock select
        db     0ffh                    ; end of data

;*******************************************************************************
; Table that maps mode numbers passed to us into addresses of the
; data to be used in setting the mode
;*******************************************************************************

; native mode setting data
INDEXED_REG     equ    08000h
TERMINATOR      equ    0FFFFh

public native_640_480_8
native_640_480_8 label word
        dw                   04h,  00h  ; disable all interrupts
        dw                   05h, 0FFh  ; reset all interrupts
        dw                   00h,  04h  ; set extended graphics mode
        dw    INDEXED_REG OR 64h,  00h  ; palette mask - blank display
        dw                   01h,  00h  ; no 64k video memory aperture
;       dw                   08h,  00h  ; video memory aperture index
;       dw                   06h,  00h  ; virtual memory control
        dw                   09h,  03h  ; memory access - 8bpp Intel
        dw    INDEXED_REG OR 50h,  11h  ; display mode 1-prepare for reset, VFB
        dw    INDEXED_REG OR 50h,  10h  ;     "         ,reset
; xga CRTC parameters...
        dw    INDEXED_REG OR 10h,  63h  ; horizontal total low
        dw    INDEXED_REG OR 11h,  00h  ; horizontal total high
        dw    INDEXED_REG OR 12h,  4fh  ; horizontal display end low
        dw    INDEXED_REG OR 13h,  00h  ; horizontal display end high
        dw    INDEXED_REG OR 14h,  4fh  ; horizontal blank start low
        dw    INDEXED_REG OR 15h,  00h  ; horizontal blank start high
        dw    INDEXED_REG OR 16h,  63h  ; horizontal blank end low
        dw    INDEXED_REG OR 17h,  00h  ; horizontal blank end high
        dw    INDEXED_REG OR 18h,  55h  ; horizontal sync start low
        dw    INDEXED_REG OR 19h,  00h  ; horizontal sync start high
        dw    INDEXED_REG OR 1ah,  61h  ; horizontal sync end low
        dw    INDEXED_REG OR 1bh,  00h  ; horizontal sync end high
        dw    INDEXED_REG OR 1ch,  00h  ; horizontal sync position
        dw    INDEXED_REG OR 1eh,  00h  ; horizontal sync position
        dw    INDEXED_REG OR 20h,  0ch  ; vertical total low
        dw    INDEXED_REG OR 21h,  02h  ; vertical total high
        dw    INDEXED_REG OR 22h, 0dfh  ; vertical display end low
        dw    INDEXED_REG OR 23h,  01h  ; vertical display end high
        dw    INDEXED_REG OR 24h, 0dfh  ; vertical blank start low
        dw    INDEXED_REG OR 25h,  01h  ; vertical blank start high
        dw    INDEXED_REG OR 26h,  0ch  ; vertical blank end low
        dw    INDEXED_REG OR 27h,  02h  ; vertical blank end high
        dw    INDEXED_REG OR 28h, 0eah  ; vertical sync start low
        dw    INDEXED_REG OR 29h,  01h  ; vertical sync start high
        dw    INDEXED_REG OR 2ah, 0ech  ; vertical sync end
        dw    INDEXED_REG OR 2ch, 0ffh  ; vertical line comp low
        dw    INDEXED_REG OR 2dh, 0ffh  ; vertical line comp high
; ...end xga CRTC parameters
        dw    INDEXED_REG OR 36h,  00h  ; sprite control
        dw    INDEXED_REG OR 40h,  00h  ; start address low
        dw    INDEXED_REG OR 41h,  00h  ; start address medium
        dw    INDEXED_REG OR 42h,  00h  ; start address high
        dw    INDEXED_REG OR 43h,  50h  ; buffer pitch low
        dw    INDEXED_REG OR 44h,  00h  ; buffer pitch high
        dw    INDEXED_REG OR 54h,  00h  ; clock select
        dw    INDEXED_REG OR 51h,  03h  ; display mode 2 - 8bpp (magnify 1 x 1)
        dw    INDEXED_REG OR 70h,  00h  ; external clock select
        dw    INDEXED_REG OR 50h, 0d7h  ; display mode 1 - 480 line, VFB,
                                        ; non interlaced, normal operation
        dw    TERMINATOR

public native_640_480_16
native_640_480_16 label word
        dw                   04h,  00h  ; disable all interrupts
        dw                   05h, 0FFh  ; reset all interrupts
        dw                   00h,  04h  ; set extended graphics mode
        dw    INDEXED_REG OR 64h,  00h  ; palette mask - blank display
        dw                   01h,  00h  ; no 64k video memory aperture
;       dw                   08h,  00h  ; video memory aperture index
;       dw                   06h,  00h  ; virtual memory control
        dw                   09h,  04h  ; memory access - 16 bpp Intel
        dw    INDEXED_REG OR 50h,  11h  ; display mode 1-prepare for reset, VFB
        dw    INDEXED_REG OR 50h,  10h  ;     "         ,reset
; xga CRTC parameters...
        dw    INDEXED_REG OR 10h,  63h  ; horizontal total low
        dw    INDEXED_REG OR 11h,  00h  ; horizontal total high
        dw    INDEXED_REG OR 12h,  4fh  ; horizontal display end low
        dw    INDEXED_REG OR 13h,  00h  ; horizontal display end high
        dw    INDEXED_REG OR 14h,  4fh  ; horizontal blank start low
        dw    INDEXED_REG OR 15h,  00h  ; horizontal blank start high
        dw    INDEXED_REG OR 16h,  63h  ; horizontal blank end low
        dw    INDEXED_REG OR 17h,  00h  ; horizontal blank end high
        dw    INDEXED_REG OR 18h,  55h  ; horizontal sync start low
        dw    INDEXED_REG OR 19h,  00h  ; horizontal sync start high
        dw    INDEXED_REG OR 1ah,  61h  ; horizontal sync end low
        dw    INDEXED_REG OR 1bh,  00h  ; horizontal sync end high
        dw    INDEXED_REG OR 1ch,  00h  ; horizontal sync position
        dw    INDEXED_REG OR 1eh,  00h  ; horizontal sync position
        dw    INDEXED_REG OR 20h,  0ch  ; vertical total low
        dw    INDEXED_REG OR 21h,  02h  ; vertical total high
        dw    INDEXED_REG OR 22h, 0dfh  ; vertical display end low
        dw    INDEXED_REG OR 23h,  01h  ; vertical display end high
        dw    INDEXED_REG OR 24h, 0dfh  ; vertical blank start low
        dw    INDEXED_REG OR 25h,  01h  ; vertical blank start high
        dw    INDEXED_REG OR 26h,  0ch  ; vertical blank end low
        dw    INDEXED_REG OR 27h,  02h  ; vertical blank end high
        dw    INDEXED_REG OR 28h, 0eah  ; vertical sync start low
        dw    INDEXED_REG OR 29h,  01h  ; vertical sync start high
        dw    INDEXED_REG OR 2ah, 0ech  ; vertical sync end
        dw    INDEXED_REG OR 2ch, 0ffh  ; vertical line comp low
        dw    INDEXED_REG OR 2dh, 0ffh  ; vertical line comp high
; ...end xga CRTC parameters
        dw    INDEXED_REG OR 36h,  00h  ; sprite control
        dw    INDEXED_REG OR 40h,  00h  ; start address low
        dw    INDEXED_REG OR 41h,  00h  ; start address medium
        dw    INDEXED_REG OR 42h,  00h  ; start address high
        dw    INDEXED_REG OR 43h, 0a0h  ; buffer pitch low
        dw    INDEXED_REG OR 44h,  00h  ; buffer pitch high
        dw    INDEXED_REG OR 54h,  00h  ; clock select
        dw    INDEXED_REG OR 51h,  04h  ; display mode 2 - 16bpp (magnify 1 x 1)
        dw    INDEXED_REG OR 70h,  00h  ; external clock select
        dw    INDEXED_REG OR 50h, 0d7h  ; display mode 1 - 480 line, VFB,
                                        ; non interlaced, normal operation
        dw    TERMINATOR

public native_1024_768_8
native_1024_768_8 label word
        dw                   04h,  00h  ; disable all interrupts
        dw                   05h, 0FFh  ; reset all interrupts
        dw                   00h,  04h  ; set extended graphics mode
        dw    INDEXED_REG OR 64h,  00h  ; palette mask - blank display
        dw                   01h,  00h  ; no 64k video memory aperture
;       dw                   08h,  00h  ; video memory aperture index
;       dw                   06h,  00h  ; virtual memory control
        dw                   09h,  03h  ; memory access - 8 bpp Intel
        dw    INDEXED_REG OR 50h,  01h  ; display mode 1-prepare for reset
        dw    INDEXED_REG OR 50h,  00h  ;     "         ,reset
; xga CRTC parameters...
        dw    INDEXED_REG OR 10h,  9dh  ; horizontal total low
        dw    INDEXED_REG OR 11h,  00h  ; horizontal total high
        dw    INDEXED_REG OR 12h,  7fh  ; horizontal display end low
        dw    INDEXED_REG OR 13h,  00h  ; horizontal display end high
        dw    INDEXED_REG OR 14h,  7fh  ; horizontal blank start low
        dw    INDEXED_REG OR 15h,  00h  ; horizontal blank start high
        dw    INDEXED_REG OR 16h,  9dh  ; horizontal blank end low
        dw    INDEXED_REG OR 17h,  00h  ; horizontal blank end high
        dw    INDEXED_REG OR 18h,  87h  ; horizontal sync start low
        dw    INDEXED_REG OR 19h,  00h  ; horizontal sync start high
        dw    INDEXED_REG OR 1ah,  9ch  ; horizontal sync end low
        dw    INDEXED_REG OR 1bh,  00h  ; horizontal sync end high
        dw    INDEXED_REG OR 1ch,  40h  ; horizontal sync position
        dw    INDEXED_REG OR 1eh,  04h  ; horizontal sync position
        dw    INDEXED_REG OR 20h,  30h  ; vertical total low
        dw    INDEXED_REG OR 21h,  03h  ; vertical total high
        dw    INDEXED_REG OR 22h, 0ffh  ; vertical display end low
        dw    INDEXED_REG OR 23h,  02h  ; vertical display end high
        dw    INDEXED_REG OR 24h, 0ffh  ; vertical blank start low
        dw    INDEXED_REG OR 25h,  02h  ; vertical blank start high
        dw    INDEXED_REG OR 26h,  30h  ; vertical blank end low
        dw    INDEXED_REG OR 27h,  03h  ; vertical blank end high
        dw    INDEXED_REG OR 28h,  00h  ; vertical sync start low
        dw    INDEXED_REG OR 29h,  03h  ; vertical sync start high
        dw    INDEXED_REG OR 2ah,  08h  ; vertical sync end
        dw    INDEXED_REG OR 2ch, 0ffh  ; vertical line comp low
        dw    INDEXED_REG OR 2dh, 0ffh  ; vertical line comp high
; ...end xga CRTC parameters
        dw    INDEXED_REG OR 36h,  00h  ; sprite control
        dw    INDEXED_REG OR 40h,  00h  ; start address low
        dw    INDEXED_REG OR 41h,  00h  ; start address medium
        dw    INDEXED_REG OR 42h,  00h  ; start address high
        dw    INDEXED_REG OR 43h,  80h  ; buffer pitch low
        dw    INDEXED_REG OR 44h,  00h  ; buffer pitch high
        dw    INDEXED_REG OR 54h,  0dh  ; clock select
        dw    INDEXED_REG OR 51h,  03h  ; display mode 2 - 8 bpp (magnify 1 x 1)
        dw    INDEXED_REG OR 70h,  00h  ; external clock select
        dw    INDEXED_REG OR 50h,  0fh  ; display mode 1 - 768 line,
                                        ; interlaced, normal operation
        dw    TERMINATOR

public native_1024_768_4
native_1024_768_4 label word
        dw                   04h,  00h  ; disable all interrupts
        dw                   05h, 0FFh  ; reset all interrupts
        dw                   00h,  04h  ; set extended graphics mode
        dw    INDEXED_REG OR 64h,  00h  ; palette mask - blank display
        dw                   01h,  00h  ; no 64k video memory aperture
;       dw                   08h,  00h  ; video memory aperture index
;       dw                   06h,  00h  ; virtual memory control
        dw                   09h,  02h  ; memory access - 4 bpp Intel
        dw    INDEXED_REG OR 50h,  01h  ; display mode 1-prepare for reset
        dw    INDEXED_REG OR 50h,  00h  ;     "         ,reset
; xga CRTC parameters...
        dw    INDEXED_REG OR 10h,  9dh  ; horizontal total low
        dw    INDEXED_REG OR 11h,  00h  ; horizontal total high
        dw    INDEXED_REG OR 12h,  7fh  ; horizontal display end low
        dw    INDEXED_REG OR 13h,  00h  ; horizontal display end high
        dw    INDEXED_REG OR 14h,  7fh  ; horizontal blank start low
        dw    INDEXED_REG OR 15h,  00h  ; horizontal blank start high
        dw    INDEXED_REG OR 16h,  9dh  ; horizontal blank end low
        dw    INDEXED_REG OR 17h,  00h  ; horizontal blank end high
        dw    INDEXED_REG OR 18h,  87h  ; horizontal sync start low
        dw    INDEXED_REG OR 19h,  00h  ; horizontal sync start high
        dw    INDEXED_REG OR 1ah,  9ch  ; horizontal sync end low
        dw    INDEXED_REG OR 1bh,  00h  ; horizontal sync end high
        dw    INDEXED_REG OR 1ch,  40h  ; horizontal sync position
        dw    INDEXED_REG OR 1eh,  04h  ; horizontal sync position
        dw    INDEXED_REG OR 20h,  30h  ; vertical total low
        dw    INDEXED_REG OR 21h,  03h  ; vertical total high
        dw    INDEXED_REG OR 22h, 0ffh  ; vertical display end low
        dw    INDEXED_REG OR 23h,  02h  ; vertical display end high
        dw    INDEXED_REG OR 24h, 0ffh  ; vertical blank start low
        dw    INDEXED_REG OR 25h,  02h  ; vertical blank start high
        dw    INDEXED_REG OR 26h,  30h  ; vertical blank end low
        dw    INDEXED_REG OR 27h,  03h  ; vertical blank end high
        dw    INDEXED_REG OR 28h,  00h  ; vertical sync start low
        dw    INDEXED_REG OR 29h,  03h  ; vertical sync start high
        dw    INDEXED_REG OR 2ah,  08h  ; vertical sync end
        dw    INDEXED_REG OR 2ch, 0ffh  ; vertical line comp low
        dw    INDEXED_REG OR 2dh, 0ffh  ; vertical line comp high
; ...end xga CRTC parameters
        dw    INDEXED_REG OR 36h,  00h  ; sprite control
        dw    INDEXED_REG OR 40h,  00h  ; start address low
        dw    INDEXED_REG OR 41h,  00h  ; start address medium
        dw    INDEXED_REG OR 42h,  00h  ; start address high
        dw    INDEXED_REG OR 43h,  40h  ; buffer pitch low
        dw    INDEXED_REG OR 44h,  00h  ; buffer pitch high
        dw    INDEXED_REG OR 54h,  0dh  ; clock select
        dw    INDEXED_REG OR 51h,  02h  ; display mode 2 - 4 bpp (magnify 1 x 1)
        dw    INDEXED_REG OR 70h,  00h  ; external clock select
        dw    INDEXED_REG OR 50h,  0fh  ; display mode 1 - 768 line,
                                        ; interlaced, normal operation
        dw    TERMINATOR

public native_640_480_4
native_640_480_4 label word
        dw                   04h,  00h  ; disable all interrupts
        dw                   05h, 0FFh  ; reset all interrupts
        dw                   00h,  04h  ; set extended graphics mode
        dw    INDEXED_REG OR 64h,  00h  ; palette mask - blank display
        dw                   01h,  00h  ; no 64k video memory aperture
;       dw                   08h,  00h  ; video memory aperture index
;       dw                   06h,  00h  ; virtual memory control
        dw                   09h,  02h  ; memory access - 4 bpp Intel
        dw    INDEXED_REG OR 50h,  11h  ; display mode 1-prepare for reset, VFB
        dw    INDEXED_REG OR 50h,  10h  ;     "         ,reset
; xga CRTC parameters...
        dw    INDEXED_REG OR 10h,  63h  ; horizontal total low
        dw    INDEXED_REG OR 11h,  00h  ; horizontal total high
        dw    INDEXED_REG OR 12h,  4fh  ; horizontal display end low
        dw    INDEXED_REG OR 13h,  00h  ; horizontal display end high
        dw    INDEXED_REG OR 14h,  4fh  ; horizontal blank start low
        dw    INDEXED_REG OR 15h,  00h  ; horizontal blank start high
        dw    INDEXED_REG OR 16h,  63h  ; horizontal blank end low
        dw    INDEXED_REG OR 17h,  00h  ; horizontal blank end high
        dw    INDEXED_REG OR 18h,  55h  ; horizontal sync start low
        dw    INDEXED_REG OR 19h,  00h  ; horizontal sync start high
        dw    INDEXED_REG OR 1ah,  61h  ; horizontal sync end low
        dw    INDEXED_REG OR 1bh,  00h  ; horizontal sync end high
        dw    INDEXED_REG OR 1ch,  00h  ; horizontal sync position
        dw    INDEXED_REG OR 1eh,  00h  ; horizontal sync position
        dw    INDEXED_REG OR 20h,  0ch  ; vertical total low
        dw    INDEXED_REG OR 21h,  02h  ; vertical total high
        dw    INDEXED_REG OR 22h, 0dfh  ; vertical display end low
        dw    INDEXED_REG OR 23h,  01h  ; vertical display end high
        dw    INDEXED_REG OR 24h, 0dfh  ; vertical blank start low
        dw    INDEXED_REG OR 25h,  01h  ; vertical blank start high
        dw    INDEXED_REG OR 26h,  0ch  ; vertical blank end low
        dw    INDEXED_REG OR 27h,  02h  ; vertical blank end high
        dw    INDEXED_REG OR 28h, 0eah  ; vertical sync start low
        dw    INDEXED_REG OR 29h,  01h  ; vertical sync start high
        dw    INDEXED_REG OR 2ah, 0ech  ; vertical sync end
        dw    INDEXED_REG OR 2ch, 0ffh  ; vertical line comp low
        dw    INDEXED_REG OR 2dh, 0ffh  ; vertical line comp high
; ...end xga CRTC parameters
        dw    INDEXED_REG OR 36h,  00h  ; sprite control
        dw    INDEXED_REG OR 40h,  00h  ; start address low
        dw    INDEXED_REG OR 41h,  00h  ; start address medium
        dw    INDEXED_REG OR 42h,  00h  ; start address high
        dw    INDEXED_REG OR 43h,  28h  ; buffer pitch low
        dw    INDEXED_REG OR 44h,  00h  ; buffer pitch high
        dw    INDEXED_REG OR 54h,  00h  ; clock select
        dw    INDEXED_REG OR 51h,  02h  ; display mode 2 - 4bpp (magnify 1 x 1)
        dw    INDEXED_REG OR 70h,  00h  ; external clock select
        dw    INDEXED_REG OR 50h, 0d7h  ; display mode 1 - 480 line, VFB,
                                        ; non interlaced, normal operation
        dw    TERMINATOR

public  native_mode_data_table
native_mode_data_table label word
        dw      native_640_480_8
        dw      native_640_480_16
        dw      native_1024_768_8
        dw      native_1024_768_4
        dw      native_640_480_4
        dw      native_640_480_4

;*******************************************************************************
; This table is used by the SetRegisters function to jump to the code that sets
; the register contents according to its type specified in the DMQS mode data.
;*******************************************************************************
public SetRegisters_jump_table
SetRegisters_jump_table label word
        dw      SR_Direct
        dw      SR_Indexed
        dw      SR_Indexed_ORed
        dw      SR_Direct_ORed
        dw      SR_Indexed_ANDed
        dw      SR_Direct_ANDed
