/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)bvhxga2.h  13.1 91/01/18";*/
/**********************************************************************/
/*                                                                    */
/*   File            = BVHXGA                                         */
/*                                                                    */
/*   Description     = Header file for 2.0 BVH Support for XGA        */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#undef VIOMODEINFO
#undef PVIOMODEINFO
struct _VDHMODEINFO {
        USHORT cb;
        UCHAR  fbType;
        UCHAR  color;
        USHORT col;
        USHORT row;
        USHORT hres;
        USHORT vres;
        UCHAR  fmt_ID;
        UCHAR  attrib;
        UCHAR FAR * BufferAddress;
        ULONG  BufferLength;
        ULONG  FullBufferSize;
        ULONG  PartialBufferSize;
        UCHAR FAR * ExtDataArea;
        };
#define VIOMODEINFO struct _VDHMODEINFO
#define PVIOMODEINFO VIOMODEINFO FAR *

/**********************************************************************/
/* dosopen constants                                                  */
/**********************************************************************/
#define NO_SIZE        0L
#define RESERVED_LONG  0L


/*
+----------------------------------------------------------------------------+
|  Function numbers for VDH services                                         |
+----------------------------------------------------------------------------+
*/
#define FnFillLogicalDevBlock    1L
#define FnFillInitDevBlock       3L
#define FnTextBufferUpdate       256L
#define FnInitializeEnvironment  257L
#define FnSaveEnvironment        258L
#define FnRestoreEnvironment     259L
#define FnReturnConfigInfo       260L
#define FnGetMode                268L
#define FnSetMode                269L
#define FnGetLVBInfo             279L

#define MaxFn                    FnGetLVBInfo-FnTextBufferUpdate+1

#define ChainedVDHInitEnv         (*ChainedCallVectorTable[1])
#define ChainedVDHSaveEnv         (*ChainedCallVectorTable[2])
#define ChainedVDHRestoreEnv      (*ChainedCallVectorTable[3])
#define ChainedVDHRetConfigInfo   (*ChainedCallVectorTable[4])
#define ChainedVDHGetMode         (*ChainedCallVectorTable[12])
#define ChainedVDHSetMode         (*ChainedCallVectorTable[13])
#ifdef DBCS                                                             /*YOJN*/
#define ChainedVDHSetVariableInfo (*ChainedCallVectorTable[19])         /*YOJN*/
#endif /*DBCS*/                                                         /*YOJN*/

#define FnChainedBufUpdate        0
#define FnChainedRetConfigInfo    4
/*
 +----------------------------------------------------------------------------+
 |  Minimum structure lengths for VDH functions                               |
 +----------------------------------------------------------------------------+
*/
#define MinSLen_SaveRestoreEnv  4
/*
 +----------------------------------------------------------------------------+
 |  Minimum data lengths for VDH parameters                                   |
 +----------------------------------------------------------------------------+
*/
#define Config_Return_Length          2         /* RetConfigInfo */
#define MinDLen_Config_Adapter        4
#define MinDLen_Config_Display        6
#define MinDLen_Config_Memory         10
#define MinDLen_Config_ConfigNum      12
#define MinDLen_Config_Version        14
#define MinDLen_Config_Flag           16
#define MinDLen_Config_HWBufLen       20
#define MinDLen_Config_FullSaveSz     24
#define MinDLen_Config_PartSaveSz     28
#define MinDLen_Config_EMAdapter      36
#define MinDLen_Config_EMDisplay      40

#define Mode_Return_Length        2
#define MinDLen_Mode_Type         3
#define MinDLen_Mode_Color        4
#define MinDLen_Mode_Column       6
#define MinDLen_Mode_Row          8
#define MinDLen_Mode_Hres         10
#define MinDLen_Mode_Vres         12
#define MinDLen_Mode_FormatID     13
#define MinDLen_Mode_Attrib       14
#define MinDLen_Mode_BufStart     18
#define MinDLen_Mode_BufLen       22
#define MinDLen_Mode_FullBufSz    26
#define MinDLen_Mode_PartBufSz    30
#define MinDLen_Mode_ExtData      34

#define GRAPHICS_MODE 0x02
#define PARM_NATIVE_MODE   0x08
#define ENV_NATIVE_MODE    0x01
#define VALID_TYPE_FLAGS   ( VGMT_OTHER | VGMT_GRAPHICS |              \
                                  VGMT_DISABLEBURST | PARM_NATIVE_MODE )
#define NUM_MODES                      6        /* # Modes supported  */
#define MAX_MODE_CMDS                 13        /* Max no. CMDs to set a mode */
#define UNSUPPORTED_FUNCTION 0 /* VDH service is not supported by this adapter*/

/*+--------------------------------------------------------------------------+*/
/*| Display types                                                            |*/
/*+--------------------------------------------------------------------------+*/

#define DISPLAY_TYPE_NONE    0
#define DISPLAY_TYPE_PLASMA 10

/*+--------------------------------------------------------------------------+*/
/*| Adapter types                                                            |*/
/*+--------------------------------------------------------------------------+*/
         /*************************************************************/
         /* Adapter types:                                            */
         /*          0 - MPA                   5 - IBM Japan H        */
         /*          1 - CGA                   6 - IBM Japan ST       */
         /*          2 - EGA                   7 - 8514/A             */
         /*          3 - VGA or PS/2 adapter   8 - Image Adapter/A    */
         /*          4 - IBM Japan G           9 - XGA                */
         /*************************************************************/

#define TYPE_XGA   9

/*+--------------------------------------------------------------------------+*/
/*| Emulated Display types                                                   |*/
/*+--------------------------------------------------------------------------+*/

#define  EmDisp_MPA     0x0001
#define  EmDisp_CGA     0x0002
#define  EmDisp_EGA     0x0004
#define  EmDisp_8503    0x0008
#define  EmDisp_8512    0x0010
/* bits 5-8 reserved */
#define  EmDisp_8514    0x0200
#define  EmDisp_PLASMA  0x0400
#define  EmDisp_8507    0x0800

#define  EmDisp_VGA     (EmDisp_8503 | EmDisp_8512 | EmDisp_PLASMA)

/*+--------------------------------------------------------------------------+*/
/*| Emulated Adapter types                                                   |*/
/*+--------------------------------------------------------------------------+*/

#define EMULATE_TYPE_MPA    0x01
#define EMULATE_TYPE_CGA    0x02
#define EMULATE_TYPE_EGA    0x04
#define EMULATE_TYPE_VGA    0x08
#define EMULATE_TYPE_8514   0x80

#define POWERUP  1

#define TRUE  1
#define FALSE 0

#define INIT_ERROR 1

#define UPDATE_HARDWARE  1
#define RS_UPDATE_HARDWARE 2

#define INITENV_3xBOX    0x02
#define VALID_INITENV_FLAG (UPDATE_HARDWARE+INITENV_3xBOX)

#define SAVEREST_HARDWARE 0x02
#define SAVEREST_FULLPVB  0x04
#define SAVEREST_PARTPVB  0x08
#define VALID_SAVEREST_FLAG ( SAVEREST_HARDWARE + SAVEREST_FULLPVB +\
                              SAVEREST_PARTPVB )

#define SAVE    0
#define RESTORE 1

#define UNKNOWN 0

#define NONE            0x00

#define  VGADisplaySize 0x50000

/* DosOpen parameters */
#define SCREENDD_NAME  (PSZ)"IMGDRV$"
#define RETURN_ERROR   (USHORT)0x2000     /* OpenMode bit mask */
#define SYNCHRONOUS    (USHORT)0x4000
#define SYSTEM_FILE    (USHORT)0x0004
#define NO_INHERIT     (USHORT)0x0080
#define DENY_NONE      (USHORT)0x0040
#define READ_WRITE     (USHORT)0x0002
#define OPEN_IF_EXISTS 0x0001             /* OpenFlag bit mask */
#define NO_SIZE        0L
#define NO_ATTRIBUTES  0
#define RESERVED_LONG  0L


/*---------------------------------------------------------------------------*/
/*                            Macros                                         */
/*---------------------------------------------------------------------------*/

#define OFFSET(FARpointer) (USHORT)((ULONG)(&(FARpointer)))
#define min(x,y) (x)<(y)?(x):(y)

/*****************************************************************************/
/* Type definitions */
/*****************************************************************************/
#define PRIMARY_ADAPTER 0x01

typedef struct {
          USHORT TdepAddress;
          UCHAR TDEP[1024];
          } TDEPINFO;

typedef struct {
          USHORT Length;
          UCHAR  Palette[768];
          } HSRPALBLK;

typedef struct {
          USHORT Left;
          USHORT Top;
          USHORT Right;
          USHORT Bottom;
          } SCRLRECT;

typedef struct {
          UCHAR FAR *DataArea;
          USHORT FirstEntry;
          USHORT NumEntries;
          } REGDATA;

typedef struct {
          UCHAR   Command;
          REGDATA RegData;
          } REGCMD;

typedef union {
          UCHAR FAR *FullAddress;
          struct {
            USHORT Offset;
            USHORT Selector;
            } part;
          } FARAddress;

typedef struct {
          USHORT cb;              /* VioGetMode structure              */
          UCHAR  fbType;
          UCHAR  color;
          USHORT col;
          USHORT row;
          USHORT hres;
          USHORT vres;
          UCHAR  fmt_ID;
          UCHAR  attrib;
          UCHAR  MemMap;          /* Index in memory map table         */
          UCHAR  ROMFontIndex;    /* Index in ROM font table           */
          UCHAR  Flags;

          REGCMD ModeRegs[MAX_MODE_CMDS+1];     /* Register command table            */
          } VIDEOMODE;

typedef VIDEOMODE FAR * PVIDEOMODE;

typedef struct {
          ULONG  FAR *Flags;              /* ULONG ? */
          USHORT FAR * FAR *CallVectorTable;
          } DEV_PARM2;

typedef DEV_PARM2 FAR * PDEV_PARM2;

typedef struct {
          ULONG EngineVersion;
          ULONG TableSize;
          } DEV_PARM1;

typedef DEV_PARM1 FAR * PDEV_PARM1;

typedef struct {                       /* Real Mode data area (based at 40:0) */
                UCHAR  BIOS_PrinterData[0x10];         /* 0040:0000 */
                USHORT BIOS_equipflag;                 /* 0040:0010 */
                UCHAR  BIOS_Miscellaneous[0x37];       /* 0040:0012 */
                UCHAR  BIOS_crtmode;                   /* 0040:0049 */
                USHORT BIOS_crtcols;                   /* 0040:004A */
                USHORT BIOS_crtlen;                    /* 0040:004C */
                USHORT BIOS_crtstart;                  /* 0040:004E */
                USHORT BIOS_cursorposn[8];             /* 0040:0050 */
                union {
                  USHORT Type;
                  struct {
                    UCHAR EndCursor;
                    UCHAR StartCursor;
                    } CRTReg;
                  } BIOS_cursormode;                   /* 0040:0060 */
                UCHAR  BIOS_activepage;                /* 0040:0062 */
                USHORT BIOS_addr6845;                  /* 0040:0063 */
                UCHAR  BIOS_crtmodeset;                /* 0040:0065 */
                UCHAR  BIOS_crtpalette;                /* 0040:0066 */
                UCHAR  BIOS_SystemData[0x1D];          /* 0040:0067 */
                UCHAR  BIOS_rows;                      /* 0040:0084 */
                USHORT BIOS_points;                    /* 0040:0085 */
                UCHAR  BIOS_info;                      /* 0040:0087 */
                UCHAR  BIOS_info3;                     /* 0040:0088 */
                UCHAR  BIOS_DiskData[0x1F];            /* 0040:0089 */
                struct _VIDEO_PARAMS {
                  char FAR *VideoTablePtr;
                  struct _EGA_PALETTE {
                    UCHAR Palettes[16]; /* bytes 0 - 15 = palette registers */
                    UCHAR Overscan;     /* byte 16 = overscan register */
                    } FAR *EGARegs;
                  } FAR *BIOS_saveptr;                 /* 0040:00A8 */
          } VIDEO_BIOS;

typedef struct {
        USHORT  cb     ;
        USHORT  adapter;
        USHORT  display;
        ULONG   cbMemory;
        USHORT  Configuration; /* 1.2 */
        USHORT  DeviceDriver;
        USHORT  Flags;
        ULONG   HWBufferSize;
        ULONG   FullSaveSize;
        ULONG   PartSaveSize;
        USHORT  EMAdaptersOFF;
        USHORT  EMDisplaysOFF;
        USHORT  LEMAdapterdata;
        USHORT  EMAdapters;
        USHORT  LEMDisplaydata;
        USHORT  EMDisplays;
        } VDHCONFIGINFO;

typedef VDHCONFIGINFO FAR * PVDHCONFIGINFO;

/*----------------------------------------------------------------------*/
/* Definition of the Environment Block and its flags                    */
/*----------------------------------------------------------------------*/

typedef struct
{
   USHORT        ModeDataOFF;
   UCHAR         ModeIndex;    /* Index in Mode table to current mode */
   UCHAR         ROMFontIndex; /* Index in ROM font table or FILLER   */
   VIOMODEINFO   ModeData;     /* ScrollRect must follow ModeData @P1 */
   SCRLRECT      ScrollRect;   /* Scrollable rectangle of text screen */
   USHORT        AttrBufSize;  /* Byte in an attribute for cur mode   */
   UCHAR         AttrBuf[4];   /* default attribute for current mode  */
   USHORT        EnvFlags;     /* Flag word for this environment,     */
                               /* 0x01 = native mode                  */
                               /* 0x02 = dos session                  */
   XGASTATE      state_buffer;    /* dos XGA critical state */
   USHORT        VGAEnvironment;  /* Start of VGA envment for chaining */
} ENVIRONMENT;

typedef ENVIRONMENT FAR * PENVIRONMENT;


/*****************************************************************************/
/* VDH Routine Type Definitions */
/*****************************************************************************/

typedef struct {
          USHORT Length;
          USHORT Flags;
          USHORT Blink;
          USHORT Overscan;
          USHORT Underscore;
          USHORT VideoEnable;
          ULONG  DisplayMask;
          USHORT CodePageID;
          USHORT ScrlLeft;
          USHORT ScrlTop;
          USHORT ScrlRight;
          USHORT ScrlBottom;
          USHORT ScreenRows;
          USHORT ScreenCols;
          } VDH_VARIABLE;

typedef VDH_VARIABLE FAR * PVDH_VARIABLE;

typedef struct {
          USHORT       Length;
          USHORT       Flags;
          PVIOMODEINFO ModeDataPTR;
          } VDH_MODE;

typedef VDH_MODE FAR * PVDH_MODE;

typedef struct {
          USHORT         Length;
          USHORT         Flags;
          VDHCONFIGINFO FAR *ConfigDataPTR;
          } VDH_CONFIG;

typedef VDH_CONFIG FAR * PVDH_CONFIG;

typedef struct {
          USHORT Length;
          USHORT Flags;
          } VDH_INITENV;

typedef VDH_INITENV FAR * PVDH_INITENV;

typedef struct {
          USHORT Length;
          USHORT Flags;
          USHORT PVBHugeSEL;
          } VDH_SAVEREST;

typedef VDH_SAVEREST FAR * PVDH_SAVEREST;


/******************************************************************************/
/* prototype for chaining to vga                                              */
/******************************************************************************/
typedef USHORT (APIENTRY *FNVGACHAIN)(PVOID, PVOID, ULONG);

/******************************************************************************/
/* VDH Routine Entry Points                                                   */
/******************************************************************************/
USHORT EXPENTRY DEVENABLE(       PDEV_PARM2,  PDEV_PARM1,   ULONG );
USHORT EXPENTRY GetVariableInfo( PENVIRONMENT , PVDH_VARIABLE , ULONG );
USHORT EXPENTRY SetVariableInfo( PENVIRONMENT , PVDH_VARIABLE , ULONG );
USHORT EXPENTRY BVHGetMode(      PENVIRONMENT , PVDH_MODE ,     ULONG );
USHORT EXPENTRY BVHSetMode(      PENVIRONMENT , PVDH_MODE ,     ULONG );
USHORT EXPENTRY RetConfigInfo(   PENVIRONMENT , PVDH_CONFIG ,   ULONG );
USHORT EXPENTRY InitEnv(         PENVIRONMENT , PVDH_INITENV ,  ULONG );
USHORT EXPENTRY SaveEnv(         PENVIRONMENT , PVDH_SAVEREST , ULONG );
USHORT EXPENTRY RestoreEnv(      PENVIRONMENT , PVDH_SAVEREST , ULONG );
USHORT EXPENTRY ChainRouter(     PENVIRONMENT , PCHAR,         ULONG );

/*----------------------------------------------------------------------------*/
/* Monitor translate table                                                    */
/*                                                                            */
/* This table is indexed by the AI monitor ID bit values.                     */
/* It converts the AI ID bits to the VDH monitor identification format        */
/*----------------------------------------------------------------------------*/
     /***********************************************************/
     /* Display types:                                          */
     /*      0 - 5151 mono         5 - IBM Japan 5550 mono      */
     /*      1 - 5153 color        6 - IBM Japan 5550 color     */
     /*      2 - 5154 enhanced     7 - IBM Japan 5570 color     */
     /*      3 - 8503 mono         8 - IBM Japan 5570 full page */
     /*      4 - 8512/8513 color   9 - 8514 color               */
     /***********************************************************/
USHORT MonitorTable[] = {
                              0x00,              /* 0000         */
                              0x00,              /* 0001         */
                              0x00,              /* 0010         */
                              0x00,              /* 0011         */
                              0x0f,              /* 0100  5081                */
                              0x0d,              /* 0101  Buffalo             */
                              0x00,              /* 0110         */
                              0x0e,              /* 0111  Boston              */
                              0x00,              /* 1000         */
                              0x0B,              /* 1001  8604 + Albany       */
                              0x09,              /* 1010  8514                */
                              0x0c,              /* 1011  Dallas              */
                              0x00,              /* 1100         */
                              0x03,              /* 1101  8503 + Seattle      */
                              0x04,              /* 1110  8513 + 8512         */
                              0x00,              /* 1111  No monitor attached */
                               };

/******************************************************************************/
/* Private interfaces                                                         */
/******************************************************************************/
short         ExamineConfig( void );
void FAR      SaveRegs( void );
void FAR      RestoreRegs( void );
void FAR      PreSetMode( void );
void FAR      PostSetMode( void );
USHORT FAR xga_inp(USHORT);
USHORT FAR xga_outp(USHORT, USHORT);

USHORT EXPENTRY SAVERESTOREPVB( USHORT, USHORT, USHORT );
USHORT EXPENTRY APPTDEPSAVE( TDEPINFO FAR *);
USHORT EXPENTRY APPTDEPRESTORE( TDEPINFO FAR *);
USHORT EXPENTRY CHECKADAPTER(USHORT FAR *, ULONG FAR *, USHORT FAR *);
/* USHORT EXPENTRY QUERYNATIVE(); */
USHORT EXPENTRY UNLOCKLVB();
void   EXPENTRY HDIHSPAL(char FAR *, HSRPALBLK FAR *);  /* Dummy Handle, Parameter blk*/
void   EXPENTRY HDIHRPAL(char FAR *, HSRPALBLK FAR *);  /* Dummy Handle, Parameter blk*/
void   EXPENTRY HDIHCLOSE(char FAR *, USHORT FAR *);    /* Dummy Handle, Parameter blk*/
void   EXPENTRY HDIHOPEN(char FAR *, USHORT FAR *);     /* Dummy Handle, Parameter blk*/
void   EXPENTRY HDIHSYNC(char FAR *, USHORT FAR *);     /* Dummy Handle, Parameter blk*/

void          Debug( void );


/**********************************************************************/
/* The following section contains definitions relating to DMQS        */
/* overide file. (XGASETUP.PRO - see DMQS spec).                      */
/**********************************************************************/

typedef struct
{
  PUCHAR data;
  USHORT length;
  USHORT position;
} OVERRIDEBUFFER;

typedef OVERRIDEBUFFER FAR * POVERRIDEBUFFER;

/******************************************************************************/
/* Name of the DMQS override file                                             */
/* monitor file (monitor ID filled in at run-time)                            */
/******************************************************************************/
#define DMQS_OVERRIDE_FILE "XGASETUP.PRO"
#define DMQS_DISPLAY_FILE "MON????.DGS"
#define EXT_LENGTH 4
#define DMQS_DISPLAY_EXT ".DGS"

/******************************************************************************/
/* DMQS directory and                                                         */
/* maximum length of a filename (8+ . + 3)                                    */
/* position of first char of filename in DMQS_DIRECTORY                       */
/******************************************************************************/
#define DMQS_DIRECTORY "\\XGA$DMQS\\????????.???"
#define MAX_FILENAME_LEN 12
#define DMQS_DIR_FILE 10

/******************************************************************************/
/* DMQS environment variable                                                  */
/******************************************************************************/
#define DMQS_ENVIRONMENT "DMQSPATH"

/******************************************************************************/
/* Table of valid tokens for DMQS override file.                              */
/******************************************************************************/
#define BEGIN_TAG '<'
#define END_TAG '>'
#define DMQS_TOKEN_TABLE { BEGIN_TAG,'\0',                                      \
                           END_TAG,'\0',                                  \
                           ',','\0',                                      \
                           '=','\0',                                      \
                           'S','L','O','T','\0',                          \
                           'N','U','M','B','E','R','\0',                  \
                           'M','O','N','I','T','O','R','_','I','D','\0',  \
                           'S','T','A','R','T','U','P','\0','\0' }

#define DT_ERROR 0
#define DT_BEGIN_TAG 1
#define DT_END_TAG 2
#define DT_PARAM_SEPARATOR 3
#define DT_PARAM_EQUATE 4
#define DT_SLOT 5
#define DT_NUMBER 6
#define DT_MONITOR_ID 7
#define DT_STARTUP 8
#define DT_END_OF_DATA 0xffff

#define STATE_BEGIN 1
#define STATE_END 2
#define STATE_NUMBER 3
#define STATE_MONITOR_ID 4
#define STATE_COMPLETE 5
#define STATE_ERROR 0xffff


/******************************************************************************/
/* Maximum number of slots into which an XGA can be plugged.                  */
/******************************************************************************/
#define MAX_DMQS_SLOTS 8


