;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;	SCCSID = @(#)bvhxga.asm 13.1 91/01/18
	PAGE	60,132

;/**********************  START OF SPECIFICATIONS  **********************/
;/*									*/
;/*  SOURCE FILE NAME: bvhxga.asm					*/
;/*									*/
;/*  DESCRIPTIVE NAME: Assembler routines use by the XGA 20 BVH 	*/
;/*									*/
;/***********************  END OF SPECIFICATIONS  ***********************/
.386


;
;ͻ
;  Include files							      
;ͼ
;

?DF	equ	1	; we dont want _TEXT segment defined
include cmacros.inc

INCL_GPIBITMAPS EQU 1
include os2.inc
include struc.inc			   ; Structured assembly macros
include xgaadapt.inc
include eddhtype.inc



extrn xga_adapter   :word
extrn DosAllocSeg   :far
extrn DosAllocHuge  :far
extrn DosFreeSeg    :far
extrn DosSleep	    :far




_DATA		segment word use16 public 'DATA'
ensuresafe      db      0
_DATA  ENDS


_TEXT2	segment use16 dword public 'CODE'
ASSUME  CS:_TEXT2
ASSUME	DS:_DATA



public haltproc
haltproc proc far
	int	3
	ret
haltproc endp

ifdef BVHTESTING
public loopy
loopy	proc near
@@:	jmp	@B
loopy	endp
endif


_TEXT2	ENDS



;/***********************************************************************/
;/* The following code needs to be in a Ring 2 segment because it	*/
;/* performs I/O.							*/
;/***********************************************************************/

_RING2	segment use16 dword public 'CODE'
ASSUME  CS:_RING2


;/**********************  START OF SPECIFICATIONS  **********************/
;/*									*/
;/*  SUBROUTINE NAME: PreSetMode					*/
;/*									*/
;/*  DESCRIPTIVE NAME: Routine called before the VGA SetMode		*/
;/*									*/
;/*  FUNCTION: PreSetMode is made before a call to the VGA BVH SetMode. */
;/*	       Its purpose is to blank the screen using the VGA 	*/
;/*	       PEL MASK register, which will remain blank until 	*/
;/*	       we call PostSetMode. These functions are required	*/
;/*	       because otherwise we get unacceptable flickering 	*/
;/*	       when changing modes.					*/
;/*									*/
;/*  ENTRY POINT: PreSetMode						*/
;/*    LINKAGE:   CALL FAR						*/
;/*									*/
;/*  INPUT: NONE							*/
;/*									*/
;/*  EXIT-NORMAL:							*/
;/*									*/
;/*  INTERNAL REFERENCES:						*/
;/*    ROUTINES: NONE							*/
;/*									*/
;/*  EXTERNAL REFERENCES:						*/
;/*    ROUTINES: NONE							*/
;/*									*/
;/***********************  END OF SPECIFICATIONS  ***********************/
PUBLIC	  PreSetMode
PreSetMode  proc  far

PEL_MASK_REG	EQU   03C6h

	mov	dx,PEL_MASK_REG   ; Load DX with address of register
	xor	al,al		  ; Zero AL
	out	dx,al		  ; Zero the register
	ret			  ; Return

PreSetMode  endp


;/**********************  START OF SPECIFICATIONS  **********************/
;/*									*/
;/*  SUBROUTINE NAME: PostSetMode					*/
;/*									*/
;/*  DESCRIPTIVE NAME: Routine called after the VGA SetMode		*/
;/*									*/
;/*  FUNCTION: PostSetMode is made after a call to the VGA BVH SetMode. */
;/*	       Its purpose is to restore the VGA PEL MASK register	*/
;/*	       to make the screen contents visible. The screen will	*/
;/*	       have been blanked earlier (in PreSetMode) by clearing	*/
;/*	       this register.						*/
;/*	       Before reenabling the screen, we wait for five frames	*/
;/*	       which gives XGA time to copy the new fonts from VRAM	*/
;/*	       to SRAM. If we do not wait for five frames then junk	*/
;/*	       will momentarily appear on the screen.			*/
;/*									*/
;/*  ENTRY POINT: PostSetMode						*/
;/*    LINKAGE:   CALL FAR						*/
;/*									*/
;/*  INPUT: NONE							*/
;/*									*/
;/*  EXIT-NORMAL:							*/
;/*									*/
;/*  INTERNAL REFERENCES:						*/
;/*    ROUTINES: NONE							*/
;/*									*/
;/*  EXTERNAL REFERENCES:						*/
;/*    ROUTINES: NONE							*/
;/*									*/
;/***********************  END OF SPECIFICATIONS  ***********************/
PUBLIC	  PostSetMode
PostSetMode  proc  far

	; The following code waits for five frames.
	; It has been directly copied from the changes that were
	; made to the XGA BIOS.

	mov	dx,03cch		; Miscellaneous Output Register.
	in	al,dx			; Give me MOR.
	test	al,01h			; If the I/O address select bit
	jz	set3ba			; is off - Input Status Reg 1 at 3BAH.

	mov	dx,03dah		; On - so Input Status Reg 1 at 3DAH.
	jmp	wait_5_frames		; Go wait for two retrace cycles.
set3ba:
	mov	dx,03bah		; ISR1 is at 3BAH.
wait_5_frames:
	mov	cx,5			; Five Vertical Retraces required.
vrloop:
	push	cx			; Save outer loop counter
	xor	cx,cx			; Timeout value of 64k
vrloop1:
	in	al,dx			; Read ISR1.
	test	al,08h			; Do we have Vertical Retrace ?
	loope	vrloop1 		; No - so keep testing.
	xor	cx,cx			; Timeout value of 64k
vrloop2:				; Yes - now loop till it drops.
	in	al,dx			; Read ISR1.
	test	al,08h			; Has Vertical Retrace dropped ?
	loopne	vrloop2 		; No - so check again.
	pop	cx			; Restore outer loop counter
	loop	vrloop			; Repeat till CX = 0.

	; We've now waited for five frames so we just have to
	; enable the screen and exit.

	mov	dx,PEL_MASK_REG   ; Load DX with address of register
	mov	al,0FFh 	  ; Load AL with all 1s
	out	dx,al		  ; Store value in register
	ret			  ; Return

PostSetMode  endp








;/***********************************************************************/
;/*									*/
;/*  SUBROUTINE NAME: xga_inp						*/
;/*									*/
;/*  DESCRIPTIVE NAME: allows the ring 3 bvh to do an in		*/
;/*									*/
;/*									*/
;/***********************************************************************/
cProc	xga_inp, <PUBLIC, FAR>
	parmW	io_reg

cBegin
	xor	ax, ax
	mov	dx, word ptr io_reg
	in	al, dx
cEnd









;/***********************************************************************/
;/*									*/
;/*  SUBROUTINE NAME: xga_outp						*/
;/*									*/
;/*  DESCRIPTIVE NAME: allows the ring 3 bvh to do an out		*/
;/*									*/
;/*									*/
;/***********************************************************************/
cProc	xga_outp, <PUBLIC, FAR>
	parmW	io_reg
	parmW	io_val

cBegin
	mov	ax, word ptr io_val
	mov	dx, word ptr io_reg
	out	dx, al
cEnd

;/***********************************************************************/
;/*									*/
;/*  SUBROUTINE NAME: SemaphoreReplacement				*/
;/*									*/
;/*  DESCRIPTIVE NAME: almost a semaphore				*/
;/*									*/
;/***********************************************************************/
cProc	SemaphoreReplacement, <PUBLIC, FAR>

cBegin
	jmp	first_time
GoToSleep:
	push	0
	push	0
	call	DosSleep
first_time:
	cli
	mov	al, 0ffh
	xchg	al, ensuresafe
	cmp	al, 0
	sti
	jnz	GoToSleep
cEnd

_RING2	ENDS

END
