;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page ,132
;***********************************************************************
;
;   Module          = VIOMACRO.INC
;
;   Description     = Private AI code
;
;   Function        = Does AVIO text work
;
;
;   Change log:
;   Date      Mark         APAR      Description
;   --------  ------------ --------- -----------------------------------
;
;***********************************************************************


ifdef   BPP24

;----------------------------------------------------------------------
; takes P0|P1|P2|P3 in AX and outputs to DX port
;----------------------------------------------------------------------
SendBits16      macro
        IFNDEF S3
        rol     al,4                    ; now       P0|P1|P3|P2
        rol     ax,4                    ; now       P1|P3|P2|P0
        rol     ah,4                    ; now       P3|P1|P2|P0
        rol     ax,1                    ; P0,P1 into hw position
        out     dx,ax                   ; output P0,P1
        ror     ax,4                    ; P2,P3 into hw position
        out     dx,ax                   ; output P2,P3
        ELSE
        xchg    ah,al
        out     dx,ax
        ENDIF
        endm

;----------------------------------------------------------------------
; extracts and saves bits for phase shifting
;----------------------------------------------------------------------
SavePhaseBits macro reg8
        mov     bl, reg8                ; cache new unused pixels
        not     ch                      ; form left mask
        and     bl, ch                  ; isolate new unused pixels
        not     ch                      ; restore right mask
        and     reg8, ch                ; make room for old unused pixels
        or      reg8, bh                ; add in old unused pixels
        mov     bh, bl                  ; save new unused pixels
        endm

;----------------------------------------------------------------------
; aligns bytes in AL, AH
;----------------------------------------------------------------------
DoPhaseShift macro
        xchg    ah,al                   ; now P0|P1|P2|P3
        ror     ax,cl                   ; align to destination
        SavePhaseBits ah                ; AH has rightmost bits
        SendBits16                      ; send out AX
        endm


; check_grey
; ----------
;
;   variables referenced:
;       AIxfer.bFGIndex
;       AIxfer.bBGIndex
;       _pAVIOColorXlate
;
;   variables set:
;        _Shadow8514Regs.Color_0
;        _Shadow8514Regs.Color_1
;
;   registers destroyed:
;       eax
;
check_grey Macro g_flag
        Local   not_grey

        mov     g_flag,0                        ;; assume not grey
ifndef  AVIO_EPOCH_MONO_TEXT
        movzx   eax,AIxfer.bFGIndex
        shl     eax,2                           ;; table is dwords so * 4
        add     eax, dword ptr _pAVIOColorXlate ;; add the table start
        mov     eax, [eax]                      ;; get the color value
        mov     _Shadow8514Regs.Color_1,eax
        movzx   eax,AIxfer.bBGIndex
        shr     eax,2                           ;; was * 16 so div by four
        add     eax, dword ptr _pAVIOColorXlate ;; add the table start
        mov     eax, [eax]                      ;; get the color value
        mov     _Shadow8514Regs.Color_0,eax
else  ; AVIO_EPOCH_MONO_TEXT
        mov     eax,_Shadow8514Regs.Color_0
endif ; AVIO_EPOCH_MONO_TEXT
        rol     eax,8                           ;; XXBBGGRR -> BBGGRRXX
        mov     al,ah                           ;; BBGGRRRR
        ror     eax,8                           ;; RRBBGGRR
        xor     al,ah                           ;; GG == RR?
        jnz     not_grey                        ;; no, not gray
        shr     eax,16                          ;; 0000RRBB
        xor     al,ah                           ;; RR == BB?
        jnz     not_grey
        mov     eax,_Shadow8514Regs.Color_1
        rol     eax,8                           ;; XXBBGGRR -> BBGGRRXX
        mov     al,ah                           ;; BBGGRRRR
        ror     eax,8                           ;; RRBBGGRR
        xor     al,ah                           ;; GG == RR?
        jnz     not_grey                        ;; no, not gray
        shr     eax,16                          ;; 0000RRBB
        xor     al,ah                           ;; RR == BB?
        jnz     not_grey                        ;; no, not grey
        mov     g_flag,1                        ;; yes
not_grey:
        Endm


; calc_clip
; ---------
;   input:
;       DX              - blt target height (0 based)
;       dest_pos (esi)  - dest position (y-x format)
;
;   output:
;       esi         - clipped dest position
;       is_clipped  - 1: totaly clipped out.
;
;   variables referenced:
;        LeftClip   (stack)
;        RightClip  (stack)
;        TopClip    (stack)
;        BottomClip (stack)
;
;   variables set:
;       x_src (stack)       - x blt src mask
;       y_src (stack)       - y blt src mask
;       usHeight (stack)    - blt height (1 based)
;
;   registers destroyed:
;       eax, edx, edi
;
calc_clip Macro dest_pos, is_clipped
        Local   LeftOK
        Local   RightOK
        Local   TopOK
        Local   BottomOK
        Local   done_24_char
        Local   L1

        Ifdifi  <dest_pos>,<esi>
        mov     esi,dest_pos            ;; dest pos (y-x format)
        Endif

;;*****        inc     dx                      ;; make one based
;;*****        mov     usHeight, dx

        mov     x_src,0                 ;; assume no clipping
        mov     y_src,0

        mov     edi, pAvioInfo
        movzx   eax,[edi].bCellHeight   ;;*****
        mov     usHeight, ax            ;;*****
        mov     eax,esi
        movzx   edx,[edi].bCellWidth    ;; ax = x dest  dx = blt width
        mov     usPels,dx               ;; assume full char width
        cmp     ax,LeftClip             ;; any clipping on left?
        jge     LeftOK                  ;; no, check right edge
        add     ax,dx                   ;; ax = right edge of blt
        sub     ax,LeftClip             ;; are we totally clipped out?
        jle     done_24_char            ;; yes, don't bother
        mov     usPels,ax               ;; new blt width
        mov     dx,ax                   ;; save for later
        mov     ax,LeftClip
        sub     ax,si
        mov     x_src,ax
        add     si,ax                   ;; new x dest
        mov     ax,si                   ;; check right edge
LeftOK:
        cmp     ax,RightClip            ;; are we totally clipped out?
        jg      done_24_char            ;; yes
        add     ax,dx                   ;; dx has blt width
        sub     ax,RightClip
        jle     RightOK
        dec     ax
        sub     usPels,ax
        jz      done_24_char
RightOK:
        shr     eax,16                  ;; ax = y dest
        cmp     ax,BottomClip           ;; are we totaly clipped out?
        jg      done_24_char            ;; yes
;;        movzx   edx,[edi].bCellHeight
        movzx   edx,usHeight
        sub     ax,TopClip
        jge     TopOK
        neg     ax
        sub     dx,ax                   ;; new height
        jle     done_24_char
        mov     y_src,ax
        rol     esi,16
        add     si,ax
        rol     esi,16
TopOK:
        mov     eax,esi
        shr     eax,16
        add     ax,dx                   ;; ax = bottom of blt
        sub     ax,BottomClip
        jle     BottomOK
        dec     ax
        sub     dx,ax
        jle     done_24_char
BottomOK:
        mov     usHeight,dx
        mov     is_clipped, 0
        jmp     L1

done_24_char:
        mov     is_clipped, 1
L1:
        Endm


; avio_mem_to_vram
; ----------------
;
;       EAX         - source offset (y-x format)
;       lCurrentPos - destination position (y-x format)
;       DX          - blt target height (0 based)
;
;
avio_mem_to_vram Macro CellValue
        Local    abc_spaced_font
        Local    store_char_width
        Local    ss_mono_not_24
        Local    mono_to_vram_return

if 0
        mov     esi, eax                ;; save it
        mov     x_src, ax
        swap    eax
        mov     y_src, ax

        mov     edi, pAvioInfo
        movzx   ax, [edi].bCellWidth
        mov     usPels, ax
        mov     usHeight, dx
endif ; 0

        mov     eax, PattMap
        add     ax,x_src
        and     ax,00007h               ;; *
        push    ax                      ;; param(1) bits into first byte

        push    ONE_BPP                 ;; param(2) format

        movzx   edx,usHeight
        dec     edx                     ;; make zero-based ???????
        push    edx                     ;; param(3) height

if      CELL_SHIFT eq 2

        ;; 4 bytes per cell can have LCID fonts.
        mov     ecx, CellValue
        swap    ecx
        .ERRNZ  MFI_FONTBITS AND 0ffffff00h
        and     ecx, MFI_FONTBITS
        mov     eax, SIZE FONTDETAILS
        mul     ecx
        add     eax, pFontDetails

else  ;;CELL_SHIFT eq 2

        mov     eax, pFontDetails

endif ;;CELL_SHIFT eq 2

        movzx   ecx, word ptr [eax].usCachedFontIndex
        mov     eax, SIZE FontCacheInfo
        mul     ecx
        mov     edi, _pFontCacheInfo
        add     edi, eax
        mov     ebx, indx
        mov     ebx, CIndexArray[ebx*4]
        lea     ebx, [ebx + ebx*2]     ;; EBX <- EBX * 3
        lea     ebx, [edi].fci_aCharDef[ebx*2]
                                       ;; so we assume 1 entry is 6 bytes
        .errnz  type FcCharDef - 6

        push    edi                     ;; save it
        mov     edi, pFocafnt
        cmp     [edi].ff_fdDefinitions.fdh_fsChardef, FONTDEFCHAR3
        je      short abc_spaced_font

        movzx   ebx, word ptr [ebx].fccd_width
        jmp     short store_char_width

abc_spaced_font:
        movzx   ebx, word ptr [ebx].fccd_bspace

store_char_width:
        mov     ax, bx                  ;; bmap width in pels           *
        add     ax, 7                   ;; round up to byte boundary    *
        and     ax, NOT 7               ;;                              *
        shr     ax, 3                   ;; get byte count               *
        mul     y_src                   ;;                              *
        mov     y_src, ax               ;; save byte offset into y_src  *

        pop     edi                     ;; restore it
        dec     ebx                     ;; Make zero-based*****
        push    ebx                     ;; param(4) bmap width

        movzx   edx,usPels
        dec     edx                     ;; Make zero-based
        push    edx                     ;; param(5) blt width

        swap    esi                     ;; get in x-y format
        push    esi                     ;; param(6) vram dest

        ;; now get the address of the char definition
        mov     ebx, indx
        mov     ebx, CIndexArray[ebx*4]
        movzx   eax, y_src              ;;                              *
        add     eax, [edi].fci_aCharOffset[ebx*4]   ;;                  *
;;;*    mov     eax, [edi].fci_aCharOffset[ebx*4]
        mov     edx, PattMap            ;; *
        and     edx, 00000ffffh         ;; needs only x-axis.
        add     dx, x_src               ;; *
        shr     edx, 3                  ;; *
        add     eax, edx                ;; *
        push    eax                     ;; param(7) memory source
        test    [_DDT],USE_24BPP
        jz      ss_mono_not_24

        call    _Copy24MonoToVRAM
        jmp short mono_to_vram_return

ss_mono_not_24:
        call    _Copy16MonoToVRAM

mono_to_vram_return:
        add     esp,26

        Endm


endif ;; BPP24


ifdef _8514

; select_font_cache_plane
; -----------------------
;
; for the defect 75206
;
;   registers destroyed:
;       EAX, EDX
;
;   registers preserved:
;       EBX, ECX
;
select_font_cache_plane Macro  fpo_index
       Local    Dontneed
       Ifdifi   <fpo_index>,<eax>
       mov      eax,fpo_index            ;; fetch data value
       Endif

       mov      dl, byte ptr CfpoArray[eax]     ;; Font plane number
       cmp      dl, _SPad.fontnum
       jz short Dontneed                        ;; same font plane

       mov      _SPad.fontnum, dl               ;; save it

       push     ecx
       mov      cl, dl
       WaitQ    2                               ;; note that AX and DX are destroyed
       mov      eax, 1
       shl      eax, cl
       ifndef S3
       rol      al, 1
       endif ;; S3
       outwQ    READ_ENABLE,ax                  ;; located on a bit plane.
       outwQ    WRITE_ENABLE,WRITE_ALL_PLANES   ;; Expand to all planes.
       pop      ecx
Dontneed:
       endm

endif ;; _8514





ifdef   _8514

; avio_blt_from_vram
; ------------------
;
avio_blt_from_vram Macro
        Local   L1
        Local   L2

        WaitQIdle
        WaitQ   5

        mov     eax,PattMap
        swap    eax
        mov     ebx,pVRAM
        add     ebx,eax

        calc8514xy      ebx
        mov     ecx,edx
        outwQ   Y0,ax
        mov     eax,ecx
ifdef   BPP24
        test    [_DDT],USE_24BPP
        jz      L1
        mov     dx,3
        mul     dx
L1:
endif
        outwQ   X0,ax

        mov     eax, DestMap
ifdef   BPP24
        test    [_DDT],USE_24BPP
        jz      L2
        mov     dx,3
        mul     dx
L2:
endif
        outwQ   X1,ax
        swap    eax
        outwQ   Y1,ax
        mov     ax, Dim2
        outwQ   LY,ax

        select_font_cache_plane indx

;; Now, a bacon, lettuce & tomato please.
        WaitQ   1
        outwQ   CMD_FLAGS,CMD_DRAWTEXT
        Endm

endif ; _8514


