;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    Thunk Functions
        SUBTITLE Header
;/*****************************************************************************
;*
;* SOURCE FILE NAME = MYTHUNK.ASM
;*
;* DESCRIPTIVE NAME = 32 -> 16 bit thunks to PMWIN
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/09/91
;*
;* DESCRIPTION  This file contains functions to thunk between the 32 bit
;*              driver functions and the 16 bit Presentation Manager Window
;*              functions.
;*
;*
;* FUNCTIONS    VioGetPSAddress32
;*              ThunkToVioGetPSAddress
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/9/91                      KEZ  Original
;*   11/26/92                     John Batty. Added DCAF changes.
;*                                (Reordered headers).
;*
;*****************************************************************************/

        .386P
        .MODEL FLAT,SYSCALL
OPTION PROLOGUE:None    ; Added by SEL
OPTION EPILOGUE:None

;/*
;** Included files
;*/


        EXTERNDEF DOS32FLATDS                  :ABS

        EXTRN   Vio16GetPSAddress:FAR16

ring3_VioGetPSAddress PROTO SYSCALL
_DMS32CallBack        PROTO PASCAL,  pfnFunction :DWORD
VioGetPSAddress32     PROTO SYSCALL, hVIO        :DWORD

;/*
;** Public functions
;*/

        .CODE

        SUBTITLE GetPSAddress
        PAGE +

;/***************************************************************************
;*
;* FUNCTION NAME = GetPSAddress
;*
;* DESCRIPTION   =
;*
;* INPUT         =
;*
;* OUTPUT        =
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

        ALIGN   4

GetPSAddress PROC PASCAL, hVIO     :DWORD

        push    ebp
        mov     ebp,esp

        MOV     EDX, hVIO

        INVOKE  _DMS32CallBack,OFFSET ring3_VioGetPSAddress

        mov     eax,edx                         ; restore pVioPS

        mov     esp,ebp
        pop     ebp
        RET

GetPSAddress ENDP

        ALIGN   4

ring3_VioGetPSAddress PROC SYSCALL


        INVOKE  VioGetPSAddress32,
                edx                             ; hVIO

;        or      eax,eax
;        jnz     ring3_VioGetPS_okay
;        mov     eax,0
;ring3_VioGetPS_okay:
        ret
ring3_VioGetPSAddress ENDP


        SUBTITLE VioGetPSAddress32 Function
        PAGE +

;/***************************************************************************
;*
;* FUNCTION NAME = VioGetPSAddress32
;*
;* DESCRIPTION   = This routine is a thunk to the VIO routine
;*                 and is taken largely from the 32 PM GRE thunks.
;*
;* INPUT         = hVIO: DWORD
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

        ALIGN   4

VioGetPSAddress32 PROC SYSCALL, hVIO     :DWORD

        PUSH    EBP
        MOV     EBP,ESP

;/*
;** Compare stack selector against FLAT:R3DSB
;** If the selector is not equal, then don't bump stack.
;*/

        MOV     EDX,SS
        CMP     DX,DOS32FLATDS          ; 32 bit stack?
        JNE     @F                      ; If not, skip bumping code

;/*
;** Bump the stack down if too near 64K boundary.
;*/

        MOV     EDX,ESP
        CMP     DX,4096
        JAE     @F
        XOR     DX,DX
        MOV     ESP,EDX                 ; Bump the stack down

;/*
;** Insure that 1 DWORD exists on stack
;*/

        PUSH    EDX
@@:

;/*
;** Create new call frame, using 16-bit semantics.
;*/

        PUSH    ES
        PUSH    EBX
        PUSH    EBP                     ; Save EBP
        MOV     EDX,ESP                 ; Save current ESP
        PUSH    SS
        PUSH    EDX

;/*
;** Convert SS:ESP to 16-bit SS:SP.
;*/

        MOV     DX,SS                  ; Get cpl bits to use as dpl bits
        AND     DX,3                   ; Mask off rest of register

        OR      DL,4                    ; Force LDT bit on

        MOV     EAX,ESP                 ; Use CRMA on ESP to get SS
        ROR     EAX,16
        SHL     EAX,3
        OR      AL,DL
        mov     edx,hVIO
        MOV     SS,EAX
        JMP     FAR ptr ThunkToVioGetPSAddress


        ALIGN   4

R_VioGetPSAddress::                     ; Label defining return JMP location

;/*
;** Restore 32-bit SS:ESP - it is on top of stack.
;*/

        MOVZX   ESP,sp                  ; make sure that ESP is correct
        LSS     ESP,[ESP]
        POP     EBP
        POP     EBX
        POP     ES

;/*
;** Convert Return Code
;*/

        ror     eax,16
        shr     ax,3
        rol     eax,16
        mov     edx,eax                 ; save pVioPS

;/*
;** Return type maps directly.
;*/

;/*
;** 32-bit return code.
;*/

        LEAVE

        RET

VioGetPSAddress32 ENDP

        PAGE +

_Text16 SEGMENT DWORD PUBLIC USE16 'CODE'

        SUBTITLE ThunkToVioGetPSAddress Function

;/***************************************************************************
;*
;* FUNCTION NAME = ThunkToVioGetPSAddress
;*
;* DESCRIPTION   = This 16-bit function is called from the 32-bit
;*                 VioGetPSAddress32 function to allow a call through a call
;*                 gate to VioGetPSAddress.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

        ALIGN   4

ThunkToVioGetPSAddress PROC FAR SYSCALL

        xor     eax,eax
        push    eax
        mov     ax,sp
        push    ss
        push    ax
        push    dx
        CALL    Vio16GetPSAddress
        pop     eax
        JMP     FAR PTR FLAT:R_VioGetPSAddress  ; jump back

ThunkToVioGetPSAddress ENDP

_Text16 ENDS

END
