;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    ,132
        TITLE   DBCSTHNK.ASM

        .386p

_CODE  SEGMENT PARA USE32 PUBLIC 'CODE'
_CODE  ENDS

_CODE16 SEGMENT PARA USE16 PUBLIC 'CODE'
_CODE16 ENDS

_TEXT16 SEGMENT PARA USE16 PUBLIC 'CODE'
_TEXT16 ENDS

        EXTRN   DOS16CALLBACK:FAR
;        EXTERNDEF    pszPMNLSFM:DWORD
;        EXTERNDEF    R3hModule :DWORD

        EXTERNDEF    _szFMname:DWORD
        EXTERNDEF    _szFMDispatchTable:DWORD
        EXTERNDEF    _FMDispatchTable:DWORD

DosLoadModule PROTO SYSCALL,
                ErrObjNames :DWORD,
                ERRBUFLEN   :DWORD,
                szPMNLSFM   :DWORD,
                hModule     :DWORD

_CODE  SEGMENT PARA
        ASSUME  DS:FLAT,ES:FLAT

R2LoadFontMgr32 PROC SYSCALL

; Save SS:ESP to restore on top of stack

        push    ss
;        push    ebp    ;Temporary
        mov     eax,esp ;   fix
        push    eax     ;    dayo--n !!

; Convert SS:ESP to 16-bit SS:SP via CRMA

        mov     eax,esp
        shr     eax,16
        shl     eax,3
        or      al,6                    ; R2 LDT selector for stack in AX
        push    eax                     ; Put new SS on stack

        movzx   eax,sp
        add     eax,4
        push    eax                     ; Put new ESP on stack
        lss     esp,[esp]               ; Set the new SS:ESP for 16R2

        JMP     FAR ptr T_R2LoadFontMgr16
R_R2LoadFontMgr16::
        movzx   esp,sp
        lss     esp,[esp]               ; Restore stack for return

        add     esp,4   ;Temporary fix
        ret

R2LoadFontMgr32 ENDP

;---------------------------Public-Routine------------------------------;
; R3LoadFontMgr32
;
;   Load specified dynamic link module.
;
; Returns:
;       AX = DosLoadModule return code
; Registers Destroyed:
;       EAX
; Registers Preserved:
;       EBX,ECX,ESI,EDI
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;
        PUBLIC  R3LoadFontMgr32
ALIGN 4
R3LoadFontMgr32::

; Save the old SS:SP for restoration before return to 16R3
        mov     eax,esp
        push    ss
        push    eax                     ; Save the old SS:ESP on top of stack

; Convert 16-bit SS:SP to 32-bit SS:ESP via reverse CRMA for other thunks

        mov     eax,esp
        ror     eax,16
        mov     ax,ss
        shr     ax,3
        rol     eax,16                  ; Get new ESP relative to FLAT
        push    ds                      ; Put new SS on stack
        push    eax                     ; Put new ESP on stack
        lss     esp,[esp]               ; Set the new SS:ESP for 32R3

; Put the parameters on the stack and call the Dispatcher at ring 3

        push    ebp
        mov     ebp,esp
        sub     esp,4
        mov     eax,esp
        lea     ebx,_szFMname

        INVOKE  DosLoadModule,
                0,
                0,
                ebx,
                eax

        mov     edx,[ebp-4]
        mov     esp,ebp
        pop     ebp
        lss     esp,[esp]               ; Restore old SS:SP for 16R3

        jmp     FAR PTR R3LoadFontMgr16ret

_CODE  ENDS

_CODE16 SEGMENT PARA

                public T_R2LoadFontMgr16
T_R2LoadFontMgr16 PROC FAR

        push    SEG    R3LoadFontMgr16
        mov     ax,OFFSET R3LoadFontMgr16
        push    ax
        call    DOS16CALLBACK

        jmp     FAR PTR FLAT:R_R2LoadFontMgr16 ; jump back
T_R2LoadFontMgr16 ENDP

_CODE16 ENDS


_TEXT16 SEGMENT PARA

                public R3LoadFontMgr16
R3LoadFontMgr16 PROC FAR
        jmp     FAR PTR FLAT:R3LoadFontMgr32 ; Return to 32-bit at R3
R3LoadFontMgr16 ENDP

                public R3LoadFontMgr16ret
R3LoadFontMgr16ret PROC FAR
        ret
R3LoadFontMgr16ret ENDP

_TEXT16 ENDS

END
