;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132

        .386

        .MODEL FLAT,SYSCALL

        ASSUME  CS:FLAT,SS:FLAT,DS:FLAT,ES:FLAT

        EXTERNDEF    _szFMname:DWORD
        EXTERNDEF    _szFMDispatchTable:DWORD
        EXTERNDEF    _FMDispatchTable:DWORD

R2LoadFontMgr32 PROTO SYSCALL

DosLoadModule PROTO SYSCALL,
                ErrObjNames :DWORD,
                ERRBUFLEN   :DWORD,
                szPMNLSFM   :DWORD,
                hModule     :DWORD

DosQueryProcAddr PROTO SYSCALL,
                hmodHandle  :DWORD,
                ulOrdinal   :DWORD,
                pszProcName :DWORD,
                pProcAddr   :DWORD


        .XLIST

FMDISPATCH32                    STRUC
fmdisp32_Fm32QueryFonts         DD      ?
fmdisp32_Fm32OpenFont           DD      ?
fmdisp32_Fm32CloseFont          DD      ?
fmdisp32_Fm32QueryCharAttr      DD      ?
fmdisp32_Fm32CharStr            DD      ?
fmdisp32_Fm32CharStr2           DD      ?
fmdisp32_Fm32MapCharGlyph       DD      ?
fmdisp32_Fm32MapCharGlyph2      DD      ?
fmdisp32_Fm32LoadFontDriver     DD      ?
fmdisp32_Fm32UnloadFontDriver   DD      ?
fmdisp32_Fm32FlushCache         DD      ?
FMDISPATCH32                    ENDS


        .LIST

;        .DATA

;-----------------------------------------------------------------------;
; word <-> dword convert table
;-----------------------------------------------------------------------;
;align 4
;ArrayConvTable  dw      512     dup(?)


;-----------------------------------------------------------------------;
; DBCS device font support module
;-----------------------------------------------------------------------;

;szFmDispatchTbl db      'DDFM_DISPATCH_TABLE32',0
;alpFm           dd      (size FMDISPATCH32)/4 dup (0)

;szPMNLSFM       db      'PMNLSFM',0
;pszPMNLSFM      dd      ?

        .CODE

page

;---------------------------Public-Routine------------------------------;
; DbcsLoadFontManager
;
;   Load DBCS font manager for current DbcsLoadFontManager process.
;   Font manager dispatch table will be copied.
;
; Return:
;   EAX    = 0 else error code
; Registers Destroyed:
;   EAX,EBX,ECX,EDX
; Registers Preserved:
;   ESI,EDI
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

ERRBUFLEN       equ     100

DbcsLoadFontManager PROC SYSCALL uses ESI EDI EBX
        LOCAL   lpEntry     :DWORD,
                hModule     :DWORD,
                ErrObjNames[ERRBUFLEN] :BYTE

        mov     eax,cs
        and     eax,1           ;at R3?
        jnz     Case_R3         ;Yes

; Load DBCS font manager (from Ring 2).

;        lea     eax,szPMNLSFM
;        mov     pszPMNLSFM,eax
        call    R2LoadFontMgr32

; Check return code

        or      ax,ax
        jnz     loadfm_done
        mov     hModule,edx
        jmp     Get_dispatch_table

; Load DBCS font manager (from Ring 3).

Case_R3:
        INVOKE  DosLoadModule,
                ADDR ErrObjNames,
                ERRBUFLEN,
                ADDR _szFMname,
                ADDR hModule
        or      ax,ax
        jnz     loadfm_done

        public Get_dispatch_table
Get_dispatch_table::

; Get font manager dispatch table.

        INVOKE  DosQueryProcAddr,
                hModule,
                0,
                ADDR _szFMDispatchTable,
                ADDR lpEntry
        or      ax,ax
        jnz     loadfm_done

; Copy font manager dispatch table.

        mov     esi,lpEntry
        lea     edi,_FMDispatchTable
        mov     ecx,(size FMDISPATCH32)/4
        cld
        rep     movsd
        xor     ax,ax

loadfm_done:
        movzx   eax,ax
        ret
DbcsLoadFontManager ENDP



DbcsDosLoadModule PROC SYSCALL uses ESI EDI EBX,
        pszName     :DWORD,
        phmod       :DWORD
        LOCAL   ErrObjNames[ERRBUFLEN] :BYTE

        mov     eax,cs
        and     eax,1           ;at R3?
        jnz     ddlm_Case_R3    ;Yes

; Load DBCS font manager (from Ring 2).

;        lea     eax,szPMNLSFM
;        mov     pszPMNLSFM,eax
        call    R2LoadFontMgr32

; Check return code

        or      ax,ax
        jnz     loadmod_done
;;;        mov     [phmod],edx
        lea     ebx,phmod
        mov     ebx,[ebx]
        mov     [ebx],edx
        jmp     loadmod_done

; Load DBCS font manager (from Ring 3).

ddlm_Case_R3:
        INVOKE  DosLoadModule,
                ADDR ErrObjNames,
                ERRBUFLEN,
                pszName,
                phmod

loadmod_done:
        movzx   eax,ax
        ret
DbcsDosLoadModule ENDP

end
