;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;*******************************************************************************
;
; MODULE NAME: XGAADAPT.INC
;
; DESCRIPTION: Definitions needed to use the xga kernel device driver.
;
; CHANGE HISTORY:
;
;   17Sep92 KJE - DCR53004 (WPS Implementation for INT 10 DMQS Services).
;
;*******************************************************************************

;**********************************************************************
;*
;* xgaadapt.inc definitions needed to use the xga kernel device driver
;*
;**********************************************************************

;*******************************************************************************
; constants for devopen of xgaring0
;*******************************************************************************
FACTION         EQU     0001h           ;open if existing, fail otherwise
SYSFILE         EQU     0004h           ;open as system file
DEVOPEN         EQU     4042h           ;synchronous, deny none, read/write

;*******************************************************************************
; constants for devioctls to xgaring0
;*******************************************************************************
DEVINIT            EQU     0002h
BVH_CONFIG         EQU     0006h           ;IOCtl number
IO_SAVE_VRAM       EQU     0007h           ;IOCtl number
IO_RESTORE_VRAM    EQU     0008h           ;IOCtl number
IO_VGA_MODE        EQU     0009h
IO_NATIVE_MODE     EQU     000ah
IO_SAVE_COPROC     EQU     000bh
IO_RESTORE_COPROC  EQU     000ch
IO_132_COL_MODE    EQU     000dh
IO_SAVE_REGS       EQU     000eh
IO_RESTORE_REGS    EQU     000fh
IO_SAVE_PALETTE    EQU     0010h
IO_RESTORE_PALETTE EQU     0011h

;*******************************************************************************
; additional 2.0 routines
;*******************************************************************************
IO_FLAT_LOCK       equ     0012h
IO_FLAT_UNLOCK     equ     0013h
IO_FLAT_ACCESS     equ     0014h
IO_CREATE_CALLGATE equ     0015h

GEN_FUNCTION       EQU     0041h           ;IOCtl function number
XGA_CATEGORY       EQU     0081h           ;IOCtl category number

;*******************************************************************************
; pixel operations for save /restore vram operations
; -  background source: source pixel map
; -  foreground source: source pixel map
; -  step: PxBlt
; -  source pixel map: Map B for save, A for restore
; -  destination pixel map: Map A for save, B for restore
; -  pattern pixel map: foreground (fixed)
; -  mask pixel map: disabled
; -  drawing mode: don't care
; -  direction octant: left to right, top to bottom
;*******************************************************************************
FROM_VRAM       EQU     0a8218000h
TO_VRAM         EQU     0a8128000h

;*******************************************************************************
; coprocessor control register values
;*******************************************************************************
COPROC_BUSY             equ     80h
TERMINATE_OPERATION     equ     20h
SUSPEND_OPERATION       equ     08h
SAVE_STATE              equ     02h
OPERATION_SUSPENDED     equ     10h

;*******************************************************************************
; monitor ids for xga supported displays
;*******************************************************************************
D_8517          equ     090F0h
D_8507_8604     equ     0F00Fh
D_8514          equ     0F0F0h
D_8515          equ     0F0FFh
D_8503          equ     0FF0Fh
D_8512_8513     equ     0FFF0h
D_NONE          equ     0FFFFh

;*******************************************************************************
; monitor types as defined by DMQS spec
;*******************************************************************************
MT_MONO_CRT         equ 00000h
MT_COLOR_CRT        equ 00001h
MT_MONO_LCD         equ 00002h
MT_COLOR_LCD        equ 00003h
MT_MONO_BORDERLESS  equ 00004h
MT_COLOR_BORDERLESS equ 00005h

;*******************************************************************************
; max size of coprocessor save / restore buffer
;*******************************************************************************
SIZE_COPROC_STATE       equ    400h
SIZE_PALETTE            equ    300h
SIZE_IO_REGISTERS       equ    44h

;*******************************************************************************
; system id register values (index 53)
;*******************************************************************************
XGA_CHIP_MASK equ  0f0h
XGA_CHIP_V30  equ  30h
XGA_DAC_SPD31 equ  0

;*******************************************************************************
; values for flags in ADAPTERINFO
;*******************************************************************************
XGA_PRIMARY_ADAPTER  equ 1
XGA_EXTERNAL_POLLING equ 2
XGA_16BPP_SUPPORTED  equ 4


;*******************************************************************************
; structure definitions
;*******************************************************************************

;*******************************************************************************
; check_adapter DevIOCtl structure - must be the same as
; in xgaadapt.h
;*******************************************************************************
adapterinfo     struc
   usDisplayType   dw    ?
   lMemorySize     dd    ?
   usFlags         dw    ?
   usIORegBase     dw    ?
   pxmMemRegBase   dd    ?
   ulVRAMBase      dd    ?
   hfDevHandle     dd    ?
   AdapterID       dw    ?
adapterinfo     ends

adapterinfo2    struc
   usScreenWidth   dw    ?
   usScreenHeight  dw    ?
   usMonitorType   dw    ?
adapterinfo2    ends

MAX_ISO_COLOURS    EQU 11

MAX_MON_ID EQU 5

XGAINSTANCE struc
pos_id                  dw      ?
pos_data                db      4   dup(?)
slot_number             db      ?       ;0-8 (0 = planar)
XGA_level               dw      ?       ;implementation level
XGA_io_base             dw      ?       ;base address of i/o registers
XGA_mem_map_phys        dd      ?       ;base address of mem mapped registers
XGA_mem_map_virt        dd      ?
XGA_mem_map_flat        dd      ?
XGA_base_vram           dd      ?       ;base addr of vram in memory
XGA_monitor_id          dw      ?
XGA_vram_size           dd      ?       ;total vram available
primary_adapter         db      0       ;flag to indicate adapter is primary
phys_addr_instance      dd      0       ;physical addr of XGAINSTANCE itself
XGA_1M_aperture_phys    dd      0
XGA_1M_aperture_flat    dd      0
XGA_4M_aperture_phys    dd      0
XGA_4M_aperture_flat    dd      0
DMQS_Mon_File_Memory    dw      0       ;selector of allocated memory for file
usScreenSizeX           dw      ?
usScreenSizeY           dw      ?
usMonitorTypeInstance   dw      ?
pszMonitorID            db      (MAX_MON_ID) dup (?)
argb2ISOColours         db      (MAX_ISO_COLOURS * size RGB2) dup (?)
XGAINSTANCE ends

SIZEOFXGAINSTANCE       EQU     size XGAINSTANCE

modedata        struc
   usPelsWide       dw   ?
   usPelsHigh       dw   ?
   bBitsPerPel      db   ?
   bInstance        db   ?
   bSlot            db   ?
   pDMQSModeData    dd   ?
modedata ends

MAX_NUM_DMQS_MODES EQU 30

modedatainfo    struc
   bNumberOfModes   db   ?
   primary_adapter_slot dw ?
   ModesData        db   (MAX_NUM_DMQS_MODES * size modedata) dup (?)
modedatainfo    ends

dmqs_mon_data_header    struc
   usLength         dw   ?
   usXPels          dw   ?
   usYPels          dw   ?
   usMinXGALevel    dw   ?
   usVendorID       dw   ?
   usReserved       dw   ?
   usModeFlags      dw   ?
   usModeDataOffset dw   ?
dmqs_mon_data_header ends

;*******************************************************************************
; xga state structure - must be the same as in xgaadapt.h
;*******************************************************************************
coprocstate     struc
   state_a_length  dw    ?
   state_b_length  dw    ?
   saved_state     dd    ?
coprocstate     ends

vramstate       struc
   huge_shift      dw    ?
   saved_buffer    dd    ?
vramstate       ends

xgastate        struc
   coproc_state    db    8 dup (?)
   VRAM            db    6 dup (?)
   saved_io_regs   dd    ?
   saved_palette   dd    ?
xgastate        ends

;*******************************************************************************
; native mode setting data table structure
;*******************************************************************************
nativemodedata  struc
   reg_id          dw    ?
   reg_data        dw    ?
nativemodedata  ends

ifndef  _8514
;*******************************************************************************
; XGA Memory mapped hardware registers
;*******************************************************************************
memmap          struc
page_dir_base_addr      dd      ?       ; 00h
current_virtual_addr    dd      ?       ; 04h
                        dd      ?
state_a                 db      ?       ; 0Ch
state_b                 db      ?       ; 0Dh
                        dw      ?
                        db      ?
pi_control              db      ?       ; 11h
hw_pi_map_index         dw      ?       ; 12h
hw_pi_map_base_ptr      dd      ?       ; 14h
hw_pi_map_width         dw      ?       ; 18h
hw_pi_map_height        dw      ?       ; 1ah
hw_pi_map_format        db      ?       ; 1ch
                        db      ?
                        dw      ?
bres_error              dw      ?       ; 20h
                        dw      ?
bres_k1                 dw      ?       ; 24h
                        dw      ?
bres_k2                 dw      ?       ; 28h
                        dw      ?
dir_steps               dd      ?       ; 2ch
                        dd      ?
                        dd      ?
                        dd      ?
                        dd      ?
                        dd      ?
                        dd      ?
fg_mix                  db      ?       ; 48h
bg_mix                  db      ?       ; 49h
colour_comp_fun         db      ?       ; 4ah
                        db      ?
colour_comp_colour      dw      ?       ; 4ch
                        dw      ?
plane_mask              dw      ?       ; 50h
                        dw      ?
carry_chain_mask        dw      ?       ; 54h
                        dw      ?
fg_colour               dw      ?       ; 58h
                        dw      ?
bg_colour               dw      ?       ; 5ch
                        dw      ?
dim1                    dw      ?       ; 60h
dim2                    dw      ?       ; 62h
                        dd      ?
                        dd      ?
mask_org                dd      ?       ; 6ch
src_map                 dd      ?       ; 70h
patt_map                dd      ?       ; 74h
dest_map                dd      ?       ; 78h
pixel_op                dd      ?       ; 7ch

;*******************************************************************************
; Extra locations for pixmap registers (same as AIShadow in eddftype.h)
;*******************************************************************************
sw_pi_map_index_A       dw      ?
sw_pi_map_base_ptr_A    dd      ?
sw_pi_map_width_A       dw      ?
sw_pi_map_height_A      dw      ?
sw_pi_map_format_A      db      ?
                        db      ?

sw_pi_map_index_B       dw      ?
sw_pi_map_base_ptr_B    dd      ?
sw_pi_map_width_B       dw      ?
sw_pi_map_height_B      dw      ?
sw_pi_map_format_B      db      ?
                        db      ?

sw_pi_map_index_C       dw      ?
sw_pi_map_base_ptr_C    dd      ?
sw_pi_map_width_C       dw      ?
sw_pi_map_height_C      dw      ?
sw_pi_map_format_C      db      ?
                        db      ?

sw_pi_map_index_M       dw      ?
sw_pi_map_base_ptr_M    dd      ?
sw_pi_map_width_M       dw      ?
sw_pi_map_height_M      dw      ?
sw_pi_map_format_M      db      ?
                        db      ?
memmap          ends

ifdef HARD_DRAW
pi_map_index_A          equ     hw_pi_map_index
pi_map_base_ptr_A       equ     hw_pi_map_base_ptr
pi_map_width_A          equ     hw_pi_map_width
pi_map_height_A         equ     hw_pi_map_height
pi_map_format_A         equ     hw_pi_map_format

pi_map_index_B          equ     hw_pi_map_index
pi_map_base_ptr_B       equ     hw_pi_map_base_ptr
pi_map_width_B          equ     hw_pi_map_width
pi_map_height_B         equ     hw_pi_map_height
pi_map_format_B         equ     hw_pi_map_format

pi_map_index_C          equ     hw_pi_map_index
pi_map_base_ptr_C       equ     hw_pi_map_base_ptr
pi_map_width_C          equ     hw_pi_map_width
pi_map_height_C         equ     hw_pi_map_height
pi_map_format_C         equ     hw_pi_map_format

pi_map_index_M          equ     hw_pi_map_index
pi_map_base_ptr_M       equ     hw_pi_map_base_ptr
pi_map_width_M          equ     hw_pi_map_width
pi_map_height_M         equ     hw_pi_map_height
pi_map_format_M         equ     hw_pi_map_format
endif ; HARD_DRAW

ifdef SOFT_DRAW
pi_map_index_A          equ     sw_pi_map_index_A
pi_map_base_ptr_A       equ     sw_pi_map_base_ptr_A
pi_map_width_A          equ     sw_pi_map_width_A
pi_map_height_A         equ     sw_pi_map_height_A
pi_map_format_A         equ     sw_pi_map_format_A

pi_map_index_B          equ     sw_pi_map_index_B
pi_map_base_ptr_B       equ     sw_pi_map_base_ptr_B
pi_map_width_B          equ     sw_pi_map_width_B
pi_map_height_B         equ     sw_pi_map_height_B
pi_map_format_B         equ     sw_pi_map_format_B

pi_map_index_C          equ     sw_pi_map_index_C
pi_map_base_ptr_C       equ     sw_pi_map_base_ptr_C
pi_map_width_C          equ     sw_pi_map_width_C
pi_map_height_C         equ     sw_pi_map_height_C
pi_map_format_C         equ     sw_pi_map_format_C

pi_map_index_M          equ     sw_pi_map_index_M
pi_map_base_ptr_M       equ     sw_pi_map_base_ptr_M
pi_map_width_M          equ     sw_pi_map_width_M
pi_map_height_M         equ     sw_pi_map_height_M
pi_map_format_M         equ     sw_pi_map_format_M
endif ; SOFT_DRAW

;*******************************************************************************
;Memory mapped hardware registers (extra word length access to X/Ys)
;*******************************************************************************
memmap2         struc
                        dd      ?       ; 00h
                        dd      ?       ; 04h
                        dd      ?
                        db      ?       ; 0Ch
                        db      ?       ; 0Dh
                        dw      ?
                        db      ?
                        db      ?       ; 11h
                        dw      ?       ; 12h
                        dd      ?       ; 14h
hw_pi_map_size          dd      ?       ; 18h
                        db      ?       ; 1ch
                        db      ?
                        dw      ?
                        dw      ?       ; 20h
                        dw      ?
                        dw      ?       ; 24h
                        dw      ?
                        dw      ?       ; 28h
                        dw      ?
                        dd      ?       ; 2ch
                        dd      ?
                        dd      ?
                        dd      ?
                        dd      ?
                        dd      ?
                        dd      ?
                        db      ?       ; 48h
                        db      ?       ; 49h
                        db      ?       ; 4ah
                        db      ?
                        dw      ?       ; 4ch
                        dw      ?
                        dw      ?       ; 50h
                        dw      ?
                        dw      ?       ; 54h
                        dw      ?
                        dw      ?       ; 58h
                        dw      ?
                        dw      ?       ; 5ch
                        dw      ?
dimensions              dd      ?       ; 60h
                        dd      ?
                        dd      ?
mask_org_x              dw      ?
mask_org_y              dw      ?
src_map_x               dw      ?
src_map_y               dw      ?
patt_map_x              dw      ?
patt_map_y              dw      ?
dest_map_x              dw      ?
dest_map_y              dw      ?
                        dd      ?       ; 7ch


                        dw      ?
                        dd      ?       ; 14h
sw_pi_map_size_A        dd      ?       ; 18h
                        db      ?       ; 1ch
                        db      ?

                        dw      ?
                        dd      ?       ; 14h
sw_pi_map_size_B        dd      ?       ; 18h
                        db      ?       ; 1ch
                        db      ?

                        dw      ?
                        dd      ?       ; 14h
sw_pi_map_size_C        dd      ?       ; 18h
                        db      ?       ; 1ch
                        db      ?

                        dw      ?
                        dd      ?       ; 14h
sw_pi_map_size_M        dd      ?       ; 18h
                        db      ?       ; 1ch
                        db      ?
memmap2         ends

ifdef HARD_DRAW
pi_map_size_A           equ     hw_pi_map_size
pi_map_size_B           equ     hw_pi_map_size
pi_map_size_C           equ     hw_pi_map_size
pi_map_size_M           equ     hw_pi_map_size
endif ; HARD_DRAW

ifdef SOFT_DRAW
pi_map_size_A           equ     sw_pi_map_size_A
pi_map_size_B           equ     sw_pi_map_size_B
pi_map_size_C           equ     sw_pi_map_size_C
pi_map_size_M           equ     sw_pi_map_size_M
endif ; SOFT_DRAW


;*******************************************************************************
;I/O mapped hardware registers
;*******************************************************************************
iomap           struc
op_mode                 db      ?       ; 00h
pc_vram_window_ctl      db      ?       ; 01h
                        db      ?       ; 02h
                        db      ?       ; 03h
int_enable              db      ?       ; 04h
int_status              db      ?       ; 05h
virt_mem_ctrl           db      ?       ; 06h
virt_mem_int_stat       db      ?       ; 07h
pc_vram_indx            db      ?       ; 08h
mem_access_mode         db      ?       ; 09h
index                   db      ?       ; 0ah
                        db      ?       ; 0bh
dataio                  db      ?       ; 0ch
                        db      ?       ; 0dh
                        db      ?       ; 0eh
                        db      ?       ; 0fh
iomap           ends
endif   ;_8514

AVIO_charblt            equ     08012040h
AVIO_scrollblt          equ     28118040h

;*******************************************************************************
;* Pixel Operation constants
;*******************************************************************************
HW_BUSY                 equ     80h

BACK_SRC_MASK           equ    0C0000000h
FORE_SRC_MASK           equ     30000000h
STEP_FN_MASK            equ     0F000000h
SRC_PIX_MAP_MASK        equ     00F00000h
DST_PIX_MAP_MASK        equ     000F0000h
PAT_PIX_MAP_MASK        equ     0000F000h
MSK_PIX_MAP_MASK        equ     000000C0h
DRAW_MODE_MASK          equ     00000030h
DIR_OCT_MASK            equ     00000007h

BACK_SRC_BACK_COL       equ     0h
BACK_SRC_SRC_PIX_MAP    equ     80000000h

FORE_SRC_FORE_COL       equ     0h
FORE_SRC_SRC_PIX_MAP    equ     20000000h

STEP_PLOT_STEP          equ     04000000h
STEP_FN_LINE_DRAW_WRITE equ     05000000h

SRC_PIX_MAP_A           equ     00100000h
SRC_PIX_MAP_B           equ     00200000h
SRC_PIX_MAP_C           equ     00300000h
SRC_PIX_MAP_DONTCARE    equ     <SRC_PIX_MAP_A>

DST_PIX_MAP_A           equ     00010000h
DST_PIX_MAP_B           equ     00020000h
DST_PIX_MAP_C           equ     00030000h

PAT_PIX_MAP_A           equ     00001000h
PAT_PIX_MAP_B           equ     00002000h
PAT_PIX_MAP_C           equ     00003000h
PAT_PIX_MAP_FORE        equ     00008000h
PAT_PIX_MAP_SRC         equ     00009000h

MASK_PIX_MAP_OFF        equ     0h
MASK_PIX_MAP_EDGE       equ     00000040h
MASK_PIX_MAP_FULL       equ     00000080h

DRAW_MODE_ALL_PELS      equ     0h
DRAW_MODE_NO_FIRST_PEL  equ     00000010h
DRAW_MODE_NO_LAST_PEL   equ     00000020h
DRAW_MODE_DONTCARE      equ     <DRAW_MODE_ALL_PELS>

STEP_PXBLT              equ     08000000h
DIR_OCTANT_LRTB         equ     00000000h
DIR_OCTANT_LRBT         equ     00000002h
DIR_OCTANT_RLTB         equ     00000004h
DIR_OCTANT_RLBT         equ     00000006h

BLTDIR_BOTTOMTOTOP      equ     02h
BLTDIR_RIGHTTOLEFT      equ     04h

;*******************************************************************************
;* Other register constants
;*******************************************************************************
SEL_PIX_MAP_A           equ     01h
SEL_PIX_MAP_B           equ     02h
SEL_PIX_MAP_C           equ     03h
SEL_MASK_MAP            equ     00h

ONE_BPP                 equ     00h
FOUR_BPP                equ     02h
EIGHT_BPP               equ     03h
SIXTEEN_BPP             equ     04h
TWENTYFOUR_BPP          equ     05h
BPP_MASK                equ     07h
INTEL                   equ     00h
MOTOROLA                equ     08h

ONE_BIT_PER_PEL         equ     MOTOROLA + ONE_BPP
FOUR_BITS_PER_PEL       equ     MOTOROLA + FOUR_BPP
EIGHT_BITS_PER_PEL      equ     MOTOROLA + EIGHT_BPP
SIXTEEN_BITS_PER_PEL    equ     MOTOROLA + SIXTEEN_BPP
TWENTYFOUR_BITS_PER_PEL equ     MOTOROLA + TWENTYFOUR_BPP

;Set in DDT screen flags
USE_16BPP               equ     04h
USE_24BPP               equ     08h
ifdef   _8514
DM_MONO                 equ     01h
DM_HI_RES               equ     02h
USE_ATTDAC              equ     10h
USE_BTDAC               equ     20h
endif
USE_8BITDAC             equ     40h

ifndef _8514

HWMIX_ZEROS                    equ        0
HWMIX_SOURCE_AND_DEST          equ        1
HWMIX_SOURCE_AND_NOTDEST       equ        2
HWMIX_SOURCE                   equ        3
HWMIX_NOTSOURCE_AND_DEST       equ        4
HWMIX_DEST                     equ        5
HWMIX_SOURCE_XOR_DEST          equ        6
HWMIX_SOURCE_OR_DEST           equ        7
HWMIX_NOTSOURCE_AND_NOTDEST    equ        8
HWMIX_SOURCE_XOR_NOTDEST       equ        9
HWMIX_NOTDEST                  equ        10
HWMIX_SOURCE_OR_NOTDEST        equ        11
HWMIX_NOTSOURCE                equ        12
HWMIX_NOTSOURCE_OR_DEST        equ        13
HWMIX_NOTSOURCE_OR_NOTDEST     equ        14
HWMIX_ONES                     equ        15

endif

OCT_DX_BIT              equ     4
OCT_DY_BIT              equ     2
OCT_DZ_BIT              equ     1

;*******************************************************************************
;Index register assignments
;*******************************************************************************
mem_config              equ     00h

state_a_data            equ     0ch
state_b_data            equ     0dh

horiz_total             equ     10h
horiz_display_end       equ     12h
horiz_blank_start       equ     14h
horiz_blank_end         equ     16h
horiz_sync_start        equ     18h
horiz_sync_end1         equ     1Ah
horiz_sync_end2         equ     1Ch
horiz_skew              equ     1Eh

vert_total_lo           equ     20h
vert_total_hi           equ     21h
vert_display_end_lo     equ     22h
vert_display_end_hi     equ     23h
vert_blank_start_lo     equ     24h
vert_blank_start_hi     equ     25h
vert_blank_end_lo       equ     26h
vert_blank_end_hi       equ     27h
vert_sync_start_lo      equ     28h
vert_sync_start_hi      equ     29h
vert_sync_end           equ     2ah
vert_line_comp_lo       equ     2ch
vert_line_comp_hi       equ     2dh

horiz_sprite_start_lo   equ     30h
horiz_sprite_start_hi   equ     31h
horiz_sprite_preset     equ     32h
vert_sprite_start_lo    equ     33h
vert_sprite_start_hi    equ     34h
vert_sprite_preset      equ     35h
sprite_control          equ     36h

sprite_colour_0_red     equ     38h
sprite_colour_0_green   equ     39h
sprite_colour_0_blue    equ     3Ah
sprite_colour_1_red     equ     3Bh
sprite_colour_1_green   equ     3Ch
sprite_colour_1_blue    equ     3Dh

start_addr_lo           equ     40h
start_addr_mi           equ     41h
start_addr_hi           equ     42h
buffer_pitch_lo         equ     43h
buffer_pitch_hi         equ     44h

disp_mode1              equ     50h
disp_mode2              equ     51h
monitor_id              equ     52h
system_id               equ     53h
clock_sel               equ     54h
border_colour           equ     55h

sprite_indx_write_lo    equ     60h
sprite_indx_write_hi    equ     61h
sprite_indx_read_lo     equ     62h
sprite_indx_read_hi     equ     63h
palette_mask            equ     64h
palette_data            equ     65h
palette_sequence        equ     66h
palette_red             equ     67h
palette_green           equ     68h
palette_blue            equ     69h
sprite_data             equ     6ah
sprite_save_restore     equ     6bh

;*******************************************************************************
;palette ordering
;*******************************************************************************
palette_rgb             equ     0000h OR palette_sequence

;*******************************************************************************
;operating mode register (address 21x0) values
;*******************************************************************************
MODE_VGA_ADD        equ         0
MODE_VGA_ADE        equ         1
MODE_132_ADD        equ         2
MODE_132_ADE        equ         3
MODE_EXT_GRAPHICS   equ         4

;*******************************************************************************
;Constants for colour compare operations.  Used to process
;BM_SRCTRANSPARENT and BM_DESTTRANSPARENT background mixes.
;NB COLCOMP_NOT_EQUAL is not implemented in the MESS.
;*******************************************************************************
COLCOMP_EQUAL        equ        06h
COLCOMP_NOT_EQUAL    equ        02h
COLCOMP_ALWAYS       equ        04h

;*******************************************************************************
; These values are also stored in the colour compare register, but
; must not be written to the hardware. They are just used to
; indicate a BM_SRCTRANSPARENT operation to the MESS.
;*******************************************************************************
COLCOMP_SRC_NOT_EQUAL  equ      80h


;/**********************************************************************/
;/* This callgate structure is used when createing a dynamicAPI entry. */
;/**********************************************************************/
callgate    struc
    linear_address      dd      ?
    cParams             dd      ?
    cg_offset           dd      ?
    cg_selector         dd      ?
callgate    ends

;*******************************************************************************
; XGA POS ID constants
;*******************************************************************************
XGA_ID_HIGHEST  equ 08fdbh
XGA_DMQS_ID     equ 08fdah
XGA_ID_LOWEST   equ 08fd8h

ifdef MATROX
MATROX_ID       equ 080eeh
endif ; MATROX

;*******************************************************************************
; KJE - DCR53004
; Define the DMQS data structure provided by the INT 10 EBIOS DMQS Service.
;*******************************************************************************
DMQS_Int10Pdi struc

    usNextDMQS         dw  ?
    bSlotNumber        db  ?
    usXGALevel         dw  ?
    ulVendorID         dd  ?
    usIOBase           dw  ?
    usRegSeg           dw  ?
    us1MPhysAperture   dw  ?
    us4MPhysAperture   dw  ?
    usVRAMBase         dw  ?
    usMonitorID        dw  ?
    bVRAMSize          db  ?
    ulAlternateRegBase dd  ?
    usDMQSPDIReserved  db  ?

DMQS_Int10Pdi ends
