/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/* Wolves.h is a header file needed for the MATROX support.           */
/* This is simply a copy of the listing in Appendix C of              */
/* 'ILLUMINATOR-Series         3.0 Driver and Video Presentation      */
/*  Guide'. (as we weren't sent the real file!)                       */
/**********************************************************************/

/**********************************************************************/
/* The header uses WORDs and DWORDs. This is what I think they mean.  */
/**********************************************************************/
typedef     SHORT   WORD;
typedef     LONG    DWORD;

/**********************************************************************/
/* Video handle.                                                      */
/**********************************************************************/
typedef WORD    HVIDWND;

/**********************************************************************/
/* Live video window definition structure.                            */
/**********************************************************************/
typedef struct
{
    HVIDWND     hVidWnd;            /*  Video window handle          */
    WORD        Xdst;               /*  Dest. rectangle left         */
    WORD        yDst;               /*  Dest. rectangle top          */
    WORD        DstWidth;           /*  Dest. rectangle width        */
    WORD        DstHeight;          /*  Dest. rectangle height       */
    WORD        XSrc;               /*  Source rectangle left        */
    WORD        YSrc;               /*  Source rectangle top         */
    WORD        SrcWidth;           /*  Source rectangle width       */
    WORD        SrcHeight;          /*  Source rectangle height      */
    WORD        FullMotion;         /*  FM_SINGLE     = single grab, */
                                    /*  FM_CONTINUOUS = continuous   */
    WORD        Priority;           /*  Priority                     */
} VIDEOGRAB;

/**********************************************************************/
/* Video parameter definition structure.                              */
/**********************************************************************/
typedef struct
{
    HVIDWND     hVidWnd;            /*  Video window handle          */
    WORD        Name;               /*  Name of parameter being      */
                                    /*  accessed (VP_...)            */
    DWORD       Value;              /*  Value of parameter           */
} VIDEOPARM;

/**********************************************************************/
/* Wolves support return values                                       */
/**********************************************************************/

#define     WS_INTERRUPTCONNECT     0x0001
#define     WS_WOLVESPRESENT        0x0002
#define     WS_PALBOARD             0x0080

/**********************************************************************/
/* Motion values (for VIDEOGRAB FullMotion field)                     */
/**********************************************************************/

#define     FM_SINGLE               0
#define     FM_CONTINUOUS           1

/**********************************************************************/
/* Video parameter identification (for VIDEOPARM Name field)          */
/**********************************************************************/

#define     VP_HUE                  1
#define     VP_SATURATION           2
#define     VP_CONTRAST             3
#define     VP_OFFSET_VAL           4
#define     VP_GAIN                 5
#define     VP_SOURCE               6
#define     VP_INPUTMASK            7
#define     VP_COMPMASK             8
#define     VP_COMPDATA             9
#define     VP_KEYMODE             10
#define     VP_OUTMODE             11
#define     VP_FADE                12
#define     VP_LIVEWINSTATE        13
#define     VP_GENLOCK             14

/**********************************************************************/
/* OUTMODE masks                                                      */
/**********************************************************************/

#define     OM_INTERLACE            0
#define     OM_NONINTREPT           2
#define     OM_NONINTPROG           3

/**********************************************************************/
/* Board state return values                                          */
/**********************************************************************/

#define     LWS_FREESTATE           0
#define     LWS_USEDSTATE           1
#define     LWS_LIVESTATE           2
#define     LWS_SGLESTATE           3

/**********************************************************************/
/* Function Prototypes                                                */
/**********************************************************************/

WORD    PASCAL  MTXWolvesSupport( VOID );
HVIDWND PASCAL  MTXCreateVideoWindow( VOID );
WORD    PASCAL  MTXDeleteVideoWindow( HVIDWND );
WORD    PASCAL  MTXStartVideoGrab( VIDEOGRAB * );
WORD    PASCAL  MTXStopVideoGrab( HVIDWND );
WORD    PASCAL  MTXQueryVideoParm( WORD, DWORD * );
WORD    PASCAL  MTXVideoParm( VIDEOPARM *, VIDEOPARM * );
WORD    PASCAL  MTXStartVideoRegion( VOID );
WORD    PASCAL  MTXStopVideoRegion( VOID );

