/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*   FILE: STRCHEXT.H                                                       */
/*                                                                          */
/*   DESCRIPTION: Display Device Driver external functions prototypes       */
/*                and defines used to perform image stretching on bitblt.   */
/*                                                                          */
/*   REFERENCE:                                                             */
/*                                                                          */
/*                                                                          */
/*   CHANGE HISTORY:                                                        */
/*                                                                          */
/*      21May93 <DCRTURBO> (KJE, GAM) Creation for turbo stretch            */
/*              implementation to improve performance of image stretching   */
/*              bitblt function.                                            */
/*                                                                          */
/****************************************************************************/

/****************************************************************************/
/* DEFINES                                                                  */
/****************************************************************************/

/****************************************************************************/
/* Return Code value definitions.                                           */
/****************************************************************************/
#define  RC_OK                       1L
#define  RC_UNSUPPORTED_ROP          2L
#define  RC_UNSUPPORTED_OPTION       3L
#define  RC_TRANSPARENT_BLT          4L
#define  RC_GETDRIVERINFO_FAILS      5L
#define  RC_BITMAP_NOT_SELECTED      6L
#define  RC_SRC_NOT_MEM              7L
#define  RC_DST_NOT_SCREEN           8L
#define  RC_SRC_WRONG_BITCOUNT       9L
#define  RC_DST_WRONG_BITCOUNT      10L
#define  RC_SRC_OR_DST_EXT_IS_ZERO  11L
#define  RC_ERROR                  100L

/****************************************************************************/
/*                                                                          */
/* Description: Determines if the XGA display driver can handle stretch     */
/*              function requested by the OS/2 Graphics Engine. If the      */
/*              XGA Display Driver can handle it, this function will do     */
/*              the appropriate initialization to setup for the XGA         */
/*              Display Driver stretch functions that will be called later  */
/*              on. Otherwise, the call will be passed back to the Graphics */
/*              Engine for it to handle it.                                 */
/*                                                                          */
/****************************************************************************/
ULONG IsValidStretchRequest (HDC hdc,
    LHANDLE ArgSource,
    PLONG   ArgCoords,
    ULONG   ArgRop,
    ULONG   ArgOptions,
    PDC     *pdcSrc,
    RECTS   *SrcRect,
    PDC     pdcArg,
    ULONG   FunN
);

/****************************************************************************/
/*                                                                          */
/* Description: Copies a rectangle from the original, unstretched source    */
/*              bitmap into the Phunk.                                      */
/*                                                                          */
/****************************************************************************/
VOID StretchCopyChunkToPhunk(POINTS ptsChunkPos);/* Lower-left corner of    */
                                                 /* chunk to stretch in     */
                                                 /* stretched source bitmap */
