/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = S3HWCRSR.C                                     */
/*                                                                    */
/*   Description     = Files handles routine for S3 Hardware Cursor   */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*                                                                    */
/*   Reference       =                                                */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/* CHANGE ACTIVITY =                                                  */
/*   DATE      FLAG        APAR   CHANGE DESCRIPTION                  */
/*   --------  ----------  -----  ------------------------------------*/
/**********************************************************************/
#define INCL_WINSHELLDATA
#define INCL_WINPROGRAMLIST
#define INCL_DOSDEVICES
#define INCL_DOSMEMMGR
#define INCL_DOSMODULEMGR
#define INCL_DOSRESOURCES
#define INCL_DOSNLS
#define INCL_DOSMISC
#define INCL_GRE_DEVICE
#define INCL_DDIMISC
#define INCL_WINSYS
#define INCL_WINERRORS
#define INCL_DOSERRORS
#define INCL_DOSMVDM
#include <eddinclt.h>

#include <eddhcone.h>
#include <eddfcone.h>
#include <eddmcone.h>
#include <eddvcone.h>
#include <eddecone.h>

#include <edddtypt.h>
#include <eddetypt.h>
#include <eddftype.h>

#include <eddaextf.h>
#include <eddbextf.h>
#include <eddcextf.h>
#include <eddeextf.h>
#include <eddgextf.h>
#include <eddmextf.h>
#include <eddtextf.h>
#include <eddqextf.h>

#include <edddlg.h>

#include <memman.h>
#include <cursor.h>
#include <cacheman.h>

ADAPTER8514                   ai8514Adapter;

VOID SetupCursorInformation(VOID);

extern DDTType                DDT;
extern BitmapHeader           DirectListEntry;
extern BitmapHeader           DummyInfoBitmap;
extern CURSORDATA             cursor_data;
extern BOOL                   SWCursorForced;

VOID SetupCursorInformation(VOID)
{

    /******************************************************************/
    /* Specific values which describe the screen pixmap.              */
    /******************************************************************/
    cursor_data.screen_hw_format = DirectListEntry.Info.HWFormat;
    cursor_data.screen_hw_size   = (DirectListEntry.Info.HWHeight << 16) +
                                    DirectListEntry.Info.HWWidth;

    /**************************************************************/
    /* assembler code also needs to know the defined size         */
    /* (the rectangular size within which the cursor was defined) */
    /* and various hardware sizes                                 */
    /**************************************************************/
    cursor_data.software_cursor.defnsize.x = DDT.CursorWidth;
    cursor_data.software_cursor.hwsize.x   = DDT.CursorWidth - (USHORT)1;
    cursor_data.software_cursor.defnsize.y = DDT.CursorHeight;
    cursor_data.software_cursor.hwsize.y   = DDT.CursorHeight - (USHORT)1;
    cursor_data.draw_sprite_width        = DDT.CursorWidth;
    cursor_data.draw_sprite_height       = DDT.CursorHeight;

    /******************************************************************/
    /* Set this to say that there is initially no valid saved cursor  */
    /* data to be restored by restore_software_cursor.                */
    /******************************************************************/
    cursor_data.software_cursor.coord.x = 0x8000;

    /**************************************************************/
    /* The cursor will be handled by the hardware, so set the     */
    /* HW cursor colors in our structure.                         */
    /**************************************************************/

    /**************************************************************/
    /* Cursor is always black and something.                      */
    /**************************************************************/
    cursor_data.draw_sprite_col1.clr8  = 0x00;
    cursor_data.draw_sprite_col1.clr16 = 0x00;
    cursor_data.draw_sprite_col1.clr24 = 0x00;

    /**********************************************************/
    /* Monitor is colour so cursor is white and black         */
    /**********************************************************/
    cursor_data.draw_sprite_col2.clr8  = 0xff;
    cursor_data.draw_sprite_col2.clr16 = 0xff;
    cursor_data.draw_sprite_col2.clr24 = 0xff;

    //if ( (DDT.fScreenFlags & USE_BROOKDAC) && (HWResolution > 3 ) ) {
    //   cursor_data.cursor_status |= CURSOR_SOFTWARE;
    //   SWCursorForced = TRUE;
    //}

}
