/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************/
/*  Module Name: PMNLSFM.H                                                    */
/*                                                                            */
/*      32-bit version of font manager interface definition.                  */
/*      also includes 32-bit to 16-bit API thunking definition                */
/*      C Set/2 compiler.                                                     */
/*                                                                            */
/*  Created: 09-Jul-1992                                                      */
/*  Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]                       */
/*                                                                            */
/*                        Refer to Copyright Inscruction Form No.G120-2083    */
/*                                                                            */
/*  Exported Functions:   none                                                */
/*                                                                            */
/*  Public Functions:     none                                                */
/*                                                                            */
/*  Public Data:          none                                                */
/*                                                                            */
/*  General Description:                                                      */
/*                                                                            */
/******************************************************************************/

typedef PFOCAFONT   HFM;
typedef PUCHAR      PSTR;
typedef PUSHORT     PINDX;
typedef PULONG      PINDXL;

#define  FM_PM_FONT             1       /* FMFONTINFO.flType                  */
#define  FM_CACHE_FONT          2       /* FMFONTINFO.flType                  */
#define  FM_PUBLIC              1       /* QueryFonts.flOptions               */
#define  FM_PRIVATE             2       /* QueryFonts.flOptions               */
#define  FM_FONT_SIZE           1       /* FMQUERYDATA.lQuery                 */
#define  FM_FONT_IMAGE          2       /* FMQUERYDATA.lQuery                 */
#define  FM_FONT_NULL           4       /* FMQUERYDATA.lQuery                 */
#define  FM_WITH_FONT           1       /* CharStr.flOptions                  */
#define  FM_WITHOUT_FONT        2       /* CharStr.flOptions                  */
#define  FM_ALL_FONT            (-1L)   /* FlushCache.hfm                     */
#define  FM_ALL_GLYPH           (-1L)   /* FlushCache.index                   */

#define  FM_ERROR               (-1L)
#define  FM_SUCCESS             0
#define  FM_FONT_NOT_FOUND      0
#define  FM_FONT_FOUND          1

#ifdef INCL_32
/******************************************************************************/
/* Define 32-bit interface.                                                   */
/******************************************************************************/

typedef LONG (*APIENTRY PFN32)();

typedef struct _FMFONTINFO {            /* fmfont */
        HFM     hfm;                    /* Font manager font handle           */
        PFOCAFONT pFont;                /* FOCAFONT structure                 */
        ULONG   ulLen;                  /* Length of FOCAFONT structure       */
        ULONG   flType;                 /* Type flags                         */
        UCHAR   szGlyphlist[16];        /* Glyph list name                    */
        LONG    lMatch;                 /* Match indentifier                  */
        ULONG   cbCache;                /* Length of Cache Buffer             */
} FMFONTINFO, *PFMFONTINFO;

typedef struct _FMQUERYDATA {           /* fmquery */
        ULONG   lQuery;                 /* Query type                         */
        ULONG   sizl_cx;                /* X extent of the font               */
        ULONG   sizl_cy;                /* Y extent of the font               */
        ULONG   a_space;                /* A space                            */
        ULONG   b_space;                /* B space                            */
        ULONG   c_space;                /* C space                            */
        ULONG   cbLen;                  /* Size of buffer in byte             */
        PBYTE   pBuffer;                /* Font data buffer (bitmap/outline)  */
} FMQUERYDATA, *PFMQUERYDATA;

typedef struct _FMDISPATCH32 {          /* fmdisp32 */
        PFN32   Fm32QueryFonts;
        PFN32   Fm32OpenFont;
        PFN32   Fm32CloseFont;
        PFN32   Fm32QueryCharAttr;
        PFN32   Fm32CharStr;
        PFN32   Fm32CharStr2;
        PFN32   Fm32MapCharGlyph;
        PFN32   Fm32MapCharGlyph2;
        PFN32   Fm32LoadFontDriver;
        PFN32   Fm32UnloadFontDriver;
        PFN32   Fm32FlushCache;
} FMDISPATCH32, *PFMDISPATCH32;

LONG APIENTRY Fm32QueryFonts        (ULONG, PFMFONTINFO, HFM, ULONG, ULONG);
LONG APIENTRY Fm32OpenFont          (PFATTRS, PFMFONTINFO);
LONG APIENTRY Fm32CloseFont         (HFM);
LONG APIENTRY Fm32QueryCharAttr     (HFM, ULONG, PFMQUERYDATA);
LONG APIENTRY Fm32MapCharGlyph      (HFM, LONG, PSTR, PINDX, LONG);
LONG APIENTRY Fm32MapCharGlyph2     (HFM, LONG, PSTR, PINDXL, LONG);
LONG APIENTRY Fm32CharStr           (HFM, ULONG, PINDX, LONG);
LONG APIENTRY Fm32CharStr2          (HFM, ULONG, PINDXL, LONG);
LONG APIENTRY Fm32LoadFontDriver    (ULONG, PSZ);
LONG APIENTRY Fm32UnloadFontDriver  (ULONG, PSZ);
LONG APIENTRY Fm32FlushCache        (HFM, ULONG);

#ifdef INCL_THUNK32TO16
/******************************************************************************/
/* Define 16-bit interface for thunking.                                      */
/******************************************************************************/
#pragma pack(2)                         /* set packing convension to 16bit    */

typedef struct _FMFONTINFO16 {          /* fmfont                             */
    HFM       _Seg16 hfm;               /* Font manager font handle           */
    PFOCAFONT _Seg16 pFont;             /* FOCAFONT segment                   */
    ULONG            ulLen;             /* Length of FOCAFONT segment         */
    ULONG            flType;            /* Type flags                         */
    UCHAR            szGlyphlist[16];   /* Glyph list name                    */
    LONG             lMatch;            /* Match indentifier                  */
    USHORT           cbCache;           /* Length of Cache Buffer             */
} FMFONTINFO16, *PFMFONTINFO16;

typedef struct _FMQUERYDATA16 {         /* fmquery */
    ULONG            lQuery;            /* Query type                         */
    ULONG            sizl_cx;           /* X extent of the font               */
    ULONG            sizl_cy;           /* Y extent of the font               */
    ULONG            a_space;           /* A space                            */
    ULONG            b_space;           /* B space                            */
    ULONG            c_space;           /* C space                            */
    ULONG            cbLen;             /* Size of buffer in byte             */
    PBYTE     _Seg16 pBuffer;           /* Font data buffer (bitmap/outline)  */
} FMQUERYDATA16, *PFMQUERYDATA16;

LONG APIENTRY16 FmQueryFonts        (ULONG, PFMFONTINFO16, HFM, ULONG, ULONG);
LONG APIENTRY16 FmOpenFont          (PFATTRS, PFMFONTINFO16);
LONG APIENTRY16 FmCloseFont         (HFM);
LONG APIENTRY16 FmQueryCharAttr     (HFM, ULONG, PFMQUERYDATA16);
LONG APIENTRY16 FmCharStr           (HFM, ULONG, PINDX, LONG);
LONG APIENTRY16 FmMapCharGlyph      (HFM, LONG, PSTR, PINDX, LONG);
LONG APIENTRY16 FmFlushCache        (HFM, ULONG);
LONG APIENTRY16 FmLoadFontDriver    (ULONG, PSZ);
LONG APIENTRY16 FmUnloadFontDriver  (ULONG, PSZ);

#define SELOF(p32)      (((ULONG)((PVOID _Seg16)(p32)))>>16)
#define OFFOF(p32)      (((ULONG)((PVOID _Seg16)(p32)))&0xFFFF)
#define LIMIT64KB       ((ULONG)0xFFFF)

#pragma pack()                          /* restore packing convension to 32bit*/
/******************************************************************************/
/* 16-bit interface definition for thunking - end                             */
/******************************************************************************/
#endif/* INCL_THUNK32TO16*/
#else /*!INCL_32*/
/******************************************************************************/
/* Define 16-bit interface.                                                   */
/******************************************************************************/

typedef LONG (APIENTRY *PFN16)();

typedef struct _FMFONTINFO {            /* fmfont */
        HFM     hfm;                    /* Font manager font handle           */
        PFOCAFONT pFont;                /* FOCAFONT structure                 */
        ULONG   ulLen;                  /* Length of FOCAFONT structure       */
        ULONG   flType;                 /* Type flags                         */
        UCHAR   szGlyphlist[16];        /* Glyph list name                    */
        LONG    lMatch;                 /* Match indentifier                  */
        USHORT  cbCache;                /* Length of Cache Buffer             */
} FMFONTINFO, FAR *PFMFONTINFO;

typedef struct _FMQUERYDATA {           /* fmquery */
        ULONG   lQuery;                 /* Query type                         */
        ULONG   sizl_cx;                /* X extent of the font               */
        ULONG   sizl_cy;                /* Y extent of the font               */
        ULONG   a_space;                /* A space                            */
        ULONG   b_space;                /* B space                            */
        ULONG   c_space;                /* C space                            */
        ULONG   cbLen;                  /* Size of buffer in byte             */
        PBYTE   pBuffer;                /* Font data buffer (bitmap/outline)  */
} FMQUERYDATA, FAR *PFMQUERYDATA;

typedef struct _FMDISPATCH {            /* fmdisp */
        PFN16   FmQueryFonts;
        PFN16   FmOpenFont;
        PFN16   FmCloseFont;
        PFN16   FmQueryCharAttr;
        PFN16   FmCharStr;
        PFN16   FmMapCharGlyph;
        PFN16   FmLoadFontDriver;
        PFN16   FmUnloadFontDriver;
        PFN16   FmFlushCache;
} FMDISPATCH, FAR *PFMDISPATCH;

LONG APIENTRY FmQueryFonts          (ULONG, PFMFONTINFO, HFM, ULONG, ULONG);
LONG APIENTRY FmOpenFont            (PFATTRS, PFMFONTINFO);
LONG APIENTRY FmCloseFont           (HFM);
LONG APIENTRY FmQueryCharAttr       (HFM, ULONG, PFMQUERYDATA);
LONG APIENTRY FmMapCharGlyph        (HFM, LONG, PSTR, PINDX, LONG);
LONG APIENTRY FmCharStr             (HFM, ULONG, PINDX, LONG);
LONG APIENTRY FmLoadFontDriver      (ULONG, PSZ);
LONG APIENTRY FmUnloadFontDriver    (ULONG, PSZ);
LONG APIENTRY FmFlushCache          (HFM, ULONG);

/******************************************************************************/
/* 16-bit interface definition for thunking - end                             */
/******************************************************************************/
#endif /*!INCL_32*/
