;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;***********************************************************************
;
;   Module          = PERFMATH
;
;   Description     = Performance test assembler routines for
;                     doing 32 bit maths in a 16bit C routines without
;                     using any c library functions.
;
;
;   Function        = Ulong multiply and divide routines for
;                     the 16bit code
;
;
;***********************************************************************

?DF     equ     1       ; we dont want cmacros to define the _text seg

include cmacros.inc

.386

_CODE16         segment word use16 public 'CODE'

                assume CS:_CODE16


cProc           PTUlongMult, <PUBLIC, NEAR>
                        parmD   operand1
                        parmD   operand2
cBegin
        mov     eax, operand1
        mov     edx, operand2
        mul     edx
        mov     edx, eax
        shr     edx, 16
cEnd

cProc           PTUlongDiv, <PUBLIC, NEAR>
                        parmD   operand1
                        parmD   operand2
cBegin
        mov     edx, 0
        mov     eax, operand1
        div     operand2
        mov     edx, eax
        shr     edx, 16
cEnd

_CODE16         ends

END
