/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = PALTYPES.H                                     */
/*                                                                    */
/*   Description     = Palette manager types and structures           */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#define HW_PAL_SIZE     256

/**********************************************************************/
/* We should never use this any more. Its old value was 16. Now we    */
/* should look up the value in ulDeviceDefaultPaletteSize.            */
/**********************************************************************/
// #define RESERVED_COLS   ulDeviceDefaultPaletteSize

/**********************************************************************/
/* The following masks are used when considering RGB2 values as ULONGS*/
/**********************************************************************/
#define RED_MASK        0x00FF0000
#define GREEN_MASK      0x0000FF00
#define BLUE_MASK       0x000000FF
#define RGB_MASK        (RED_MASK | GREEN_MASK | BLUE_MASK)
/**********************************************************************/
/* keep just the bits the engine knows about                          */
/**********************************************************************/
#define RGB_PLUS_MASK   (RGB_MASK | PC_RESERVED | PC_EXPLICIT | PC_NOCOLLAPSE)
/**********************************************************************/
/* this next mask is used in realize palette to test if we need to    */
/* reload a hw palette entry                                          */
/**********************************************************************/
#define RGB_TEST_MASK   (RGB_MASK | PC_RESERVED)

/**********************************************************************/
/* FREE_FLAGS is the value we place in the fcOptions of an RGB2       */
/* value in the HWPalette structure when that HW slot is unused (free)*/
/**********************************************************************/
#define FREE_FLAGS      0


typedef struct
    {
        RGB2        rgb;                /* b,g,r,options              */
        BYTE        bCurrent;           /* current h/w index          */
        BYTE        bPrevious;          /* previous h/w index         */
        /**************************************************************/
        /* this next field is to make palette entries 8 bytes long    */
        /* which aids debugging                                       */
        /**************************************************************/
        USHORT      padding;            /* may find a use for this    */
    } PALENTRY;

typedef struct
    {
        USHORT      Identifier;
        USHORT      cUsage;             /* usage count                */
        /**************************************************************/
        /* minimum is always 0 so need not be stored                  */
        /**************************************************************/
        USHORT      usMax;              /* max index defined (no limit*/
        /**************************************************************/
        /* flags holds both user supplied flags (PURECOLOR etc) and   */
        /* driver internal flags                                      */
        /**************************************************************/
        USHORT      usFlags;            /* palette flags              */
        USHORT      usLocalOptimizeID;  /* stops unnecessary realizes */
        USHORT      usCountStored;     /* no of stored entries (<=256)*/
        /**************************************************************/
        /* 8514 maintains list of available memory slots for palettes */
        /* by chaining them together. May do this later.              */
        /**************************************************************/
        /**************************************************************/
        /* entries must be the last field in this structure because   */
        /* that allows us to store only the number of entries         */
        /* actually defined if that is actually what we want to do    */
        /* (for example the DeviceDefaultPalette has 16 entries only) */
        /**************************************************************/

        /* Defect 63839 - Remove 256 entry logical palette limit      */
        PALENTRY    entries[1];                 /* actual data        */
    } DEVPAL;

/**********************************************************************/
/* HDEVPAL is already defined as a ULONG so we define a PDEVPAL as    */
/* a pointer to a DEVPAL                                              */
/* whenever the engine wants a HDEVPAL from us we return them a       */
/* PDEVPAL value                                                      */
/**********************************************************************/
#define PDEVPAL DEVPAL FAR *

/**********************************************************************/
/* flags entry in DEVPAL needs to hold the following user flags       */
/*     LCOL_PURECOLOR and LCOL_OVERRIDE_DEFAULT_COLORS                */
/* driver level flags are                                             */
/*   PAL_CHANGED        palette has changed since it was last realized*/
/*   PAL_PREVIOUS_OK    palette previous entries are valid            */
/*   PAL_CURRENT_OK     palette current entries are valid             */
/**********************************************************************/

#define PAL_CHANGED             0x8000
#define PAL_PREVIOUS_OK         0x4000
#define PAL_CURRENT_OK          0x2000

/**********************************************************************/
/* we piggy back extra bits into the fcOptions byte of the RGB2 entry */
/* start at the top end of the byte because the system defined values */
/* start at the bottom (see PC_ flags in pmgpi.h)                     */
/*                                                                    */
/* Notes:                                                             */
/* The PC_NEW is used only on logical palette entries, and PC_DEFAULT */
/* and PC_OLD are used only on HW palette entries.  Their valuse      */
/* could be overlapped if necessary in the future.                    */
/*                                                                    */
/* The PC_DEFAULT value is hardcoded into the default device palettes */
/* so do not change it!  (Unless you change all the palette           */
/* definitions in edddata.c too).                                     */
/**********************************************************************/
#define PC_DEFAULT      0x80
#define PC_USED         0x40
#define PC_NEW          0x20
#define PC_OLD          0x10

/**********************************************************************/
/* the HWPalette structure is now a simple array of RGB2 (or ULONGs   */
/* if that is how you want to consider them)                          */
/**********************************************************************/
#ifdef OMIT
/**********************************************************************/
/* this next structure defines the copy of the hardware palette       */
/**********************************************************************/
typedef struct
    {
        RGB2        rgb[HW_PAL_SIZE];       /* hw palette rgb entries */
    } HWPAL;
#endif /* OMIT */

/**********************************************************************/
/* useful macros                                                      */
/**********************************************************************/

/**********************************************************************/
/* get an RGB2 structure and pass it back in a ULONG                  */
/**********************************************************************/
#define URGB(x) (*(PULONG)&(x))

/**********************************************************************/
/* allow a ULONG to be accessed as an RGB2 structure                  */
/**********************************************************************/
#define RGBU(x) (*(PRGB2)&(x))

/**********************************************************************/
/* the default h/w palette is 16 entries                              */
/* this macro give us the default entry, which we dont actually keep  */
/* as a full table anywhere                                           */
/* for 4bpp valid values of i are 0 - 15                              */
/* for 8bpp valid values of i are 0 - 255                             */
/*              (0 - 7 are first 8 colours, 8 - 247 are black (NULL), */
/*               248 - 255 are last 8 colours)                        */
/**********************************************************************/
extern RGB2 RGB2NULL;  /* an RGB2 stucture containing only NULLS */

#define DirectDeviceDefaultRGB2(i)                                           \
        (                                                                    \
         ((DDT.BitCount == 4) || ((i) < ulDirectDeviceDefaultPaletteSize/2)) \
         ?                                                                   \
           DirectDeviceDefaultPalette[(i)]                                   \
         :                                                                   \
           (                                                                 \
             ((i) < 256-ulDirectDeviceDefaultPaletteSize/2 )                 \
             ?                                                               \
               RGB2NULL                                                      \
             :                                                               \
               DirectDeviceDefaultPalette[(i) - 256                          \
                                + ulDirectDeviceDefaultPaletteSize]          \
            )                                                                \
         )

#define DirectDeviceDefaultULONG(i)                                          \
        (                                                                    \
         ((DDT.BitCount == 4) || ((i) < ulDirectDeviceDefaultPaletteSize/2)) \
         ?                                                                   \
           ((PULONG)DirectDeviceDefaultPalette)[(i)]                         \
         :                                                                   \
           (                                                                 \
             ((i) < 256-ulDirectDeviceDefaultPaletteSize/2 )                 \
             ?                                                               \
               0                                                             \
             :                                                               \
               ((PULONG)DirectDeviceDefaultPalette)[(i) - 256                \
                                + ulDirectDeviceDefaultPaletteSize]          \
            )                                                                \
         )

#define MemoryDeviceDefaultRGB2(i)                                           \
        (                                                                    \
         ((i) < SizeOfHWPalette)                                             \
         ?                                                                   \
           MemoryDeviceDefaultPalette[(i)]                                   \
         :                                                                   \
           RGB2NULL                                                          \
        )

#define MemoryDeviceDefaultULONG(i)                                          \
        (                                                                    \
         ((i) < SizeOfHWPalette)                                             \
         ?                                                                   \
           ((PULONG)MemoryDeviceDefaultPalette)[(i)]                         \
         :                                                                   \
           0                                                                 \
        )


