/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#ifdef S3
#define  MAXCHARLEN   256

#define  INCL_DOSFILEMGR
#define  INCL_DOSMEMMGR
#define  INCL_DOSMISC

#define INCL_GPIBITMAPS
#define INCL_GPIDISPPRF
#include <eddinclt.h>
#include "edddtypt.h"
#include "eddesres.h"

extern PSCREENRESOLUTION asrScreenResolution;
extern USHORT            usNumScreenResolutions;
#ifdef   BPP24
extern DDTType           DDT;
#endif

ULONG ulFilePos, ulFileSize;

PVOID MyAlloc(HFILE hf)
{
   FILESTATUS3  fib;
   ULONG        ulcbread;
   PVOID        pbuf;

   if(!DosQueryFileInfo(hf, FIL_STANDARD, &fib, sizeof(FILESTATUS3)))
   {
      if(!DosAllocMem(&pbuf, fib.cbFile, fALLOC))
      {
         if(!DosRead(hf, pbuf, fib.cbFile, &ulcbread))
         {
            ulFileSize = ulcbread;
            ulFilePos  = 0;
            return(pbuf);
         }
      }
   }

   return(NULL);
}

int MyGetString(PSZ pszStr, ULONG ulsize, PPVOID ppbuf)
{
   ULONG      cnt;

   if(ulFilePos >= ulFileSize) return(0);

   for (cnt=0;cnt < ulsize;cnt++)
   {
      if (((PSZ)*ppbuf)[cnt] == 0x0a)
      {
         pszStr[cnt] = 0;
         (*((PULONG)ppbuf)) += cnt+1;
         ulFilePos += cnt+1;
         break;
      }
      else
      {
         if(ulFilePos + cnt > ulFileSize) return(0);
         pszStr[cnt] = ((PSZ)*ppbuf)[cnt];
      }
   }

   return (1);
}

ULONG Myatoi(PSZ psz)
{

  PSZ    p1;
  ULONG  ulvalue = 0;

  for(p1 = psz; *p1 == 0x20; p1++);   /* Strip leading blanks */

  for(;*p1>='0' && *p1<='9';p1++)     /* Convert ASCII to integer */
  {
     ulvalue = ulvalue * 10;
     ulvalue += *p1 - '0';
  }

  return(ulvalue);
}

int MySscanf(PSZ pszBuffer, PULONG pulid)
{
   PSZ        p1;

   for (p1=pszBuffer;*p1 != '=';p1++);
   *pulid = Myatoi(&p1[1]);
   return(1);

}

HFILE Myfopen(PSZ pszFilename)
{
   HFILE   hfile;
   ULONG   ulact;
   ULONG   rc;

   rc = DosOpen(pszFilename, &hfile, &ulact, 0L, 0L, 1L, 0x40L, NULL);
   return (rc ? (HFILE)0 : hfile);
}

VOID SetObtainableModes(VOID)
{
   ULONG      ulDrive;
   CHAR       pszPMIFileName[20] = "#:\\OS2\\SVGADATA.PMI";
   HFILE      hfpmi;
   ULONG      cnt;
   PVOID      pBuf;

   char       pszPMIStr[MAXCHARLEN];
   ULONG      ul_xres, ul_yres, ul_clr, ul_planes;

   #ifdef   BPP24
   DDT.fScreenFlags |= USE_ATTDAC;
   #endif

   /* Search for the correct PMI File           */
   /*   We will append the system boot drive    */
   /*   to the OS2 dir and try to open the      */
   /*   file.                                   */

   DosQuerySysInfo(QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, &ulDrive, sizeof(ULONG));
   pszPMIFileName[0] = (UCHAR)(( (ULONG)'A' + ulDrive ) - 1);

   /* Open and parse for a match                            */
   /*   Search will be base on the [comment] key word in    */
   /*   the appropriate pmi file                            */

   if((hfpmi = Myfopen(pszPMIFileName)) && (pBuf = MyAlloc(hfpmi)))
   {

      while (MyGetString(pszPMIStr, MAXCHARLEN, &pBuf))
      {
         if(pszPMIStr[0] == '[' &&
            pszPMIStr[1] == 'M' &&
            pszPMIStr[2] == 'o' &&
            pszPMIStr[3] == 'd' &&
            pszPMIStr[4] == 'e' &&
            pszPMIStr[5] == 'I' &&
            pszPMIStr[6] == 'n' &&
            pszPMIStr[7] == 'f' &&
            pszPMIStr[8] == 'o' &&
            pszPMIStr[9] == ']')
         {
            MyGetString(pszPMIStr, MAXCHARLEN, &pBuf);     /* Mode Attributes      */
            MyGetString(pszPMIStr, MAXCHARLEN, &pBuf);     /* Bytes Per Scan Line  */
            MyGetString(pszPMIStr, MAXCHARLEN, &pBuf);     /* X Resolution         */
            MySscanf(pszPMIStr, &ul_xres);
            MyGetString(pszPMIStr, MAXCHARLEN, &pBuf);     /* Y Resolution         */
            MySscanf(pszPMIStr, &ul_yres);
            MyGetString(pszPMIStr, MAXCHARLEN, &pBuf);     /* Text Rows            */
            MyGetString(pszPMIStr, MAXCHARLEN, &pBuf);     /* Bits Per Pixel       */
            MySscanf(pszPMIStr, &ul_clr);
            ul_clr = 1 << ul_clr;                          /* Convert BPP to #clrs */
            MyGetString(pszPMIStr, MAXCHARLEN, &pBuf);     /* Number of Planes     */
            MySscanf(pszPMIStr, &ul_planes);

            for(cnt=0;cnt<usNumScreenResolutions;cnt++)
            {
               if ( asrScreenResolution[cnt].width  == ul_xres   &&
                    asrScreenResolution[cnt].height == ul_yres   &&
                    asrScreenResolution[cnt].colors == ul_clr    &&
                    asrScreenResolution[cnt].planes == ul_planes)
               {
                  asrScreenResolution[cnt].floptions |= DSP_RESOLUTION_OBTAINABLE;
               }
            }

         }

      #ifdef  BPP24
         if(pszPMIStr[3] == 'H' &&
            pszPMIStr[4] == 'I' &&
            pszPMIStr[5] == '-' &&
            pszPMIStr[6] == 'C' &&
            pszPMIStr[7] == 'O' &&
            pszPMIStr[8] == 'L' &&
            pszPMIStr[9] == 'O' &&
            pszPMIStr[10] == 'R' &&
            pszPMIStr[11] == ' ' &&
            pszPMIStr[12] == 'D' &&
            pszPMIStr[13] == 'A' &&
            pszPMIStr[14] == 'C' &&
            pszPMIStr[15] == ' ' &&
            pszPMIStr[16] == 'b' &&
            pszPMIStr[17] == 'y' &&
            pszPMIStr[18] == ' ')
         {
             if (pszPMIStr[19] == 'M' &&
                 pszPMIStr[20] == 'u' &&
                 pszPMIStr[21] == 's' &&
                 pszPMIStr[22] == 'i' &&
                 pszPMIStr[23] == 'c')
             {

                DDT.fScreenFlags &= ~USE_ATTDAC;

             }
             else if (pszPMIStr[19] == 'B' &&
                      pszPMIStr[20] == 'r' &&
                      pszPMIStr[21] == 'o' &&
                      pszPMIStr[22] == 'o' &&
                      pszPMIStr[23] == 'k')
                   {

                      DDT.fScreenFlags |= (USE_BROOKDAC | USE_8BIT_DAC);

                   }
                   else if (pszPMIStr[19] == 'A' &&
                            pszPMIStr[20] == 'T' &&
                            pszPMIStr[21] == '&' &&
                            pszPMIStr[22] == 'T')
                         {

                            DDT.fScreenFlags |= USE_8BIT_DAC;

                         }
         }
      #endif
      }

      DosFreeMem(pBuf);
      DosClose(hfpmi);
   }

   return;
}
#endif
