/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/* memman.h                                                           */
/*                                                                    */
/* Memory management header file.                                     */
/**********************************************************************/

/* minimum size of heap we will accept to allow the system to continue */
#define MIN_HEAP_SIZE 0x100000

/* memory object type identifiers */
#define MT_BITMAP           0x50414d42  /* BMAP */
#define MT_DC               0x20204344  /* DC   */
#define MT_PALETTE          0x204c4150  /* PAL  */
#define MT_COLORTABLE       0x42415443  /* CTAB */
#define MT_CORRRECTS        0x43455243  /* CREC */
#define MT_EXT_BITMAP       0x504d4245  /* EBMP */
#define MT_CODEPAGE         0x47415043  /* CPAG */
#define MT_FONTTABLE        0x42415446  /* FTAB */
#define MT_BITMAP_INFO2     0x32494d42  /* BMI2 */
#define MT_FONTLIST         0x54534c46  /* FLST */
#define MT_FONTMETRICS      0x54454d46  /* FMET */
#define MT_COORDLIST        0x53445243  /* CRDS */
#define MT_BITMAP_HEADER    0x44484d42  /* BMHD */
#define MT_PROFILESTRING    0x20465250  /* PRF  */
#define MT_FONTCACHEINFO    0x20494346  /* FCI  */
#define MT_PHUNK            0x4b4e4850  /* PHNK */
#define MT_CHAR_CACHE       0x45484343  /* CCHE */
#define MT_TEMP             0x504d4554  /* TEMP */
#define MT_DISPATCH_TABLE   0x42415444  /* DTAB */
#define MT_SCREEN_RES_TABLE 0x53455253  /* SRES */
#ifdef VRAMPTR
#define MT_BMCACHE          0x41434d42  /* BMCA */
#endif /* VRAMPTR */
#ifdef DCAF                                                               //DCAF
#define MT_SCA              0x20414353  /* SCA  */                        //DCAF
#define MT_CONVERT_TABLE    0x50524E43  /* CNVT */                        //DCAF
#endif /* DCAF */                                                         //DCAF

/* memory object flags */
#define MO_SHARED       0x01
#define MO_PRIVATE      0x02
#define MO_SSALLOC      0x04

/* allocation types */
#define AT_SUBALLOC     1
#define AT_SSALLOC      2

/* memory object info type */
typedef struct _MEMORYOBJECTINFO
{
    ULONG objectid;
    ULONG ulSize;
    ULONG ulAllocType;
} MEMORYOBJECTINFO;

typedef MEMORYOBJECTINFO *PMEMORYOBJECTINFO;


/**********************************************************************/
/* Function prototypes for memory management.                         */
/**********************************************************************/

ULONG DRIVERCALL InitializeMemoryAllocation(VOID);

PVOID DRIVERCALL AllocateMemory(ULONG ulSize,
                                ULONG ulTypeID,
                                ULONG ulFlags);

ULONG DRIVERCALL FreeMemory(PVOID pFreeMemoryBase);

VOID DRIVERCALL AccessMemoryObjects(VOID);
