;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
.386p
;/**********************************************************************
;/*
;/* Module:         LOCK
;/*
;/* Description:    Functions for locking and unlocking segments.
;/*
;/**********************************************************************

ifndef  _8514
include eddinclt.inc


extrn   DosDevIOCtl     : far
extrn   _aiXGAAdapter    : far


public  _pmlock
public  _pmunlock


_DATA   segment dword use32 public 'DATA'
_DATA   ends



_TEXT2  segment use32 dword public 'CODE'
                assume  cs:FLAT, ds:FLAT, es:FLAT

;/***********************************************************************
;/* Function:  PMLOCK
;/* Purpose:   Lock segment
;/***********************************************************************

_pmlock  proc  near

        mov   ebx,4                           ;DevIOctl routine 4
        jmp   short common_code

_pmlock  endp

;/***********************************************************************
;/* Function:  PMUNLOCK
;/* Purpose:   UnLock region identified by lock handle
;/***********************************************************************

_pmunlock  proc  near

        mov   ebx,5                            ;DevIOclt routine 5

;/***********************************************************************
;/* Common code
;/***********************************************************************
common_code:

        push    ebp
        mov     ebp, esp

        push    esi

; Set up pointer to parameter block (esi)
        mov     esi, [ebp+6]            ;Get address of parm block (ESI)

; Issue DosDevIOCtl to kernel driver
        push    ebp                     ;save the function number on the stack
        mov     eax, esp
        push    esi                     ;push addr of parm block
        push    eax                     ;function number
        push    dword ptr GEN_FUNCTION  ;device function request
        push    dword ptr XGA_CATEGORY  ;device catagory
        push    _aiXGAAdapter.hfDevHandle ;device handle
        call    DosDevIOCtl             ;do it ....
        add     esp, 4                  ;recover fn number stack

        pop     esi
        pop     ebp
        retf    8

_pmunlock  endp

_TEXT2  ends

endif   ;_8514

        end
