/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = INSTANCE.C                                     */
/*                                                                    */
/*   Description     = Contains variables which are kept per          */
/*                     process, and the routine to set them up.       */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DOSPROCESS
#define INCL_DOSDEVICES
#include <eddinclt.h>

ULONG   CurrentProcess;
ULONG   CurrentThread;

VOID InitializeInstance(VOID)
{
    PTIB    pThreadInfo;
    PPIB    pProcessInfo;

    DosGetInfoBlocks(&pThreadInfo,
                     &pProcessInfo);

    CurrentProcess = pProcessInfo->pib_ulpid;
    CurrentThread  = pThreadInfo->tib_ptib2->tib2_ultid;
}
