/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*   Module           : FONTDRVR.H                                    */
/*                                                                    */
/*   Description      : PM Display Driver DBCS handling routine       */
/*                      Defs for GreEscape (DBE_FONT_MANAGEMENT)      */
/*                                                                    */
/*   Created          : 12/09/91                                      */
/*   Author           : Yohji Nakamura (JL04328 at YMTVM6)            */
/*                                                                    */
/*   Notes            :                                               */
/*                    - This file is a direct translation of          */
/*                      FONTDRVR.INC                                  */
/*                                                                    */
/*   History          :                                               */
/*                                                                    */
/*                      OCO Source Materials                          */
/*                      XXXX-XXX                                      */
/**********************************************************************/
/*====================================================================*/
/* DevEscape (DEVESC_DBE_FONTMANAGEMENT) function                     */
/*                                                                    */
/*   SubFunction:    LOAD_FD_PRIVATE     load font driver private     */
/*                   LOAD_FD_PUBLIC      load font driver public      */
/*                   UNLOAD_FD_PRIVATE   unload font driver private   */
/*                   UNLOAD_FD_PUBLIC    unload font driver public    */
/*                                                                    */
/*   Description:    Load/Unload specified font driver as             */
/*                   private/public.                                  */
/*====================================================================*/
/*--------------------------------------------------------------------*/
/* structure for input parm                                           */
/*--------------------------------------------------------------------*/
#define DBCS_FIXGREESC                                      //@HSTTT
typedef struct
{
  ULONG fdi_lMatch;
  ULONG fdi_lFunctionID;
  ULONG fdi_lCodePoint;
#ifdef DBCS_FIXGREESC                  /* if GRE gives us 16:16 ptr   */
  VOID _far16 * fdi_pFontInfo;         /*   have to remember it       */
#else                                  /* or if GRE gives 0:32 ptr    */
  PVOID fdi_pFontInfo;                 /*   this is enough            */
#endif
} DBE_FDI_PARAMETERS;

typedef DBE_FDI_PARAMETERS *PDBE_FDI_PARAMETERS;

/*--------------------------------------------------------------------*/
/* value for fdi_lFunctionID                                          */
/*--------------------------------------------------------------------*/
#define LOAD_FD_PRIVATE   0x8001
#define UNLOAD_FD_PRIVATE 0x8002
#define LOAD_FD_PUBLIC    0x8003
#define UNLOAD_FD_PUBLIC  0x8004

/*====================================================================*/
/* DevEscape (DEVESC_DBE_FONTMANAGEMENT) function       DCR189 @ JP20 */
/*                                                                    */
/*   SubFunction:    QUERY_VIO_FONTATTRIBUTE                          */
/*                                                                    */
/*   Description:    Return the Vio font attribute corresponding to   */
/*                   the specified cellsize.                          */
/*====================================================================*/
/*--------------------------------------------------------------------*/
/* structure for input parm                                           */
/*--------------------------------------------------------------------*/
typedef struct
{
  ULONG vioa_ulRecordLength;
  LONG vioa_lFunctionID;
  ULONG vioa_cx;
  ULONG vioa_cy;
} VIOFONTATTRIBUTE;

typedef VIOFONTATTRIBUTE *PVIOFONTATTRIBUTE;

/*--------------------------------------------------------------------*/
/* value for vioa_lFunctionID                                         */
/*--------------------------------------------------------------------*/
#define QUERY_VIO_FONTATTRIBUTE 0x4001

/*====================================================================*/
/* For ease of handling...                                            */
/*====================================================================*/
typedef union
{                                      /* Note size of both struct is */
  DBE_FDI_PARAMETERS fdi;              /* equal, and offset of func   */
  VIOFONTATTRIBUTE   vioa;             /* ID is also same.            */
} FONTMGRPARM;

typedef FONTMGRPARM *PFONTMGRPARM;

