/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/* errors.c                                                           */
/*                                                                    */
/* Contains functions relating to error detection and handling.       */
/**********************************************************************/

#define INCL_DDIMISC
#define INCL_DDICOMFLAGS

#include "eddinclt.h"

//#include "eddbcone.h"
//#include "eddccone.h"

//#include "eddbtypt.h"
//#include "edddtypt.h"

//#include "pmdddefs.h"
//#include "bitmaps.h"
//#include "memory.h"
#include "errors.h"
//#include "convfuns.h"
//#include "spad.h"

//#include "eddbextf.h"
//#include "eddcextf.h"
//#include "eddgextf.h"

//#include "eddhcone.h"
//#include "eddhtype.h"
//#include "eddhmacr.h"




/**********************************************************************/
/* globals                                                            */
/**********************************************************************/
ERRORID eiErrorToLog = MAKEERRORID(0, 0);



/**********************************************************************/
/* IllegallyInPath                                                    */
/*                                                                    */
/* fsCommandBits  the command bits portion of the FunN passed to the  */
/*                driver.                                             */
/*                                                                    */
/* Called by functions which are not allowed within paths (or areas). */
/* Returns TRUE and sets the global error variable, eiErrorToLog, if  */
/* currently in a path or area; returns FALSE if not.                 */
/**********************************************************************/
BOOL PASCAL IllegallyInPath(ULONG  fsCommandBits)
{
   if ( fsCommandBits & (COM_AREA | COM_PATH) )
   {
      if ( fsCommandBits & COM_PATH )
      {
         eiErrorToLog = MAKEERRORID(SEVERITY_ERROR, PMERR_INV_IN_PATH);
      }
      else /* com_area */
      {
         eiErrorToLog = MAKEERRORID(SEVERITY_ERROR, PMERR_INV_IN_AREA);
      }

      return(TRUE);
   }
   else /* not in path or area */
   {
      return(FALSE);
   }
} /* IllegallyInPath */
