/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDZTRCF                                       */
/*                                                                    */
/*   Description     = Display Device Driver Trace and Error Logging  */
/*                     Macro definitions.                             */
/*                                                                    */
/*   Function        = Declares macros for:                           */
/*                     - TRACE8 : regression tracing                  */
/*                     - TRACE6 : development/test tracing            */
/*                     - TRACE4 : development/test tracing            */
/*                     - LOGERR : error logging                       */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#define TRACE4(S,C,P,N)
#define TRACE6(S,C,P,N)
#define TRACE8(S,C,P,N)
#define TRACE12(S,C,P,N)

USHORT PASCAL eddz_Init (BOOL FirstTime);

CHAR * PASCAL eddz_hex(LONG   lnum);

CHAR * PASCAL eddz_decimal(LONG   lnum,
                           SHORT  digits);

/**********************************************************************/
/* TRACE macros                                                       */
/**********************************************************************/
#ifdef EDDTRACE
extern BOOL eddz_on;
VOID PASCAL eddz_Trace(PCHAR  caller,
                       PCHAR  messg,
                       PCHAR  info,
                       USHORT num);
#endif


#ifdef EDDTRACE
#if (EDDTRACE != 0)

#if (EDDTRACE <= 4)
#undef  TRACE4
#define TRACE4(S,C,P,N) if (eddz_on) eddz_Trace((PCHAR)(S),(PCHAR)(C), \
                                   (PCHAR)(P),(USHORT)(N))
#endif

#if (EDDTRACE <= 6)
#undef  TRACE6
#define TRACE6(S,C,P,N) if (eddz_on) eddz_Trace((PCHAR)(S),(PCHAR)(C), \
                                   (PCHAR)(P),(USHORT)(N))
#endif

#if (EDDTRACE <= 8)
#undef  TRACE8
#define TRACE8(S,C,P,N) if (eddz_on) eddz_Trace((PCHAR)(S),(PCHAR)(C), \
                                   (PCHAR)(P),(USHORT)(N))
#endif

#if (EDDTRACE <= 12)
#undef  TRACE12
#define TRACE12(S,C,P,N) if (eddz_on) eddz_Trace((PCHAR)(S),(PCHAR)(C), \
                                    (PCHAR)(P),(USHORT)(N))
#endif

#endif
#endif

/**********************************************************************/
/* LOGERR Macros                                                      */
/* Parameters:                                                        */
/*            S - calling function name (TFUNC)                       */
/*            C - explanatory text, eg. DosOpen failed                */
/*            P - unused                                              */
/*            N - unused                                              */
/*            E - error (LOGERR and LOGWARNING)                       */
/*              - Dos return code (LOGDOSERR)                         */
/**********************************************************************/
#ifdef EDD_DEBUG
VOID PASCAL FAR eddz_LogErr(PCHAR   Func,
                            PCHAR   Text,
                            USHORT  ErrCode);
#define LOGERR(S,C,P,N,E)                                              \
        eddz_LogErr(S,C,E);
#else /* ndef EDD_DEBUG */
#define LOGERR(S,C,P,N,E)                                              \
//      WinSetErrorInfo(MAKEERRORID(SEVERITY_ERROR,E),                 \
//                      SEI_NOBEEP|SEI_NOPROMPT);
#endif /* ndef EDD_DEBUG */

#define LOGWARNING(S,C,P,N,E)                                          \
//      WinSetErrorInfo(MAKEERRORID(SEVERITY_WARNING,E),               \
//                      SEI_NOBEEP|SEI_NOPROMPT);

#ifdef EDD_DEBUG
VOID PASCAL FAR eddz_LogDosErr(PCHAR   Func,
                               PCHAR   Text,
                               USHORT  ErrCode);
#define LOGDOSERR(S,C,P,N,E)                                           \
        eddz_LogDosErr(S,C,E);
#else /* ndef EDD_DEBUG */
#define LOGDOSERR(S,C,P,N,E)                                           \
        WinSetErrorInfo(MAKEERRORID(SEVERITY_ERROR,PMERR_BASE_ERROR),  \
                        SEI_NOBEEP|SEI_NOPROMPT|SEI_DOSERROR,          \
                        E);
#endif /* ndef EDD_DEBUG */


#define RIP(S,C,P,N,E)                                                 \
        {DebugOutput(S);                                               \
         DebugOutput(C);                                               \
         WinSetErrorInfo(MAKEERRORID(SEVERITY_ERROR,1),                \
                         SEI_REGISTERS|SEI_STACKTRACE,                 \
                         C)                                            \
        }


/**********************************************************************/
/* Profiling macros                                                   */
/**********************************************************************/
#undef PROFILE_ENTER
#undef PROFILE_EXIT

#ifdef EDD_PROFILE

#define PROFILE_ENTER(D) {                               \
     tstop();                                            \
     eddz_Profile(0,D,Time);                             \
     tstart();                                           \
}

#define PROFILE_EXIT(D)  {                               \
     tstop();                                            \
     eddz_Profile(3,0,Time);                             \
     tstart();                                           \
}

#else

#define PROFILE_ENTER(D)
#define PROFILE_EXIT(D)

#endif
