/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   Module File     = EDDZTRAC                                       */
/*                                                                    */
/*   Description     = Display Device Driver Trace                    */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


#define INCL_WINP_FSRS
#include <eddinclt.h>
#include <eddztrce.h>
#include <eddgextf.h>


/**********************************************************************/
/* We only compile this section if we actually want tracing !         */
/**********************************************************************/
#ifdef EDDTRACE
#if EDDTRACE != 0

/**********************************************************************/
/* VAR, conv, hexarr and hexstr are used by eddz_hex to avoid calls   */
/* to the ltoa library routine.                                       */
/**********************************************************************/

typedef union { ULONG number; CHAR ch[4]; } VAR;

CHAR conv[16][32] = {
 "000102030405060708090A0B0C0D0E0F",
 "101112131415161718191A1B1C1D1E1F",
 "202122232425262728292A2B2C2D2E2F",
 "303132333435363738393A3B3C3D3E3F",
 "404142434445464748494A4B4C4D4E4F",
 "505152535455565758595A5B5C5D5E5F",
 "606162636465666768696A6B6C6D6E6F",
 "707172737475767778797A7B7C7D7E7F",
 "808182838485868788898A8B8C8D8E8F",
 "909192939495969798999A9B9C9D9E9F",
 "A0A1A2A3A4A5A6A7A8A9AAABACADAEAF",
 "B0B1B2B3B4B5B6B7B8B9BABBBCBDBEBF",
 "C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF",
 "D0D1D2D3D4D5D6D7D8D9DADBDCDDDEDF",
 "E0E1E2E3E4E5E6E7E8E9EAEBECEDEEEF",
 "F0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF" };

USHORT (*hexarr)[256] = (USHORT (*)[256])conv;

USHORT hexstr[5];

/**********************************************************************/
/* Blanks is used by eddztrac to align output (to max of 25 widths).  */
/**********************************************************************/

CHAR Blanks[25] = "                         ";

extern ULONG            eddz_TraceFile;
extern BOOL             eddz_On;
extern PFSRSEM          lpTraceFileSem;

#ifdef EDD_DEBUG2

VOID TrcWrite(CHAR *  pstr,
              USHORT  c)

{ while ( *pstr)
          {
             *((PCHAR)eddz_TraceFile) = *pstr++;
             ((USHORT)eddz_TraceFile)++;
             *((PCHAR)eddz_TraceFile) = '\\';
          }
}

#else /* EDD_DEBUG2 */

#define TrcWrite( A, B)                                                \
    (void)DosWrite((HFILE)eddz_TraceFile, (A), (B),                    \
                                         (PUSHORT)&(USHORT)Done);
#endif /* EDD_DEBUG2 */


/**********************************************************************/
/* eddz_Init initialises the trace level and opens trace file.        */
/**********************************************************************/

USHORT PASCAL eddz_Init (BOOL FirstTime)

{
#define TFUNC "eddz_Init"
    USHORT      DosAction;
    USHORT      Result;

    /******************************************************************/
    /* Open the trace file. The main file characteristics are:        */
    /* - name      : fixed name defined in EDDZTRCE.H                 */
    /* - open flag : specifies create or replace                      */
    /* - open mode : specifies normal path/ asynchronous write/ errors*/
    /*               reported via system/ shared read/ read and write.*/
    /******************************************************************/
    if (FirstTime == TRUE)
    {
#ifdef EDD_DEBUG2
        Result = SSAllocSeg( FULL_SEGMENT,
                             (PSEL)&SELECTOROF(eddz_TraceFile), 6);
#else /* EDD_DEBUG2 */
        Result = DosOpen(EDDTRACEFILE, (PHFILE)&eddz_TraceFile,
                  (PUSHORT)&(USHORT)DosAction, 0L, 0, 0X12, 0X41, 0L);
        CloseTraceFile;
#endif /* EDD_DEBUG2 */
    }
    else
    {
#ifdef EDD_DEBUG2
        Result = DosGetSeg( SELECTOROF(eddz_TraceFile));
#endif /* EDD_DEBUG2 */
    }
    return(Result);
}
#undef TFUNC


/**********************************************************************/
/* eddz_trace outputs a trace message plus data to trace file.        */
/**********************************************************************/

VOID PASCAL eddz_Trace(PCHAR  caller,
                       PCHAR  messg,
                       PCHAR  info,
                       USHORT num)

{
    USHORT    Done;
    SHORT     Leng;
    PLONG     Linfo;
    CHAR *    Str;
    USHORT    OutCnt;
    USHORT    ProcessID;
    ULONG     NewFilePtr;
    USHORT    DosAction;
    USHORT    Result;

    /******************************************************************/
    /* don't trace if tracing not switched on                         */
    /******************************************************************/
    if ( ! eddz_On )
        return;

    /**************************************************************/
    /* request the trace file semaphore to ensure all the data    */
    /* is output without being split up                           */
    /**************************************************************/
    RequestSemaphore (lpTraceFileSem);

    /******************************************************************/
    /* open the trace file here                                       */
    /******************************************************************/
    Result = DosOpen(EDDTRACEFILE, (PHFILE)&eddz_TraceFile,
              (PUSHORT)&(USHORT)DosAction, 0L, 0, 0X11, 0X41, 0L);
    if (Result != DOS_OK)
    {
        goto Error_clear_semaphore;
    }

    Result = DosChgFilePtr((HFILE)eddz_TraceFile, 0L, 2, &NewFilePtr);

    if (Result != DOS_OK)
    {
        goto Error_close_file;
    }

    /**************************************************************/
    /* Put the thread ID in the trace file                        */
    /**************************************************************/
    ProcessID = lpTraceFileSem->ThrdID;
    Str = eddz_hex((LONG)ProcessID);
    TrcWrite( Str, 4);
    TrcWrite( ": ", 2);

    /**************************************************************/
    /* Put the two strings provided into the trace file.          */
    /**************************************************************/
    Leng = min(strlen(caller),15);
    TrcWrite( caller, Leng);
    TrcWrite( Blanks, 15-Leng);
    TrcWrite( ": ", 2);

    Leng = min(strlen(messg),20);
    TrcWrite( messg, Leng);
    TrcWrite( Blanks, 20-Leng);
    TrcWrite( ": ", 2);

    /**************************************************************/
    /* Put the 32-bit words provided into the trace file, as      */
    /* hex strings.                                               */
    /* Loop below puts out four 32-bit words on the first line,   */
    /* with eight 32-bit words on subsequent lines.               */
    /**************************************************************/
    if (info != FNULL)
    {
        for (Leng = num, Linfo = (long far *)info, OutCnt = 1;
                                Leng > 0; --Leng, ++Linfo, ++OutCnt)
        {
            Str = eddz_hex(*Linfo);
            TrcWrite( Str, 8);
            TrcWrite( " ", 1);

            if (((OutCnt % 4) == 0) && (Leng > 1))
            {
                TrcWrite( "\015\n", 2);
                TrcWrite( Blanks, 20);
                TrcWrite( Blanks, 25);
            }
        }
    }
    TrcWrite( "\015\n", 2);

 Error_close_file:
    /******************************************************************/
    /* close trace file here to flush data                            */
    /******************************************************************/
    CloseTraceFile;

 Error_clear_semaphore:
    /**************************************************************/
    /* release the trace file semaphore                           */
    /**************************************************************/
    ClearSemaphore (lpTraceFileSem);

}



/**********************************************************************/
/* eddz_hex converts a long to a hex ascii string.                    */
/**********************************************************************/


CHAR * PASCAL eddz_hex(LONG   lnum)

{
    VAR     innum;
    USHORT  i;

    innum.number = lnum;
    hexstr[4] = 0;
    for (i = 0; i < 4; ++i)
    {
        hexstr[i] = (*hexarr)[(SHORT)innum.ch[i]];
    }
    return((CHAR *)&hexstr[0]);
}

#endif /* EDDTRACE != 0 */
#endif /* EDDTRACE */

#ifdef EDD_DEBUG
VOID PASCAL FAR eddz_LogErr(PCHAR   Func,
                            PCHAR   Text,
                            USHORT  ErrCode)
{
     DebugOutput("** ERROR: ");
     DebugOutput(Func);
     DebugOutput(": ");
     DebugOutput(Text);
     DebugOutput("\n\r");
//   WinSetErrorInfo(MAKEERRORID(SEVERITY_SEVERE,ErrCode),
//                   SEI_NOBEEP|SEI_NOPROMPT);
}

VOID PASCAL FAR eddz_LogDosErr(PCHAR   Func,
                               PCHAR   Text,
                               USHORT  ErrCode)
{
     DebugOutput("** DOS ERROR: ");
     DebugOutput(Func);
     DebugOutput(": ");
     DebugOutput(Text);
     DebugOutput("\n\r");
//   WinSetErrorInfo(MAKEERRORID(SEVERITY_SEVERE,PMERR_BASE_ERROR),
//                   SEI_NOBEEP|SEI_NOPROMPT|SEI_DOSERROR,ErrCode);
}



#endif /* EDD_DEBUG */

