;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)eddvsr32.asm       6.2 91/12/05
        page    ,132
;---------------------------Module-Header--------------------------------------;
; Module Name: EDDVSR32.ASM                                                    ;
;                                                                              ;
;    Abstract: 32 bit code subroutines used in                                 ;
;              Display Driver AVIO Functions                                   ;
;                                                                              ;
;     Created: 91-12-01                                                        ;
;      Author: Eitaroh Kasamatsu (JL21221 at YMTVM6)                           ;
;                                                                              ;
;                                                                              ;
;                                                                              ;
;                                                                              ;
; Description:                                                                 ;
;              Routines in this module are used to get a long pointer to       ;
;              VioPresentationSpace structure. The pointer is required in      ;
;              DeviceSetAvioFont2 function to refer to the structure, because  ;
;              for OS/2 J, we have to store font selectors and pointers to     ;
;              codepoint mapping tables in that structure. (XGA SBCS Original  ;
;              Code does not store these information in PS but only in DC)     ;
;                                                                              ;
; History:                                                                     ;
;                                                                              ;
;  91/12/05     22:40   -by-    E.Kasamatsu (JL21221 at YMTVM6)                ;
;                       Wrote it!                                              ;
;------------------------------------------------------------------------------;

;------------------------------------------------------------------------------;
; Include Files                                                                ;
;------------------------------------------------------------------------------;
        .386p                          ; 
INCL_DEF = 1                           ; import all macros
include basemaca.inc                   ; a lot of useful macros
include eddjthnk.inc                    ; macros for thunking
include eddjdef.inc                     ; common definitions
        .list

;------------------------------------------------------------------------------;
; Segment Definitions                                                          ;
;------------------------------------------------------------------------------;
        DefSeg  _TEXT, _TEXT, CODE, DWORD, PUBLIC, USE32, 'CODE'
        DefSeg  _DATA, _DATA, DATA, DWORD, PUBLIC, USE32, 'DATA'

        DefSeg  _CODE16, _CODE16, CODE, WORD, PUBLIC, USE16, 'CODE'
        DefSeg  _DATA16, _DATA16, DATA, WORD, PUBLIC, USE16, 'DATA'

        DefSeg  _CODE16IOPL, _CODE16IOPL, CODE, WORD, PUBLIC, USE16, 'CODE'

;------------------------------------------------------------------------------;
; External access for this module                                              ;
;------------------------------------------------------------------------------;

        extrn   GetPSAddress16:far

;------------------------------------------------------------------------------;
; Constants                                                                    ;
;------------------------------------------------------------------------------;
        ;NO CONSTANTS


DefCode PRIVATE, _TEXT, PASCAL
                assume  cs:FLAT, ds:FLAT, es:FLAT

;---------------------------Public  Routine------------------------------------;
; ULONG PASCAL GetPSAddress(ULONG hVio)                                        ;
;                                                                              ;
;                                                                              ;
; This 32bit code routine retrieves FAR pointer to VioPresentationSpace        ;
; structure from hdc which is a handle of DC currently associated with         ;
; the Vio Presentation Space. It actually calls 16 bit code routine named      ;
; GetPSAddress16. **NOTE** This routine is PASCAL procedure, not C.            ;
;                                                                              ;
; Entry: hVio   -- VIO handle                                                  ;
;                                                                              ;
;  Exit: eax    -- 32bit pointer (or sel:offset) to VioPS (= 0 if error)       ;
;                                                                              ;
; Registers: EBX,ECX,EDX,EDI,ESI,DS,ED -- will be preserved                    ;
;---------------------------exit-----------------------------------------------;

Procedure GetPSAddress, near            ; beginning of procedure.
                                        ; note this is PASCAL (not C)
                                        ; procedure.
        ArgVar  hVio,DWORD              ; define given argument

EnterProc                               ; buildup satck frame

        push    ebx                     ; parent C ruotine asumes
        push    ecx                     ; these registers mustn't
        push    edx                     ; be corrupted
        push    esi
        push    edi
        push    ds
        push    es

T32Begin _CODE16,_TEXT,_DATA16,_DATA ; begin of 32->16 thunk code

        GetRPL  bx,ss                   ; copy RPL bits from ss to bx
                                        ; and make bx default RPL REG
        mov     esi,hVio                ; keep hdc value in ESI because we
                                        ; can't access hdc after swiching stack
        T32Stack ESP,PTRFLAT,<>,2048    ; switch to 16-bit stack on ESP
                                        ; guaranteeing mininum 2KB
                                        ; default work reg is used
                                        ;   (EAX,ECX,EDX)
                                        ; RPL comes from default (BX)
        mov     eax,esi                 ; EAX holds hVio
        T32Call GetPSAddress16,C        ; now call 16 bit routine (C proc.)
                                        ; 16 bit routine returns here
        T32EndStack                     ; switch back to 32 bit stack
T32End                                  ; end thunk code
                                        ; EAX hold required pointer
        or      eax,eax                 ; get sel:offset?
        jnz short @f                    ; yes
        jmp short ret_to_c              ; no, error retrn
@@:
        mov     dx,ax                   ; get  offset
        shr     eax,16                  ; 
        mov     cx,ax                   ; get selector
        FlatPtr eax,cx,dx               ; convert to 0:32 pointer

ret_to_c:                               ; then return

        pop     es                      ; recover registers
        pop     ds
        pop     edi
        pop     esi
        pop     edx
        pop     ecx
        pop     ebx
ExitProc
EndProc GetPSAddress


EndCode

end
