;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)eddvsr16.asm       6.2 91/11/28
        page    ,132
;---------------------------Module-Header--------------------------------------;
; Module Name: EDDVSR16.ASM                                                    ;
;                                                                              ;
;    Abstract: 16 bit code subroutines used in                                 ;
;              Display Driver AVIO Functions                                   ;
;                                                                              ;
;     Created: 91-11-28                                                        ;
;      Author: Eitaroh Kasamatsu (JL21221 at YMTVM6)                           ;
;                                                                              ;
;                                                                              ;
;                                                                              ;
;                                                                              ;
; Description:                                                                 ;
;         16 bit code routines used in Device Driver Avio Functions.           ;
;                                                                              ;
; History:                                                                     ;
;                                                                              ;
;  91/11/28     11:55   -by-    E.Kasamatsu (JL21221 at YMTVM6)                ;
;                       Wrote it!                                              ;
;  91/12/03     11:05   -by-    E.Kasamatsu (JL21221 at YMTVM6)                ;
;                       Add ForceValidCP16 routine for DBCS CodePage Support.  ;
;------------------------------------------------------------------------------;
        .286p
        .xlist
?DF     = 1                             ; Do not define seg in cmacros
        include cmacros.inc
INCL_DOSNLS             equ     1
INCL_DOSMEMMGR          equ     1
INCL_DDIMISC            equ     1
INCL_DOSERRORS          equ     1
INCL_GRE_XFORMS         equ     1
INCL_GRE_BITMAPS        equ     1
INCL_GRE_STRINGS        equ     1
INCL_GRE_DCS            equ     1
INCL_GRE_DEVMISC1       equ     1
INCL_DEV                equ     1
INCL_WINP               equ     1
INCL_DDICOMFLAGS        equ     1
INCL_FONTFILEFORMAT     equ     1
INCL_GRE_CLIP           equ     1
INCL_GPIREGIONS         equ     1
INCL_AVIOP              equ     1
        include pmgre.inc
DINCL_VIO               equ     1
        include driver.inc
        include fontseg.inc
        include njmp.mac
        .list

        .386p


;;------------------------------------------------------------------------------;
;; VioSegData definition                                                        ;
;;------------------------------------------------------------------------------;
;sBegin Code
;globalW VioSegData,DataBASE
;sEnd   Code

;------------------------------------------------------------------------------;
; External access for this module                                              ;
;------------------------------------------------------------------------------;
        externFP    Vio16GetPSAddress

sBegin  VioSeg
        assumes cs,VioSeg

;       externW VioSegData

;---------------------------Public  Routine------------------------------------;
; GetPSAddress16()                                                             ;
;                                                                              ;
; This 16bit code routine retrieves FAR pointer to VioPresentationSpace        ;
; structure from hdc which is a handle of DC currently associated with         ;
; the Vio Presentation Space. First this routine calls GreGetHandle with       ;
; hdc to get hvio. Then it calls VioGetPSAddress with hvio to get FAR          ;
; pointer to VioPresentationSpace.                                             ;
;                                                                              ;
; Entry: EAX - hVio                                                            ;
;                                                                              ;
;  Exit: EAX - error indicator (0 = no error, 1 = error occurs)                ;
;                                                                              ;
;------------------------------------------------------------------------------;

cProc   GetPSAddress16,<PUBLIC,FAR,NODATA>,<ebx,ecx,edx,esi,edi,ds,es>
        localD  hdc
        localW  pbsel
        localW  pboff
cBegin
        or      eax,eax                 ; hVio value non-null?
        jnz short hvio_ok               ; yes it's ok.
        jmp     short indicate_error    ; is null, indicate error

hvio_ok:
        mov     dx,ax
        sub     ax,ax                   ; clear AX
        push    ax                      ; 
        push    ax                      ; 
        mov     bx,sp                   ; load stack pointer in BX
        farPtr  ppaviops,ss,bx          ; make far pointer for ppaviops
        cCall   Vio16GetPSAddress,<ppaviops,dx>
        or      ax,ax                   ; got ps address successfully?
        pop     si                      ; 
        pop     ds                      ; 
        jz short get_address_16_ok      ; yes, so indicate success and exit
        jmp short indicate_error        ; 

get_address_16_ok:
        mov     ax,ds                   ; set selector
        shl     eax,16                  ; 
        mov     ax,si                   ; set offset
        jmp short exit_get_ps_address_16

indicate_error:
        sub     eax,eax                 ; indicate failure

exit_get_ps_address_16:

cEnd


sEnd    VioSeg
end
