/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDVJTYP                                       */
/*                                                                    */
/*   Description     = Display Device Driver Japanese unique type     */
/*                     Definitions for AVIO Functions                 */
/*                                                                    */
/*   Created          : 92/Jul/27                                     */
/*   Author           : Eitaroh Kasamatsu (JL21221 at YMTVM6)         */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/*   History                                                          */
/*      93/May/24  16:30   E.Kasamatsu                                */
/*         Delete JVIOINNERPB and add 16 bit VioPresentationSpace     */
/*         structure for JFIX_AVIOSETF.                               */
/*      92/Jul/30  16:00   E.Kasamatsu                                */
/*         Added JUniqueVioInnerParameterBlock structure.             */
/*                                                                    */
/*      92/Jul/27  13:40   E.Kasamatsu                                */
/*         Wrote it!                                                  */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* We use reserved field of VioPSNLSExt structure to support          */
/* IBM-J Vio format support.                                          */
/**********************************************************************/
typedef struct _JVIOPSNLSEXT {  /* J unique viopsnlsext */
    DBCSENVINFO DBCSEvInfo[4];  /* For lcid 0 to 3      */
    ULONG       grid_color;     /* For Display.dll      */
    ULONG       scrn_attr_flag; /* To support IBM-J Vio */
} JVIOPSNLSEXT;

typedef JVIOPSNLSEXT FAR  *PJVIOPSNLSEXT;

/***********************************************************************/
/* We have to use 16 bit structure of VioPresentationSpace, if         */
/* Vio16GetPSAddress still returns 16 bit structure.                   */
/***********************************************************************/
typedef struct _JfixVioPresentationSpace {  /* 16 bit version of viops */

    FSRSEM  fsemVioPSLock;

    SEL     selLVB;
    SEL     selBVSCB;
/*  BOOL    rgfAVio; */
    USHORT  rgfAVio;

    USHORT  CellByteSize;

    USHORT  BufferRowCount;
    USHORT  BufferColumnCount;

/* Window Origin coordinates can be negative for AVio presentation spaces.
 * For Vio presentation spaces the Shield Layer always coerces them to
 * non-negative values such that the client rectangle always lies completely
 * within the image of the logical video buffer.
 */
    SHORT   WindowOriginRow;
    SHORT   WindowOriginColumn;

    USHORT  TextCursorRow;
    USHORT  TextCursorColumn;
    USHORT  TextCursorStartLine;
    USHORT  TextCursorEndLine;
    USHORT  TextCursorWidth;
/*  BOOL    TextCursorVisible; */
    USHORT  TextCursorVisible;

    USHORT  CellImageHeight;
    USHORT  CellImageWidth;

    USHORT  CodepageID;

    USHORT  WindowHeight;
    USHORT  WindowWidth;

    HDC     hConsoleDisplayContext;

/* The following fields are used for private communication between
 * the shield thread and the display driver.
 *
 * NB: The order and positions of the fields RowOrgLatch..CursorWidth
 *     must parallel that of the fields WindowOriginRow..TextCursorWidth
 *     in the Vio presentation space.  The UpdateCursor code in the device
 *     driver depends on this being so.  See the AVioPS.inc file used
 *     by the driver.
 */
    HWND    hVioWindow;         /* Window handle for this Vio PS  */

    SHORT   RowOrgLatch;        /* Window origin coordinates from */
    SHORT   ColOrgLatch;        /* the last call to UpdateCursor  */

    SHORT   CursorRow;          /* Cursor state as of the last    */
    SHORT   CursorCol;          /* call to UpdateCursor           */
    SHORT   CursorStartLine;
    SHORT   CursorEndLine;
    BYTE    CursorWidth;

    CHAR    PartialCellAdjust;  /* Adjustment for partial cells   */
                                /* on the bottom of the window.   */
    SHORT   XLatch;             /* Pel coordinates of the cursor  */
    SHORT   YLatch;             /* rectangle relative to the Vio  */
    SHORT   WidthLatch;         /* window                         */
    SHORT   HeightLatch;

    USHORT  CellHeightLatch;    /* To detect cell height changes. */

/*  BOOL    rgfShieldStates; */

    USHORT  rgfShieldStates;    /* Shield States shared with the  */
                                /* device driver code.            */

    SEL     selFontsLoaded[3];  /* Selectors for fonts loaded into */
                                /* LCID 1..3.                      */

    USHORT NEAR *npMapFontsLoaded[3];
                                /* Offsets within the display driver's   */
                                /* global data segment of the code page  */
                                /* maps for fonts loaded into LCID 1..3. */
    USHORT  FormatID;
    USHORT  Reserved;           /*
                                 * Japan needs to know FormatID and *
                                 * Reserved for the Display Device  *
                                 * Driver.                          */
    /*ifdef D1348*/
    PVIOPSNLSEXT lpNLSExt;
    /*endif D1348*/

} JFixVioPresentationSpace;


/* Standard typedefs
 */
typedef JFixVioPresentationSpace JFIXVIOPS;
typedef JFIXVIOPS FAR *PJFIXVIOPS;
typedef JFIXVIOPS NEAR *NPJFIXVIOPS;
typedef PJFIXVIOPS FAR *PPJFIXVIOPS;

/* Currently, Vio16GetPSAddress returns 16 bit structure. So we define  */
/* following flag.                                                      */
#define JFIX_AVIOSETF
