/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDVEXTF                                       */
/*                                                                    */
/*   Description     = Display Device Driver external files for       */
/*                     AVIO routines                                  */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
DDIENTRY eddv_CharRect (HDC             hdc,
                        PVIOPS          VioPS,
                        LPGridRectRef   ArgCharRect,
                        PDC             pdcArg,
                        ULONG           FunN);

DDIENTRY eddv_CharStr (HDC              hdc,
                       PVIOPS           VioPS,
                       LPGridStringRef  ArgCharString,
                       PDC              pdcArg,
                       ULONG            FunN);

DDIENTRY eddv_ScrollRect (HDC                hdc,
                          PVIOPS             VioPS,
                          LPScrollRectRef    ArgScrollRect,
                          PDC                pdcArg,
                          ULONG              FunN);

DDIENTRY eddv_UpdateCursor (HDC         hdc,
                            PVIOPS      VioPS,
                            PDC         pdcArg,
                            ULONG       FunN);

DDIENTRY eddv_DeviceSetAVIOFont2 (HDC           hdc,
                                  PFATTRS       pFattrs,
                                  PFOCAFONT     FontDef,
                                  LONG          LCIDindex,
                                  PDC           pdcArg,
                                  ULONG         FunN);

/**********************************************************************/
/* Internal routines.                                                 */
/**********************************************************************/
VOID DRIVERCALL CheckAVIOFonts(PVIOPS  VioPS);

VOID DRIVERCALL CheckAVIOFontsCached(PVIOPS  VioPS);

#ifndef DBCS                                                
VOID DRIVERCALL CGAText(VOID);

VOID DRIVERCALL MFIText(VOID);
#else 
BOOL DRIVERCALL CGAText(VOID);

BOOL DRIVERCALL MFIText(VOID);

BOOL DRIVERCALL DBCSCommonText(VOID);

BOOL DRIVERCALL EpochColorText(PVIOPS VioPS);

BOOL DRIVERCALL EpochMonoText(PVIOPS VioPS);
#endif 

VOID DRIVERCALL InvertAVIOCursor(PVIOPS  VioPS);

VOID DRIVERCALL CalculateGridOffsets(PAVIOINFO pAvioInfo,
                                     PVIOPS    VioPS);

#ifdef DBCS                                                 
BOOL CheckCodePage(PVIOPS        VioPS,
                   PFONTDETAILS  pfdBaseFont);

LONG DRIVERCALL AvioForceCharInCache(PFONTDETAILS pFontDetails,
                                     ULONG        ulCodePoint);
#endif 

/**********************************************************************/
/* Assembler code routines                                            */
/*                                                                    */
/* Important!!!                                                       */
/* In CL386, calling convention has been changed. According to new    */
/* calling convention, input arguments pushed by caller are expeced   */
/* to be removed by callee. We don't want to apply this convention.   */
/* So, we use _cdecl instead of DRIVERCALL. _cdecl uses previous      */
/* calling convention...                                              */
/**********************************************************************/
#ifndef DBCS                                                
VOID DRIVERCALL CGATextBlock(PFONTDETAILS pFontDetails,
                             PAVIOINFO    pAvioInfo);
VOID DRIVERCALL MFITextBlock(PFONTDETAILS pFontDetails,
                             PAVIOINFO    pAvioInfo);
VOID DRIVERCALL AVIOScroll(PVOID);

VOID DRIVERCALL AVIOCursor(VOID);

ULONG DRIVERCALL update_cache_charrect_2(PFONTDETAILS pFontDetails,
                                         PAVIOINFO    pAvioInfo);
ULONG DRIVERCALL update_cache_charrect_4(PFONTDETAILS pFontDetails,
                                         PAVIOINFO    pAvioInfo);
#else 
BOOL _cdecl CGATextBlock(PFONTDETAILS pFontDetails,
                         PAVIOINFO    pAvioInfo);

BOOL _cdecl MFITextBlock(PFONTDETAILS pFontDetails,
                         PAVIOINFO    pAvioInfo);

BOOL _cdecl DBCSCommonBlock(PFONTDETAILS pFontDetails,
                            PAVIOINFO    pAvioInfo);

BOOL _cdecl EpochColorBlock(PFONTDETAILS pFontDetails,
                            PAVIOINFO    pAvioInfo);

BOOL _cdecl EpochMonoBlock(PFONTDETAILS  pFontDetails,
                           PAVIOINFO    pAvioInfo);

VOID _cdecl AVIOScroll(PVOID);

VOID _cdecl AVIOCursor(VOID);

BOOL  _cdecl update_cache_charrect_2(PFONTDETAILS pFontDetails,
                                     PVOID        pCharBuffer);

BOOL  _cdecl update_cache_charrect_4(PFONTDETAILS pFontDetails,
                                     PVOID        pCharBuffer);

BOOL  _cdecl common_update_cache_charrect(PFONTDETAILS pFontDetails,
                                          PVOID        pCharBuffer);

BOOL  _cdecl epoch_update_cache_charrect(PFONTDETAILS pFontDetails,
                                         PVOID        pCharBuffer);
#endif 
