/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDTTYPT                                       */
/*                                                                    */
/*   Description     = Display Device Driver types for Text           */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


typedef struct
    {
        ULONG            Identity;
        ULONG            Size;
        KERNINGPAIRS     Pairs;
    } KerningTableType;

typedef KerningTableType FAR *lpKerningTable;


/**********************************************************************/
/* Type definitions                                                   */
/* These should really be defined in a PM header (but they aren't!)   */
/**********************************************************************/
typedef struct _ABC_CHAR_DEFN
{
    ULONG       ulImageOffset;
    USHORT      usASpace;
    USHORT      usBSpace;
    USHORT      usCSpace;
} ABC_CHAR_DEFN;

typedef struct _NON_ABC_CHAR_DEFN
{
    ULONG       ulImageOffset;
    USHORT      usCharWidth;
} NON_ABC_CHAR_DEFN;

typedef union _CHAR_DEFN
{
    ABC_CHAR_DEFN       abcDefn;
    NON_ABC_CHAR_DEFN   nonabcDefn;
} CHAR_DEFN;
typedef CHAR_DEFN FAR *PCHAR_DEFN;
