;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;***********************************************************************
;
;   Module          = EDDPHUNK
;
;   Description     = Private AI code
;
;   Function        = Blt interface to the PHUNK
;
;
;***********************************************************************
INCL_GPIBITMAPS EQU     1
include os2.inc
include eddinclt.inc

include eddhcone.inc
include eddhtype.inc
include eddhmacr.inc

?DF     equ     1       ; we dont want cmacros to define the _text seg
include cmacros.inc

; Physical and virtual pointers to the PHUNK segment.
extrn _pPhunkPhys               :dword
extrn _pPhunkVirt               :dword

; Access to the Hardware
ifndef  _8514
extrn _pRealXGARegs             :word
else
extrn _pReal8514Regs            :word
endif
extrn _pbHWPollRegister         :dword

IFDEF PALETTE_MGR
; Array of BYTE[256] for conversion between palettes.
extrn _PaletteMapping   :word
ENDIF ; PALETTE_MGR


;*********************************************************************;
; Give us access to the data segement
;*********************************************************************;
_DATA           segment dword use32 public 'DATA'
_DATA           ends

_TEXT           segment use32 dword public 'CODE'
                assume  cs:FLAT, ds:FLAT, es:FLAT

;***********************************************************************
;
; Function: eddb_PhunkThatBitmap
;
; Called by: eddb_bitblt                        eddnbblt.c
;            eddb_bltSourceToDestination        eddbbsub.c
;            OutputMarker                       eddnmark.c
;            eddb_imageData                     eddbimag.c
;
; Purpose: copies a bitmap to the PHUNK
;
;***********************************************************************

public eddb_PhunkThatBitmap

        align   4
cProc eddb_PhunkThatBitmap,<PUBLIC>,<esi, edi>
        parmD   pPhunkThis       ; pointer to bitmap header to be PHUNKed

cBegin
; Before we do the transfer we must wait for the Hardware in case it is
; already using the PHUNK for something else
        ifndef  _8514
        pushxga
        movxga  _pRealXGARegs
        waitshort
        popxga
        endif

; Copy the PHUNKs physical address to the bitmap headers physical address of
; the bitmap.
        mov     eax, _pPhunkPhys
        mov     edi, pPhunkThis
IFDEF FIREWALLS
        cmp     [edi].phys_addr, 0
        je      short @F
        int 3   ; we are phunking something that already has a physical address
@@:
ENDIF ; FIREWALLS
        mov     [edi].phys_addr, eax

; Get the size of the bitmap into ecx
        mov     ecx, [edi].bm_size

; Get virtual address of the bitmap into esi
        mov     esi, [edi].virt_addr

; Get virtual address of the PHUNK into edi
        mov     edi, _pPhunkVirt

; Set the string flags to indicate work upwards
        cld

; Keep a copy of the bitmap size.
        mov     eax, ecx

; Transfer dwords
        shr     ecx, 2
        rep movs  DWORD PTR [edi], DWORD PTR [esi]

; Transfer remaining bytes
        mov     cl, al
        and     cl, 3
        rep movs  BYTE PTR [edi], BYTE PTR [esi]

cEnd




;***********************************************************************
;
; Function: eddb_KnuhpThatBitmap
;
; Called by: eddb_BMIntToInt indirectly through eddb_far_KnuhpThatBitmap
;            in eddbbcnv.c
;
; Purpose: copies the PHUNK back to a bitmap
;
;***********************************************************************

public eddb_KnuhpThatBitmap

        align   4
cProc eddb_KnuhpThatBitmap,<PUBLIC>,<esi, edi>
        parmD   pUnPhunkThis       ; pointer to bitmap header to be unPHUNKed

cBegin

; First we must wait for the hardware to finish with the bitmap in the PHUNK
        pushxga
        ifndef  _8514
        movxga  _pRealXGARegs
        else
        movxga  _pReal8514Regs
        endif
        waitshort
        popxga

; Invalidate the bitmaps physical address
        mov     esi, pUnPhunkThis
        mov     [esi].phys_addr, 0

; Get the size of the bitmap into ecx
        mov     ecx, [esi].bm_size

; Get virtual address of the bitmap into edi
        mov     edi, [esi].virt_addr

; Get virtual address of the PHUNK into esi
        mov     esi, _pPhunkVirt

; Set the string flags to indicate work upwards
        cld

; Keep a copy of the bitmap size.
        mov     eax, ecx

; Transfer dwords
        shr     ecx, 2
        rep movs  DWORD PTR [edi], DWORD PTR [esi]

; Transfer remaining bytes
        mov     cl, al
        and     cl, 3
        rep movs  BYTE PTR [edi], BYTE PTR [esi]

cEnd



;***********************************************************************
; eddb_ConvertPhunk is not used by anyone at the moment.
; It is left in (and compiled for DEBUG and DEKKO versions) to ensure
; that the code is compileable and up to date.
; It is left out for the RETAIL version to reduce the .DLL size.
;***********************************************************************
IFNDEF RETAIL
IFDEF PALETTE_MGR

;***********************************************************************
;
; Function: eddb_ConvertPhunk
;
; Called by: eddb_bitblt in eddnbblt.c
;            eddb_bltSourceToDestination in eddbbsub.c
;
; Purpose: converts the contents of the PHUNK from one palette to another
;          using the PaletteMapping table created by
;          eddb_CreatePaletteMapping
;
;***********************************************************************

public eddb_ConvertPhunk

        align   4
cProc eddb_ConvertPhunk,<PUBLIC,NEAR>,<esi, ebx>
        parmD   PhunkSize       ; number of bytes in the PHUNK to be converted

cBegin

; Set esi to point to the base of the phunk, and ecx to be the count of the
; number of bytes that we need to convert in the phunk.
        mov     esi, _pPhunkVirt
        mov     ecx, PhunkSize

; We will use ecx as an index into the PHUNK and we will get/put 4 bytes
; at a time so we want to round esi down to the nearest 4 bytes.
; NOTE that we do not worry about going past the end of the PHUNK as we know
; that the usable portion of it is a multiple of 4 bytes.
        and     ecx, 0fffffffch

        xor     ebx, ebx          ;clear ebx

@@:
; Get four bytes from the PHUNK
        mov     eax, [esi][ecx]

; Convert the bottom word
        mov     bl, al
        mov     al, byte ptr _PaletteMapping[ebx]
        mov     bl, ah
        mov     ah, byte ptr _PaletteMapping[ebx]

; Get the top word into ax
        swap    eax

; Convert the top word
        mov     bl, al
        mov     al, byte ptr _PaletteMapping[ebx]
        mov     bl, ah
        mov     ah, byte ptr _PaletteMapping[ebx]

; Get back the bottom word into ax
        swap    eax

; Store the converted double word back into the PHUNK
        mov     [esi][ecx], eax

; Move the index to the next four bytes to be processed in the PHUNK
        sub     ecx, 4

; Loop back if we have not finished
        jnc     @B

cEnd


ENDIF ; PALETTE_MGR

ENDIF ; NDEF RETAIL

_TEXT           ends

END
