/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDBMCCH                                       */
/*                                                                    */
/*   Description     = Display Device Driver header for bitmap cache  */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/* Constants */

/**********************************************************************/
/* Maximum size of a bitmap which can be cached in VRAM.              */
/**********************************************************************/
#ifndef   _8154
#define VRAM_BM_CACHE_SIZE          1600
#else
#define VRAM_BM_CACHE_SIZE          8192
#endif

#define VRAM_BM_CACHE_HOR_SIZE      64
#define VRAM_BM_VERT_CACHE_HOR_SIZE 40

#ifdef S3
#define VRAM_BM_CACHE_VERT_SIZE      127
#define VRAM_BM_VERT_CACHE_VERT_SIZE 80
#else
#define VRAM_BM_CACHE_VERT_SIZE     128
#endif

#define VRAM_MAX_VERT_BITMAPS       1
#define VRAM_MAX_HOR_BITMAPS        13
#define NO_FREE_BM_CACHE_SLOTS 0xffffffff
#define BITMAP_NOT_CACHED      0xffffffff

#ifdef _8514
#define SEAMLESS_MAX_HOR_BITMAPS    2
#endif


/**********************************************************************/
/* Flags for BMCACHE structure.                                       */
/**********************************************************************/
#define BM_IN_USE 0x01



/* Types */

/**********************************************************************/
/* Structure holding information about one cache slot in the VRAM     */
/* bitmap cache.                                                      */
/**********************************************************************/
typedef struct
{
  ULONG         physical_address;
  pBitmapHeader pbmh;
  ULONG         flags;
} BMCACHE;
typedef BMCACHE *PBMCACHE;



/* Function prototypes */

BOOL initialise_bm_cache(VOID);
BOOL cache_bitmap(pBitmapHeader);
VOID evict_cached_bitmap(ULONG);
VOID shutdown_bm_cache(VOID);



/* Globals */

extern PBMCACHE        bm_cache;
extern ULONG           max_cached_bitmaps;
extern ULONG           next_eviction;

#ifdef _8514
extern ULONG           p8514FontCache[];
/**********************************************************************/
/* Defect 75206. A global to keep track of whether or not we've       */
/* to plane + 8.                                                      */
/**********************************************************************/
extern ULONG           aulFontPlaneOffset[];
#endif




/* Macros */

#define UNUSED_BM_CACHE_SLOT(b) (((b).flags&BM_IN_USE)==0)
#define USED_BM_CACHE_SLOT(b) (((b).flags&BM_IN_USE)!=0)
#define RELEASE_BM_CACHE_SLOT(b) ((b).flags&=~BM_IN_USE)
#define RESERVE_BM_CACHE_SLOT(b) ((b).flags|=BM_IN_USE)
#define CACHED_BM_HEADER(b) ((b).pbmh)
#define CACHED_BM_PHYS_ADDR(b) (CACHED_BM_HEADER(b)->BMPhys)
#define CACHED_BM_VIRT_ADDR(b) (CACHED_BM_HEADER(b)->Bitmap)
#define CACHED_BM_SIZE(b) (CACHED_BM_HEADER(b)->BMSize)
#define CACHE_PHYS_ADDR(b) ((b).physical_address)
#define CACHED_BM_SLOT(b) (CACHED_BM_HEADER(b)->bm_cache_slot)
#define MARK_BMH_NOT_CACHED(b) (CACHED_BM_SLOT(b)=BITMAP_NOT_CACHED)
#define BITMAP_IS_CACHED(b) ((b)->bm_cache_slot!=BITMAP_NOT_CACHED)
