/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDMRES                                        */
/*                                                                    */
/*   Description     = Display Device Driver function                 */
/*                     QueryDevResource                               */
/*                                                                    */
/*   Function        = QueryDevResource queries the resources         */
/*                     supplied with the driver.                      */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_WINERRORS
#define INCL_DOSERRORS
#define INCL_DOSRESOURCES
#define INCL_DDIMISC

#include <eddinclt.h>
#include <edddtypt.h>
#include <eddgextf.h>
#include <eddmextf.h>

#include <eddtcone.h>

#include <eddmcone.h>

extern HMODULE hModule;
extern HMODULE font_hmod;
extern DDTType DDT;
extern ULONG                    ulSysFontId;
#ifdef DBCS                                                 
extern PVOID                    pDefaultFont;
#endif 

/**********************************************************************/
/* QueryDevResource returns the address of the requested resource.    */
/*                                                                    */
/* If the resource is not avaliable NULL is returned.                 */
/**********************************************************************/
DDIENTRY eddm_QueryDevResource (HDC     hdc,
                                ULONG   ArgTypeID,
                                ULONG   ArgNameID,
                                PDC     pdcArg,
                                ULONG   FunN)
{
    ULONG   Address;
    ULONG   Result;

    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(hdc);

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* If a query for DisplayInfo then check the screen resolution    */
    /* and request 32x32 icons if 640x480 else use 40x40.             */
    /* xga32.rc defines an ID of 1 for 40x40 and 2 for 32x32.         */
    /******************************************************************/
    if ( ArgTypeID == RT_DISPLAYINFO )
    {
      if ( DDT.ScreenWidth <= LO_RES_WIDTH )
      {
        ArgNameID = LO_RES_ICON_ID;
      }
      else if ( DDT.ScreenWidth <= RES_800_WIDTH )
      {
        ArgNameID = RES_800_ICON_ID;
      }
      else /* greater than 800 pixels wide */
      {
        ArgNameID = HI_RES_ICON_ID;
      }
    }

    /******************************************************************/
    /* If they are querying for are default image font (as the engine */
    /* now manages it for us) we need to return the font according    */
    /* to the resolution/monitor we have.                             */
    /******************************************************************/
    if ( (ArgTypeID == FONT) || (ArgTypeID == RT_FONTDIR) )
    {
        /**************************************************************/
        /* System Proportional fonts have ID's 100... AVIO fonts have */
        /* ID's 2000, 2001, ... For System proportional we may want to*/
        /* substitute an alternative one depending on display!        */
        /**************************************************************/
        if ((ArgTypeID == FONT) && (ArgNameID == SFONT_RASTER))
        {
#ifdef DBCS                                                 
      if (CHECKENV(ENV_DBCS_CAPABLE))  // if default font is MBCS font
        {                              //
          ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);
          return (ULONG)pDefaultFont;  // no need to load again!
                                       // and we cannot load it from
                                       // resource as it is owned by
                                       // DBCS font manager...
        }                              // end of if:
#endif 
            ArgNameID = ulSysFontId;
        }

        Result = DosGetResource( font_hmod,
                                 ArgTypeID,
                                 ArgNameID,
                                 (PPVOID)&Address);
    }
    else
    {
        Result = DosGetResource( hModule,
                                 ArgTypeID,
                                 ArgNameID,
                                 (PPVOID)&Address);
    }

    if (Result != NO_ERROR)
    {
        /**************************************************************/
        /* The resource was not found so log the error.               */
        /* (Actually this is probably a result of just checking if    */
        /* the display driver is supplying an optional resource,      */
        /* which if not found will be supplied by PMWIN)              */
        /* Hence we only log this as a warning level error.           */
        /**************************************************************/
        LogWarning(PMERR_RESOURCE_NOT_FOUND);
        Address = NULL;
    }

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* Return the address of the resource.                            */
    /******************************************************************/
    return (Address);
}
