/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDMLOCK                                       */
/*                                                                    */
/*   Description     = Display Device Driver minor functions          */
/*                     LockDevice and UnlockDevice                    */
/*                                                                    */
/*   Function        = LockDevice prohibits all drawing by threads    */
/*                     other than the current one.                    */
/*                     UnlockDevice allows all drawing blocked by     */
/*                     LockDevice to continue                         */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/*   History                                                          */
/*                                                                    */
/*   73175  930820  Torgny Stadler changed dekko major code f7 -> df  */
/*                                                                    */
/**********************************************************************/
#define INCL_DDIMISC
#define INCL_DOSSEMAPHORES
#include <eddinclt.h>

#include <eddmextf.h>
#include <eddgextf.h>

#include <semaphor.h>

#ifdef DEKKO
/**********************************************************************/
/* Dekko hooks for IBM's performance analysis                         */
/*                                                                    */
/* Most of the dekko timings are done through EnterDriver and         */
/* ExitDriver, but LockDevice and UnlockDevice do not both call Enter */
/* and Exit driver and so have to have the dekko hooks put in         */
/* explicitly.                                                        */
/**********************************************************************/
VOID FAR cdecl Dekko32Trace( ULONG, ULONG, ULONG, PSZ );
#endif /* DEKKO */

/**********************************************************************/
/* LockDevice locks the device to the thread from which it is called. */
/* All current and pending drawing is allowed to complete, but        */
/* further drawing from other threads is prohibited until             */
/* UnlockDevice is called.                                            */
/**********************************************************************/
DDIENTRY eddm_LockDevice (HDC       hdc,
                          PDC       pdcArg,
                          ULONG     FunN)

{
    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(hdc);

#ifdef DEKKO
    /******************************************************************/
    /* Start the Dekko timings for the LockDevice call.               */
    /******************************************************************/
    Dekko32Trace( 0xdf00, (FunN & 0xff), 0, NULL );    /* @73175 */
#endif /* DEKKO */

    /******************************************************************/
    /* Just get the display semaphore and exit.                       */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD);

#ifdef DEKKO
    /******************************************************************/
    /* Stop the Dekko timings for the LockDevice call.                */
    /******************************************************************/
    Dekko32Trace( 0xdf80, (FunN & 0xff), 0, NULL );    /* @73175 */
#endif /* DEKKO */

    return(OK);
}


/**********************************************************************/
/* UnlockDevice allows all operations blocked by LockDevice to        */
/* proceed.                                                           */
/**********************************************************************/
DDIENTRY eddm_UnlockDevice (HDC         hdc,
                            PDC         pdcArg,
                            ULONG       FunN)
{
    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(hdc);


#ifdef DEKKO
    /******************************************************************/
    /* Start the Dekko timings for the UnLockDevice call.             */
    /******************************************************************/
    Dekko32Trace( 0xdf00, (FunN & 0xff), 0, NULL );    /* @73175 */
#endif /* DEKKO */

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD);

#ifdef DEKKO
    /******************************************************************/
    /* Stop the Dekko timings for the UnLockDevice call.              */
    /******************************************************************/
    Dekko32Trace( 0xdf80, (FunN & 0xff), 0, NULL );    /* @73175 */
#endif /* DEKKO */

    return(OK);
}
