/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDLGETO                                       */
/*                                                                    */
/*   Description     = Display Device Driver minor function handler   */
/*                     GetLineOrigin                                  */
/*                                                                    */
/*   Function        = Gets the current style state. This is kept in  */
/*                     the instance data and is the function return   */
/*                     value                                          */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DDIMISC
#define INCL_DDIPATHS
#define INCL_DDICOMFLAGS
#include <eddinclt.h>

#include <eddgextf.h>
#include <eddlextf.h>

extern BYTE      LinePatStep;

/**********************************************************************/
/* Gets the current style state. This is a Dword in the DC instance   */
/* data; the high word indicates whether the first pel is being drawn */
/* while the high byte (of the low word) is the style error value,    */
/* the low byte is the style mask.                                    */
/**********************************************************************/
DDIENTRY eddl_GetLineOrigin (HDC            hdc,
                             PPOINTL        ArgCurrPos,
                             PDC            pdcArg,
                             ULONG          FunN)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    ULONG              Style;        /* returned value                */
    ULONG              DriverPatCnt; /* contains engine pat count bits*/
    ULONG              EnginePatCnt; /* above but in driver format    */

    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(hdc);

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* Get the style state from the DC.                               */
    /*                                                                */
    /* The high word gives the "draw first pel state": 1 means draw   */
    /* the first pel, 0 means dont.  This is stored in the high       */
    /* word of DCIStyleNumber.                                        */
    /*                                                                */
    /* The low word gives the current position in the line style      */
    /* pattern: the high byte contains the error, the low byte        */
    /* contains the position in the mask.                             */
    /*                                                                */
    /* See EDDDATA.C for details of how the current position in the   */
    /* line style pattern is handled.                                 */
    /******************************************************************/
    DriverPatCnt = pdc->DCILinePatCnt * LinePatStep;
    EnginePatCnt = HIBYTE(DriverPatCnt) | ((LOBYTE(DriverPatCnt)) << 8);

    Style = (pdc->StyleNumber & 0xFFFF0000) | (EnginePatCnt);

    /******************************************************************/
    /* If the transform flag is set pass the current position back in */
    /* WORLD coordinates, otherwise they should be returned in SCREEN */
    /* coordinates.                                                   */
    /******************************************************************/
    if (FunNTest(COM_TRANSFORM))
    {
        /**************************************************************/
        /* COM_TRANSFORM set so return WORLD coordinates              */
        /**************************************************************/
        *ArgCurrPos = pdc->DCICurrPosWorld;
    }
    else
    {
        /**************************************************************/
        /* Otherwise return SCREEN coordinates                        */
        /**************************************************************/
        ArgCurrPos->x = pdc->DCICurrPosAI.X;
        ArgCurrPos->y = pdc->DCIBoundingClip[1].Y - pdc->DCICurrPosAI.Y;
    }

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    return (Style);
}
