/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDLCONE                                       */
/*                                                                    */
/*   Description     = Printer Device Driver line constants           */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#define NUMBER_LINETYPES        10     /* number of linetypes         */

/**********************************************************************/
/* Define the constants for plot/step direction definition.           */
/**********************************************************************/

#define RIGHT          (BYTE)0
#define UP_RIGHT       (BYTE)0x20
#define UP             (BYTE)0x40
#define UP_LEFT        (BYTE)0x60
#define LEFT           (BYTE)0x80
#define DOWN_LEFT      (BYTE)0xA0
#define DOWN           (BYTE)0xC0
#define DOWN_RIGHT     (BYTE)0xE0

#define STEP           (BYTE)0
#define PLOT           (BYTE)0x10

/**********************************************************************/
/* Define the maximum plot/step buffer size.                          */
/**********************************************************************/
#define PLOTSTEP_BUFFER_SIZE 1600

/**********************************************************************/
/* Flags for setting graphics quality (HSGQ)                          */
/**********************************************************************/
#define HSGQ_LAST_PEL      0x1800
#define LAST_PEL_NULL      0x0
#define LAST_PEL_ON        0x800
#define AUTOCLOSE_OFF      0x400

