/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*   Module	      : EDDJSUB.H				      */
/*								      */
/*   Description      : PM Display Driver DBCS handling routine       */
/*			External definitions for EDDJSUB.H	      */
/*								      */
/*   Created	      : 12/11/91				      */
/*   Author	      : Yohji Nakamura (JL04328 at YMTVM6)	      */
/*								      */
/*   Notes	      : 					      */
/*								      */
/*   History	      : 					      */
/*								      */
/*			OCO Source Materials			      */
/*			XXXX-XXX				      */
/**********************************************************************/
/*====================================================================*/
/* global variables						      */
/*====================================================================*/
extern USHORT ausString[WORK_BUFFER_SIZE];
extern USHORT ausWidth[WORK_BUFFER_SIZE];
extern USHORT ausGlyph[WORK_BUFFER_SIZE];
extern SHORT  asCIndex[WORK_BUFFER_SIZE];
extern LONG   alVector[WORK_BUFFER_SIZE];
extern SHORT  asDVector[WORK_BUFFER_SIZE];

/*====================================================================*/
/* constants							      */
/*====================================================================*/
//#define FORCED_SINGLEBYTE	  0x100  /* this codepoint is used to	*/
				       /*  represent a 2byte char,    */
				       /*  which should be drawn as   */
				       /*  an SBCS default char       */
				       /*  (since used font is SBCS)  */
				       /* Will be handled as SBCS in  */
				       /*  some cases (e.g. getting   */
				       /*  width of string), and      */
				       /*  will be handled as DBCS in */
				       /*  other cases (e.g. returning*/
				       /*  values for QueryCharPos    */
				       /*  call).		      */
/*====================================================================*/
/* function prototypes						      */
/*====================================================================*/
extern LONG eddj_UnifiedDBCS( PFONTDETAILS pFontDtl,
			      PCHAR pchCodepoint,
			      ULONG ulSrcLength,
			      PLONG plSrcVector,
			      PUSHORT pusResult,
			      ULONG ulDstLength,
			      PLONG plDstVector,
			      PULONG pulResultCount );

extern ULONG eddj_ChopString( PFONTDETAILS pFontDtl,
			      PCHAR pchString,
			      ULONG ulSrcBytes,
			      ULONG ulDstChars );

extern USHORT eddj_CodepointToGlyph( PFONTDETAILS pFontDtl,
				     USHORT usCodepoint );

#ifdef OMIT
extern LONG eddj_UnifiedDBCSVector( PFONTDETAILS pFontDtl,
				    PCHAR pchCodepoint,
				    ULONG ulLength,
				    PLONG plVectorCount,
				    PLONG plVector );

extern LONG eddj_GlyphIndex( PFONTDETAILS pFontDtl,
			     PCHAR pchCodepoint,
			     PUSHORT pusGlyphIndexes,
			     ULONG ulLength,
			     PLONG plResultCount,
			     PLONG plVector );
#endif /* OMIT */

extern ULONG eddj_GetCharWidth( PCHAR pchCodePoints,
				ULONG ulCharNum,
				PFONTDETAILS pFontDtl,
				PUSHORT pusWidth );

extern VOID StringToGlyph( PFONTDETAILS pFontDtl,
			   PCHAR pchCodepoint,
			   PUSHORT pusGlyphIndexes,
			   ULONG ulLength );

extern LONG eddj_CountChar( PCHAR pchInput,
			    LONG lNumBytes,
			    PFONTDETAILS pFontDtl );

extern VOID _cdecl eddj_IsSbcsOnly( PCHAR pchString,
				    LONG lCount,
				    PFONTDETAILS pFontDtl );

extern VOID eddj_CheckProcOptions( PCHAR pchString,
				   LONG lCount,
				   PFONTDETAILS pFontDtl );

extern VOID eddj_IsCallDbcsFM( PFONTDETAILS pFontDtl );

extern VOID eddj_GetDefaultCodepoint( PFONTDETAILS pFontDtl );
