/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*   Module           : EDDJFONT.H                                    */
/*                                                                    */
/*   Description      : PM Display Driver DBCS handling routine       */
/*                      Include for C module who call functions       */
/*                      in EDDJFONT.C                                 */
/*                                                                    */
/*   Created          :  5/22/92                                      */
/*   Author           : Yohji Nakamura (JL04328 at YMTVM6)            */
/*                                                                    */
/*   Notes            :                                               */
/*                                                                    */
/*   History          :                                               */
/*                                                                    */
/*                      OCO Source Materials                          */
/*                      XXXX-XXX                                      */
/**********************************************************************/
/*====================================================================*/
/* constants                                                          */
/*====================================================================*/
#define FM_CHARSTR_LIMIT        256
                                       /* max #indexes for charstr    */
/*====================================================================*/
/* exported functions                                                 */
/*====================================================================*/
extern VOID eddj_FixFontMetrics( PFONTMETRICS pMetrics );

extern BOOL eddj_LoadFontManager( VOID );

extern ULONG eddj_GetFontList( PFMFONTINFO *ppFMFontInfo,
                                            ULONG flOptions );

extern VOID  eddj_ValidateSystemFont( VOID );

extern PFOCAFONT  eddj_RealizeFont( PFATTRS pFattrs );

extern VOID  eddj_UnrealizeFont( PFOCAFONT pFont );

extern VOID  pascal eddj_QueryFontProfile( PFOCAFONT pFont,
                                           PUSHORT pFlags,
                                           PUSHORT pCacheSize );

extern BOOL eddj_LoadFontDriver( ULONG ulFuncID, PSZ pszFontDriver );

extern BOOL  eddj_ValidateFontSeg( LONG lCount,
                                              PFOCAFONT pFont,
                                              PUSHORT pusGlyphIndex );

extern BOOL  eddj_MapCharGlyph( ULONG ulCodePage,
                                           ULONG ulLength,
                                           PFOCAFONT pFont,
                                           PVOID pString );

extern LONG  eddj_QueryMatchNum( PFOCAFONT pFont );

